#if !defined(AFX_SECURITYPASSWORDDLG_H__1D338532_97D9_430D_B0C8_A8C9F2164C15__INCLUDED_)
#define AFX_SECURITYPASSWORDDLG_H__1D338532_97D9_430D_B0C8_A8C9F2164C15__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ChangePasswordDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CChangePasswordDlg dialog
#include "resource.h"
#include "apl_api.h"

struct CSecuritySettings
{
	//   
	enum ECharType
	{
		ECT_UPPER,
		ECT_LOWER,
		ECT_DIGIT,
		ECT_SPECIAL,
		ECT_COUNT
	};

	//   
	enum ESecurityType
	{
		EST_LOW,
		EST_NORMAL,
		EST_HARD,
		EST_COUNT
	};

	CaplAPI *m_api;
	int m_iMinSize;
	int m_aiSymbolTypes[ECT_COUNT];

	static const int SPECIAL_COUNT = 28;	// ! @ # $ % ^ & * ( ) - _ + = ; : , ./ ? \ | ` ~ [ ] { }. 
	static const int DIGITS_COUNT = 10;		// 0 - 10
	static const int UPPER_COUNT = 26;		// A - Z
	static const int LOWER_COUNT = 26;		// a - z
	static const int PWD_MINIMAL_SIZE = 8;	//      (   Microsoft)

	//             (   Microsoft)
	static const __int64 PWD_BRUTE_FORCE_NORMAL_COUNT = 218340105584896;	// = (UPPER_COUNT + LOWER_COUNT + DIGITS_COUNT)^PWD_MINIMAL_SIZE
	//            
	static const __int64 PWD_BRUTE_FORCE_HARD_COUNT	= 4304672100000000;		// = (UPPER_COUNT + LOWER_COUNT + DIGITS_COUNT + SPECIAL_COUNT)^PWD_MINIMAL_SIZE

	CSecuritySettings(CaplAPI *api);

	CString GetPasswordSecurityStr() const;
	//    
	ESecurityType GetPasswordSecurity() const;
	//      
	bool CheckPassword(const CString& sPassword) const;
	CString GetPasswordInfo() const;

	void ReadFromOptions();
	void SaveToOptions();
};

class CSecurityPasswordDlg : public CaplTranslateDialog
{
	// Construction
protected:
	CaplAPI		*m_api;
public:
	CSecurityPasswordDlg(CaplAPI *api, CSecuritySettings* pSecurity, CWnd* pParent = NULL);   // standard constructor
	~CSecurityPasswordDlg();

public:

	CSecuritySettings* m_pSecurity;
	CaplInstance* m_pUser;
	// Dialog Data
	//{{AFX_DATA(CChangePasswordDlg)
	enum { IDD = IDD_SET_PASSWORD_PARAMS };
	CaplButton	m_ok_btn;
	CaplButton	m_cancel_btn;
	CButton m_acSymbolsCheck[CSecuritySettings::ECT_COUNT];
	//}}AFX_DATA

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChangePasswordDlg)
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

	// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CChangePasswordDlg)
	virtual void OnOK();
	virtual BOOL OnInitDialog();

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnEnChangeMinSize();
	afx_msg void OnBnClickedSymbolTypeCheck(UINT id);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHANGEPASSWORDDLG_H__1D338532_97D9_430D_B0C8_A8C9F2164C15__INCLUDED_)
