// SelectAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SelectAppDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectAppDlg dialog


CSelectAppDlg::CSelectAppDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelectAppDlg)
	m_use_def = FALSE;
	m_file_name = _T("");
	//}}AFX_DATA_INIT
}


void CSelectAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectAppDlg)
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_BROWSE, m_browse_btn);
	DDX_Control(pDX, IDC_APPS, m_apps_ctrl);
	DDX_Control(pDX, IDC_USE_DEFAULT, m_use_def_ctrl);
	DDX_Check(pDX, IDC_USE_DEFAULT, m_use_def);
	DDX_Text(pDX, IDC_FILE_NAME, m_file_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectAppDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectAppDlg)
	ON_BN_CLICKED(IDC_USE_DEFAULT, OnUseDefault)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectAppDlg message handlers

BOOL CSelectAppDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	//   
	CWinApp *app=AfxGetApp();
	TCHAR* OldRegistryKey=(TCHAR*)app->m_pszRegistryKey;
	app->m_pszRegistryKey=_T("CALS Centre \"Applied Logistic\"");
	int i,k;
	CString buf,buf1;
	k=app->GetProfileInt(_T("Apps"),_T("AppsCount"),0);
	for(i=0;i<k;i++)
	{
		buf1.Format(_T("APP%i"),i);
		buf=app->GetProfileString(_T("Apps"),buf1);
		if(buf!=_T(""))m_apps.Add(buf);
	}
	app->m_pszRegistryKey=OldRegistryKey;
	

	for(i=0;i<m_apps.GetSize();i++)
	{
		m_apps_ctrl.AddString(m_apps[i]);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectAppDlg::OnUseDefault() 
{
	// TODO: Add your control notification handler code here
	if(m_use_def_ctrl.GetCheck())
	{
		m_apps_ctrl.EnableWindow(FALSE);
		m_browse_btn.EnableWindow(FALSE);
	}
	else
	{
		m_apps_ctrl.EnableWindow(TRUE);
		m_browse_btn.EnableWindow(TRUE);
	}
		
}

void CSelectAppDlg::OnOK() 
{
	CString buf,buf1;
	m_apps_ctrl.GetWindowText(buf);
	if(buf==_T("")) {AfxMessageBox( APL_T("  ")); return;}
	m_App=buf;
	int i,j=0;
	CWinApp *app=AfxGetApp();
	TCHAR *OldRegistryKey=(TCHAR*)app->m_pszRegistryKey;
	app->m_pszRegistryKey=_T("CALS Centre \"Applied Logistic\"");

	bool bFound=false;
	for(i=0;i<m_apps.GetSize();i++)
	{
		if(m_apps[i]==buf)
		{
			bFound=true;
			break;
		}
	}
	buf1.Format(_T("APP%i"),0);
	app->WriteProfileString(_T("Apps"),buf1,buf);
	j=1;

	for(i=0;i<m_apps.GetSize();i++)
	{
		if(bFound){	if(m_apps[i]==m_App) continue;}
		buf1.Format(_T("APP%i"),j);
		app->WriteProfileString(_T("Apps"),buf1,m_apps[i]);
		j++;
	}
	app->WriteProfileInt(_T("Apps"),_T("AppsCount"),j);
	app->m_pszRegistryKey=OldRegistryKey;
	

	CaplTranslateDialog::OnOK();
}

void CSelectAppDlg::OnBrowse() 
{
	CFileDialog dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		_T("Exe Files (*.exe)|*.exe|All Files (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)	m_apps_ctrl.SetWindowText(dlg.GetPathName( ));	
	
}
