// SelectLanguageDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelectLanguageDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectLanguageDlg dialog


CSelectLanguageDlg::CSelectLanguageDlg(CaplAPI* api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSelectLanguageDlg::IDD, pParent)
{
	ASSERT(api);
	m_api = api;
	m_inst = NULL;
	//{{AFX_DATA_INIT(CSelectLanguageDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSelectLanguageDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectLanguageDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_LIST, m_ListBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectLanguageDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSelectLanguageDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectLanguageDlg message handlers

void CSelectLanguageDlg::OnOK() 
{
	int cur = m_ListBox.GetCurSel();
	if(cur<0)
	{
		AfxMessageBox( APL_T("  !"), MB_OK|MB_ICONWARNING);
		return;
	}

	m_inst = (CaplInstance*)m_ListBox.GetItemData(cur);
	
	CaplTranslateDialog::OnOK();
}

BOOL CSelectLanguageDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	
	if(!m_api->m_data.IsDictLoad())
	{
		EndDialog(0);
		return FALSE;
	}

	aplExtent ext;
	int i, ind;
	CString buf;

	m_api->m_data.GetEntityExtent(m_api->m_prd_mgr.e_apl_language, ext);
	for(i=0; i<ext.GetSize(); i++)
	{
		if(ext[i]==NULL) continue;
		if(ext[i]->GetAccessmode()>aplRO) continue;
		m_api->m_data.GetAttr(ext[i], m_api->m_prd_mgr.a_apl_language_name, buf);
		ind = m_ListBox.AddString(buf);
		m_ListBox.SetItemData(ind, (DWORD)ext[i]);
	}

	if(ext.GetSize()==0)
	{
		AfxMessageBox( APL_T("      !"), MB_OK|MB_ICONINFORMATION);
		EndDialog(0);
		return FALSE;
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
