// SelectUsersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelectUsersDlg.h"
#include "SelectPecipientsDlg.h"

// SelectUsersDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelectUsersDlg.h"

// CSelectUsersDlg dialog

IMPLEMENT_DYNAMIC(CSelectUsersDlg, CResizableDialog)

CSelectUsersDlg::CSelectUsersDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSelectUsersDlg::IDD, pParent)
{
	m_api=NULL;
	m_inst= NULL;

	m_mode= APL_MODE_SELECT_USER;//person'  

	m_sTitle= _T("");
	m_bDblCl=false;

}

CSelectUsersDlg::~CSelectUsersDlg()
{
}

void CSelectUsersDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectUsersDlg)
	DDX_Control(pDX, IDC_ACCESS_AGENT_TREE, m_treeCtrl);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Text(pDX, IDC_TREE_STATIC, m_sTreeTitle);
	DDX_Control(pDX, IDC_BUTTON4_FBEG, m_btnFBegin);
	DDX_Control(pDX, IDC_BUTTON3_FBACK, m_btnFBack);
	DDX_Control(pDX, IDC_BUTTON2_FFORW, m_btnFForward);
	DDX_Control(pDX, IDC_EDIT1_FVAL, m_edFindStr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectUsersDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CSelectUsersDlg)
	ON_NOTIFY(TVN_SELCHANGED, IDC_ACCESS_AGENT_TREE, OnSelchangedAATree)
	ON_BN_CLICKED(IDC_BUTTON2_FFORW, OnFindForward)
	ON_BN_CLICKED(IDC_BUTTON3_FBACK, OnFindBack)
	ON_BN_CLICKED(IDC_BUTTON4_FBEG, OnButton4Beg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CSelectUsersDlg message handlers
void CSelectUsersDlg::SetAnchors()
{
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);

	AddAnchor(IDC_TREE_STATIC, TOP_LEFT, TOP_RIGHT);		

	AddAnchor(IDC_ACCESS_AGENT_TREE, TOP_LEFT, BOTTOM_RIGHT);		

	AddAnchor(IDC_STATIC_FCAP,BOTTOM_LEFT);
	AddAnchor(IDC_EDIT1_FVAL,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_BUTTON2_FFORW,BOTTOM_RIGHT);
	AddAnchor(IDC_BUTTON3_FBACK,BOTTOM_RIGHT);
	AddAnchor(IDC_BUTTON4_FBEG,BOTTOM_RIGHT);

}


BOOL CSelectUsersDlg::OnInitDialog()
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	static CImageList imagelist;
	static bool imagelist_flag=true;
	if(imagelist_flag){
		imagelist.Create(IDR_TB_ACCESS_AGENT,20,2,RGB(255,0,255));
		imagelist_flag=false;
	}
	m_treeCtrl.SetImageList(&imagelist,TVSIL_NORMAL);//   TVSIL_STATE);

	SetAnchors();

	// TODO:  Add extra initialization here
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	m_btnFForward.SetIcon(GetAplTableIco(APL_TABLE_BOTTOM));
	m_btnFBack.SetIcon(GetAplTableIco(APL_TABLE_TOP));
	m_btnFBegin.SetIcon(GetAplTableIco(APL_TABLE_RIGHT));

	m_btnFForward.SetFlat(FALSE);
	m_btnFBack.SetFlat(FALSE);
	m_btnFBegin.SetFlat(FALSE);

	m_btnFForward.SetTooltipText( APL_T("  (F3)"));
	m_btnFBack.SetTooltipText( APL_T("  (Ctrl+F3)"));
	m_btnFBegin.SetTooltipText( APL_T(""));


	if(m_api!=0)
	{
		FillTree();
	}
	SetWindowText(m_sTitle);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CSelectUsersDlg::OnOK() 
{	
	CResizableDialog::OnOK();
}

void CSelectUsersDlg::OnCancel() 
{	
	CResizableDialog::OnCancel();
}


void CSelectUsersDlg::FillTree()
{
	if(m_api==0) return;

	int i=0,j=0;
	m_treeCtrl.DeleteAllItems();
	m_list_items_group.RemoveAll();
	m_list_items_users.RemoveAll();

	//     
	CString* pbuf=0;
	CString buf=_T("");

	CaplAggr aggr;
	CaplInstance *inst_user=0,*inst_group=0;
	CaplMap map_user2group;

	aplExtent m_ext_workgroup,m_ext_user;
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_apl_workgroup,m_ext_workgroup);
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_apl_user,m_ext_user);


	//   
	CaplStr2InstMap map_group;
	for(i=0;i<m_ext_workgroup.GetSize();i++){
		m_api->m_data.CaplStepData::GetAttr(m_ext_workgroup[i],m_api->m_appr_mgr.a_apl_user_name,buf);
		pbuf=new CString(buf);//*pbuf
		map_group.Add(pbuf,m_ext_workgroup[i]);
	}
	map_group.SortStr();

	HTREEITEM parent_item,cur_item;
	CaplMap group2HTREEITEM;
	int image;
	//    
	for(i=0;i<map_group.Size;i++)
	{
		pbuf=map_group.GetStrByIndx(i);
		inst_group=map_group.GetInstByIndx(i);
		if(inst_group->GetId()==2){
			image=ICON_CUR_GROUPE;
		}else{
			image=ICON_GROUPE;
		}
		cur_item=m_treeCtrl.InsertItem(*pbuf,image,image,TVI_ROOT);
		m_treeCtrl.SetItemData(cur_item,(DWORD)inst_group);
		group2HTREEITEM.Add((long)inst_group,(long)cur_item);
		m_list_items_group.Add(cur_item);
	}
	group2HTREEITEM.SortIn();
	bool non_group,global_non_group=false;

	//    
	for(i=0;i<m_ext_user.GetSize();i++)
	{
		//   
		inst_user=m_ext_user[i];
		non_group = true;
		m_api->m_data.CaplStepData::GetAttr(inst_user,m_api->m_appr_mgr.a_apl_user_groups,aggr);
		for(j=0;j<aggr.GetSize();j++)
		{
			aggr.GetByIndex(j,inst_group);
			map_user2group.Add((long)inst_group,(long)inst_user);
			non_group = false;
		}
		if(non_group)
		{
			map_user2group.Add((long)0,(long)inst_user);
			global_non_group = true;
		}
	}
	//     -    
	if(global_non_group)
	{
		//    
		image=ICON_NON_GROUPE_USERS;

		cur_item=m_treeCtrl.InsertItem( APL_T("  "),image,image,TVI_ROOT);
		m_treeCtrl.SetItemData(cur_item,(DWORD)0);
		group2HTREEITEM.Add((long)0,(long)cur_item);
		m_list_items_group.Add(cur_item);
	}


	//   
	map_user2group.SortIn();

	//   -     
	for(i=0;i<map_user2group.Size;i++)
	{
		map_group.Clear();
		inst_group=(CaplInstance*)map_user2group.Data[i].in;
		parent_item=(HTREEITEM)group2HTREEITEM.GetByIn((long)inst_group);
		do{
			inst_user=(CaplInstance*)map_user2group.Data[i].out;
			pbuf=new CString();
			m_api->m_appr_mgr.GetPersonName(inst_user,*pbuf,true,true);
			map_group.Add(pbuf,inst_user);
			i++;
		}while(inst_group==(CaplInstance*)map_user2group.Data[i].in);
		i--;//    
		//    
		map_group.SortStr();

		//    
		for(j=0;j<map_group.Size;j++){
			pbuf=map_group.GetStrByIndx(j);
			inst_user=map_group.GetInstByIndx(j);
			if(inst_user->GetId()==1){
				image=ICON_CUR_USER;
			}else{
				image=ICON_USER;
			}
			cur_item=m_treeCtrl.InsertItem(*pbuf,image,image,parent_item);
			m_treeCtrl.SetItemData(cur_item,(DWORD)inst_user);
			m_list_items_users.Add(cur_item);

		}
	}

}

//*****************************************************************************
void CSelectUsersDlg::OnSelchangedAATree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	*pResult = 0;

	bool bSel= false;
	m_inst= NULL;
	CaplInstance* inst= (CaplInstance*)m_treeCtrl.GetItemData(pNMTreeView->itemNew.hItem);
	if(inst)
	{
		if((m_mode&APL_MODE_SELECT_USER)>0)
		{
			if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_apl_user)) bSel= true;
		}
		if((m_mode&APL_MODE_SELECT_USER_GROUP)>0)
		{
			if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_apl_workgroup)) bSel= true;
		}
	}
	if(bSel)
	{
		m_inst= inst;
		if(!m_okBtn.IsWindowEnabled())
			m_okBtn.EnableWindow();
	}
	else 
	{
		m_inst= 0;
		if(m_okBtn.IsWindowEnabled())
			m_okBtn.EnableWindow(FALSE);
	}

	m_treeCtrl.SetFocus();
}

void CSelectUsersDlg::OnFindForward()
{
	CString str;
	m_edFindStr.GetWindowText(str);
	str.MakeUpper();

	HTREEITEM re=NULL,item=m_treeCtrl.GetSelectedItem();
	HTREEITEM roo=m_treeCtrl.GetRootItem();
	HTREEITEM olditem=item;
	CaplInstance *inst;

	if(item==NULL)
	{
		inst = (CaplInstance *)m_treeCtrl.GetItemData(roo);
		if(spdStrInclude(m_treeCtrl.GetItemText(roo),str, inst, m_api))
		{
			m_treeCtrl.EnsureVisible(roo);
			m_treeCtrl.SelectItem(roo);
			return;
		}
		else
			olditem=item=roo;
	}

	re=find_item_forw(&m_treeCtrl,str,item, m_api);

	if(re!=NULL)
	{	
		m_treeCtrl.SelectItem(re);
		m_treeCtrl.EnsureVisible(re);
	}
	else
	{
		item=roo;
		inst = (CaplInstance *)m_treeCtrl.GetItemData(item);
		if(spdStrInclude(m_treeCtrl.GetItemText(item),str, inst, m_api))
		{
			m_treeCtrl.SelectItem(item);
			m_treeCtrl.EnsureVisible(item);
			if(item==olditem)
				AfxMessageBox( APL_T(" ."));
			return;
		}
		re=find_item_forw(&m_treeCtrl,str,item, m_api);
		if(re!=NULL)
		{	
			m_treeCtrl.SelectItem(re);
			m_treeCtrl.EnsureVisible(re);
			if(re==olditem)
				AfxMessageBox( APL_T(" ."));
		}
		else
			AfxMessageBox( APL_T(" ."));
	}
}

void CSelectUsersDlg::OnFindBack()
{
	CString str;
	m_edFindStr.GetWindowText(str);
	str.MakeUpper();
	HTREEITEM re=NULL,item=m_treeCtrl.GetSelectedItem();
	HTREEITEM roo=m_treeCtrl.GetRootItem();
	if(!roo) return;
	HTREEITEM olditem=item;
	CaplInstance *inst;

	if(item==NULL)
	{	
		inst = (CaplInstance *)m_treeCtrl.GetItemData(roo);
		if(spdStrInclude(m_treeCtrl.GetItemText(roo),str, inst, m_api))
		{
			m_treeCtrl.SelectItem(roo);
			m_treeCtrl.EnsureVisible(roo);
			return;
		}
		else
			olditem=item=roo;
	}

	re=find_item_back(&m_treeCtrl,str,item, m_api);

	if(re!=NULL)
	{
		m_treeCtrl.SelectItem(re);
		m_treeCtrl.EnsureVisible(re);
	}
	else
	{

		item=find_last_item(&m_treeCtrl);
		inst = (CaplInstance *)m_treeCtrl.GetItemData(item);
		if(spdStrInclude(m_treeCtrl.GetItemText(item),str, inst, m_api))
		{
			m_treeCtrl.SelectItem(item);
			m_treeCtrl.EnsureVisible(item);
			if(item==olditem)
				AfxMessageBox( APL_T(" ."));
			return;
		}
		re=find_item_back(&m_treeCtrl,str,item, m_api);
		if(re!=NULL)
		{	
			m_treeCtrl.SelectItem(re);
			m_treeCtrl.EnsureVisible(re);
			if(re==olditem)
				AfxMessageBox( APL_T(" ."));
		}
		else
			AfxMessageBox( APL_T(" ."));
	}
}

void CSelectUsersDlg::OnButton4Beg() 
{
	CString str;
	m_edFindStr.GetWindowText(str);
	str.MakeUpper();
	HTREEITEM re=NULL,item=m_treeCtrl.GetRootItem();
	HTREEITEM roo=m_treeCtrl.GetRootItem();
	if(!roo) return;

	if(item==NULL)
	{
		return;
	}
	CaplInstance *inst = (CaplInstance *)m_treeCtrl.GetItemData(roo);
	if(spdStrInclude(m_treeCtrl.GetItemText(roo),str, inst, m_api))
	{
		m_treeCtrl.SelectItem(roo);
		m_treeCtrl.EnsureVisible(roo);
		return;
	}

	re=find_item_forw(&m_treeCtrl,str,item, m_api);

	if(re!=NULL)
	{
		m_treeCtrl.SelectItem(re);
		m_treeCtrl.EnsureVisible(re);
	}
	else
	{
		m_treeCtrl.SelectItem(roo);
		m_treeCtrl.EnsureVisible(roo);
		AfxMessageBox( APL_T(" ."));
	}
}

bool bCntrlPressedU=false;

BOOL CSelectUsersDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message==WM_KEYDOWN)
	{
		if(pMsg->wParam==VK_CONTROL)
			bCntrlPressedU=true;
		else if(pMsg->wParam==VK_F3)
		{
			if(bCntrlPressedU)
				OnFindBack();
			else
				OnFindForward();
		}
	}
	else if (pMsg->message==WM_KEYUP)
	{
		if(pMsg->wParam==VK_CONTROL)
			bCntrlPressedU=false;
	}
// 	else if (pMsg->message==WM_RBUTTONDOWN)
// 	{
// 		if(pMsg->hwnd==m_treeCtrl.m_hWnd)
// 		{
// 			CPoint p;
// 			p.x = GET_X_LPARAM(pMsg->lParam); 
// 			p.y = GET_Y_LPARAM(pMsg->lParam);
// 
// 			UINT flag=TVHT_ONITEM;
// 			HTREEITEM hItem=m_treeCtrl.HitTest(p,&flag);
// 			if(0!=hItem){ TreeContextMenu(hItem,pMsg->pt); return TRUE;}
// 		}
// 	}

	return CResizableDialog::PreTranslateMessage(pMsg);
}