// ShowItemApprovals.cpp : implementation file
//

#include "stdafx.h"
#include "ShowItemApprovals.h"


// CShowItemApprovals dialog

IMPLEMENT_DYNAMIC(CShowItemApprovals, CaplResizableDialog)

CShowItemApprovals::CShowItemApprovals(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CShowItemApprovals::IDD, pParent)
	, m_ObjectId(_T(""))
	, m_HideRevocation(TRUE)
{
	m_item = 0;
	m_api = 0;

}

CShowItemApprovals::~CShowItemApprovals()
{
}

void CShowItemApprovals::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_OBJECT_ID, m_ObjectId);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Check(pDX, IDC_HIDE_REVOCATION, m_HideRevocation);
}


BEGIN_MESSAGE_MAP(CShowItemApprovals, CaplResizableDialog)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_OBJECTS_STATIC, OnDblclkListAttributes)
	ON_BN_CLICKED(IDC_HIDE_REVOCATION, &CShowItemApprovals::OnBnClickedHideRevocation)
END_MESSAGE_MAP()


// CShowItemApprovals message handlers

BOOL CShowItemApprovals::OnInitDialog()
{
	if(m_api==0 || m_item == 0) return FALSE;

	BOOL res=m_ListObjects.CreateFromStatic(IDC_LIST_OBJECTS_STATIC,this,0);
	m_ListObjects.SetUniqueName(_T("CShowItemApprovals"));

	CaplResizableDialog::OnInitDialog();

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	// TODO:  Add extra initialization here
	m_ListObjects.DeleteAllColumns();// -        "..."

	m_ListObjects.InsertColumn(0, APL_T("."),LVCFMT_LEFT,80);
	m_ListObjects.InsertColumn(1, APL_T(""),LVCFMT_LEFT,80);
	m_ListObjects.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	m_ListObjects.InsertColumn(3, APL_T(""),LVCFMT_LEFT,110);
	m_ListObjects.InsertColumn(4, APL_T(""),LVCFMT_LEFT,110);
	m_ListObjects.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,110);
	m_ListObjects.LoadColumnWidths();
	m_ListObjects.SetColumnDate(3);


	AddAnchor(IDC_OBJECT_ID,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_LIST_OBJECTS_STATIC,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_HIDE_REVOCATION,BOTTOM_LEFT, BOTTOM_LEFT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT, BOTTOM_RIGHT);

	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);

	FeelTable();

	return TRUE;  
	// return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


bool CShowItemApprovals::FeelTable()
{
	if(m_api==0 || m_item == 0) return false;
	if(m_item->GetType()==0)return false;

	CString m_type = _T(""),s_dt;
	aplExtent ext0;
	int i,k;
	CaplInstance *inst, *inst0=0;
	CString buf;
	COleDateTime odt;

	m_ListObjects.DeleteAllItems();

	if(m_item->GetAccessmode() == aplNO)
	{
		m_ObjectId = APL_T("<   >");
		UpdateData(FALSE);
		return true;
	}

	m_ObjectId = m_api->GetItemTypeName(m_item) + _T(" : ") + m_api->GetItemName(m_item);
	UpdateData(FALSE);

	if(m_api->m_data.IsKindOf(m_item,m_api->m_doc_mgr.e_apl_doc))
	{
		m_api->m_data.GetAttr(m_item, m_api->m_doc_mgr.a_apl_doc_active, inst0);
		m_item = inst0;
		inst0 = 0;
	}
	else if(m_api->m_data.IsKindOf(m_item,m_api->m_bp_mgr.e_bp) && m_api->m_bp_mgr.m_bUseVersions)
	{
		m_api->m_data.GetAttr(m_item,m_api->m_bp_mgr.a_bp_act,inst0);
	}
	else if(m_api->m_data.IsKindOf(m_item,m_api->m_charact_mgr.e_apl_charact_value) && m_api->m_charact_mgr.m_bUseVersions)
	{
		m_api->m_data.GetAttr(m_item,m_api->m_charact_mgr.a_apl_charact_val_act_ver,inst0);
	}

	m_api->m_appr_mgr.LoadItemApproval(m_item,ext0);
	aplExtent ext1;
	if(inst0)
	{
		if(inst0->GetAccessmode()<aplNO)
		{
			m_api->m_appr_mgr.LoadItemApproval(inst0,ext1);
			ext0.Append(ext1);
		}
	}

	m_ListObjects.SetRedraw(FALSE);

	for(i=0;i<ext0.Size;i++)
	{
		CaplInstance *appr=ext0[i];
		if(appr!=0)
		{
			if(m_HideRevocation==TRUE)
			{
				m_api->m_data.GetAttr(appr,m_api->m_appr_mgr.a_appr_revocation_date_time,buf);
				if(buf!=_T("")) continue;
			}

			if(appr->GetAccessmode() == aplNO)
			{
				buf = APL_T("<   >");
			}
			else
			{
				m_api->m_data.GetAttrBN(appr,_T("status"),inst);
				if(inst!=0) m_api->m_data.GetAttrBN(inst,S::name,buf);
			}

			k=m_ListObjects.InsertItem(0,buf);
			m_ListObjects.SetItemData(k,(long)appr);
			if(appr->GetAccessmode() == aplNO)continue;

			m_api->m_data.GetAttrBN(appr,_T("role"),buf);
			m_ListObjects.SetItemText(k,1,buf);

			m_api->m_data.GetAttrBN(appr,_T("person_organization"),inst);
			if(inst!=0)
				if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_pers_org))
					m_api->m_data.GetAttrBN(inst,_T("the_person"),inst);
			//if(inst!=0)m_api->m_data.GetAttrBN(inst,_T("last_name"),buf);
			if(inst!=0)m_api->GetItemName(inst,buf);
			m_ListObjects.SetItemText(k,2,buf);

			m_api->m_data.GetAttrBN(appr,_T("approval_date_time_s"),s_dt);
			if(aplString2Date(s_dt,odt))
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			else buf=_T("");
			m_ListObjects.SetItemText(k,3,buf);

			m_api->m_data.GetAttrBN(appr,_T("notes"),buf);
			m_ListObjects.SetItemText(k,4,buf);

			m_api->m_data.GetAttrBN(appr,_T("revocation_date_time"),s_dt);
			if(aplString2Date(s_dt,odt))
				buf=odt.Format(_T("%d.%m.%Y  %H:%M:%S"));
			else buf=_T("");
			m_ListObjects.SetItemText(k,5,buf);

		}
	}

	m_ListObjects.SortColumn(m_ListObjects.GetMainSortColumn());

	m_ListObjects.SetRedraw(TRUE);

	return true;
}

void CShowItemApprovals::OnDblclkListAttributes(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	int selected_item = m_ListObjects.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	if( selected_item == -1)
	{
		return;
	}
	CaplInstance* appr = (CaplInstance*)m_ListObjects.GetItemData(selected_item);
	if(appr->GetAccessmode() == aplNO) return;

	m_api->m_appr_mgr.ShowApproval(appr);

}

void CShowItemApprovals::OnBnClickedHideRevocation()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	FeelTable();
}
