// aplApprovalView.cpp : implementation file
//

#include "stdafx.h"
#include "aplApprovalView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplApprovalView

IMPLEMENT_DYNCREATE(CaplApprovalView, CaplPropsView)

CaplApprovalView::CaplApprovalView()
{
}

CaplApprovalView::~CaplApprovalView()
{
}


BEGIN_MESSAGE_MAP(CaplApprovalView, CaplPropsView)
	//{{AFX_MSG_MAP(CaplApprovalView)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplApprovalView drawing

void CaplApprovalView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CaplApprovalView diagnostics

#ifdef _DEBUG
void CaplApprovalView::AssertValid() const
{
	CaplPropsView::AssertValid();
}

void CaplApprovalView::Dump(CDumpContext& dc) const
{
	CaplPropsView::Dump(dc);
}
#endif //_DEBUG


BOOL CaplApprovalView::InitColumns(void)
{
	CListCtrl*	pList		=NULL;

	CString		csTxt[]		={ APL_T(""), APL_T(""), APL_T(""), APL_T("")};
	int			iSz[]		={100,150,100,150};

	int			i;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	pList->SetImageList(aplGetInstImageList(),LVSIL_SMALL);

	for(i=0;i<sizeof(iSz)/sizeof(int);i++)
		pList->InsertColumn(i,csTxt[i],LVCFMT_LEFT,iSz[i]);

	long lStyles=::GetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE);
	lStyles|=LVS_SINGLESEL|LVS_SHOWSELALWAYS;
	::SetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE,lStyles);

	return TRUE;
}

BOOL CaplApprovalView::_CanDel(CaplInstance* ciIn)
{
	CaplInstance *po=0,*pers=0,*user=0,*pers_cur=0;

	CaplInstance*	ciPO		=NULL;
	CaplInstance*	ciPers		=NULL;
	CaplInstance*	ciUser		=NULL;
	CaplInstance*	ciCurPers	=NULL;

	if(NULL==ciIn)
		return FALSE;

	if(!m_api->m_appr_mgr.IsAdmin())
	{
		apidata.GetAttr(ciIn,m_api->m_appr_mgr.a_appr_pers_org,ciPO);
		if(NULL!=ciPO)
			apidata.GetAttr(ciPO,m_api->m_appr_mgr.a_po_the_pers,ciPers);
		
		ciCurPers=m_api->m_appr_mgr.GetCurrentPerson();
		if(ciPers!=ciCurPers)
			return FALSE;
	}

	return TRUE;
}

void CaplApprovalView::ChangeCtrlsState(void)
{
	CaplInstance*	cit	=NULL;

	POSITION pos		=NULL;

	CListCtrl*	pList	=NULL;

	BOOL	bEnAdd		=FALSE;
	BOOL	bEnDel		=FALSE;
	BOOL	bEnProps	=FALSE;

	int		ipos;

	if(!IsWindowVisible())
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	pos=pList->GetFirstSelectedItemPosition();

	if(NULL!=m_inst)
		if(m_inst->GetAccessmode()<=aplRO)
		{
			bEnAdd=TRUE;
			if(NULL!=pos)
			{
				ipos=pList->GetNextSelectedItem(pos);
				cit=(CaplInstance*)pList->GetItemData(ipos);
				if(m_api->m_data.IsMyInstance(cit, true))
				{
					bEnDel=_CanDel(cit);
					bEnProps=TRUE;
				}
			}
		}

	m_pAdd->EnableWindow(bEnAdd);
	m_pDel->EnableWindow(bEnDel);
	m_pProps->EnableWindow(bEnProps);
}

BOOL CaplApprovalView::LoadData(void)
{
	if(NULL==m_api)
		return TRUE;

	if(NULL==m_inst)
		return TRUE;

	if(false==m_api->m_appr_mgr.LoadItemApproval(m_inst,m_aeItems,true))
		return FALSE;

	return TRUE;
}

BOOL CaplApprovalView::_FillItem(int iPos,CaplInstance* ciIn)
{
	CaplInstance*		cit		=NULL;
	CaplInstance*		cit2	=NULL;

	CListCtrl*			pList	=NULL;

	COleDateTime		codt;

	CString				cst,cst2;

	int					i;

	if(NULL==m_api)
		return FALSE;

	if(NULL==ciIn)
		return FALSE;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	if(pList->GetItemCount()<=iPos)
		iPos=pList->InsertItem(iPos,_T(""),m_api->GetInstIco(ciIn));

	for(i=0;i<pList->GetHeaderCtrl()->GetItemCount();i++)
		pList->SetItemText(iPos,i,_T(""));

	apidata.GetAttr(ciIn,m_api->m_appr_mgr.a_appr_status,cit);
	if(NULL!=cit)
		apidata.GetAttr(cit,m_api->m_appr_mgr.a_appr_status_name,cst);
	pList->SetItemText(iPos,0,cst);cst=_T("");

	apidata.GetAttr(ciIn,m_api->m_appr_mgr.a_appr_role,cst);
	pList->SetItemText(iPos,1,cst);cst=_T("");


	apidata.GetAttr(ciIn,m_api->m_appr_mgr.a_appr_pers_org,cit);
	if(NULL!=cit)
	{
		if(m_api->m_data.IsKindOf(cit, m_api->m_appr_mgr.e_pers_org))
			apidata.GetAttr(cit,m_api->m_appr_mgr.a_po_the_pers,cit2);
		else
			cit2 = cit;
		if(NULL!=cit2)
		{
			apidata.GetAttr(cit2,m_api->m_appr_mgr.a_pers_last_name,cst);
			pList->SetItemText(iPos,2,cst);cst=_T("");
		}
	}


	apidata.GetAttr(ciIn,m_api->m_appr_mgr.a_appr_appr_date_time_s,cst);
	if(aplString2Date(cst,codt))
		cst=codt.Format(_T("%d.%m.%Y  %H:%M:%S"));
	else
		cst=_T("");
	pList->SetItemText(iPos,3,cst);cst=_T("");

	pList->SetItemData(iPos,(DWORD)ciIn);

	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
// CaplApprovalView message handlers
void CaplApprovalView::OnBAdd(void)
{
	CListCtrl*		pList	=NULL;

	CaplInstance*	cit		=NULL;

	if(0==m_inst->GetType())
		return;
	if(m_inst->GetAccessmode()>aplRO)
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	cit=m_api->m_appr_mgr.CreateApproval(m_inst);
	if(NULL!=cit)
	{
		_FillItem(m_aeItems.GetSize(),cit);
		m_aeItems.Add(cit);
	}
	
	ReSort();
}

void CaplApprovalView::OnBDel(void)
{
	CaplInstance*	cit		=NULL;
	CaplInstance*	cit1	=NULL;

	aplExtent		aet;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				i,iPos,iRet;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;

	if(cit->GetAccessmode()>aplOWN)
	{
		AfxMessageBox( APL_T(" !"),MB_ICONSTOP|MB_OK);
		return;
	}

	iRet=AfxMessageBox( APL_T("  ?"),MB_ICONQUESTION|MB_YESNO);
	if(IDNO==iRet)
		return;

	apidata.GetAttr(cit,m_api->m_appr_mgr.a_appr_attachment,aet);
	for(i=0;i<aet.GetSize();i++)
	{
		cit1=aet.GetAt(i);
		if(!apidata.IsKindOf(cit1,m_api->m_doc_mgr.e_apl_stored_document))
			continue;
		apidata.NET_DeleteBlob(cit1,m_api->m_doc_mgr.a_apl_stored_document_source);
	}

	for(i=0;i<m_aeItems.GetSize();i++)
		if(cit==m_aeItems.GetAt(i))
		{
			m_aeItems.Remove(i);
			break;
		}

	pList->DeleteItem(iPos);

	apidata.DeleteInstance(cit);

	apidata.NET_SaveChanges( APL_T("  "));
}

void CaplApprovalView::OnBProps(void)
{
	CaplInstance*	cit		=NULL;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				iPos;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;

	if(true==m_api->m_appr_mgr.ShowApproval(cit))
		_FillItem(iPos,cit);
}
