// aplCertificateDlg.cpp : implementation file
//

#include "stdafx.h"
#include "aplCertificateDlg.h"
#include "CommonCertInfoDlg.h"
#include "CertOwnerCratorDlg.h"
#include "CertVerificationDlg.h"

CString Convert2String(COleDateTime time)
{
	CString str;

	str.Format(_T("%.2d.%.2d.%.4d     %.2d:%.2d:%.2d"), time.GetDay(), time.GetMonth(), time.GetYear(), time.GetHour(), time.GetMinute(), time.GetSecond());
	return str;
}

// CaplCertificateDlg dialog

IMPLEMENT_DYNAMIC(CaplCertificateDlg, CaplTranslateDialog)

CaplCertificateDlg::CaplCertificateDlg(CaplAPI *api, CaplInstance *ciCert, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CaplCertificateDlg::IDD, pParent)
{
	m_api = api;
	m_ciCert = ciCert;
}

CaplCertificateDlg::~CaplCertificateDlg()
{
}

void CaplCertificateDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);	

	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_TAB, m_tab);
	DDX_Control(pDX, IDC_SAVE, m_save_btn);
}


BEGIN_MESSAGE_MAP(CaplCertificateDlg, CaplTranslateDialog)
	ON_WM_DESTROY()

	ON_BN_CLICKED(IDC_WIN_SHOW, &CaplCertificateDlg::OnBnClickedWinShow)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, &CaplCertificateDlg::OnTcnSelchangeTab)
	ON_NOTIFY(TCN_SELCHANGING, IDC_TAB, &CaplCertificateDlg::OnTcnSelchangingTab)
	ON_BN_CLICKED(IDC_SAVE, &CaplCertificateDlg::OnBnClickedSave)
END_MESSAGE_MAP()

BOOL CaplCertificateDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	//  
	InitButtons();

	//  
	//InitLists();

	//      
	if(!SaveCertificateToTmpFile())
	{
		EndDialog(0);
		return FALSE;
	}

	//    
	GetCertificateInfo();

	//  ""
	FillGrpCertificate();

	ConstructTab();

	return TRUE;
}

bool CaplCertificateDlg::SaveCertificateToTmpFile()
{
	CString sBlob, sName, sFile;

	if(m_api->m_data.IsKindOf(m_ciCert,m_api->m_appr_mgr.e_apl_digital_sign_open_key))
		m_api->m_data.GetAttr(m_ciCert, m_api->m_appr_mgr.a_apl_digital_sign_open_key_open_key_cert_blob, sBlob);
	else  if(m_api->m_data.IsKindOf(m_ciCert,m_api->m_appr_mgr.e_apl_appr))
		m_api->m_data.GetAttr(m_ciCert, m_api->m_appr_mgr.a_appr_dg_sign_cert, sBlob);

	if(sBlob.IsEmpty())
	{
		MessageBox( APL_T("     ."),  APL_T(" "), MB_ICONSTOP);
		return false;
	}

	//     .     
	sName = CaplCryptographicManager::GenRandom();
	aplGetTempPath(m_sFile);
	m_sFile	+= sName + ".cer";

	if(!m_api->m_data.NET_LoadFileFromSrv(sBlob, m_sFile,  APL_T(" ...")))
	{
		MessageBox( APL_T("     !"),  APL_T(" "), MB_ICONSTOP);
		return false;
	}

	return true;
}

bool CaplCertificateDlg::GetCertificateInfo()
{
	CaplCryptographicManager::GetDataFromCertFile(m_sFile, m_sSubject, m_sOpenKey, m_dtNotBefor, m_dtNotAfter, m_sIssuer, m_sSN, m_sAlgorithm);

	int i = 0;
	CString str = m_sSN;

	m_sSN="";
	for(i=str.GetLength(); i >= 1; i-=2)
		m_sSN += str.Mid(i-2, 2);			

	for(i=0; i<m_sSN.GetLength(); i+=2) { m_sSN.Insert(i, ' '); i++; }

	return true;
}

bool CaplCertificateDlg::FillGrpCertificate()
{
	m_sNotBefor = Convert2String(m_dtNotBefor);
	m_sNotAfter =(Convert2String(m_dtNotAfter));	

	return true;
}

bool CaplCertificateDlg::DeleteTmpFile()
{
	::SetFileAttributes(m_sFile, FILE_ATTRIBUTE_NORMAL);
	::DeleteFile(m_sFile);

	return true;
}

void CaplCertificateDlg::OnCancel()
{
	DeleteTmpFile();
	CaplTranslateDialog::OnCancel();
}

void CaplCertificateDlg::OnOK()
{
	DeleteTmpFile();
	CaplTranslateDialog::OnOK();
}

bool CaplCertificateDlg::InitButtons()
{
	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));

	m_save_btn.SetFlat(FALSE);
	m_save_btn.SetIcon(GetAplTableIco(APL_TABLE_SAVE));

	return true;
}
void CaplCertificateDlg::OnBnClickedWinShow()
{
	
}

bool CaplCertificateDlg::ConstructTab()
{
	TC_ITEM TabItem;
	//TabItem.mask = TCIF_TEXT;

	/************************************************************************/
	/*                                                                      */
	/************************************************************************/

	//    
	m_tab.InsertItem(0,  APL_T(" "));
	CCommonCertInfoDlg* pPage1 = new CCommonCertInfoDlg(this);
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)pPage1;
	m_tab.SetItem(0, &TabItem);
	pPage1->Create(CCommonCertInfoDlg::IDD, &m_tab);
	pPage1->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	pPage1->ShowWindow(SW_SHOW); 
		
	/************************************************************************/
	/*                                                                      */
	/************************************************************************/

	//    
	m_tab.InsertItem(1,  APL_T(" / "));
	CCertOwnerCratorDlg* pPage2 = new CCertOwnerCratorDlg(this); 
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)pPage2;
	m_tab.SetItem(1, &TabItem);
	pPage2->Create(CCertOwnerCratorDlg::IDD, &m_tab);
	pPage2->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	pPage2->ShowWindow(SW_HIDE);

	/************************************************************************/
	/*                                                                      */
	/************************************************************************/		

	//    
	m_tab.InsertItem(2,  APL_T(""));
	CCertVerificationDlg* pPage3 = new CCertVerificationDlg(this);	
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)pPage3;
	m_tab.SetItem(2, &TabItem);
	pPage3->Create(CCertVerificationDlg::IDD, &m_tab);
	pPage3->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	pPage3->ShowWindow(SW_HIDE);

	return true;
}

void CaplCertificateDlg::OnDestroy()
{
	CaplTranslateDialog::OnDestroy();

	CWnd* pWnd;
	TC_ITEM tci;
	tci.mask = TCIF_PARAM; 

	for (int i = m_tab.GetItemCount()-1; i>=0; i--)
	{
		m_tab.GetItem(i, &tci);
		ASSERT(tci.lParam); 

		pWnd = (CWnd *)tci.lParam;
		pWnd->DestroyWindow();
		delete pWnd;
	}	
}
void CaplCertificateDlg::OnTcnSelchangeTab(NMHDR *pNMHDR, LRESULT *pResult)
{
	int nTab = m_tab.GetCurSel(); 
	TC_ITEM tci; 
	tci.mask = TCIF_PARAM; 

	m_tab.GetItem(nTab, &tci); 
	ASSERT(tci.lParam); 

	CWnd* pWnd = (CWnd *)tci.lParam; 
	pWnd->ShowWindow(SW_SHOW); 	

	*pResult = 0;
}

void CaplCertificateDlg::OnTcnSelchangingTab(NMHDR *pNMHDR, LRESULT *pResult)
{
	int nTab = m_tab.GetCurSel(); 
	TC_ITEM tci;
	tci.mask = TCIF_PARAM; 

	m_tab.GetItem(nTab, &tci);
	ASSERT(tci.lParam); 

	CWnd* pWnd = (CWnd *)tci.lParam;
	pWnd->ShowWindow(SW_HIDE); 

	*pResult = 0;
}

void CaplCertificateDlg::OnBnClickedSave()
{
	if(m_sFile==_T("")) {AfxMessageBox(APL_T("   ")); return;}

	CFileDialog f_dlg(FALSE,_T("*.cer"),0,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, APL_T("  (*.cer)|*.cer|  (*.*)|*.*|"),this);
	if(f_dlg.DoModal()!=IDOK) return;

	CFileFind ff;
	if(ff.FindFile(f_dlg.GetPathName()))
	{
		SetFileAttributes(f_dlg.GetPathName(),FILE_ATTRIBUTE_NORMAL);
		DeleteFile(f_dlg.GetPathName());
	}
	CopyFile(m_sFile,f_dlg.GetPathName(),FALSE);
}
