#pragma once
#include "apl_gui.h"


// CaplCertificateDlg dialog

class CaplCertificateDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CaplCertificateDlg)

public:
	CaplCertificateDlg(CaplAPI *api, CaplInstance *ciCert, CWnd* pParent = NULL);   // standard constructor
	virtual ~CaplCertificateDlg();

// Dialog Data
	enum { IDD = IDD_CERT_PROPERTIES };

	CaplButton m_ok_btn;
	CTabCtrl m_tab;

	//  
	CString m_sFile;

	//   
	CString m_sSubject;
	CString m_sOpenKey;
	CString m_sIssuer;
	CString m_sSN;
	CString m_sAlgorithm;
	CString m_sNotBefor;
	CString m_sNotAfter;

	COleDateTime m_dtNotBefor;
	COleDateTime m_dtNotAfter;

	//  
	CaplAPI *m_api;
	CaplInstance *m_ciCert;

protected:

	//   
	bool ConstructTab();

	//   ""
	bool FillGrpCertificate();

	//      
	bool SaveCertificateToTmpFile();

	//    
	bool GetCertificateInfo();

	//  ,  
	bool DeleteTmpFile();

	//  
	bool InitButtons();

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedWinShow();
	afx_msg void OnDestroy();
	afx_msg void OnTcnSelchangeTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTcnSelchangingTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedSave();
	CaplButton m_save_btn;
};
