// aplListCtrl.cpp : implementation file
//

#include "stdafx.h"

#if _MSC_VER < 1400
#	include "list.h"
#endif

#include "aplListCtrl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplCompareFolderListCtrl

CaplCompareFolderListCtrl::CaplCompareFolderListCtrl()
{
	m_dark = RGB(128,128,128);
	m_red = RGB(255,0,0);
	m_green = RGB(0,200,0);
	m_lith = RGB(200,200,200);
	m_cx_level = 5;
}

CaplCompareFolderListCtrl::~CaplCompareFolderListCtrl()
{
}


BEGIN_MESSAGE_MAP(CaplCompareFolderListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CaplCompareFolderListCtrl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplCompareFolderListCtrl message handlers
void CaplCompareFolderListCtrl::DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	// TODO: Add your message handler code here and/or call default
	CDC dc;
	dc.Attach(lpDrawItemStruct->hDC);
	
	CItem *item = (CItem*)GetItemData(lpDrawItemStruct->itemID);
	if(item==0) return;
	RECT r = lpDrawItemStruct->rcItem;
	r.left+=15+item->level1*m_cx_level;
	
	COLORREF crOldTextColor = dc.GetTextColor();
	COLORREF crOldBkColor = dc.GetBkColor();
	
	if ((lpDrawItemStruct->itemAction & ODA_SELECT) &&
      (lpDrawItemStruct->itemState & ODS_SELECTED))
	{
		dc.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		dc.SetBkColor(::GetSysColor(COLOR_HIGHLIGHT));
		dc.FillSolidRect(&r,::GetSysColor(COLOR_HIGHLIGHT));
	}
	else
	{
		if(item->color==0) dc.FillSolidRect(&r, crOldBkColor);
		else if(item->color==1) dc.FillSolidRect(&r, m_dark);
		else if(item->color==2 || item->color == 3) dc.FillSolidRect(&r, m_lith);
		if(item->color==1)
			dc.SetTextColor(m_red);
		else if(item->color==2)
			dc.SetTextColor(m_green);
		else if(item->color==3)
			dc.SetTextColor(m_blue);
	}


	if ((lpDrawItemStruct->itemAction & ODA_FOCUS) &&
      (lpDrawItemStruct->itemState & ODS_FOCUS))
	{
		CBrush br(::GetSysColor(COLOR_SCROLLBAR));
		dc.FrameRect(&r, &br);
	}

	CHeaderCtrl *header = this->GetHeaderCtrl();
	int cnt = header->GetItemCount();
	for(int i=0; i<cnt;i++)
	{
		RECT rect;
		header->GetItemRect(i,&rect);
		rect.top = r.top;
		if(i==0) rect.left+=item->level1*m_cx_level;
		else rect.left+=item->level2*m_cx_level;
		if(i==0 || i==m_col)
		{
			rect.left+=15;
			int img = i==0 ? item->img1 : item->img2;
			if(rect.right - rect.left>16 && m_image.m_hImageList!=0)
				m_image.Draw(&dc,img,CPoint(rect.left-14,rect.top),ILD_TRANSPARENT);
		}
		rect.left+=2;
		rect.bottom = r.bottom;
		CString str, points=_T("");
		str = GetItemText(lpDrawItemStruct->itemID,i);
		int size = dc.GetTextExtent(str).cx;
		while(str>_T("") && size>rect.right-rect.left)
		{
			str = str.Left(str.GetLength()-1);
			points = _T("...");
			size = dc.GetTextExtent(str+points).cx;
		}
		dc.DrawText(str+points,_strlen(str+points),&rect,DT_LEFT|DT_SINGLELINE|DT_VCENTER);
	}
	dc.SetTextColor(crOldTextColor);
	dc.SetBkColor(crOldBkColor);
	dc.Detach();
}

BOOL CaplCompareFolderListCtrl::DestroyWindow() 
{
	while(GetItemCount()>0)
	{
		CItem *item = (CItem*)GetItemData(0);
		if(item) delete item;
		DeleteItem(0);
	}
	m_image.DeleteImageList();
	return CListCtrl::DestroyWindow();
}

void CaplCompareFolderListCtrl::SetImageList(CImageList *img, UINT mode, int scol)
{
	m_image.DeleteImageList();
	m_image.Create(img);
	CListCtrl::SetImageList(&m_image,mode);
	m_col = scol;
}

COLORREF CaplCompareFolderListCtrl::SetColor(COLORREF color, UINT id)
{
	COLORREF old=0;
	if(id&LCC_DARK)
	{
		old = m_dark;
		m_dark = color;
	}
	else if(id&LCC_LIGHT)
	{
		old = m_lith;
		m_lith = color;
	}
	else if(id&LCC_RED)
	{
		old = m_red;
		m_red = color;
	}
	else if(id&LCC_GREEN)
	{
		old= m_green;
		m_green = color;
	}
	else if(id&LCC_BLUE)
	{
		old= m_blue;
		m_blue = color;
	}
	return old;
}

CItem::CItem()
{
	color = 0;
	m_inst = 0;
	m_type = 0;
	m_folder = 0;
	path = _T("");
	img1 = -1;
	img2 = -1;
	level1 = 0;
	level2 = 0;
	fsize = 0;
}

void CaplCompareFolderListCtrl::DeleteAllItems()
{
	while(GetItemCount()>0)
	{
		CItem *item = (CItem*)GetItemData(0);
		if(item) delete item;
		DeleteItem(0);
	}
}

void CaplCompareFolderListCtrl::SetLevelCX(int cx)
{
	m_cx_level = cx;
}

void CaplCompareFolderListCtrl::SelCur(int cur)
{
	if(cur>-1 && cur<GetItemCount())
		SetItemState(cur,LVIS_SELECTED|LVIS_FOCUSED,LVIS_SELECTED|LVIS_FOCUSED);
}

COLORREF CaplCompareFolderListCtrl::Invert(COLORREF color)
{
	BYTE rval = GetRValue(color);
	BYTE gval = GetGValue(color);
	BYTE bval = GetBValue(color);
	return RGB(255-rval,255-gval,255-bval);
}

CItem* CaplCompareFolderListCtrl::GetItemData(int cur)
{
	return (CItem*)CListCtrl::GetItemData(cur);
}
