// aplOrgStructHelper.h: interface for the CaplOrgStructHelper class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLORGSTRUCTHELPER_H__8EBDC9A7_7CF2_466A_9D11_54CE1EAE062E__INCLUDED_)
#define AFX_APLORGSTRUCTHELPER_H__8EBDC9A7_7CF2_466A_9D11_54CE1EAE062E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CaplAPI;

class CaplOrgStructHelper
{
	CaplAPI *m_api;
	CaplAggrMap m_org_struct_map;
	CaplAggrMap m_org_pers_map;
	bool m_bWithPers, m_bWithOffc, m_bWithMy, m_bWithAWG;
	HTREEITEM InsertFolder(CTreeCtrl &tc, CaplInstance *folder, HTREEITEM parent);

	static int CALLBACK CompareTreeItems(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);

public:
	void SetApi(CaplAPI *api);
	void FillTree(CTreeCtrl &tc, aplExtent &extRoot, bool bWithPers, bool bWithOffc, bool bWithMy, bool bWithAWG, bool bPO);
	void Sort(CTreeCtrl &tc, HTREEITEM item);
	void InsertItem(CTreeCtrl &tc, CaplInstance *item, HTREEITEM parent);
};

#endif // !defined(AFX_APLORGSTRUCTHELPER_H__8EBDC9A7_7CF2_466A_9D11_54CE1EAE062E__INCLUDED_)


