// ListDialog.cpp : implementation file
//

#include "stdafx.h"
#include "ListDialog.h"
#include <AplGuiEx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "dictionary.h"
#include "apl_api.h"
#include "aplWorkFlowManager.h"

#include "TPDialog.h"
/////////////////////////////////////////////////////////////////////////////
// CListDialog dialog

CListDialog::CListDialog(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CListDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CListDialog)
	m_sName = APL_T("< >");
	//}}AFX_DATA_INIT

	m_bReadOnly= FALSE;
	m_index= -1;

	m_sItemsType= _T("work_object");
	m_api= NULL;
	m_sTitle= _T("");
	m_curSelItem= NULL;
	m_process= NULL;
	m_proc_tmpl= NULL;

	m_wf_mgr= NULL;
}


void CListDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CListDialog)
	DDX_Control(pDX, IDC_SHOW_SCHEMA, m_showSchemaBtn);
	DDX_Control(pDX, IDC_ADD_BUTTON, m_addBtn);
	DDX_Control(pDX, IDC_PROP_BUTTON, m_propBtn);
	DDX_Control(pDX, IDC_DELETE_BUTTON, m_deleteBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_LOAD_BUTTON, m_loadBtn);
	DDX_Control(pDX, IDC_VIEW_BUTTON, m_viewBtn);
	DDX_Control(pDX, IDC_ITEMS_LIST, m_itemsList);
	DDX_Control(pDX, IDC_PROT_NAME, m_nameCtrl);
	DDX_Text(pDX, IDC_PROT_NAME, m_sName);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_GET_DLIT, m_get_glit_btn);
	DDX_Control(pDX, IDC_CLEAR_ISP, m_clear_isp_btn);
}


BEGIN_MESSAGE_MAP(CListDialog, CaplResizableDialog)
	//{{AFX_MSG_MAP(CListDialog)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_ITEMS_LIST, OnItemchangedItemsList)
	ON_NOTIFY(NM_DBLCLK, IDC_ITEMS_LIST, OnDblclkItemsList)
	ON_BN_CLICKED(IDC_ADD_BUTTON, OnAddButton)
	ON_BN_CLICKED(IDC_PROP_BUTTON, OnPropButton)
	ON_BN_CLICKED(IDC_DELETE_BUTTON, OnDeleteButton)
	ON_BN_CLICKED(IDC_LOAD_BUTTON, OnLoadButton)
	ON_BN_CLICKED(IDC_VIEW_BUTTON, OnViewButton)
	ON_BN_CLICKED(IDC_SHOW_SCHEMA, OnShowSchema)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GET_DLIT, &CListDialog::OnBnClickedGetDlit)
	ON_BN_CLICKED(IDC_CLEAR_ISP, &CListDialog::OnBnClickedClearIsp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CListDialog message handlers AFX_MSGMAP

BOOL CListDialog::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

	RECT rect0,rect1;
	m_get_glit_btn.GetWindowRect(&rect0);
	m_clear_isp_btn.GetWindowRect(&rect1);
	rect0.top=rect1.top; rect0.bottom=rect1.bottom;
	ScreenToClient(&rect0);
	m_get_glit_btn.MoveWindow(&rect0);

	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	m_addBtn.SetFlat(FALSE);
	m_addBtn.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_deleteBtn.SetFlat(FALSE);
	m_deleteBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_propBtn.SetFlat(FALSE);
	m_propBtn.SetIcon(aplGetButtonIco(APL_24_PROPERTIES));

	m_showSchemaBtn.SetFlat(FALSE);
	m_showSchemaBtn.SetIcon(aplGetButtonIco(APL_24_VIEW));

	m_get_glit_btn.SetFlat(FALSE);
	m_clear_isp_btn.SetFlat(FALSE);

	m_itemsList.SetImageList(aplGetInstImageList(), LVSIL_SMALL);
	m_itemsList.SetExtendedStyle(m_itemsList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
	
	AddAnchor(IDC_ITEMS_LIST,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDOK,BOTTOM_RIGHT);	
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);	
	AddAnchor(IDC_GET_DLIT,BOTTOM_LEFT);	
	AddAnchor(IDC_CLEAR_ISP,BOTTOM_LEFT);	

	AddAnchor(IDC_PROT_NAME, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_ADD_BUTTON, TOP_RIGHT);	
	AddAnchor(IDC_PROP_BUTTON, TOP_RIGHT);	
	AddAnchor(IDC_DELETE_BUTTON, TOP_RIGHT);	

	
	if(m_sItemsType==_T("work_object"))
	{
		m_itemsList.InsertColumn(0, APL_T(""), LVCFMT_LEFT, 240);
		m_itemsList.InsertColumn(1, APL_T(" "), LVCFMT_LEFT, 250);
		
		m_propBtn.SetWindowText(APL_T("..."));
		m_loadBtn.ModifyStyle(0, WS_VISIBLE, 0);
		m_viewBtn.ModifyStyle(0, WS_VISIBLE, 0);
		m_loadBtn.EnableWindow(FALSE);
		m_viewBtn.EnableWindow(FALSE);
		
		ShowWOInList(*m_items);	
	}
	else if(m_sItemsType==_T("task_prototype"))
	{
		m_itemsList.InsertColumn(0, APL_T(" "), LVCFMT_LEFT, 120);
		m_itemsList.InsertColumn(1, APL_T(" "), LVCFMT_LEFT, 150);
		m_itemsList.InsertColumn(2, APL_T(""), LVCFMT_LEFT, 120);
		m_itemsList.InsertColumn(3, APL_T(""), LVCFMT_LEFT, 120);		
		m_itemsList.InsertColumn(4, APL_T(""), LVCFMT_LEFT, 60);
		m_itemsList.InsertColumn(5, APL_T(" "), LVCFMT_LEFT, 120);
		m_itemsList.InsertColumn(6, APL_T(" "), LVCFMT_LEFT, 120);
		
		if(m_prototype)
			m_api->m_data.GetAttr(m_prototype, m_wf_mgr->a_proc_prot_name, m_sName);

		m_propBtn.SetWindowText(APL_T(""));
		m_propBtn.EnableWindow(FALSE);
		m_addBtn.EnableWindow(FALSE);

		m_get_glit_btn.ShowWindow(SW_SHOW);
		m_clear_isp_btn.ShowWindow(SW_SHOW);

		ShowTPInList(*m_items);
	}
	
	m_deleteBtn.EnableWindow(FALSE);
	SetWindowText(m_sTitle);

	if(!m_prototype) m_nameCtrl.SetReadOnly();

	if(m_bReadOnly)
	{
		m_addBtn.EnableWindow(FALSE);
		m_deleteBtn.EnableWindow(FALSE);
		m_propBtn.EnableWindow(FALSE);
// 		m_loadBtn.EnableWindow(FALSE);
//		m_viewBtn.EnableWindow(FALSE);
		m_okBtn.EnableWindow(FALSE);
	}

	UpdateData(FALSE);

	m_itemsList.SortColumn(0);
	m_itemsList.SortColumn(0);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CListDialog::OnItemchangedItemsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	m_index= m_itemsList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(-1!=m_index)
	{
		m_curSelItem= (CaplInstance*)m_itemsList.GetItemData(m_index);
		
		if(m_curSelItem)
		{
			if(m_curSelItem->GetType()==NULL) return;

			CaplInstance* inst= NULL;
			
			if(m_sItemsType==_T("work_object"))
			{	
				if(!m_bReadOnly)
				{
					m_deleteBtn.EnableWindow();
					m_propBtn.EnableWindow();
				}
				
				if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_wo))
					apidata.GetAttrBN(m_curSelItem, _T("object"), inst);					
				else
					inst= m_curSelItem;
				
				if(inst)
				{
					if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_stored_document) ||
						apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_assigned_document) ||
						 apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc) ||
						  apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc_rev))
					{
						m_loadBtn.EnableWindow();
						m_viewBtn.EnableWindow();
					}
					else
					{
						m_loadBtn.EnableWindow(FALSE);
						m_viewBtn.EnableWindow(FALSE);
					}
				}
			}
			else if(m_sItemsType==_T("task_prototype"))
			{
				bool bNew= true;
				int j;

				for(j= 0; j<m_taskItems.GetSize(); j++)
				{
					if(m_taskItems[j].m_activity==m_curSelItem){bNew= false;break;}
				}
				if(bNew)
				{
					for(j= 0; j<m_items->GetSize(); j++)
					{
						if(m_items->GetAt(j)==m_curSelItem){bNew= false;break;}
					}
				}
				if(bNew)
				{
					if(!m_bReadOnly)
					{
						m_addBtn.EnableWindow();
					}
					m_deleteBtn.EnableWindow(FALSE);
					m_propBtn.EnableWindow(FALSE);				
				}
				else
				{
					m_addBtn.EnableWindow(FALSE);
					m_propBtn.EnableWindow();
					if(!m_bReadOnly)
					{
						m_deleteBtn.EnableWindow();
					}
				}
			}
		}
		else //  
		{
			m_loadBtn.EnableWindow(FALSE);
			m_viewBtn.EnableWindow();
			m_deleteBtn.EnableWindow();

/*			if(m_sItemsType==_T("task_prototype"))
			{
				m_addBtn.EnableWindow();
				m_propBtn.EnableWindow(FALSE);
			}*/
		}
	}
	else
	{
		m_deleteBtn.EnableWindow(FALSE);
		m_loadBtn.EnableWindow(FALSE);
		m_viewBtn.EnableWindow(FALSE);

		if(m_sItemsType==_T("task_prototype"))
		{
			m_addBtn.EnableWindow(FALSE);
			m_propBtn.EnableWindow(FALSE);
		}
		
		m_curSelItem= NULL;
	}

	*pResult = 0;
}

void CListDialog::OnDblclkItemsList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	HD_NOTIFY *phdn = (HD_NOTIFY *) pNMHDR;
	
	if(-1==m_index) return;
	if(m_sItemsType==_T("task_prototype"))
	{		
		if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_activity))
		{
			bool bNew= true;
			for(int j= 0; j<m_taskItems.GetSize(); j++)
			{
				if(m_taskItems[j].m_activity==m_curSelItem){bNew= false;break;}
			}

			if(bNew)
			{
				if(!m_bReadOnly)
					AddTaskProt();
			}
			else
				ShowProperties();
		}
		else if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_task_tmpl))
		{
			ShowProperties();
		}
	}
	
	*pResult = 0;
}

void CListDialog::OnAddButton() 
{
	if(m_sItemsType==_T("work_object")) AddWorkObject();
	else if(m_sItemsType==_T("task_prototype")) AddTaskProt();
}

void CListDialog::OnPropButton() 
{
	if(m_sItemsType==_T("work_object")) AddFile();
	else if(m_sItemsType==_T("task_prototype")) ShowProperties();
}
  
void CListDialog::OnDeleteButton() 
{
	if(m_sItemsType==_T("work_object")) DeleteWorkObject();
	else if(m_sItemsType==_T("task_prototype")) DeleteTaskProt();	
}

CString CListDialog::GetTypeName(CaplInstance* inst)
{
	CString sType;
	
	if(!inst) return sType;
	if(!inst->GetType()) return sType;

	if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_prd))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_apl_pdf))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_prd_inst_mgr.e_prd_inst))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_prd_inst_mgr.e_lot))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_change_mgr.e_chng))
		sType = APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_bp_mgr.e_bp))
		sType= APL_T("-");
	else if(apidata.IsKindOf(inst, m_api->m_bp_mgr.e_apl_bp_inst))
		sType= APL_T(" -");
	else if(0!= m_api->m_expl_mgr && apidata.IsKindOf(inst, m_api->m_expl_mgr->e_apl_refusal))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_classifier_mgr.e_apl_classifier_system))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_classifier_mgr.e_apl_classifier_level))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_folder_mgr.e_folder))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_project_mgr->e_project))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_person))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_message_mgr.e_message))
		sType= APL_T("");
	else sType= inst->GetType()->name;

	return sType;
}

void CListDialog::OnShowSchema() 
{
	CaplInstance* activity= NULL;
	if(m_curSelItem)
	{
		if(m_api->m_data.IsKindOf(m_curSelItem, m_wf_mgr->e_activity))
			activity= m_curSelItem;
		else if(m_api->m_data.IsKindOf(m_curSelItem, m_wf_mgr->e_task_tmpl))
			m_api->m_data.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_activity, activity);
	}

	m_wf_mgr->ShowTemplateSchema(m_proc_tmpl, activity);
}

void CListDialog::AddWorkObject()
{
	if(!m_api && !apidata.IsConnected()) return;

	aplExtent res;
	m_wf_mgr->SelectInstanceEx(
								APL_MODE_SELECT_PRD |
								APL_MODE_SELECT_PDF |
								APL_MODE_SELECT_DOC |
								APL_MODE_SELECT_DOC_REVISION |
								APL_MODE_SELECT_CATEG_REVISION |
								APL_MODE_SELECT_BP_REVISION |
								APL_MODE_SELECT_LOT |
								APL_MODE_SELECT_PRDINST  |
								APL_MODE_SELECT_CATEGORY |
								APL_MODE_SELECT_FOLDER   |
								APL_MODE_SELECT_BP	|
								APL_MODE_SELECT_CLASSIF_SYSTEM	|
								APL_MODE_SELECT_CLASSIF_ELEMENT |								
								APL_MODE_SELECT_MULTY,
								res);
	
	bool bNew;
	CaplInstance* inst1;

	for(int j= 0; j<res.GetSize(); j++)
	{
		bNew= true;

		for(int i= 0; i<m_items->GetSize(); i++)
		{
			inst1= NULL;
			apidata.GetAttrBN(m_items->GetAt(i), _T("object"), inst1);
			if(res[j]==inst1) 
			{
				bNew= false;
				break;
			}
		}

		if(bNew && -1==m_newItems.Find(res[j]))
		{
			CString name, buf, type;
			UINT ico;

			m_api->GetItemName(res[j], name);
			ico = m_api->GetInstIco(res[j]);
			type= GetTypeName(res[j]);

			if(name.IsEmpty()) name.Format(_T("%s -> id %i"), res[j]->GetType()->name, res[j]->GetId());

			m_newItems.Add(res[j]);
			int n= m_itemsList.GetItemCount();
			int m= m_itemsList.InsertItem(n, name, ico);
			m_itemsList.SetItemData(m, (DWORD)res[j]);
			m_itemsList.SetItemText(m , 1, type);
		}	
	}
}

void CListDialog::AddTaskProt()
{
	CaplInstance* inst;
	int i;
	for(i= 0; i<m_delItems.GetSize(); i++)
	{
		inst= NULL;
		apidata.GetAttr(m_delItems[i], m_wf_mgr->a_task_tmpl_activity, inst);
		if(inst==m_curSelItem)
		{
			if(IDYES==AfxMessageBox(APL_T("  .\n\n  ?"), MB_YESNO|MB_ICONQUESTION))
			{
				m_curSelItem= m_delItems[i];
				m_itemsList.SetItemData(m_index, (DWORD)m_curSelItem);
				m_items->Add(m_curSelItem);
				m_delItems.Remove(i);
				
				ShowProperties();
				
				CaplInstance* mgr= NULL, *per= NULL, *act= NULL;
				CString name, buf;
				CaplAggr aggr0;
				COleDateTimeSpan odts;
				double rDur= 0;
				CString sId, sName;

				apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_performer ,per);
				apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_manager, mgr);
				apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_duration, rDur);
				apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_id, sId);
				apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_name, sName);

				if(per)
				{
					m_api->m_appr_mgr.GetPersonName(per, name);
					if(!name.IsEmpty()){m_itemsList.SetItemText(m_index, 2, name);}
				}
				name.Empty();

				if(mgr)
				{
					m_api->m_appr_mgr.GetPersonName(mgr, name);
				}
				m_itemsList.SetItemText(m_index, 3, name);
				name.Empty();
				
				if(0==rDur)buf=_T("");
				else
				{
					odts.m_span= rDur;
					buf.Format(APL_T("%i . %i . %i ."), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
				}
				m_itemsList.SetItemText(m_index, 4, buf);

				m_itemsList.SetItemText(m_index, 5, sId);
				m_itemsList.SetItemText(m_index, 6, sName);
				
				m_addBtn.EnableWindow(FALSE);
				m_propBtn.EnableWindow();
				m_deleteBtn.EnableWindow();

				return;
			}
		}
	}

	CTPDialog dlg;
	dlg.m_prot_info.m_api= m_api;
	dlg.m_prot_info.m_wfMgr= m_wf_mgr;
	dlg.m_api= m_api;
	dlg.m_wf_mgr= m_wf_mgr;
	dlg.m_process= m_process;
	dlg.m_proc_tmpl= m_proc_tmpl;
	
	dlg.m_tp= m_items;
	dlg.m_prototypes= &m_taskItems;

	dlg.m_prot_info.m_activity= m_curSelItem;
	if(m_prototype)
		dlg.m_bCanEditRole= true;

	if(IDOK==dlg.DoModal())
	{
		CString name, buf;
		UINT ico= APL_ICON_TASK;
		CaplAggr aggr0;
			
		m_itemsList.SetItemData(m_index, (DWORD)dlg.m_prot_info.m_activity);
		
		if(dlg.m_prot_info.m_performer)
		{
			m_api->m_appr_mgr.GetPersonName(dlg.m_prot_info.m_performer, name);			
			if(!name.IsEmpty()){m_itemsList.SetItemText(m_index, 2, name);}
			name.Empty();
		}
		else if(dlg.m_prot_info.m_performers.GetSize())
		{
			for(i= 0; i<dlg.m_prot_info.m_performers.GetSize(); i++)
			{
				m_api->m_appr_mgr.GetPersonName(dlg.m_prot_info.m_performers[i], buf);
				if(!buf.IsEmpty())
				{
					if(!name.IsEmpty())name+=_T("; ");
					name+=buf; 
				}
			}	
			if(!name.IsEmpty()){m_itemsList.SetItemText(m_index, 2, name);}
			name= _T("");
		}
		
		if(dlg.m_prot_info.m_manager)
		{
			m_api->m_appr_mgr.GetPersonName(dlg.m_prot_info.m_manager, name);			
			if(!name.IsEmpty()){m_itemsList.SetItemText(m_index, 3, name);}
			name= _T("");			
		}
		
		COleDateTimeSpan odts;
		odts.m_span= dlg.m_prot_info.m_rDuration;
		buf.Format(APL_T("%i . %i . %i ."), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
		if(!buf.IsEmpty()) m_itemsList.SetItemText(m_index, 4, buf);

		if(!dlg.m_prot_info.m_sId.IsEmpty()) 
			m_itemsList.SetItemText(m_index, 5, dlg.m_prot_info.m_sId);
		if(!dlg.m_prot_info.m_sName.IsEmpty())
			m_itemsList.SetItemText(m_index, 6, dlg.m_prot_info.m_sName);

		m_taskItems.Add(dlg.m_prot_info);
		
		m_addBtn.EnableWindow(FALSE);
		m_propBtn.EnableWindow();
		m_deleteBtn.EnableWindow();
	}
}

void CListDialog::DeleteWorkObject()
{
	if(IDYES!=MessageBox(APL_T("     ?"),
		APL_T("  "), MB_ICONWARNING|MB_YESNO))
		return;

	if(!m_curSelItem)
	{
		CString buf= m_itemsList.GetItemText(m_index, 0);
		m_itemsList.DeleteItem(m_index);
		for(int i=0; i<m_fileItems.GetSize(); i++)
			if(buf==m_fileItems[i]){m_fileItems.RemoveAt(i); break;}
	}
	else
	{	
/*		CaplInstance* inst= NULL;
		apidata.GetAttrBN(m_curSelItem, _T("object"), inst);

		if(!inst) return;
		
		bool bMod= false;

		if(apidata.IsKindOfBN(inst, _T("apl_stored_document")) ||
			apidata.IsKindOfBN(inst, _T("apl_assigned_document")))
		{
			m_items->Remove(m_items->Find(m_curSelItem));
			m_delItems.Add(m_curSelItem);
			apidata.DeleteInstance(inst);
			bMod= true;
		}*/
		
		int r= m_newItems.Find(m_curSelItem);
		
		if(-1!=r)
		{
			m_newItems.Remove(r);
		}
		else
		{
			m_items->Remove(m_items->Find(m_curSelItem));
			m_delItems.Add(m_curSelItem);
			//apidata.DeleteInstance(m_curSelItem);
//			bMod= true;
		}
		
//		if(bMod) apidata.NET_SaveChanges();
		
		m_itemsList.DeleteItem(m_index);
	}
}

void CListDialog::DeleteTaskProt()
{
	if(IDYES!=MessageBox(APL_T("    ?"),
		APL_T("  "), MB_ICONWARNING|MB_YESNO))
		return;
	
	CaplInstance* inst= NULL;
	
	if(!m_curSelItem || !m_curSelItem->GetType()) return;// 

	if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_activity))
	{
		inst= m_curSelItem;
		for(int i=0; i<m_taskItems.GetSize(); i++)
		{
			if(m_taskItems[i].m_activity==inst)
			{
				m_taskItems.RemoveAt(i);
				break;
			}
		}
	}
	else if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_task_tmpl))
	{
		apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_activity, inst);
		m_items->Remove(m_items->Find(m_curSelItem));
		m_delItems.Add(m_curSelItem);
	}

	aplExtent ext;
	CString buf, name, name1;
	double r;
	COleDateTimeSpan odts;

	m_api->m_data.GetAttr(inst, m_wf_mgr->a_activity_executors, ext);
	if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org))
	{
		m_api->m_appr_mgr.GetPersonName(ext[0], buf);
		name.Format(APL_T(" [%s]"), buf);
		m_itemsList.SetItemText(m_index, 2, name);
	}
	else
	{

		m_api->m_data.GetAttr(inst, m_wf_mgr->a_activity_managers, ext);
		if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org))
		{
			m_api->m_appr_mgr.GetPersonName(ext[0], buf);
			name1.Format(APL_T(" [%s]"), buf);
		}
	}
	

	apidata.GetAttr(inst, m_wf_mgr->a_activity_duration, r);
	if(0!=r)
	{
		odts.m_span= r;
		buf.Format(APL_T(" [%i . %i . %i .]"), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
	}

	m_itemsList.SetItemText(m_index, 2, name);
	m_itemsList.SetItemText(m_index, 3, name1);
	m_itemsList.SetItemText(m_index, 4, buf);	
	m_itemsList.SetItemText(m_index, 5, _T(""));
	m_itemsList.SetItemText(m_index, 6, _T(""));
	
	m_itemsList.SetItemData(m_index, (DWORD)inst);

	m_addBtn.EnableWindow();
	m_propBtn.EnableWindow(FALSE);
	m_deleteBtn.EnableWindow(FALSE);
}

void CListDialog::AddFile()
{
	CFileDialog dlg(TRUE,0,0,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT,
		_T("All Files (*.*)|*.*||"));
	
	CString buf;
	LPTSTR szFilesNames= buf.GetBuffer(2048);
	dlg.m_ofn.lpstrFile= szFilesNames;
	dlg.m_ofn.nMaxFile= 2048;

	if(dlg.DoModal()==IDOK)
	{
		buf.ReleaseBuffer();

		POSITION pos=dlg.GetStartPosition();
		while(pos!=0) 
		{
			CString buf= dlg.GetNextPathName(pos);		

			LVFINDINFO info;
			info.flags= LVFI_STRING;		
			info.psz= buf;
			
			if(m_itemsList.FindItem(&info, -1)==-1)
			{
				UINT ico= ICON_FILE;
				int n= m_itemsList.GetItemCount();
				int m= m_itemsList.InsertItem(n, buf, ico);
				m_itemsList.SetItemData(m, 0);
				m_fileItems.Add(buf);
				m_itemsList.SetItemText(m, 1, APL_T(""));
			}
			else
			{
				AfxMessageBox(buf+APL_T(":       ."));
			}		
		}
	}
}

void CListDialog::ShowProperties()
{
	CTPDialog dlg;
	dlg.m_wf_mgr= m_wf_mgr;
	dlg.m_api= m_api;
	dlg.m_process= m_process;
	dlg.m_proc_tmpl= m_proc_tmpl;
	dlg.m_tp= m_items;
	dlg.m_prototypes= &m_taskItems;
	
	dlg.m_bReadOnly= m_bReadOnly;
	if(m_prototype)
		dlg.m_bCanEditRole= true;

	int i= -1;
	
	if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_task_tmpl))
	{
		dlg.m_prot= m_curSelItem;
	}
	else if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_activity))
	{
		for(i=0; i<m_taskItems.GetSize(); i++)
		{
			if(m_taskItems[i].m_activity==m_curSelItem)
			{
				dlg.m_prot_info.m_activity= m_taskItems[i].m_activity;
				dlg.m_prot_info.m_manager= m_taskItems[i].m_manager;
				dlg.m_prot_info.m_performer= m_taskItems[i].m_performer;
				dlg.m_prot_info.m_performers.Append(m_taskItems[i].m_performers);
				dlg.m_prot_info.m_rDuration= m_taskItems[i].m_rDuration;
				dlg.m_prot_info.m_sId= m_taskItems[i].m_sId;
				dlg.m_prot_info.m_sName= m_taskItems[i].m_sName;
				dlg.m_prot_info.m_role= m_taskItems[i].m_role;
				break;
			}
		}
	}

	if(IDOK==dlg.DoModal())
	{
		CaplInstance* mgr= NULL, *per= NULL, *act= NULL;
		aplExtent pers;
		CString name, buf;
		CaplAggr aggr0;
		COleDateTimeSpan odts;
		double rDur= 0;
		CString sId, sName;

		if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_activity))
		{
			m_taskItems[i].m_activity= dlg.m_prot_info.m_activity;
			m_taskItems[i].m_manager= dlg.m_prot_info.m_manager;
			m_taskItems[i].m_performer= dlg.m_prot_info.m_performer;
			m_taskItems[i].m_performers.Clear(); 
			m_taskItems[i].m_performers.Append(dlg.m_prot_info.m_performers);
			m_taskItems[i].m_rDuration= dlg.m_prot_info.m_rDuration;
			m_taskItems[i].m_sId= dlg.m_prot_info.m_sId;
			m_taskItems[i].m_sName= dlg.m_prot_info.m_sName;
			m_taskItems[i].m_role= dlg.m_prot_info.m_role;
			
			act= dlg.m_prot_info.m_activity;
			mgr= dlg.m_prot_info.m_manager;
			per= dlg.m_prot_info.m_performer;
			pers.Clear(); pers.Append(dlg.m_prot_info.m_performers);
			rDur= dlg.m_prot_info.m_rDuration;
			sId= dlg.m_prot_info.m_sId;
			sName= dlg.m_prot_info.m_sName;
		}
		else if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_task_tmpl))
		{		
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_performer, per);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_performer, per);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_performers, pers);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_manager, mgr);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_duration, rDur);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_id, sId);
			apidata.GetAttr(m_curSelItem, m_wf_mgr->a_task_tmpl_name, sName);
		}

		if(per)
		{
			m_api->m_appr_mgr.GetPersonName(per, name);
			if(!name.IsEmpty()){m_itemsList.SetItemText(m_index, 2, name);}
		}
		else if(pers.GetSize())
		{
			for(i= 0; i<pers.GetSize(); i++)
			{
				m_api->m_appr_mgr.GetPersonName(pers[i], buf);
				if(!buf.IsEmpty())
				{
					if(!name.IsEmpty())name+=_T("; ");
					name+=buf; 
				}
			}
			
		}
		
		m_itemsList.SetItemText(m_index, 2, name);
		name= _T("");

		if(mgr)
		{
			m_api->m_appr_mgr.GetPersonName(mgr, name);
		}
		m_itemsList.SetItemText(m_index, 3, name);
		name= _T("");
		
		if(0==rDur) buf=_T("");
		else
		{
			odts.m_span= rDur;
			buf.Format(APL_T("%i . %i . %i ."), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
		}
		m_itemsList.SetItemText(m_index, 4, buf);

		m_itemsList.SetItemText(m_index, 5, sId);
		m_itemsList.SetItemText(m_index, 6, sName);
	}		
}

void CListDialog::ShowWOInList(aplExtent &items)
{
	m_itemsList.DeleteAllItems();

	aplExtent ext, wo; 
	for(int j= 0; j<items.GetSize(); j++)
	{
		CaplInstance* inst= NULL;

		if(!items[j] || !items[j]->GetType()) continue;
		if(items[j]->GetAccessmode()==aplNO) continue;
		
		apidata.GetAttr(items[j], m_wf_mgr->a_wo_object, inst);
		if(!inst) continue;
		if(inst->GetAccessmode()==aplNO) continue;
		
		ext.Add(inst);
		wo.Add(items[j]);
	}
	
	m_api->m_doc_mgr.LoadExtentInfo(ext);

	CString type, buf, name;
	int ico;
	for(int i= 0; i<ext.GetSize(); i++)
	{
		
		m_api->GetItemName(ext[i], name);
		ico = m_api->GetInstIco(ext[i]);
		type= GetTypeName(ext[i]);
		
		if(name.IsEmpty()) name.Format(_T("%s -> id %i"), ext[i]->GetType()->name, ext[i]->GetId());

		int n= m_itemsList.GetItemCount();
		int m= m_itemsList.InsertItem(n, name, ico);
		m_itemsList.SetItemData(m, (DWORD)wo[i]);
		m_itemsList.SetItemText(m, 1, type);
	}
}

void CListDialog::OnOK() 
{
	CaplInstance *inst= NULL;
	int i;

	UpdateData();

	if(m_sItemsType==_T("work_object"))
	{
		bool bModified= false;

		for(i= 0; i<m_fileItems.GetSize(); i++)
		{
			inst=m_api->m_doc_mgr.CreateFile(m_fileItems[i], true);
			if(!inst)
			{
				CString buf; buf.Format(APL_T("   \n\n\"%s\" "),LPCTSTR(m_fileItems[i]));
				AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
			}
			else
				m_newItems.Add(inst);

			inst= NULL;
			bModified= true;
		}

		for(i= 0; i<m_newItems.GetSize(); i++)
		{
			break;
			bModified= true;
		}
		
		for(i= 0; i<m_delItems.GetSize(); i++)
		{
			apidata.DeleteInstance(m_delItems[i]);
			bModified= true;
		}
		
		if(bModified) apidata.NET_SaveChanges();
	}
	else if(m_sItemsType==_T("task_prototype"))
	{
		if(m_process && m_process->GetType()==NULL) CaplResizableDialog::OnOK();// 
		bool bSave= false;

		if(m_prototype)
		{
			if(m_sName.IsEmpty())
			{
				AfxMessageBox(APL_T("  !"), MB_OK|MB_ICONERROR);
				return;				
			}

			CaplAttrValue test_val[3];
			test_val[0].attr= m_wf_mgr->a_proc_prot_name;
			test_val[0].value.Set(m_sName);
			test_val[1].attr= m_wf_mgr->a_proc_prot_tmpl;
			test_val[1].value.Set(m_proc_tmpl);

			if(!m_api->m_data.TestUniqueAttrValues(m_wf_mgr->e_proc_prot, m_prototype, 2, &test_val[0]))
			{
				AfxMessageBox(APL_T("  !"), MB_OK|MB_ICONERROR);
				return;
			}

			m_api->m_data.PutAttr(m_prototype, m_wf_mgr->a_proc_prot_name, m_sName);
		}

		// 
		for(i= 0; i<m_delItems.GetSize(); i++)
		{
			m_items->Remove(m_items->Find(m_delItems[i]));
			apidata.DeleteInstance(m_delItems[i]);
			bSave= true;
		}
		
		// 
		for(i= 0; i<m_taskItems.GetSize(); i++)
		{
			inst= apidata.CreateInstance(m_wf_mgr->e_task_tmpl);
			bSave= true;
			if(inst)
			{
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_activity, m_taskItems[i].m_activity);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_performer, m_taskItems[i].m_performer);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_performers, m_taskItems[i].m_performers);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_manager, m_taskItems[i].m_manager);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_role, m_taskItems[i].m_role);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_duration, m_taskItems[i].m_rDuration);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_id, m_taskItems[i].m_sId);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_name, m_taskItems[i].m_sName);
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_task_tmpl_proc_prot, m_prototype);

				m_items->Add(inst);
			}
			inst= NULL;
		}

		if(bSave) apidata.NET_SaveChanges();
	}

	CaplResizableDialog::OnOK();
}

void CListDialog::ShowTPInList(aplExtent &items)
{
	m_itemsList.DeleteAllItems();
	UINT ico= ICON_TASK;
	CString buf, name;
	double r;
	CaplInstance* inst= NULL;
	CaplAggr aggr0;
	COleDateTimeSpan odts;
	aplExtent ext;
	
	int i;
	CaplLoadData ld(&m_api->m_data,DEF_SOURCE);
	if(items.GetSize()>0)
	{
		for(i= 0; i<items.GetSize(); i++)
			ld.AddQuery(0, items[i], true);
		ld.AddQuery(_T('d'), 0, 0, m_wf_mgr->a_task_tmpl_activity, true, true);
		if(!ld.LoadEx())
		{
			if(apidata.GetLastAplError()!=APL_SOCK_OPERATION_IN_PROGRESS)
				AfxMessageBox(APL_T("   (MGR)"), MB_OK|MB_ICONSTOP);
		}

		for(i= 0; i<items.GetSize(); i++)
		{
			int n= m_itemsList.GetItemCount();

			if(!items[i] || !items[i]->GetType()) continue;

			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_activity, inst);
			if(!inst) continue;

			apidata.GetAttr(inst, m_wf_mgr->a_action_id, name);

			if(!name.IsEmpty())
			{
				int m= m_itemsList.InsertItem(n, name, ico);
				m_itemsList.SetItemData(m, (DWORD)items[i]);
				name.Empty();
			}
			apidata.GetAttr(inst, m_wf_mgr->a_action_name, name);
			m_itemsList.SetItemText(n, 1, name);


			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_performer, inst);
			if(inst)
			{
				m_api->m_appr_mgr.GetPersonName(inst, name);
				if(!name.IsEmpty()){m_itemsList.SetItemText(n, 2, name);}

				name.Empty();
				inst= NULL;
			}
			else
			{
				name.Empty();
				apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_performers, ext);

				for(int j= 0; j<ext.GetSize(); j++)
				{
					m_api->m_appr_mgr.GetPersonName(ext[j], buf);
					if(!buf.IsEmpty())
					{
						if(!name.IsEmpty())name+=_T("; ");
						name+=buf; 
					}
				}

				m_itemsList.SetItemText(n, 2, name);

				name.Empty();
				ext.Clear();
			}

			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_manager, inst);
			if(inst)
			{
				m_api->m_appr_mgr.GetPersonName(inst, name);
				if(!name.IsEmpty()){m_itemsList.SetItemText(n, 3, name);}

				name.Empty();
				inst= NULL;
			}

			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_duration, r);
			if(0==r) buf=_T("");
			else
			{
				odts.m_span= r;
				buf.Format(APL_T("%i . %i . %i ."), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
			}
			m_itemsList.SetItemText(n, 4, buf);
			buf.Empty();

			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_id, buf);
			if(!buf.IsEmpty()){m_itemsList.SetItemText(n, 5, buf);}
			buf.Empty();

			apidata.GetAttr(items[i], m_wf_mgr->a_task_tmpl_name, buf);
			if(!buf.IsEmpty()){m_itemsList.SetItemText(n, 6, buf);}
			buf.Empty();
		}
	}

	
	m_wf_mgr->GetProcessComponents(m_proc_tmpl, m_activities);
	for(i= 0; i<m_activities.GetSize(); i++)
	{
		if(!apidata.IsKindOf(m_activities[i], m_wf_mgr->e_activity)) continue;
		bool bShow= true;

		for(int j= 0; j<items.GetSize(); j++)
		{
			if(!items[j] || !items[j]->GetType()) continue;
			apidata.GetAttr(items[j], m_wf_mgr->a_task_tmpl_activity, inst);
			if(m_activities[i]==inst)
			{
				bShow= false;
				break;
			}
		}

		if(bShow)
		{
			apidata.GetAttr(m_activities[i], m_wf_mgr->a_action_id, name);

			if(!name.IsEmpty())
			{
				int n= m_itemsList.GetItemCount();
				int m= m_itemsList.InsertItem(n, name, ico);
				m_itemsList.SetItemData(m, (DWORD)m_activities[i]);
				name.Empty();
				
				apidata.GetAttr(m_activities[i], m_wf_mgr->a_action_name, name);
				m_itemsList.SetItemText(n, 1, name);

				bool bGiveTheProcessOwner=false;
				apidata.GetAttr(m_activities[i], m_wf_mgr->a_activity_give_the_process_owner, bGiveTheProcessOwner);
				if(bGiveTheProcessOwner) m_itemsList.SetItemText(n, 2, APL_T("<< >>"));
				else
				{
					aplExtent ext;
					m_api->m_data.GetAttr(m_activities[i], m_wf_mgr->a_activity_executors, ext);
					if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org))
					{
						m_api->m_appr_mgr.GetPersonName(ext[0], buf);
						name.Format(APL_T(" [%s]"), buf);
						m_itemsList.SetItemText(n, 2, name);
						continue;
					}
				}

				m_api->m_data.GetAttr(m_activities[i], m_wf_mgr->a_activity_managers, ext);
				if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org))
				{
					m_api->m_appr_mgr.GetPersonName(ext[0], buf);
					name.Format(APL_T(" [%s]"), buf);
					m_itemsList.SetItemText(n, 3, name);
				}

				apidata.GetAttr(m_activities[i], m_wf_mgr->a_activity_duration, r);
				if(0!=r)
				{
					odts.m_span= r;
					buf.Format(APL_T(" [%i . %i . %i .]"), odts.GetDays(), odts.GetHours(), odts.GetMinutes());
					m_itemsList.SetItemText(n, 4, buf);	
				}
			}
		}
	}
}

void CListDialog::OnLoadButton() 
{
	if(m_curSelItem)
	{
		CaplInstance* inst= NULL;
		if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_wo))
			apidata.GetAttrBN(m_curSelItem, _T("object"), inst);
		else
			inst= m_curSelItem;
		if(inst)
			m_api->m_doc_mgr.LoadRevision(inst, 0);
	}
}

void CListDialog::OnViewButton() 
{
	if(!m_curSelItem)
	{
		CString fpath= m_itemsList.GetItemText(m_index, 0);
		
		SHELLEXECUTEINFO ExInfo;
		ExInfo.cbSize = sizeof(SHELLEXECUTEINFO);
		ExInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
		ExInfo.hwnd = 0;
		ExInfo.lpVerb = _T("open");
		ExInfo.lpFile = fpath;
		ExInfo.lpParameters = 0;
		ExInfo.lpDirectory = 0;
		ExInfo.nShow = SW_SHOWNORMAL;
		
		ShellExecuteEx(&ExInfo);
		
		if((int)ExInfo.hInstApp==SE_ERR_ASSOCINCOMPLETE) 
		{AfxMessageBox(APL_T("  ")); return ;}
		if((int)ExInfo.hInstApp<=32) 
		{AfxMessageBox(APL_T("  ")); return ;}
	}
	else
	{
		CaplInstance* inst= NULL;
		if(apidata.IsKindOf(m_curSelItem, m_wf_mgr->e_wo))
			apidata.GetAttrBN(m_curSelItem, _T("object"), inst);
		else
			inst= m_curSelItem;
		if(inst)
			m_api->m_doc_mgr.View(inst);
	}
}

void CListDialog::OnCancel() 
{
	for(int i= 0; i<m_delItems.GetSize(); i++)
	{
		m_items->Add(m_delItems[i]);
	}
		
	CaplResizableDialog::OnCancel();
}



void CListDialog::OnBnClickedGetDlit()
{
	if(0==m_items) return;

	//AfxMessageBox(APL_T("          !"),MB_OK|MB_ICONWARNING);

	int i;
	//for(i=0;i<m_itemsList.GetItemCount();i++)
	for(i=0;i<m_items->GetSize();i++)
	{
		//CaplInstance *task_prot=(CaplInstance*)m_itemsList.GetItemData(i);
		CaplInstance *task_prot=(CaplInstance*)m_items->GetAt(i);
		if(0==task_prot) continue;
		
		/*CaplInstance *task_templ;
		m_api->m_data.GetAttr(task_prot, m_wf_mgr->a_task_tmpl_activity, task_templ);
		if(0==task_templ) continue;*/

		double rDur= 0;
		//m_api->m_data.GetAttr(task_templ, m_wf_mgr->a_activity_duration, rDur);
		m_api->m_data.PutAttr(task_prot, m_wf_mgr->a_task_tmpl_duration, rDur);
	}
	m_api->SaveChanges();
	ShowTPInList(*m_items);

	m_cancelBtn.EnableWindow(FALSE);
}

void CListDialog::OnBnClickedClearIsp()
{
	if(0==m_items) return;

	//AfxMessageBox(APL_T("          !"),MB_OK|MB_ICONWARNING);

	int i;
	CaplValue nul_value;
	//for(i=0;i<m_itemsList.GetItemCount();i++)
	for(i=0;i<m_items->GetSize();i++)
	{
		//CaplInstance *task_prot=(CaplInstance*)m_itemsList.GetItemData(i);
		CaplInstance *task_prot=(CaplInstance*)m_items->GetAt(i);
		if(0==task_prot) continue;

		/*CaplInstance *task_templ;
		m_api->m_data.GetAttr(task_prot, m_wf_mgr->a_task_tmpl_activity, task_templ);
		if(0==task_templ) continue;*/

		m_api->m_data.PutAttr(task_prot, m_wf_mgr->a_task_tmpl_performer, nul_value);
		m_api->m_data.PutAttr(task_prot, m_wf_mgr->a_task_tmpl_performers, nul_value);
		m_api->m_data.PutAttr(task_prot, m_wf_mgr->a_task_tmpl_manager, nul_value);
	}
	m_api->SaveChanges();
	ShowTPInList(*m_items);

	m_cancelBtn.EnableWindow(FALSE);
}
