// QueryStartPointDialog.cpp : implementation file
//

#include "stdafx.h"
#include "QueryStartPointDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "aplWorkFlowManager.h"

/////////////////////////////////////////////////////////////////////////////
// CQueryStartPointDialog dialog


CQueryStartPointDialog::CQueryStartPointDialog(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CQueryStartPointDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CQueryStartPointDialog)
	m_sDscr = _T("");
	m_iSP = -1;
	//}}AFX_DATA_INIT
	m_data= NULL;
	m_wf_mgr= NULL;
	m_process= NULL;
	m_st_points= NULL;
	m_start_point= NULL;
}


void CQueryStartPointDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CQueryStartPointDialog)
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDC_START_POINT_COMBO, m_spCB);
	DDX_Text(pDX, IDC_DESCRIPTION_EDIT, m_sDscr);
	DDX_CBIndex(pDX, IDC_START_POINT_COMBO, m_iSP);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CQueryStartPointDialog, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CQueryStartPointDialog)
	ON_CBN_SELCHANGE(IDC_START_POINT_COMBO, OnSelchangeStartPointCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQueryStartPointDialog message handlers
BOOL CQueryStartPointDialog::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	if(m_data && m_data->IsConnected() && m_wf_mgr)
	{
		for(int i= 0; i<m_st_points->GetSize(); i++)
		{
			CString str, name;
			m_data->GetAttr(m_st_points->GetAt(i), m_wf_mgr->a_action_id, name);
			m_data->GetAttr(m_st_points->GetAt(i), m_wf_mgr->a_action_name, str);
			if(!str.IsEmpty())
			{
				name+=_T(":")+str;
			}
			if(!name.IsEmpty())
			{
				int n1= m_spCB.AddString(name);
				m_spCB.SetItemData(n1, (DWORD)m_st_points->GetAt(i));
			}
		}
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CQueryStartPointDialog::OnSelchangeStartPointCombo() 
{
	UpdateData();

	m_start_point= (CaplInstance*)m_spCB.GetItemData(m_iSP);
	if(m_start_point)
	{
		m_data->GetAttr(m_start_point, m_wf_mgr->a_action_dscr, m_sDscr);
	}

	UpdateData(FALSE);
}

void CQueryStartPointDialog::OnOK() 
{
	if(!m_start_point)
	{
		AfxMessageBox(APL_T("   ."), MB_OK|MB_ICONERROR);
		return;
	}
	CaplTranslateDialog::OnOK();
}

