// TPDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TPDialog.h"
#include <aplguiex.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "dictionary.h"
#include "common.h"

#include "aplWorkFlowManager.h"
/////////////////////////////////////////////////////////////////////////////
// CTPDialog dialog


CTPDialog::CTPDialog(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTPDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTPDialog)
	m_iDay = 1;
	m_iHour = 0;
	m_iMin = 0;
	m_iActivity = -1;
	m_sId = _T("");
	m_sName = _T("");
	m_sManager = _T("");
	m_sPerformer = _T("");
	m_bSetRole = FALSE;
	m_iDefaultRole = -1;
	//}}AFX_DATA_INIT
	
	m_api= NULL;
	m_wf_mgr= NULL;

	m_new_prototypes.RemoveAll();
	
	m_api= NULL;
	m_process= NULL;
	m_proc_tmpl= NULL;
	m_prot= NULL;

	m_prot_info.m_activity= NULL;
	m_prot_info.m_manager= NULL;
	m_prot_info.m_performer= NULL;
	m_prot_info.m_rDuration= 0;
	m_prot_info.m_sId= _T("");
	m_prot_info.m_sName= _T("");

	m_bReadOnly= FALSE;

	m_manager= NULL;
	m_performer= NULL;
	
	m_bCanEditRole= false;
}


void CTPDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTPDialog)
	DDX_Control(pDX, IDC_ROLES_COMBO, m_rolesCtrl);
	DDX_Control(pDX, IDC_CHANGE_ROLE_CHECK, m_setRoleCtrl);
	DDX_Control(pDX, IDC_TP_CLEAR_PERFORMER, m_clearPerformer);
	DDX_Control(pDX, IDC_TP_CLEAR_MANAGER, m_clearManager);
	DDX_Control(pDX, IDC_TP_PERFORMER_SELECT, m_selPer);
	DDX_Control(pDX, IDC_TP_MANAGER_SELECT, m_selMgr);
	DDX_Control(pDX, IDC_TP_NAME, m_name);
	DDX_Control(pDX, IDC_TP_ID, m_id);
	DDX_Control(pDX, IDC_TP_DUR_MIN, m_mEdit);
	DDX_Control(pDX, IDC_TP_DUR_HOUR, m_hEdit);
	DDX_Control(pDX, IDC_TP_DUR_DAY, m_dEdit);
	DDX_Control(pDX, IDC_TP_PERFORMER, m_per_wnd);
	DDX_Control(pDX, IDC_TP_MANAGER, m_mgr_wnd);
	DDX_Control(pDX, IDC_TP_ADD_BUTTON, m_addBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDC_TP_ACTIVITY, m_actCB);
	DDX_Control(pDX, IDC_SPIN_M, m_mSpin);
	DDX_Control(pDX, IDC_SPIN_H, m_hSpin);
	DDX_Control(pDX, IDC_SPIN_D, m_dSpin);
	DDX_Text(pDX, IDC_TP_DUR_DAY, m_iDay);
	DDX_Text(pDX, IDC_TP_DUR_HOUR, m_iHour);
	DDX_Text(pDX, IDC_TP_DUR_MIN, m_iMin);
	DDX_CBIndex(pDX, IDC_TP_ACTIVITY, m_iActivity);
	DDX_Text(pDX, IDC_TP_ID, m_sId);
	DDX_Text(pDX, IDC_TP_NAME, m_sName);
	DDX_Text(pDX, IDC_TP_MANAGER, m_sManager);
	DDX_Text(pDX, IDC_TP_PERFORMER, m_sPerformer);
	DDX_Check(pDX, IDC_CHANGE_ROLE_CHECK, m_bSetRole);
	DDX_CBIndex(pDX, IDC_ROLES_COMBO, m_iDefaultRole);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTPDialog, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTPDialog)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_D, OnDeltaposSpinD)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_M, OnDeltaposSpinM)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_H, OnDeltaposSpinH)
	ON_BN_CLICKED(IDC_TP_ADD_BUTTON, OnTpAddButton)
	ON_CBN_SELCHANGE(IDC_TP_MANAGER, OnSelchangeTpManager)
	ON_CBN_SELCHANGE(IDC_TP_ACTIVITY, OnSelchangeTpActivity)
	ON_CBN_SELCHANGE(IDC_TP_PERFORMER, OnSelchangeTpPerformer)
	ON_EN_CHANGE(IDC_TP_DUR_DAY, OnChangeTpDurDay)
	ON_EN_CHANGE(IDC_TP_DUR_HOUR, OnChangeTpDurHour)
	ON_EN_CHANGE(IDC_TP_DUR_MIN, OnChangeTpDurMin)
	ON_BN_CLICKED(IDC_TP_MANAGER_SELECT, OnTpManagerSelect)
	ON_BN_CLICKED(IDC_TP_PERFORMER_SELECT, OnTpPerformerSelect)
	ON_BN_CLICKED(IDC_TP_CLEAR_MANAGER, OnTpClearManager)
	ON_BN_CLICKED(IDC_TP_CLEAR_PERFORMER, OnTpClearPerformer)
	ON_BN_CLICKED(IDC_CHANGE_ROLE_CHECK, OnChangeRoleCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTPDialog message handlers

void CTPDialog::OnDeltaposSpinD(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	UpdateData();
	m_iDay= pNMUpDown->iPos;
	UpdateData(FALSE);
	
	*pResult = 0;
}

void CTPDialog::OnDeltaposSpinM(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	UpdateData();
	m_iMin= pNMUpDown->iPos;
	UpdateData(FALSE);
	
	*pResult = 0;
}

void CTPDialog::OnDeltaposSpinH(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	UpdateData();
	m_iHour= pNMUpDown->iPos;
	UpdateData(FALSE);
	
	*pResult = 0;
}
  
BOOL CTPDialog::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	m_selMgr.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_selMgr.SetFlat(FALSE);
	m_selMgr.SetTooltipText(APL_T(" "));
	
	m_selPer.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_selPer.SetFlat(FALSE);
	m_selPer.SetTooltipText(APL_T(" "));
	
	m_clearManager.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_clearManager.SetFlat(FALSE);
	m_clearPerformer.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_clearPerformer.SetFlat(FALSE);
	
	m_buddyWndD= FromHandle(m_dEdit.m_hWnd);
	m_dSpin.SetBuddy(m_buddyWndD);
	m_dSpin.SetRange32(0, 10000);
	m_dSpin.SetPos(m_iDay);
	
	m_buddyWndH= FromHandle(m_hEdit.m_hWnd);
	m_hSpin.SetBuddy(m_buddyWndH);
	m_hSpin.SetRange32(0, 10000);
	m_hSpin.SetPos(m_iHour);
	
	m_buddyWndM= FromHandle(m_mEdit.m_hWnd);
	m_mSpin.SetBuddy(m_buddyWndM);
	m_mSpin.SetRange32(0, 10000);
	m_mSpin.SetPos(m_iMin);
	
	m_addBtn.EnableWindow(FALSE);
	
	///////////////////////////////////////////////////////////
	aplExtent ext;
	m_wf_mgr->GetProcessComponents(m_proc_tmpl, m_activities);
	///////////////////////////////////////////////////////////

	bool bInsert= true;
	int n;
	CString buf, buf1;
	CTaskInfo ti;
	CaplInstance* inst;
	CaplInstance* role;

	int i, j;
	
	for(i= 0; i<m_activities.GetSize(); i++)
	{
		if(!m_api->m_data.IsKindOf(m_activities[i], m_wf_mgr->e_activity)) continue;

		for(j= 0; j<m_tp->GetSize(); j++)
		{
			inst= NULL;
			if(!m_tp->GetAt(i) || !m_tp->GetAt(i)->GetType()) continue;// -...
			m_api->m_data.GetAttr(m_tp->GetAt(j), m_wf_mgr->a_task_tmpl_activity, inst);
			if(inst==m_activities[i])
				bInsert= false;
		}
		
		for(j= 0; j<m_prototypes->GetSize(); j++)
		{
			ti= m_prototypes->GetAt(j);
			if(ti.m_activity==m_activities[i])
				bInsert= false;
		}

		if(bInsert)
		{
			m_api->m_data.GetAttr(m_activities[i], m_wf_mgr->a_action_id, buf);
			m_api->m_data.GetAttr(m_activities[i], m_wf_mgr->a_action_name, buf1);
			buf+=_T(":");buf+=buf1;
			
			n= m_actCB.AddString(buf);
			m_actCB.SetItemData(n, (DWORD)m_activities[i]);
		}
		else bInsert= true;
	}

	aplExtent roles;
	bool bval;
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_po_role, roles);
	for(i= 0; i<roles.GetSize(); i++)
	{
		m_api->m_data.GetAttr(roles[i], m_api->m_appr_mgr.a_po_role_system, bval);
		if(bval) continue;
		m_api->m_data.GetAttr(roles[i], m_api->m_appr_mgr.a_po_role_name, buf);
		n= m_rolesCtrl.AddString(buf);
		m_rolesCtrl.SetItemData(n, (DWORD)roles[i]);
	}

	m_okBtn.EnableWindow(FALSE);

	CaplInstance* activity= NULL;
	COleDateTimeSpan odts;

	activity= m_prot_info.m_activity;
	m_prot_info.GetDefaultPersons();
	
	//  id  
	if(activity)
	{
		if(m_prot_info.m_rDuration==0)//  
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_duration, odts.m_span);
		else// 
			odts.m_span= m_prot_info.m_rDuration;
		
		if(m_prot_info.m_sId.IsEmpty())//id    
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_action_id, m_sId);
		else// id
			m_sId= m_prot_info.m_sId;

		if(m_prot_info.m_sName.IsEmpty())
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_action_name, m_sName);
		else
			m_sName= m_prot_info.m_sName;

		if(m_prot_info.m_performers.GetSize())
			m_performers.Append(m_prot_info.m_performers);

		// ,  
		if(m_prot_info.m_role)
		{
			role= m_prot_info.m_role;
			m_bSetRole= TRUE;
			if(m_bCanEditRole) 
				m_rolesCtrl.EnableWindow(TRUE);
		}
		else
		{
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_role, role);
			m_bSetRole= FALSE;
		}
		
		if(role)
		{
			m_api->m_data.GetAttr(role, m_api->m_appr_mgr.a_po_role_name, buf);
			m_iDefaultRole= m_rolesCtrl.SelectString(-1, buf);
		}
	}

	if(!m_performer)m_performer= m_prot_info.m_performer;
	if(!m_manager)m_manager= m_prot_info.m_manager;
	
	if(m_prot)
	{
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_activity, activity);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_duration, odts.m_span);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_performer, m_performer);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_performers, m_performers);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_manager, m_manager);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_id, m_sId);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_name, m_sName);
		m_api->m_data.GetAttr(m_prot, m_wf_mgr->a_task_tmpl_role, role);
		if(role)
		{
			m_api->m_data.GetAttr(role, m_api->m_appr_mgr.a_po_role_name, buf);
			m_iDefaultRole= m_rolesCtrl.SelectString(-1, buf);
			m_bSetRole= TRUE;			
			if(m_bCanEditRole) 
				m_rolesCtrl.EnableWindow(TRUE);
		}
	}
	
	if(activity)
	{
		CaplInstance* inst= NULL;		
		CString name, buf;		
		CString st1, st2;

		aplExtent ext0;
		CString buf1;

		m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_executors, m_perExt);
		m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_managers, m_mgrExt);
		
		if(m_performer==NULL)
		{

			if(!m_performers.GetSize())
			{
				m_sPerformer= APL_T("<  >");
				m_clearPerformer.EnableWindow(FALSE);
			}
			else
			{
				for(i= 0; i<m_performers.GetSize(); i++)
				{
					m_api->m_appr_mgr.GetPersonName(m_performers[i], buf);
					if(!buf.IsEmpty())
					{
						if(!m_sPerformer.IsEmpty()) m_sPerformer+=_T("; ");
						m_sPerformer+=buf; 
					}
				}				
			}
		}
		else
		{ 
			m_api->m_appr_mgr.GetPersonName(m_performer, m_sPerformer);
		}

		if(m_manager==NULL)
		{
			m_sManager= APL_T("<  >");
			m_clearManager.EnableWindow(FALSE);
		}
		else
		{ 
			m_api->m_appr_mgr.GetPersonName(m_manager, m_sManager);					
		}
		
		m_api->m_data.GetAttr(activity, m_wf_mgr->a_action_id, name);
		m_api->m_data.GetAttr(activity, m_wf_mgr->a_action_name, buf);
		name+=_T(":");name+=buf;
		m_iActivity= m_actCB.AddString(name);		
		m_actCB.EnableWindow(FALSE);

		if(0==odts.m_span)
		{
			m_iDay= 0;
			m_iHour= 0;
			m_iMin= 0;
		}
		else
		{
			m_iDay= odts.GetDays();
			m_iHour= odts.GetHours();
			m_iMin= odts.GetMinutes();
		}

		m_dSpin.SetPos(m_iDay);
		m_hSpin.SetPos(m_iHour);
		m_mSpin.SetPos(m_iMin);

		/*   ,  0,    
		if(m_iDay==0 && m_iHour==0 && m_iMin==0)
			m_iDay= 1;
		*/
		
		if(!m_bReadOnly)
		{
			if(m_bCanEditRole)
				m_setRoleCtrl.EnableWindow();

			m_dEdit.EnableWindow();
			m_hEdit.EnableWindow();
			m_mEdit.EnableWindow();

			m_dSpin.EnableWindow();
			m_hSpin.EnableWindow();
			m_mSpin.EnableWindow();
			
			

			if(m_perExt.GetSize())
				m_selPer.EnableWindow();
			if(m_mgrExt.GetSize())
				m_selMgr.EnableWindow();

			m_id.EnableWindow();
			m_name.EnableWindow();

			m_okBtn.EnableWindow();
		}
		
		UpdateData(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTPDialog::OnOK() 
{
	UpdateData();

	for(int i= 0; i<m_new_prototypes.GetSize(); i++)
		m_prototypes->Add(m_new_prototypes[i]);
	
	COleDateTimeSpan odts;
	odts.SetDateTimeSpan(m_iDay, m_iHour, m_iMin, 0);
	
	CaplInstance* role= NULL;
	if(m_bSetRole)
		role= (CaplInstance*)m_rolesCtrl.GetItemData(m_iDefaultRole);

	if((!m_performer && !m_manager && !m_performers.GetSize()) &&
		(m_iDay==0 && m_iHour==0 && m_iMin==0))
	{
		AfxMessageBox(APL_T("       "),MB_OK | MB_ICONERROR);
		return;		
	}
	/*if(!m_performer && !m_manager && !m_performers.GetSize())
	{
		AfxMessageBox(APL_T("  ."), MB_OK|MB_ICONERROR);
		return;
	}*/
	if(!m_manager && (m_performers.GetSize()>0))
	{
		AfxMessageBox(APL_T("    ,\n    ."), MB_OK|MB_ICONERROR);
		return;			
	}
	
	/*   ,  0,    
	if(m_iDay==0 && m_iHour==0 && m_iMin==0)
	{
		AfxMessageBox(APL_T("    ."), MB_OK | MB_ICONERROR);
		return;		
	}*/

	if(m_prot)
	{	
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_manager, m_manager);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_performer, m_performer);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_performers, m_performers);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_duration, odts.m_span);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_id, m_sId);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_name, m_sName);
		m_api->m_data.PutAttr(m_prot, m_wf_mgr->a_task_tmpl_role, role);

		m_api->SaveChanges();		
	}

	if(m_prot_info.m_activity)
	{
		m_prot_info.m_manager= m_manager;
		m_prot_info.m_performer= m_performer;
		m_prot_info.m_performers.Clear();m_prot_info.m_performers.Append(m_performers);
		m_prot_info.m_rDuration= odts.m_span;
		m_prot_info.m_sId= m_sId;
		m_prot_info.m_sName= m_sName;
		m_prot_info.m_role= role;
	}
	
	CaplTranslateDialog::OnOK();
}

void CTPDialog::OnCancel() 
{
	m_new_prototypes.RemoveAll();
	CaplTranslateDialog::OnCancel();
}

void CTPDialog::OnTpAddButton() 
{
	UpdateData();

	if(!m_manager && !m_performer && !m_performers.GetSize())
	{
		AfxMessageBox(APL_T("  ."), MB_OK | MB_ICONERROR);
		return;
	}
	
	if(m_iDay==0 && m_iHour==0 && m_iMin==0)
	{
		AfxMessageBox(APL_T("    ."), MB_OK | MB_ICONERROR);
		return;		
	}

	COleDateTimeSpan odts;
	odts.SetDateTimeSpan(m_iDay, m_iHour, m_iMin, 0);
	
	CaplInstance* role= NULL;
	if(m_bSetRole)
		role= (CaplInstance*)m_rolesCtrl.GetItemData(m_iDefaultRole);
	
	CTaskInfo ti(m_api, m_wf_mgr, (CaplInstance*)m_actCB.GetItemData(m_iActivity), 
		odts.m_span, m_performer, m_manager, role, m_sId, m_sName);

	m_new_prototypes.Add(ti);
		
	m_id.EnableWindow(FALSE);
	m_name.EnableWindow(FALSE);

	m_dEdit.EnableWindow(FALSE);
	m_hEdit.EnableWindow(FALSE);
	m_mEdit.EnableWindow(FALSE);

	m_dSpin.EnableWindow(FALSE);
	m_hSpin.EnableWindow(FALSE);
	m_mSpin.EnableWindow(FALSE);
	
	m_addBtn.EnableWindow(FALSE);

	m_sManager= m_sPerformer= APL_T("<  >");

	m_actCB.DeleteString(m_iActivity);
	m_iActivity= -1;
	m_sId= _T("");
	m_sName= _T("");
	
	m_okBtn.EnableWindow();

	UpdateData(FALSE);
}

void CTPDialog::OnSelchangeTpActivity() 
{
	UpdateData();
	if(m_iActivity==-1) return;

	m_actCB.EnableWindow();
		
	m_id.EnableWindow();
	m_name.EnableWindow();

	m_dEdit.EnableWindow();
	m_hEdit.EnableWindow();
	m_mEdit.EnableWindow();

	m_dSpin.EnableWindow();
	m_hSpin.EnableWindow();
	m_mSpin.EnableWindow();

	m_addBtn.EnableWindow();

	int i;
	CaplInstance* activity= (CaplInstance*)m_actCB.GetItemData(m_iActivity);
	if(activity)
	{
		CaplAggr aggr, aggr0;
		CaplInstance* inst= NULL;
		if(activity)
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_executors, aggr);
		CString name, buf;

		aplExtent ext0;
		CaplAggr roleAggr;
//		CaplInstance* inst1;
		CString buf1;

		///////////////////////////////////////////////////////////
		aplExtent org;
		bool bOrg= false;
		for(i= 0; i<aggr.GetSize(); i++)
		{
			inst= NULL;
			aggr.GetByIndex(i, inst);
			if(!inst) continue;
			m_perExt.Add(inst);
		}

		if(activity)
			m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_managers, aggr);
		org.Clear();
		bOrg= false;
		for(i= 0; i<aggr.GetSize(); i++)
		{
			inst= NULL;
			aggr.GetByIndex(i, inst);
			if(!inst) continue;
			m_mgrExt.Add(inst);
		}			
		
		m_sManager= m_sPerformer= APL_T("<  >");

		COleDateTimeSpan odts;
		m_api->m_data.GetAttr(activity, m_wf_mgr->a_activity_duration, odts.m_span);

		m_iDay= odts.GetDays();
		m_dSpin.SetPos(m_iDay);
		m_iHour= odts.GetHours();
		m_hSpin.SetPos(m_iHour);
		m_iMin= odts.GetMinutes();
		m_mSpin.SetPos(m_iMin);

		UpdateData(FALSE);
	}
}

void CTPDialog::OnSelchangeTpManager() 
{
	
}

void CTPDialog::OnSelchangeTpPerformer() 
{
	
}

void CTPDialog::OnChangeTpDurDay() 
{
	UpdateData();	
/*	if(m_iDay<0) m_iDay= 0;*/
	m_dSpin.SetPos(m_iDay);
	UpdateData(FALSE);	
}

void CTPDialog::OnChangeTpDurHour() 
{
	UpdateData();
/*	if(m_iHour<1) m_iHour= 0;
	if(m_iHour>23) m_iHour= 23;*/
	m_hSpin.SetPos(m_iHour);
	UpdateData(FALSE);
}

void CTPDialog::OnChangeTpDurMin() 
{
	UpdateData();
/*	if(m_iMin<1) m_iMin= 1;
	if(m_iMin>59) m_iMin= 120;*/
	m_mSpin.SetPos(m_iMin);
	UpdateData(FALSE);
}

void CTPDialog::OnTpManagerSelect() 
{
	UpdateData();
	
	CaplInstance* per= m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL, m_mgrExt,
		APL_T("  "), APL_T("  :"));

	if(per && per!=m_manager)
	{
		m_manager= per;
		m_api->m_appr_mgr.GetPersonName(m_manager, m_sManager);	
		m_clearManager.EnableWindow();
	}

	UpdateData(FALSE);	
}

void CTPDialog::OnTpPerformerSelect() 
{
	aplExtent persons;
	bool bResult= false;
	CString buf;

	if(m_performer)persons.Add(m_performer);
	persons.Append(m_performers);

	bResult= m_api->m_appr_mgr.SelectPersonsOrganizations(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL, persons, false, true, 
		APL_T("  "), APL_T("  :"), &m_perExt);

	if(!persons.GetSize())
	{
		m_performer= NULL;
		m_performers.Clear();
		m_sPerformer= APL_T("<  >");
		m_clearPerformer.EnableWindow(FALSE);	
	}
	else if(1==persons.GetSize())
	{
		m_performer= persons[0];
		m_performers.Clear();
		m_api->m_appr_mgr.GetPersonName(m_performer, m_sPerformer);
		m_clearPerformer.EnableWindow();	
	}
	else
	{
		m_performer= NULL;
		m_performers.Clear();
		m_performers.Append(persons);
		m_sPerformer.Empty();
		m_clearPerformer.EnableWindow();	
		
		for(int i= 0; i<m_performers.GetSize(); i++)
		{
			m_api->m_appr_mgr.GetPersonName(m_performers[i], buf);
			if(!buf.IsEmpty())
			{
				if(!m_sPerformer.IsEmpty()) m_sPerformer+=_T("; ");
				m_sPerformer+=buf; 
			}			
		}
	}

	UpdateData(FALSE);
}

void CTPDialog::OnTpClearManager() 
{
	UpdateData();

	m_manager= NULL;
	m_sManager= APL_T("<  >");
	m_clearManager.EnableWindow(FALSE);
	
	UpdateData(FALSE);
}

void CTPDialog::OnTpClearPerformer() 
{
	UpdateData();
	
	m_performer= NULL;
	m_performers.Clear();
	m_sPerformer= APL_T("<  >");
	m_clearPerformer.EnableWindow(FALSE);
	
	UpdateData(FALSE);
}

void CTPDialog::OnChangeRoleCheck() 
{
	UpdateData();	
	m_rolesCtrl.EnableWindow(m_bSetRole);
}
