// WfSelTemplatesTree.cpp : implementation file
//

#include "stdafx.h"
#include "aplWorkFlowManager.h"
#include "WfSelTemplatesTree.h"
#include "aplWfTemlateView.h"
#include "SelectProcessTemplDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWfSelTemplatesTree

IMPLEMENT_DYNCREATE(CWfSelTemplatesTree, CaplTreeView)

CWfSelTemplatesTree::CWfSelTemplatesTree()
{
	m_api=0;
	m_wf_mgr=0;
	m_sel_template=0;
	m_graph_view=0;
	m_bEditorMode=false;
	m_parent_select_dlg=0;
}

CWfSelTemplatesTree::~CWfSelTemplatesTree()
{
	m_items.Clear();
}


BEGIN_MESSAGE_MAP(CWfSelTemplatesTree, CaplTreeView)
	//{{AFX_MSG_MAP(CWfSelTemplatesTree)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(TVN_ITEMEXPANDING, OnItemexpanding)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED , OnSelchanged)
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWfSelTemplatesTree drawing

void CWfSelTemplatesTree::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CWfSelTemplatesTree diagnostics

#ifdef _DEBUG
void CWfSelTemplatesTree::AssertValid() const
{
	CaplTreeView::AssertValid();
}

void CWfSelTemplatesTree::Dump(CDumpContext& dc) const
{
	CaplTreeView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWfSelTemplatesTree message handlers


int CWfSelTemplatesTree::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	GetTreeCtrl().ModifyStyle(WS_VSCROLL,TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS|WS_CHILD|WS_VISIBLE);
	SetImageList(aplGetInstImageList(),IDX_IL_TREE_ITEM);
	//GetTreeCtrl().SetImageList(aplGetInstImageList(),IDX_IL_TREE_ITEM);
	return 0;
}

//************************************************
bool CWfSelTemplatesTree::UpdateTemplates()
{
	ASSERT(m_api!=0);
	ASSERT(m_wf_mgr!=0);

	CTreeCtrl& m_tree=GetTreeCtrl();
	m_tree.SetRedraw(FALSE);
	m_tree.DeleteAllItems();
	m_tree.SetRedraw(TRUE);

	m_items.Clear();


	m_wf_mgr->LoadTemplates();

	int i;
	CString buf,name;

	HTREEITEM hitem4sel=0;
	
	for(i=0;i<m_templates.Size;i++)
	{
		CaplInstance *templ=m_templates[i];
		if(templ->GetType()==0) continue;
		if(templ->GetAccessmode()>aplRO) continue;

		m_api->m_data.GetAttr(templ, m_wf_mgr->a_action_id, name);
		name+=_T(" : ");
		m_api->m_data.GetAttr(templ, m_wf_mgr->a_action_name, buf);
		name+=buf;

		CaplInstance *user;
		m_api->m_data.GetAttr(templ,m_wf_mgr->a_proc_tmpl_editor,user);
		if(user!=0)
		{
			m_api->LoadItemInfo(user);
			name+=APL_T(" (  ");
			m_api->m_appr_mgr.GetPersonName(user,buf);
			name+=buf;
			name+=_T(" )");
		}

		CaplTreeItemData *tidata=new CaplTreeItemData;
		tidata->m_tree=&GetTreeCtrl();

		tidata->InsetItem(name,ICON_PROCESS_TMPL,0);
		tidata->SetItemImage(ICON_PROCESS_TMPL, IDX_IL_TREE_ITEM);
		tidata->data=templ;
		HTREEITEM m_fictive_item=GetTreeCtrl().InsertItem(_T("fictive"), 0, 0, tidata->m_item);

		//GetTreeCtrl().InsertItem(name,11,26);

		m_items.Add(tidata);

		if(0!=m_parent_select_dlg)
		{
			if(m_parent_select_dlg->m_sel_template==templ) 
				hitem4sel= tidata->m_item;
		}

	}
	
	//  .. (  workflowmodeller   ,    
	//    ""  
	if(GetTreeCtrl().GetCount() == 2)
	{
		GetTreeCtrl().Expand(GetTreeCtrl().GetRootItem(), TVE_EXPAND);
		GetTreeCtrl().Expand(GetTreeCtrl().GetRootItem(), TVE_COLLAPSE);
	}

	GetTreeCtrl().SortChildren(0);

	if(0!=hitem4sel)
	{
		GetTreeCtrl().EnsureVisible(hitem4sel);
		GetTreeCtrl().SelectItem(hitem4sel);
		GetTreeCtrl().SelectDropTarget(hitem4sel);

		if(0!=m_parent_select_dlg)
		{
			if(0 != m_parent_select_dlg->m_sel_activity) 
			{
				GetTreeCtrl().Expand(hitem4sel,2);
			}
		}
	}
	return true;
}


//*************************************************************************
void CWfSelTemplatesTree::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	*pResult = 0;

	// TODO: Add your control notification handler code here
	HTREEITEM cur_item=pNMTreeView->itemNew.hItem;
	BOOL enableOk = FALSE;
	CaplInstance *inst = 0;

	CaplTreeItemData *item=(CaplTreeItemData*)GetTreeCtrl().GetItemData(cur_item);
	if(item!=0)
	{
		inst=(CaplInstance *)item->data;
	}

	if(0 != inst) 
	{
		if(m_api->m_data.IsKindOf(inst,m_wf_mgr->e_proc_tmpl))
		{
			//  
			if(inst!=m_graph_view->m_prc)
			{
				m_graph_view->ShowTemplate(inst);
			}
			if(m_parent_select_dlg)
			{
				if((m_parent_select_dlg->m_SelectMode & APL_MODE_WFL_SELECT_TEMPLATE) > 0) enableOk = TRUE;
			}

		}
		else if(m_api->m_data.IsKindOf(inst,m_wf_mgr->e_activity))
		{
			CaplInstance *prc;
			m_api->m_data.GetAttr(inst,m_wf_mgr->a_act_tmpl_proc_tmpl,prc);
			m_graph_view->ShowTemplate(prc,inst);
			if(m_parent_select_dlg)
			{
				if((m_parent_select_dlg->m_SelectMode & APL_MODE_WFL_SELECT_ACTIVITI) > 0) enableOk = TRUE;
			}
		}
	}

	if(m_parent_select_dlg)
	{
		m_parent_select_dlg->m_ok_btn.EnableWindow(enableOk);
	}
	
}

//*************************************************************************
void CWfSelTemplatesTree::OnItemexpanding(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	HTREEITEM hitem=pNMTreeView->itemNew.hItem;
	
	if(pNMTreeView->action==2) //
	{

		CaplTreeItemData *item=(CaplTreeItemData*)GetTreeCtrl().GetItemData(hitem);
		CaplInstance *inst=(CaplInstance *)item->data;
		if(inst==0) return;

		int i;
		CString name,buf;
		HTREEITEM hitem4sel=0;

		if(m_api->m_data.IsKindOf(inst,m_wf_mgr->e_proc_tmpl))
		{
			HTREEITEM hChildItem = GetTreeCtrl().GetChildItem(hitem);
			CaplTreeItemData *child_item=(CaplTreeItemData*)GetTreeCtrl().GetItemData(hChildItem);
			if(child_item==0)
			{
				GetTreeCtrl().DeleteItem(hChildItem);

				aplExtent  m_activities;
				m_wf_mgr->GetProcessComponents(inst,m_activities);

				for(i=0;i<m_activities.Size;i++)
				{
					CaplInstance *act=m_activities[i];
					m_api->m_data.GetAttr(act, m_wf_mgr->a_action_id, name);
					name+=_T(" : ");
					m_api->m_data.GetAttr(act, m_wf_mgr->a_action_name, buf);
					name+=buf;

					CaplTreeItemData *tidata=new CaplTreeItemData;
					tidata->m_tree=&GetTreeCtrl();

					tidata->InsetItem(name,ICON_ACTIVITY,hitem);
					tidata->SetItemImage(ICON_ACTIVITY, IDX_IL_TREE_ITEM);
					tidata->data=act;
					//HTREEITEM m_fictive_item=GetTreeCtrl().InsertItem(_T("fictive"), 0, 0, tidata->m_item);
					m_items.Add(tidata);
					if(0!=m_parent_select_dlg)
					{
						if(m_parent_select_dlg->m_sel_activity == act) 
						{
							hitem4sel = tidata->m_item;
						}
					}
				}
				GetTreeCtrl().SortChildren(hitem);
			}
		}
		if(0!=hitem4sel)
		{
			GetTreeCtrl().EnsureVisible(hitem4sel);
			GetTreeCtrl().SelectItem(hitem4sel);
			GetTreeCtrl().SelectDropTarget(hitem4sel);
		}
	}
	*pResult = 0;
}

void CWfSelTemplatesTree::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default

	if(m_bEditorMode)
	{
		
		if(m_parent_select_dlg!=0)
		{
			m_parent_select_dlg->ExitFromTree(3);
		}
	}
	CaplTreeView::OnLButtonDblClk(nFlags, point);
}

void CWfSelTemplatesTree::OnRButtonDown(UINT nFlags, CPoint point) 
{
	if(!m_bEditorMode) CaplTreeView::OnRButtonDown(nFlags, point);

	// TODO: Add your message handler code here and/or call default
    UINT flag=TVHT_ONITEM|TVHT_ONITEMRIGHT;
    HTREEITEM cur_item=GetTreeCtrl().HitTest(point,&flag);
    if (cur_item!=NULL) 
	{
		GetTreeCtrl().SelectItem(cur_item);
		GetTreeCtrl().SelectDropTarget(cur_item);
	}
    CaplTreeView::OnRButtonDown(nFlags, point);
	ClientToScreen(&point);

	CaplInstance *inst=0;
	if(cur_item!=0)
	{
		CaplTreeItemData *item=(CaplTreeItemData*)GetTreeCtrl().GetItemData(cur_item);
		inst=(CaplInstance *)item->data;
		if(!m_api->m_data.IsKindOf(inst,m_wf_mgr->e_proc_tmpl)) return;
	}


	CaplMenu menu;
	VERIFY(menu.LoadMenu(IDR_WFTEMPLATE_CONTEXT_MENU));
	menu.Install(this); 
    CMenu* pPopup = menu.GetSubMenu(0);
    ASSERT(pPopup != NULL);
	if(pPopup==0) return;

	CBitmap bmp0;
	bmp0.LoadBitmap(IDB_TC_MGR_TEMPL);
	CImageList m_il;
	m_il.Create(16,16,ILC_COLOR24|ILC_MASK,0,10);
	m_il.Add(&bmp0,RGB(192,192,192));

	CaplMenu::AddIcon(ID_TEMPLATE_NEW,m_il.ExtractIcon(0));
	CaplMenu::AddIcon(ID_TEMPLATE_COPY,m_il.ExtractIcon(1));
	CaplMenu::AddIcon(ID_TEMPLATE_CHANGE,m_il.ExtractIcon(2));
	CaplMenu::AddIcon(ID_TEMPLATE_DELETE,m_il.ExtractIcon(3));
	CaplMenu::AddIcon(ID_TEMPLATE_PROPERTIES,m_il.ExtractIcon(4));
	CaplMenu::AddIcon(ID_TEMPLATE_SET_ACCESS,m_il.ExtractIcon(5));

	/*CAPLMENU!!!
	menu.ModifyODMenu(NULL,ID_TEMPLATE_NEW,&m_il,0);
	menu.ModifyODMenu(NULL,ID_TEMPLATE_COPY,&m_il,1);
	menu.ModifyODMenu(NULL,ID_TEMPLATE_CHANGE,&m_il,2);
	menu.ModifyODMenu(NULL,ID_TEMPLATE_DELETE,&m_il,3);
	menu.ModifyODMenu(NULL,ID_TEMPLATE_PROPERTIES,&m_il,4);
	menu.ModifyODMenu(NULL,ID_TEMPLATE_SET_ACCESS,&m_il,5);*/

	if(inst==0)
	{
		pPopup->EnableMenuItem(ID_TEMPLATE_COPY, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_TEMPLATE_DELETE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_TEMPLATE_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_TEMPLATE_CHANGE, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_TEMPLATE_SET_ACCESS, MF_BYCOMMAND | MF_GRAYED);
	}

	BOOL res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,
						point.x, point.y, this);

		
	switch (res)
	{
		case ID_TEMPLATE_NEW:
			if(m_parent_select_dlg!=0) m_parent_select_dlg->ExitFromTree(1);
			break;
		case ID_TEMPLATE_COPY:
			if(m_parent_select_dlg!=0) m_parent_select_dlg->ExitFromTree(2);
			break;
		case ID_TEMPLATE_CHANGE:
			if(m_parent_select_dlg!=0) m_parent_select_dlg->ExitFromTree(3);
			break;
		case ID_TEMPLATE_DELETE:
			if(m_parent_select_dlg!=0) m_parent_select_dlg->ExitFromTree(4);
			break;
		case ID_TEMPLATE_PROPERTIES:
			m_wf_mgr->ShowTmplProperties(inst);
			break;
		case ID_TEMPLATE_SET_ACCESS:
			{
				if(inst!=0)
				{
					aplExtent ext;
					ext.Add(inst);
					m_api->m_data.NET_SetInstancesAccess(&ext,_T(""));
				}
			}
			break;
	}
}
