#pragma once

#ifndef APL_WORKFLOW_MGR_NOAUTOLIB
#ifdef _DEBUG
#ifdef _UNICODE
#pragma comment (lib,"aplWorkFlowMgr_ud.lib")
#else
#pragma comment (lib,"aplWorkFlowMgrD.lib")
#endif
#else
#ifdef _UNICODE
#pragma comment (lib,"aplWorkFlowMgr_u.lib")
#else
#pragma comment (lib,"aplWorkFlowMgr.lib")
#endif
#endif
#endif

#include "StepData.h"
#include "aplNetStepData.h"
#include "aplStepManager.h"

class AFX_EXT_CLASS CaplWorkFlowManager : public CaplDeclareWorkflowManager
{
	//  
public:
	/**   (    ) <p>
		@return true     false    */
	bool Attach(CaplAPI *api);
	void Detach();

public:
	CaplEntity* e_action; ///<   ( )
	CaplAttr* a_action_id;	///< 
	CaplAttr* a_action_name; ///< 
	CaplAttr* a_action_dscr; ///< 

	CaplEntity* e_proc_tmpl; ///<  
	CaplAttr* a_proc_tmpl_state; ///<   
	CaplAttr* a_proc_tmpl_var; ///<     ( )
	CaplAttr* a_proc_tmpl_duration; ///<    
	CaplAttr* a_proc_tmpl_holders; ///<  ,       
	CaplAttr* a_proc_tmpl_managers; ///<  ,    
	CaplAttr* a_proc_tmpl_editor; ///<     
	CaplAttr* a_proc_tmpl_author_txt; ///<   
	CaplAttr* a_proc_tmpl_is_system; ///<    
	CaplAttr* a_proc_tmpl_add_wo_function;
	CaplAttr* a_proc_tmpl_add_wo_module;
	CaplAttr* a_proc_tmpl_set_enddate_by_task;
	CaplAttr* a_proc_tmpl_allow_owner_end_any_task;

	/**@name       */
	CaplAttr* a_proc_tmpl_hight; ///<
	CaplAttr* a_proc_tmpl_width; ///<
	CaplAttr* a_proc_tmpl_cols; ///<
	CaplAttr* a_proc_tmpl_rows; ///<
	CaplAttr* a_proc_tmpl_ortogonal; ///<
	
	CaplEntity* e_act_tmpl; ///<     
	CaplAttr* a_act_tmpl_proc_tmpl; ///<   
	
	/**@name       */
	CaplAttr* a_act_tmpl_point; ///<
	CaplAttr* a_act_tmpl_cx; ///<
	CaplAttr* a_act_tmpl_cy; ///<
	CaplAttr* a_act_tmpl_color; ///<
	CaplAttr* a_act_tmpl_font; ///<
	CaplAttr* a_act_tmpl_width; ///<
	
	CaplEntity* e_end_point; ///<    ( e_act_tmpl)
	CaplEntity* e_start_point; ///<    ( e_act_tmpl)

	CaplEntity* e_activity; ///<   ( e_act_tmpl)
	CaplAttr* a_activity_managers; ///<  
	CaplAttr* a_activity_executors; ///<  
	CaplAttr* a_activity_role; ///<  
	CaplAttr* a_activity_duration; ///< 
	CaplAttr* a_activity_waiting_time; ///<   
	CaplAttr* a_activity_not_sign; ///<      
	CaplAttr* a_activity_stop_another_task; ///<   
	
	CaplAttr* a_activity_sub_proc_tmpl; ///<    ( )
	CaplAttr* a_activity_ass_tmpl; ///<   ( )
	
	CaplAttr* a_activity_st_mode; ///<  (  )     
	CaplAttr* a_activity_fn_mode; ///< <  (  )     
	
	CaplAttr* a_activity_st_cond; ///<    ( )
	CaplAttr* a_activity_fn_cond; ///<    ( )
	
	CaplAttr* a_activity_add_wo;
	CaplAttr* a_activity_give_the_process_owner; ///<    

	CaplAttr* a_activity_ed_st_mod; ///<  
	CaplAttr* a_activity_ed_st_fun; ///<   ,   
	CaplAttr* a_activity_ed_st_par; ///<    ,   
	CaplAttr* a_activity_ed_fn_mod; ///<  
	CaplAttr* a_activity_ed_fn_fun; ///<   ,   
	CaplAttr* a_activity_ed_fn_par; ///<    ,   
	
	CaplEntity* e_proc_prot; ///<     
	CaplAttr* a_proc_prot_tmpl; ///<   
	CaplAttr* a_proc_prot_name; ///<   
	
	CaplEntity* e_task_tmpl; ///<     
	CaplAttr* a_task_tmpl_activity; ///<   
	CaplAttr* a_task_tmpl_performer; ///< 
	CaplAttr* a_task_tmpl_performers; ///<    
	CaplAttr* a_task_tmpl_manager; ///< 
	CaplAttr* a_task_tmpl_duration; ///< 
	CaplAttr* a_task_tmpl_waiting_time; ///<   
	CaplAttr* a_task_tmpl_id; ///<  
	CaplAttr* a_task_tmpl_name; ///<  
	CaplAttr* a_task_tmpl_status; ///<  ( )
	CaplAttr* a_task_tmpl_role; ///<  ( )
	CaplAttr* a_task_tmpl_proc_prot; ///<     

	CaplEntity* e_act_inst; ///<     
	CaplAttr* a_act_inst_start_date; ///<   
	CaplAttr* a_act_inst_end_date; ///<    
	CaplAttr* a_act_inst_check_date; ///<  
	CaplAttr* a_act_inst_finish_date; ///<   
	CaplAttr* a_act_inst_prior; ///<  
	CaplAttr* a_act_inst_percent; ///<  
	CaplAttr* a_act_inst_susp_time; ///<   
	CaplAttr* a_act_inst_last_susp_date; ///<   
	
	CaplEntity* e_proc;						///< 
	CaplAttr* a_proc_of_tmpl;				///<    
	CaplAttr* a_proc_owner;					///<   (,  )
	CaplAttr* a_proc_manager;				///<   (,  )
	CaplAttr* a_proc_state;					///<   
	CaplAttr* a_proc_task_prot;				///<    
	CaplAttr* a_proc_process_prot;			///<     
	CaplAttr* a_proc_first_activity;		///< ,     
	CaplAttr* a_proc_wo;					///<   
	CaplAttr* a_proc_archive_date;			///<     
	CaplAttr* a_proc_not_for_work;			///< ,           

	CaplEntity* e_task; ///< 
	CaplAttr* a_task_activity; ///<   
	CaplAttr* a_task_proc; ///<   ,     
	CaplAttr* a_task_state; ///<    
	CaplAttr* a_task_old_state; ///<    
	CaplAttr* a_task_prev; ///<   
	CaplAttr* a_task_performer; ///< 
	CaplAttr* a_task_manager; ///< 
//	CaplAttr* a_task_wo; ///< ( )
	CaplAttr* a_task_sub_proc; ///< ,    
	CaplAttr* a_task_notify_date; ///<   ()   
	CaplAttr* a_task_reseave_date; ///<   ()  
	CaplAttr* a_task_triggered_relations; ///<  
	
	CaplEntity* e_act_rel; ///<   
	CaplAttr* a_act_rel_id; ///< 
	CaplAttr* a_act_rel_name; ///< 
	CaplAttr* a_act_rel_dscr; ///< 
	CaplAttr* a_act_rel_from; ///<    ""
	CaplAttr* a_act_rel_to; ///<    ""
	
	/**@name       */
	CaplAttr* a_act_rel_color; ///< 
	CaplAttr* a_act_rel_font; ///< 
	CaplAttr* a_act_rel_points; ///< 
	CaplAttr* a_act_rel_title_point; ///< 
	CaplAttr* a_act_rel_width; ///< 
	CaplAttr* a_act_rel_arrow_size; ///< 
	
	CaplEntity* e_act_secuence; ///<  
	CaplAttr* a_act_secuence_tmpl; ///<    
	CaplAttr* a_act_secuence_status; ///< ,       
	CaplAttr* a_act_secuence_not_sign; ///<      
	CaplAttr* a_act_secuence_check_status_4_all_obj; ///<    
	CaplAttr* a_act_secuence_check_need_work_4_all_obj; ///<     



	
	CaplEntity* e_wo; ///<  
	CaplAttr* a_wo_object; ///<      (,    ..)
	CaplAttr* a_wo_action; ///<   ()
	CaplAttr* a_wo_for_note; ///<  

	CaplEntity* e_apl_font;
	CaplAttr* a_font_name;
	CaplAttr* a_font_height;
	CaplAttr* a_font_weight;
	CaplAttr* a_font_italic;
	CaplAttr* a_font_char_set;

	CaplEntity *e_apl_point;
	CaplAttr *a_apl_point_x;
	CaplAttr *a_apl_point_y;
	
	bool m_bCompleteProcessNotify_4_ParentProcess;  //      ,    
		

	/**    true,    */
	bool m_bUseSignature;
	

	// 

	static BOOL m_b_mark_work_with_color;  //   
	static BOOL m_b_mark_ended_work_with_color; //   
	static BOOL m_b_not_show_task_of_future_process; //         
	static int  m_i_mark_work_with_color_warning_time;  //       

	static bool LoadOptions();
	static bool SaveOptions();

	virtual void LoadParamsFromDB();

public:

	/**   (    )
		@param id - 
		@param name - 
		@param dscr - 
		@param proc_tmpl - ,    
		@param owner -  (  )
		@param manager -   
		@param start_date -   (  )
		@param finish_date -   
		@param check_date -   
		@param task_prot -  
		@param work_objects -   
		@param priority -   		
		@return         NULL    */
	CaplInstance* CreateWfProcess(LPCTSTR id, LPCTSTR name, LPCTSTR dscr,
		CaplInstance* proc_tmpl, CaplInstance* owner, CaplInstance* manager,
		LPCTSTR start_date, LPCTSTR finish_date, LPCTSTR check_date, 
		aplExtent &task_prot, aplExtent &work_objects, LPCTSTR priority= _T("medium"));
	
	/**  
		@param process - 
		@param procLog - ( )
		@param bSave -       
		@param bVerify -       
		@return true     false   */
	bool DeleteWfProcess(CaplInstance* process, CStringArray &procLog, 
		bool bSave= true, bool bVerify= true);
	
	/**    
		@param process - 
		@param bVerify -        
		@param first_activity - ,    
		@return true     false   */
	bool RunWfProcess(CaplInstance* process, bool bVerify= true, CaplInstance* first_activity= NULL);
	
	/**  
		@param process - ,   
		@return     NULL   */
	CaplInstance* RestartWfProcess(CaplInstance* process);

	/**   
		@param process - 
		@param bVerify -         
		@return true     false   */
	bool SuspendWfProcess(CaplInstance* process, bool bVerify= true);

	/**   
		@param process -  
		@param bVerify -        
		@return true     false   */
	bool TerminateWfProcess(CaplInstance* process, bool bVerify= true);

	/**    
		@param process -  
		@return true     false   */
	bool EndWfProcess(CaplInstance* process);


	/**     ,     
		 
		@param owner - 
		@param proc_tmpls -   
		@return true     false   */
	bool GetUserProcessTempList(CaplInstance* owner, aplExtent& proc_tmpls);

	/**       
		@param owner - 
		@param procs -  
		@return true     false   */
	bool GetUserProcessList(CaplInstance* owner, aplExtent& procs, bool bReturnWithArchiveProc = false, bool bOnlyActiveProc = false);

	/**       
		@param performer - 
		@param task_list -  
		@param bCompleted -  
		@param bCanceled -  
		@param bSuspended -  
		@return true      false   */
	virtual bool GetUserTaskList(CaplInstance* performer, aplExtent&task_list, bool bCompleted=true, bool bCanceled=true, bool bSuspended=true);

	/**   
		@param proc - 
		@param tasks -  
		@return true     false   */
	bool GetProcessTasks(CaplInstance* proc, aplExtent& tasks);

	/**   
		@param extProcs - 
		@param tasks -  
		@return true     false   */
	bool GetProcessTasks(aplExtent& extProcs, aplExtent& tasks);

	/**      
		@param task_or_process -   
		@param objects -   
		@return true     false   */
	virtual bool GetWorkObjects(CaplInstance* task_or_process, aplExtent&objects);

	/**     
		@param item -   
		@param paent_tasks -    (      1 )
		@return true     false   */
	bool GetParentTasks(CaplInstance *item, aplExtent& paent_tasks);


	/**          */
	bool CanChangeWorkObjectsList(CaplInstance* process);

	/**         
		@param process - 
		@return true     false   */
	virtual bool LoadProcessInfo(CaplInstance* process);

	/**         
		@param process - 
		@return true     false   */
	virtual bool LoadProcessInfo(aplExtent& process);

	/**     
		@param process - 
		@return true     false   */
	bool ShowProcessProperties(CaplInstance* process);
	
	/**  
		@param process - ,    
		@param activity - ,    
		@param connector -      .       
		@param sub_proc -  
		@param previous -  
		@param priority -  
		@param id -  
		@param name - 
		@param dscr -  
		@param perfomer -  
		@param manager -  
		@param start_date -   
		@param finish_date -   
		@param check_date -  
		@return      NULL   */
	CaplInstance* CreateTask(CaplInstance* process, CaplInstance* activity, CaplInstance* connector,
		aplExtent &sub_proc, CaplInstance* previous= NULL, 
		LPCTSTR priority= _T("medium"),
		LPCTSTR id= _T(""), LPCTSTR name= _T(""), LPCTSTR dscr= _T(""),
		CaplInstance* perfomer= NULL, CaplInstance* manager= NULL,  
		LPCTSTR start_date= _T(""), LPCTSTR finish_date= _T(""), LPCTSTR check_date= _T(""));


	//  
	CaplInstance* CaplWorkFlowManager::CreateLogicalTask(CaplInstance* process, CaplInstance* activity, CaplInstance* connector,
		aplExtent &sub_proc, CaplInstance* previous);

protected:
	//    
	bool StopAllProcessTask(CaplInstance *process);

	//       
	CaplInstance *EndLogicalTask(CaplInstance *task_log_el);
public:

	/**    
		@param task - 
		@param bVerify -         
		@return true     false   */
	bool RunTask(CaplInstance* task, bool bVerify= true);

	/**         (   )
		@param task - 
		@return true     false   */
	bool SetTaskWorking(CaplInstance* task);

	/**  
		@param task - ,   
		@param newPerformer -  
		@param newManager -  
		@return       NULL   */
	CaplInstance* RestartTask(CaplInstance* task, 
		CaplInstance* newManager= NULL, CaplInstance* newPerformer= NULL);

	/**   .     .
		@param task - ,   
		@return       NULL   */
	CaplInstance* StopAllAddRunLogcalElement(CaplInstance* task);

	/**  
		@param task - 
		@param bVerify -         
		@return true     false   */
	bool SuspendTask(CaplInstance* task, bool bVerify= true);

	/**  
		@param task - 
		@return true     false   */
	bool EndTask(CaplInstance* task, CaplInstance* connector= NULL, bool bCancelTask = false, bool bForce = false);

	/**    (  ,       - )
		@param task - 
		@return true     false   */
	bool ReEndTask(CaplInstance* task, CaplInstance* connector= NULL, bool bCancelTask = false, bool bForce = false);


	/**         
		@param  task - 
		@return true     false   */
	bool LoadTaskInfo(CaplInstance* task);
	
	/**         
		@param  tasks - 
		@return true     false   */
	bool LoadTaskInfo(aplExtent& tasks);

	/**         activity
		@param  activity - 
		@return true     false   */
	bool LoadActivityInfo(CaplInstance* activity);

	/**         activity
		@param  activity - 
		@return true     false   */
	bool LoadActivityInfo(aplExtent& activity);

	/**     
		@param  task - 
		@return true     false   */
	bool ShowTaskProperties(CaplInstance* task);

	/**    ()     
		@param task_or_act -   
		@param in_con -  
		@param out_con -  
		@return true     false   */
	bool GetConnectors(CaplInstance* task_or_act, aplExtent& in_con, aplExtent& out_con);
	
	/**   ,       
		@param proc_or_tmpl -    
		@param activities -  ,     
		@return true     false   */
	bool GetProcessComponents(CaplInstance* proc_or_tmpl, aplExtent& activities);

	/**     
		@param tmpl -  
		@param connectors -  
		@return true     false   */
	bool GetProcessConnectors(CaplInstance* tmpl, aplExtent& connectors);

	/**     ,   
		 
		@param owner - 
		@param proc_tmpls -  
		@param history -  
		@return true     false   */
	bool GetProcessTmplHistory(CaplInstance* owner,
		CaplInstance* proc_tmpls, aplExtent& history);

	/**   ,    
		 
		@param owner - 
		@param activity - 
		@param history -  
		@return true     false   */
	bool GetActivityHistory(CaplInstance* owner, CaplInstance* activity, 
		aplExtent& history);
	
	/**        
		@param id -  
		@return     NULL   */
	CaplInstance* GetProcessTmplById(LPCTSTR id);

	/**      
		@param tmpl -  
		@param bVerify -          
		@return true     false   */
	bool DeleteProcessTemplate(CaplInstance* tmpl, bool bVerify= true);
	
	/**        
		@param tmpl_or_act -    
		@return true     false   */
	bool ShowTmplProperties(CaplInstance* tmpl_or_act);
 
	/**     
		@param templ -  */
	int TemplateValidCheck(CaplInstance * templ, int errMode=false);
	
	/**       
		@return true     false    */
	bool LoadTemplates();
		
	/**  */
	bool FillWfDates(COleDateTime &startDate, double duration, 
		COleDateTime &checkDate, COleDateTime &finishDate);	
	/**  */
	bool ForwardTaskToPerfomer(CaplInstance* task, CaplInstance* perfomer);
	
	/**      
	@param ciTemplate - ,   
	@param ciActivity - ,   */
	void AnalyzeWorkTimes(CaplInstance* ciTemplate=NULL,CaplInstance* ciActivity=NULL);

	/**       
	@param ciTemplate - 
	@param ciTask - 
	@param crated_proc -  ,     */
	void StartManyProcs(CaplInstance* ciTemplate,CaplInstance* ciTask, aplExtent* crated_proc= NULL);


	/**      
	@param wf_template -  
	@param task_for_sel -  */
	void ShowTemplateSchema(CaplInstance *wf_template, CaplInstance *task_for_sel=0);

	/*    */
	bool GetProcessPrototypes(CaplInstance* proc_or_tmpl, aplExtent& prots);
	/* items      */
	bool GetProcessPrototypeItems(CaplInstance* proc_or_tmpl, aplExtent& items);
	/*      */
	CaplInstance* CreateProcessPrototype(CaplInstance* proc_tmpl);
	/*          :))
	( )*/
	bool ShowPrototypes(CaplInstance* proc_or_prot, aplExtent* existProts= NULL, bool bReadOnly= false);

	/**       
	@param templates -    
	@param sel_template -   
	@param bShowAllTemplates -      
	@param SelectMode -        <br>

		APL_MODE_WFL_SELECT_TEMPLATE -    
		APL_MODE_WFL_SELECT_ACTIVITI -   apl_activity

	@return   	*/
	CaplInstance *SelectTemplateSchema(aplExtent &templates, CaplInstance *sel_template=0, bool bShowAllTemplates = true, long SelectMode = APL_MODE_WFL_SELECT_TEMPLATE);

	/*   
	  iEditorResultMode = 0 - ;  1-  ; 2-  ; 3- 
	*/
	
	CaplInstance *SelectTemplateSchemaInEditor(aplExtent &templates, int  &iEditorResultMode);

	/*    (bStartModule= true)   (bStartModule= false) 
	 1   , 0       -1,     */
	BOOL RunProgrammModule(CaplInstance* task, aplExtent& ApprovedWO, CaplInstance* connector= NULL, bool bStartModule= true);

	bool CanAddInstanceInProcess(CaplInstance* process, CaplInstance* inst);

	/* ,    */
	virtual bool FindProcessContained(CaplInstance *ciItem, aplExtent &aeExtOut);

	/* ,    extItems*/
	virtual bool FindProcessContained(aplExtent& extItems, aplExtent& extOut);

	//      
	// bWarning   true,    
	bool GetItemColor(CaplInstance *item, COLORREF &color, bool *bWarning=0); 

	void ShowColorLegend(); //     

	/**     
		@param process_or_template -   
		@param sId -  
		@return true     false   */
		bool GenerateProcId(CaplInstance* process_or_template, CString &sId);

	/**      -     
		@return true    false   */
		bool IsItemLogicalElement(CaplInstance *item);	

		//    
		bool CreateContentForTaskNotify(CString &sContent, CaplInstance *task, LPCTSTR psNotify);

};

// TRUE,       
BOOL AFX_EXT_API  aplTestCyrcleInProcess(CaplWorkFlowManager* wf_mgr, CaplInstance* task, CaplInstance* sub_process);
//      
void AFX_EXT_API  aplSortWfInstances(CaplWorkFlowManager* wf_mgr, aplExtent& tasks, int iLeft, int iRight);

//,        ( person==NULL,
//  
BOOL AFX_EXT_API aplIsPersonOrgElement(CaplAPI* api, CaplInstance* Element, CaplInstance* person=NULL);
//bool AFX_EXT_API aplWFSignWO(CaplAPI* api, CaplInstance* approval, CString sSystem, CString &sKey, CString &sPassword, 
//		CString &sSign, CString &sHash, CString &sOpenKey, CCryptographicProvider* prov= NULL);
//bool AFX_EXT_API aplGetSignParams(CaplAPI* api, CString &sSystem, CString &sKey, CString &sPassword, CCryptographicProvider* prov= NULL);


