// CharHelper.cpp: implementation of the CCharHelper class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CharHelper.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCharHelper::CCharHelper(CaplAPI* api)
{
	m_api=api;
}

CCharHelper::~CCharHelper()
{

}

BOOL CCharHelper::GetChar(CaplInstance*& ciCharInst,CString& csCharTxt,int iType)
{
	CArray<CaplEntity*,CaplEntity*>		aeCharUnits;
	CArray<CaplEntity*,CaplEntity*>		aeCharUnits2;

	CaplInstance*	ciT=NULL;
	CaplInstance*	ciCharUnit	=NULL;

	BOOL			bIsValidType[2];

	CString			csET[2]={"",""};
	CString			cst1="",cst2="";

	if(iType<m_eFirstType || iType>m_eLastType)
		return FALSE;

	aeCharUnits.SetAtGrow(m_eWeightType,m_api->m_charact_mgr.e_apl_step_unit);
	aeCharUnits.SetAtGrow(m_eCostType,m_api->m_charact_mgr.e_apl_monetary_unit);

	aeCharUnits2.SetAtGrow(m_eWeightType,m_api->m_charact_mgr.e_apl_monetary_unit);
	aeCharUnits2.SetAtGrow(m_eCostType,m_api->m_charact_mgr.e_apl_step_unit);

	while(1)
	{
		bIsValidType[0]=FALSE;bIsValidType[1]=FALSE;
		cst1="";

		ciT=m_api->m_charact_mgr.SelectCharacteristic();
		if(NULL==ciT)
			return FALSE;//FindDefChar(ciCharInst,csCharTxt,iType);
		//	  
		m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_unit,ciCharUnit);
		if(NULL==ciCharUnit)
			return FALSE;
		if(m_api->m_data.IsKindOf(ciCharUnit,aeCharUnits[iType]) ||
		   m_api->m_data.IsKindOf(ciCharUnit,aeCharUnits2[iType]))
			bIsValidType[iType]=TRUE;
		if(TRUE==bIsValidType[iType])
			break;
		else
		{
			cst1.Format("      %s!",csET[iType]);
			AfxMessageBox(cst1,MB_ICONSTOP|MB_OK);
		}
	}

	m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_id,cst1);
	m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_name,cst2);
	ciCharInst=ciT;
	csCharTxt=cst1+" : "+cst2;
	return TRUE;
}

BOOL CCharHelper::FindDefChar(CaplInstance*& ciCharInst,CString& csCharTxt,int iType)
{
	CaplInstance*	ciT=NULL;

	CString			csCharIDs[]={"","/."};
	CString			cst1="",cst2="";

	ciT=m_api->m_charact_mgr.GetCharacteristicById(csCharIDs[iType]);
	if(NULL==ciT)
	{
		ciCharInst=NULL;
		csCharTxt="";
		return FALSE;
	}

	m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_id,cst1);
	m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_name,cst2);
	ciCharInst=ciT;
	csCharTxt=cst1+" : "+cst2;
	return TRUE;
}

BOOL CCharHelper::FindCharByTxt(CaplInstance*& ciCharInst,CString& csCharTxt)
{
	CaplInstance* ciT=NULL;

	CString csCharID="",csCharName="",cst="";

	int iPos=-1;

	ciCharInst=NULL;
	if(csCharTxt=="")
		return FALSE;
	iPos=csCharTxt.Find(':');
	if(-1==iPos)
		return FALSE;
	csCharID=csCharTxt.Left(iPos-1); //   
	csCharName=csCharTxt.Right(csCharTxt.GetLength()-iPos-2); //    
	ciT=m_api->m_charact_mgr.GetCharacteristicById(csCharID);
	if(NULL==ciT)
		return FALSE;
	m_api->m_data.GetAttr(ciT,m_api->m_charact_mgr.a_apl_charact_name,cst);
	if(cst!=csCharName)
		return FALSE;
	ciCharInst=ciT;
	return TRUE;
}

BOOL CCharHelper::GetCharTypes(aplExtent& aeCharTypes,CStringList& csCharTypes)
{
	CString cst="";

	BOOL bRet=FALSE;

	int i=0;

	aeCharTypes.Clear();
	csCharTypes.RemoveAll();

	bRet=m_api->m_data.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,aeCharTypes);
	if(FALSE==bRet)
		return FALSE;
	for(i=0;i<aeCharTypes.GetSize();i++)
	{
		cst="";bRet=FALSE;
		bRet=m_api->m_data.GetAttr(aeCharTypes[i],
								   m_api->m_charact_mgr.a_apl_charact_type_name,cst);
		if(FALSE==bRet)
		{
			aeCharTypes.Clear();
			csCharTypes.RemoveAll();
			return FALSE;
		}
		csCharTypes.AddTail(cst);
	}
	return TRUE;
}

BOOL CCharHelper::GetContexts(aplExtent& aeContexts,CStringList& csContexts)
{
	int i=0;
	BOOL bRet=FALSE;
	CString cst="";
	
	aeContexts.Clear();
	csContexts.RemoveAll();

	bRet=m_api->m_data.GetEntityExtent(m_api->m_charact_mgr.e_pd_context,aeContexts);
	if(FALSE==bRet)
		return FALSE;
	for(i=0;i<aeContexts.GetSize();i++)
	{
		cst="";
		bRet=m_api->m_data.GetAttr(aeContexts.GetAt(i),m_api->m_charact_mgr.a_pd_context_name,
								   cst);
		if(FALSE==bRet)
		{
			aeContexts.Clear();
			csContexts.RemoveAll();
			return FALSE;
		}
		csContexts.AddTail(cst);
	}
	return TRUE;
}

