// DlgAttrsHistory.cpp : implementation file
//

#include "stdafx.h"
#include "DlgAttrsHistory.h"


// CDlgAttrsHistory dialog

IMPLEMENT_DYNAMIC(CDlgAttrsHistory, CaplResizableDialog)

CDlgAttrsHistory::CDlgAttrsHistory(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CDlgAttrsHistory::IDD, pParent)
	, m_DateBeg1(COleDateTime::GetCurrentTime())
	, m_DateEnd1(COleDateTime::GetCurrentTime())
	, m_IsBeg(FALSE)
	, m_IsEnd(FALSE)
	, m_IsUsr(FALSE)
	, m_IsEnt(TRUE)
	, m_StrAbout(_T(""))
{
	//m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_data = 0;
}

CDlgAttrsHistory::~CDlgAttrsHistory()
{
}

void CDlgAttrsHistory::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CActiveUsersList)
	DDX_Control(pDX, IDOK, m_ok_btn);
	//}}AFX_DATA_MAP
	DDX_DateTimeCtrl(pDX, IDC_DATETIME_BEG1, m_DateBeg1);
// 	DDX_DateTimeCtrl(pDX, IDC_DATETIME_BEG2, m_DateBeg2);
	DDX_DateTimeCtrl(pDX, IDC_DATETIME_END1, m_DateEnd1);
// 	DDX_DateTimeCtrl(pDX, IDC_DATETIME_END2, m_DateEnd2);
	DDX_Control(pDX, IDC_COMBO_SELECT_ENTITY, m_CmbxSelectEntity);
	DDX_Control(pDX, IDC_COMBO_SELECT_USER, m_CmbxSelectUser);
	DDX_Check(pDX, IDC_CHECK_BEG, m_IsBeg);
	DDX_Check(pDX, IDC_CHECK_END, m_IsEnd);
	DDX_Check(pDX, IDC_CHECK_ENTITY, m_IsEnt);
	DDX_Check(pDX, IDC_CHECK_USER, m_IsUsr);
	DDX_Control(pDX, IDC_DATETIME_BEG1, m_CtrlDateTimeBeg1);
	DDX_Control(pDX, IDC_DATETIME_END1, m_CtrlDateTimeEnd1);
	DDX_Control(pDX, IDC_STATIC_USER, m_CtrlStUser);
	DDX_Control(pDX, IDC_CHECK_BEG, m_CtrlBtnBeg);
	DDX_Control(pDX, IDC_CHECK_END, m_CtrlBtnEnd);
	DDX_Control(pDX, IDC_STATIC_BEG1, m_CtrlStBeg1);
	DDX_Control(pDX, IDC_STATIC_END1, m_CtrlStEnd1);
	DDX_Control(pDX, IDC_APPLY, m_CtrlBtnApply);
	DDX_Control(pDX, ID_SAVE_TO_FILE, m_CtrlBtnFile);
	DDX_Text(pDX, IDC_EDIT_ABOUT, m_StrAbout);
}


BEGIN_MESSAGE_MAP(CDlgAttrsHistory, CaplResizableDialog)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_USERS, OnRclickListObjects)
	ON_BN_CLICKED(IDC_CHECK_END, &CDlgAttrsHistory::OnBnClickedCheckEnd)
	ON_BN_CLICKED(IDC_CHECK_BEG, &CDlgAttrsHistory::OnBnClickedCheckBeg)
	ON_BN_CLICKED(IDC_CHECK_USER, &CDlgAttrsHistory::OnBnClickedCheckUser)
	ON_BN_CLICKED(ID_SAVE_TO_FILE, &CDlgAttrsHistory::OnBnClickedSaveToFile)
	ON_BN_CLICKED(IDC_APPLY, &CDlgAttrsHistory::OnBnClickedApply)
END_MESSAGE_MAP()


// CDlgAttrsHistory message handlers

BOOL CDlgAttrsHistory::OnInitDialog() 
{

	CArray<CaplEntity*,CaplEntity*> list_active;
	CArray<CaplEntity*,CaplEntity*> list_all;
	aplExtent users;
	CaplEntity *entity;

	CaplResizableDialog::OnInitDialog();

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_CtrlBtnApply.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_CtrlBtnApply.SetFlat(FALSE);
	//m_CtrlBtnFile.SetIcon(GetAplStdIco16(APLSTDICO_));
	m_CtrlBtnFile.SetFlat(FALSE);

	bool state_load;
	bool found = false;
	int i;
	CString str;

	if(m_data== 0)return FALSE;
	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(m_data);

	m_ListAttrsVal.CreateFromStatic(IDC_LIST_ATTRS_VALS,this);

	state_load=m_data->NET_GetAttrsHistoryEntities(list_active,list_all,users);
	if(state_load)
	{
		if(list_active.GetSize()>0)
		{
			m_StrAbout=APL_T("  : ");
		}
		else
		{
			m_StrAbout=APL_T("      ");
		}
		int prev_line = 0;
		for(i = 0;i<list_active.GetSize();i++)
		{
			if(i>0) m_StrAbout += _T(", ");
			if(div(m_StrAbout.GetLength(),200).quot != prev_line)
			{
				m_StrAbout += _T("\r\n"); prev_line++; 
			}
			m_StrAbout+=list_active[i]->name;
		}
	}
	else
	{
		m_StrAbout=APL_T("   ");
	}
	//   m_StrAbout    
	UpdateData(FALSE);

	AddAnchor(IDC_LIST_ATTRS_VALS, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT, BOTTOM_RIGHT);
	AddAnchor(ID_SAVE_TO_FILE, BOTTOM_LEFT, BOTTOM_LEFT);
	//AddAnchor(IDC_APPLY, BOTTOM_LEFT, BOTTOM_LEFT);
	AddAnchor(IDC_EDIT_ABOUT, TOP_LEFT, TOP_RIGHT);

	EnableSaveRestore(_T("options"), _T("AttrsValsHistory_Coord"));
	
// 	SetIcon(m_hIcon, TRUE);			// Set big icon
// 	SetIcon(m_hIcon, FALSE);		// Set small icon

	if(state_load)
	{
		CRect rect;
		int pos;
		m_ListAttrsVal.GetClientRect(rect);
		m_ListAttrsVal.DeleteAllColumns();
		m_ListAttrsVal.DeleteAllItems();
		if(list_all.GetSize()== 0)
		{
			m_ListAttrsVal.InsertColumn(0,_T("..."),LVCFMT_LEFT,rect.Width()*9/10);
			m_ListAttrsVal.InsertItem(0, APL_T("     "));
			m_CtrlBtnApply.EnableWindow(FALSE);
		}
		else
		{
			for(i = 0;i<users.Size;i++)
			{
				if(users[i]->GetTemporary())
				{
					str.Format(APL_T("< #%i  >"), users[i]->GetId());
				}
				else
				{
					m_data->GetAplUserName(users[i], str);
				}
				pos=m_CmbxSelectUser.AddString(str);
				m_CmbxSelectUser.SetItemData(pos,(long)(users[i]));
			}
			if(users.Size>0)m_CmbxSelectUser.SetCurSel(0);
			for(i = 0;i<list_all.GetSize();i++)
			{
				entity=list_all.GetAt(i);
				pos=m_CmbxSelectEntity.AddString(entity->name);
				m_CmbxSelectEntity.SetItemData(pos, (long)(entity));
			}		
			if(list_active.GetSize()>0)m_CmbxSelectEntity.SetCurSel(0);

			//     --   
			m_ListAttrsVal.DeleteAllColumns();
  			m_ListAttrsVal.InsertColumn(0, APL_T(" "),LVCFMT_LEFT,rect.Width()*5/100);
			m_ListAttrsVal.InsertColumn(1, APL_T(""),LVCFMT_LEFT,rect.Width()*15/100);
			m_ListAttrsVal.InsertColumn(2, APL_T(""),LVCFMT_LEFT,rect.Width()*10/100);
			m_ListAttrsVal.InsertColumn(3, APL_T(""),LVCFMT_LEFT,rect.Width()*10/100);
			m_ListAttrsVal.InsertColumn(4, APL_T(""),LVCFMT_LEFT,rect.Width()*10/100);
			m_ListAttrsVal.InsertColumn(5, APL_T(" "),LVCFMT_LEFT,rect.Width()*10/100);
			m_ListAttrsVal.SetColumnDate(5);
			m_ListAttrsVal.InsertColumn(6, APL_T(" "),LVCFMT_LEFT,rect.Width()*20/100);
			m_ListAttrsVal.InsertColumn(7, APL_T(" "),LVCFMT_LEFT,rect.Width()*20/100);


		}
		OnBnClickedCheckBeg();
		OnBnClickedCheckEnd();
		OnBnClickedCheckUser();

	}


	return TRUE;  

	// return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE

}

void CDlgAttrsHistory::OnBnClickedCheckBeg()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_CtrlDateTimeBeg1.EnableWindow(m_IsBeg);
}

void CDlgAttrsHistory::OnBnClickedCheckEnd()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_CtrlDateTimeEnd1.EnableWindow(m_IsEnd);
}


void CDlgAttrsHistory::OnBnClickedCheckUser()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	m_CmbxSelectUser.EnableWindow(m_IsUsr);
}


void CDlgAttrsHistory::OnBnClickedApply()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	MakeAttrsHistory();
}


#define ClearTime1(odt) odt.SetDate(odt.GetYear(),odt.GetMonth(),odt.GetDay());
#define ClearTime2(odt) odt.SetDateTime(odt.GetYear(),odt.GetMonth(),odt.GetDay(),23,59,59);

bool CDlgAttrsHistory::MakeAttrsHistory()
{
	CString str,str1;
	CaplInstance *inst;
	CaplEntity* entity;

	SQAH_Info* el;
	int pos;
	CRect rect;
	COleDateTime odt;
	SQAH_Filter filter;
	CaplTAggr<SQAH_Info*,SQAH_Info*,APLAGGR_LIST_OR_AUTOKILLREF> list_rez;

	if( m_IsEnt)
	{
		pos=m_CmbxSelectEntity.GetCurSel();
		if(pos==-1)return false;
		entity = (CaplEntity*) m_CmbxSelectEntity.GetItemData(pos);
		filter.ent_id = (UINT32)entity->id;
	}
	if( m_IsUsr)
	{
		pos=m_CmbxSelectUser.GetCurSel();
		if(pos==-1)return false;
		inst = (CaplInstance*) m_CmbxSelectUser.GetItemData(pos);
		filter.user_id=(UINT32)inst->GetId();
	}
	if(m_IsBeg==TRUE)
	{
		ClearTime1(m_DateBeg1);
		aplDate2String(m_DateBeg1,filter.date_beg_1);
	}
	if(m_IsEnd==TRUE)
	{
		ClearTime2(m_DateEnd1);
		aplDate2String(m_DateEnd1,filter.date_end_1);
	}

// 	m_ListAttrsVal.GetClientRect(rect);
// 	m_ListAttrsVal.DeleteAllColumns();
// 	m_ListAttrsVal.DeleteAllItems();
// 	m_ListAttrsVal.InsertColumn(0,_T("..."),LVCFMT_LEFT,rect.Width()*9/10);
// 	m_ListAttrsVal.InsertItem(0, APL_T("...    .  ..."));

	if(!m_data->NET_GetAttrsHistory(filter,list_rez ))
	{
		m_ListAttrsVal.DeleteAllItems();
		m_ListAttrsVal.InsertItem(0, APL_T("  !      "));
		return false;
	}
	if(list_rez.GetSize()== 0)
	{
		m_ListAttrsVal.DeleteAllItems();
		m_ListAttrsVal.InsertItem(0, APL_T("  !      "));
		return true;
	}
	//     --   
// 	m_ListAttrsVal.DeleteAllColumns();
// 	m_ListAttrsVal.InsertColumn(0,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*5/100);
// 	m_ListAttrsVal.InsertColumn(1,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*15/100);
// 	m_ListAttrsVal.InsertColumn(2,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
// 	m_ListAttrsVal.InsertColumn(3,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
// 	m_ListAttrsVal.InsertColumn(4,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
// 	m_ListAttrsVal.InsertColumn(5,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*10/100);
// 	m_ListAttrsVal.SetColumnDate(5);
// 	m_ListAttrsVal.InsertColumn(6,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*20/100);
// 	m_ListAttrsVal.InsertColumn(7,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*20/100);

	CaplInstance* user;
	CaplAttr* attr;

	m_ListAttrsVal.DeleteAllItems();
	for(int i = 0;i<list_rez.Size;i++)
	{
		el=list_rez.GetAt(i);

		// 	m_ListAttrsVal.InsertColumn(0,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*5/100);
		if(el->AUSId==-1)
			str = APL_T(". , -     sql");
		else
			str.Format(_T("%i"),el->AUSId);

		m_ListAttrsVal.InsertItem(i,str);
		m_ListAttrsVal.SetItemData(i,(DWORD)el);

		// m_ListAttrsVal.InsertColumn(1,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*15/100);
		user = m_data->GetInstById(el->user_id);
		if(el->AUSId==-1 && user==0)
			str = APL_T(". , -     sql");
		else if(user== 0 || user->GetTemporary())
			str.Format( APL_T("< #%i  >"),el->user_id);
		else
			m_data->GetAplUserName(user, str);
		
		m_ListAttrsVal.SetItemText(i,1,str);

		// m_ListAttrsVal.InsertColumn(2,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
		str.Format(_T("%i"),el->inst_id);
		m_ListAttrsVal.SetItemText(i,2,str);

		//m_ListAttrsVal.InsertColumn(3,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
		//m_ListAttrsVal.InsertColumn(4,_T( APL_T("")),LVCFMT_LEFT,rect.Width()*10/100);
		attr = m_data->GetAttrDefinitionById(el->attr_id);
		if(attr== 0)
		{
			str=APL_T("");
		}
		else
		{
			str=attr->entity->name;
		}
		m_ListAttrsVal.SetItemText(i,3,str);
		if(attr== 0)
		{
			str=APL_T("");
		}
		else
		{
			str=attr->name;
		}
		m_ListAttrsVal.SetItemText(i,4,str);

		// m_ListAttrsVal.InsertColumn(5,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*10/100);
		odt=el->update_date;
		str=odt.Format(_T("%d.%m.%Y %H:%M:%S"));
		m_ListAttrsVal.SetItemText(i,5,str);
		// m_ListAttrsVal.InsertColumn(6,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*20/100);
		// m_ListAttrsVal.InsertColumn(7,_T( APL_T(" ")),LVCFMT_LEFT,rect.Width()*20/100);
		if(attr== 0)
		{
			str=_T("???");
			m_ListAttrsVal.SetItemText(i,6,str);
			m_ListAttrsVal.SetItemText(i,7,str);
		}
		else
		{
			if(el->single_val)
			{
				if(el->val_old.type==aplNOTYPE)
					str = _T("<null>");
				else
					el->val_old.Print(str);
				m_ListAttrsVal.SetItemText(i,6,str);

				if(el->val_new.type==aplNOTYPE)
					str = _T("<null>");
				else
					el->val_new.Print(str);
				m_ListAttrsVal.SetItemText(i,7,str);
			}
			else
			{
				if(attr->type==aplSTRING || attr->type==aplAGGR || attr->type==aplENUMERATION)
				{
					m_ListAttrsVal.SetItemText(i,6,el->str_val_old);
					m_ListAttrsVal.SetItemText(i,7,el->str_val_new);
				}
				else if(attr->type==aplINSTANCE || attr->type==aplSELECT || attr->type==aplINTEGER || 
					attr->type==aplBOOL || attr->type==aplLOGICAL)
				{
					str.Format(_T("%i"),el->int_val_old);
					m_ListAttrsVal.SetItemText(i,6,str);
					str.Format(_T("%i"),el->int_val_new);
					m_ListAttrsVal.SetItemText(i,7,str);
				}
				else if(attr->type==aplREAL )
				{
					str.Format(_T("%1.15G"),el->rea_val_old);
					m_ListAttrsVal.SetItemText(i,6,str);
					str.Format(_T("%1.15G"),el->rea_val_new);
					m_ListAttrsVal.SetItemText(i,7,str);
				}
			}
		}
	}
	return true;
}

void CDlgAttrsHistory::OnBnClickedSaveToFile()
{
	// TODO: Add your control notification handler code here
	//    
	ProcessContextMenu(0);
}
void CDlgAttrsHistory::OnRclickListObjects(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
	ProcessContextMenu(pNMHDR);
}

#define ID_MENU_COPY_CELL 108 
#define ID_MENU_COPY_STRING 109 
#define ID_MENU_HISTORY_SAVE_ALL 110 
#define ID_MENU_HISTORY_SAVE_SELECTED 111 

void CDlgAttrsHistory::ProcessContextMenu(NMHDR* pNMHDR)
{
	const MSG* msg;
	CaplMenu menu;
	BOOL res;
	CString buf,buf1;
	COleDateTime odt;

	msg=GetCurrentMessage();
	//   CInstPropertyCtrl     ,  
	//   RClick,    OnInitDialog  CInstPropertyCtrl::SetContexMenuMode

  	int num_curr= m_ListAttrsVal.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );

// 	CaplTAggr<SQAH_Info*,SQAH_Info*,APLAGGR_AUTOKILLREF> array;
// 	array.Clear();
// 	while( num_curr!= -1){
// 		array.Add(new SQAH_Info((SQAH_Info*)m_ListAttrsVal.GetItemData(num_curr)));
// 		num_curr= m_ListAttrsVal.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
// 	}




	menu.CreatePopupMenu();
	menu.Install(this);

	int i;
	LPNMLISTVIEW pNMListView=(LPNMLISTVIEW)pNMHDR;
	if(pNMListView != 0)
	{
		if(pNMListView->iItem!=-1)
		{
			if(pNMListView->iSubItem!=-1)menu.AppendMenu(MF_ENABLED|MF_STRING,ID_MENU_COPY_CELL, APL_T(" "));
			menu.AppendMenu(MF_ENABLED|MF_STRING,ID_MENU_COPY_STRING, APL_T(" "));
		}
	}

	menu.AppendMenu(MF_ENABLED|MF_STRING,ID_MENU_HISTORY_SAVE_ALL, APL_T("    "));
	if(num_curr>-1){
		menu.AppendMenu(MF_ENABLED|MF_STRING,ID_MENU_HISTORY_SAVE_SELECTED, APL_T("    "));
	}else{
		menu.AppendMenu(MF_GRAYED|MF_STRING,ID_MENU_HISTORY_SAVE_SELECTED, APL_T("    "));
	}
	menu.AppendMenu(MF_SEPARATOR,0,_T(""));


	res=menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this); //-V519
	//       :
	switch (res)
	{
	case ID_MENU_HISTORY_SAVE_ALL:
		odt=COleDateTime::GetCurrentTime();
		GetWindowText(buf1);
		buf=buf1;
		buf1=odt.Format(_T("%d.%m.%Y %H:%M:%S"));
		buf+= APL_T("  ")+buf1;
		apl_SaveListCtrlToFile(&m_ListAttrsVal,LPCTSTR(m_def_file_name),buf,true);
		break;

	case ID_MENU_HISTORY_SAVE_SELECTED:
		odt=COleDateTime::GetCurrentTime();
		GetWindowText(buf1);
		buf=buf1;
		buf1=odt.Format(_T("%d.%m.%Y %H:%M:%S"));
		buf+= APL_T("  ")+buf1;
		apl_SaveListCtrlToFile(&m_ListAttrsVal,LPCTSTR(m_def_file_name),buf,false,true);
		break;
	case ID_MENU_COPY_CELL:
		if(pNMListView != 0)
		{
			if(pNMListView->iItem!=-1 && pNMListView->iSubItem!=-1)
			{
				buf = m_ListAttrsVal.GetItemText(pNMListView->iItem,pNMListView->iSubItem);
				apl_CopyStr2Clipboard(buf);
			}
		}
		break;
	case ID_MENU_COPY_STRING:
		if(pNMListView != 0)
		{
			if(pNMListView->iItem!=-1)
			{
				buf = _T("");
				for(i = 0;i<(int)	m_ListAttrsVal.GetColumnCount();i++)
				{
					if(i>0)buf += _T(";");
					buf += m_ListAttrsVal.GetItemText(pNMListView->iItem,i);
				}
				apl_CopyStr2Clipboard(buf);
			}
		}
		break;
	}
}
