// DlgErrRepeat.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "DlgErrRepeat.h"
#include "TransportSocketClient.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgErrRepeat dialog


CDlgErrRepeat::CDlgErrRepeat(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgErrRepeat::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgErrRepeat)
	m_ErrMess = _T("");
	m_DontAsk = FALSE;
	//}}AFX_DATA_INIT
}


void CDlgErrRepeat::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgErrRepeat)
	DDX_Control(pDX, IDC_REPEAT, m_BtnRepeat);
	DDX_Text(pDX, IDC_ERROR_MESS, m_ErrMess);
	DDX_Check(pDX, IDC_CHECK_DONT_ASK, m_DontAsk);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgErrRepeat, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDlgErrRepeat)
	ON_BN_CLICKED(IDC_REPEAT, OnRepeat)
	ON_WM_TIMER()
	ON_WM_CANCELMODE()
	ON_BN_CLICKED(IDSTOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgErrRepeat message handlers
BOOL CDlgErrRepeat::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	// TODO: Add extra initialization here
	if(m_timer_auto_repeat>0){
		SetTimer(ID_REPEAT_TIMER,1000,0);
		//OnTimer(ID_REPEAT_TIMER);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgErrRepeat::OnRepeat() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	KillTimer(ID_REPEAT_TIMER);
	EndDialog(ID_REPEAT);
}

void CDlgErrRepeat::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	if(nIDEvent==ID_REPEAT_TIMER){
		m_timer_auto_repeat--;
		if(m_timer_auto_repeat== 0){
			OnRepeat();
			return;
		}
		CString str;
		str.Format( APL_T("   %i "),m_timer_auto_repeat);
		m_BtnRepeat.SetWindowText(str);
	}
	
	CaplTranslateDialog::OnTimer(nIDEvent);
}


void CDlgErrRepeat::OnCancel() 
{
	// TODO: Add extra cleanup here
	KillTimer(ID_REPEAT_TIMER);
	CaplTranslateDialog::OnCancel();
}

void CDlgErrRepeat::OnStop() 
{
	// TODO: Add your control notification handler code here
	KillTimer(ID_REPEAT_TIMER);
	CString str;
	str.Format( APL_T(""));
	m_BtnRepeat.SetWindowText(str);
	CaplTranslateDialog::EndDialog(IDSTOP);
	
}
