// DlgReconnect.cpp : implementation file
//

#include "stdafx.h"
#include "DlgReconnect.h"
#include "TransportSocketClient.h"

// CDlgReconnect dialog

IMPLEMENT_DYNAMIC(CDlgReconnect, CaplTranslateDialog)

CDlgReconnect::CDlgReconnect(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgReconnect::IDD, pParent)
	, m_Text(_T(""))
{
	m_transport = 0;
}

CDlgReconnect::~CDlgReconnect()
{
}

void CDlgReconnect::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_TEXT, m_Text);
	DDX_Control(pDX, IDC_BTN_RECONNECT, m_BtnReconnect);
	DDX_Control(pDX, ID_CANCEL, m_BtnCancel);
}


BEGIN_MESSAGE_MAP(CDlgReconnect, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_BTN_RECONNECT, &CDlgReconnect::OnBnClickedBtnReconnect)
	ON_BN_CLICKED(ID_CANCEL, &CDlgReconnect::OnBnClickedCancel)
	ON_STN_CLICKED(IDC_TEXT, &CDlgReconnect::OnStnClickedText)
END_MESSAGE_MAP()


// CDlgReconnect message handlers

BOOL CDlgReconnect::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(m_transport== 0) return FALSE;

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgReconnect::MakeText(CString text)
{
	m_Text=text;
	//UpdateData(FALSE);
}
void CDlgReconnect::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	EnableButtons(FALSE);
	EndDialog(-1);

}

void CDlgReconnect::EnableButtons(BOOL bEnable)
{
	m_BtnReconnect.EnableWindow(bEnable);
	m_BtnCancel.EnableWindow(bEnable);
}

void CDlgReconnect::OnBnClickedBtnReconnect()
{
	// TODO: Add your control notification handler code here

	m_transport->m_dlg_reconnect = 0;
	EnableButtons(FALSE);
	if(m_transport->ForceReconnect())
	{
		EndDialog(0);
		AfxMessageBox( APL_T("  !"),MB_OK);
	}
	else
	{
		m_transport->m_dlg_reconnect=this;
		AfxMessageBox( APL_T("   .\n ,    "),MB_ICONERROR);
		EnableButtons(TRUE);
	}
}


void CDlgReconnect::OnStnClickedText()
{
	// TODO: Add your control notification handler code here
	if(	(GetKeyState(VK_LMENU) & 0xff00) != 0)
	{
		CString str;
		str.Format( APL_T("!!! (id  %i)"), GetCurrentProcessId());
		SetWindowText(str);
	}
}
