// DlgTuneConnection.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include <aplSocketTransport.h>

#include "DlgTuneConnection.h"
#include "TransportSocketClient.h"
#include "aplNetStepData.h"
#include "DlgSelectBase.h"
#include "ErrMessCl.h" 

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgTuneConnection dialog


CDlgTuneConnection::CDlgTuneConnection(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CDlgTuneConnection::IDD, pParent)
	, m_StrProxyName(_T(""))
	, m_StrProxyPort(_T(""))
{
	//{{AFX_DATA_INIT(CDlgTuneConnection)
	m_BaseName = _T("");
	m_CompName = _T("localhost");
	m_DefUserName = _T("");
	m_ChkPortDef = FALSE;
	m_PortEdit = DEF_PORT_NUM;
	m_NameConnect = _T("");
	m_Protocol = 0;
	m_Proxy = _T("");
	//}}AFX_DATA_INIT

	m_bReadOnly=false;

}


void CDlgTuneConnection::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgTuneConnection)
	DDX_Control(pDX, IDC_STATIC_PORT, m_StaticPort);
	DDX_Control(pDX, IDC_STATIC_NAME, m_StaticName);
	DDX_Control(pDX, IDC_STATIC_DEF_USER, m_StaticDefUser);
	DDX_Control(pDX, IDC_STATIC_COMP, m_StaticComp);
	DDX_Control(pDX, IDC_STATIC_BD, m_StaticBD);
	DDX_Control(pDX, IDC_STATIC_PROTOCOL, m_StaticProtocol);
	DDX_Control(pDX, IDC_STATIC_PROXY, m_StaticProxy);
	DDX_Control(pDX, IDC_PORT_DEF, m_CtrlPortDef);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDC_PORT_EDIT, m_CtrlPortEdit);
	DDX_Control(pDX, IDC_COMBO_PROTOCOL, m_CtrlProtocol);
	DDX_Control(pDX, IDC_COMBO_PROXY, m_CtrlProxy);
	DDX_Text(pDX, IDC_BASENAME_EDIT, m_BaseName);
	DDX_Text(pDX, IDC_COMP_NAME_EDIT, m_CompName);
	DDX_Text(pDX, IDC_DEFUSERNAME_EDIT, m_DefUserName);
	DDX_Check(pDX, IDC_PORT_DEF, m_ChkPortDef);
	DDX_Text(pDX, IDC_PORT_EDIT, m_PortEdit);
	DDV_MinMaxInt(pDX, m_PortEdit, 0, 65536);
	DDX_Text(pDX, IDC_NAME_CONNECT, m_NameConnect);
	//}}AFX_DATA_MAP
	DDX_CBIndex(pDX, IDC_COMBO_PROTOCOL, m_Protocol);
	DDX_Control(pDX, IDC_PROXY_NAME, m_CtrlProxyName);
	DDX_Text(pDX, IDC_PROXY_NAME, m_StrProxyName);
	DDX_Control(pDX, IDC_PROXY_PORT, m_CtrlProxyPort);
	DDX_Text(pDX, IDC_PROXY_PORT, m_StrProxyPort);
	DDX_Control(pDX, IDC_NAME_CONNECT, m_NameConnectCtrl);
	DDX_Control(pDX, IDC_COMP_NAME_EDIT, m_CompNameCtrl);
	DDX_Control(pDX, IDC_BASENAME_EDIT, m_BaseNameCtrl);
	DDX_Control(pDX, IDC_DEFUSERNAME_EDIT, m_DefUserNameCtrl);
	DDX_Control(pDX, IDC_COMP_SELECT, m_CompSelectBtn);
	DDX_Control(pDX, IDC_BASENAME_SELECT, m_BaseNameSelectBtn);
}


BEGIN_MESSAGE_MAP(CDlgTuneConnection, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CDlgTuneConnection)
	ON_BN_CLICKED(IDC_COMP_SELECT, OnCompSelect)
	ON_BN_CLICKED(IDC_PORT_DEF, OnPortDef)
	ON_BN_CLICKED(IDC_BASENAME_SELECT, OnBasenameSelect)
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(IDC_COMBO_PROTOCOL, &CDlgTuneConnection::OnCbnSelchangeComboProtocol)
	ON_CBN_SELCHANGE(IDC_COMBO_PROXY, OnPortDef)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgTuneConnection message handlers

void CDlgTuneConnection::OnCompSelect() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	LPITEMIDLIST selected_d = 0;
	UpdateData(TRUE);	

	CString newComp =  aplSelectComputer(this->m_hWnd, 0);
	if(!newComp.IsEmpty())
		m_CompName=newComp;

	UpdateData(FALSE);	
}

void CDlgTuneConnection::OnPortDef() 
{
	// TODO: Add your control notification handler code here
	BOOL hide_user_proxy;
	hide_user_proxy = (m_CtrlProxy.GetCurSel()==2)?FALSE:TRUE;
	UpdateData(TRUE);	
	m_CtrlPortEdit.SetReadOnly(m_ChkPortDef);
	m_CtrlProxyName.SetReadOnly(hide_user_proxy);
	m_CtrlProxyPort.SetReadOnly(hide_user_proxy);
	UpdateData(FALSE);	
}


void CDlgTuneConnection::OnBasenameSelect() 
{
	int i = 0;
	// TODO: Add your control notification handler code here
	if(m_data== 0)return;
	UpdateData(TRUE);	

	CStringArray BaseList;

	if(m_ChkPortDef){
		m_PortEdit=DEF_PORT_NUM;
	}

// 	m_data->SetParentWnd(this);

	if(!m_data->NET_GetListDb(m_CompName, m_PortEdit, m_Protocol, m_Proxy, BaseList))
	{
		return;
	}

	int num_base = 0;

	for(int i = 0;i<BaseList.GetSize();i++)
	{
		if(m_BaseName.CompareNoCase(BaseList[i]) == 0)
		{
			//   ,    (    )
			num_base = i;
		}
	}

	CDlgSelectBase dlg(this);
	// dlg.m_lang_england=m_data->m_lang_england; -    .       CaplTranslate.
	dlg.m_BaseList=&BaseList;
	dlg.m_num_base_ext=num_base;
	int res=dlg.DoModal();
	if(res==IDOK)
	{
		num_base=dlg.m_num_base;
		if(num_base!=-1)
		{
			m_BaseName=BaseList[num_base];
		}
		else
		{
			m_BaseName = _T("");
		}
	}
	if(m_NameConnect == _T("") && m_BaseName != _T(""))
	{
		m_NameConnect=m_BaseName;
		if(m_CompName!=_T("localhost") && m_CompName!=_T("127.0.0.1"))
		{
			m_NameConnect += _T(" ");
			m_NameConnect += APL_T("");
			m_NameConnect += _T(" ");
			m_NameConnect += m_CompName;
			/* -    .       CaplTranslate.
			if(m_data->m_lang_england)
			{
				m_NameConnect+=_T(" on ")+m_CompName;
			}
			else
			{
				m_NameConnect+= APL_T("  ")+m_CompName;
			}*/
		}
	}
	UpdateData(FALSE);	
}

BOOL CDlgTuneConnection::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	int pos_new = -1;
	
	// TODO: Add extra initialization here
	m_ChkPortDef=m_PortEdit==DEF_PORT_NUM;

	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));m_BtnCancel.SetFlat(FALSE);

	m_CtrlProxy.AddString( PROXY_TEXT__USE_DIRECT);
	m_CtrlProxy.AddString( PROXY_TEXT__USE_IE);
	m_CtrlProxy.AddString( PROXY_TEXT__USER_PROXY);
	m_CtrlProtocol.AddString(_T("PSS Protocol"));
	m_CtrlProtocol.AddString(_T("HTTP"));
	/* -    .       CaplTranslate.
	if(m_data->m_lang_england)
	{
		SetWindowText(_T("Tune connection parametres"));
		m_BtnCancel.SetWindowText(_T("Cancel"));
		m_StaticPort.SetWindowText(_T("Port:"));
		m_StaticName.SetWindowText(_T("Connection name:"));
		m_StaticDefUser.SetWindowText(_T("Defaul username:"));
		m_StaticComp.SetWindowText(_T("Server name:"));
		m_StaticBD.SetWindowText(_T("Database name:"));
		m_CtrlPortDef.SetWindowText(_T("Default port (7239)"));
		m_StaticProtocol.SetWindowText(_T("Protocol"));
		m_StaticProxy.SetWindowText(_T("Proxy server"));
		
		m_CtrlProxy.AddString(_T("Not used"));
		m_CtrlProxy.AddString(_T("From Internet Explorer"));
		m_CtrlProxy.AddString(_T("User's proxy"));
		m_CtrlProtocol.AddString(_T("PSS Protocol"));
		m_CtrlProtocol.AddString(_T("HTTP"));
	}
	else
	{
		m_CtrlProxy.AddString( PROXY_TEXT__USE_DIRECT);
		m_CtrlProxy.AddString( PROXY_TEXT__USE_IE);
		m_CtrlProxy.AddString( PROXY_TEXT__USER_PROXY);
		m_CtrlProtocol.AddString(_T("PSS Protocol"));
		m_CtrlProtocol.AddString(_T("HTTP"));
	}*/

	
	//m_data->ReadLastProxyList(m_proxy_list);

	if(m_Protocol== 0)
	{
		m_CtrlProtocol.SetCurSel(0);
		m_CtrlProxy.SetCurSel(0);
		m_CtrlProxy.EnableWindow(FALSE);
	}
	else
	{
		m_CtrlProtocol.SetCurSel(1);
		m_CtrlProxy.EnableWindow(TRUE);
		if(m_Proxy==_T("DIRECT"))
		{
			m_CtrlProxy.SetCurSel(0);
		}
		else if(m_Proxy == _T("") || m_Proxy==_T("IE"))
		{
			m_CtrlProxy.SetCurSel(1);
		}
		else
		{
			m_CtrlProxy.SetCurSel(2);
			m_CtrlProxyName.EnableWindow(TRUE);
			m_CtrlProxyPort.EnableWindow(TRUE);

			int pos_comma = m_Proxy.Find(_T(":"));
			if(pos_comma==-1)
			{
				m_StrProxyName = _T("");
				m_StrProxyPort = _T("");
			}
			else
			{
				m_StrProxyName = m_Proxy.Left(pos_comma);
				m_StrProxyPort = m_Proxy.Mid(pos_comma+1);
			}
		}
	}

//	int i;
// 	for(i = 0;i<m_proxy_list.GetSize();i++)
// 	{
// 		if(m_proxy_list.GetAt(i)!=m_Proxy)
// 		{
// 			pos_new = m_CtrlProxy.AddString(m_proxy_list.GetAt(i));
// 		}
// 	}

	UpdateData(FALSE);	
	OnPortDef();

	if(m_bReadOnly)
	{
		m_BtnOk.EnableWindow(FALSE);
		m_NameConnectCtrl.SetReadOnly(TRUE);
		m_CompNameCtrl.SetReadOnly(TRUE);
		m_CtrlPortEdit.SetReadOnly(TRUE);
		m_CtrlPortDef.EnableWindow(FALSE);
		m_BaseNameCtrl.SetReadOnly(TRUE);
		m_DefUserNameCtrl.SetReadOnly(TRUE);
		m_CompSelectBtn.EnableWindow(FALSE);
		m_BaseNameSelectBtn.EnableWindow(FALSE);

		m_CtrlProtocol.EnableWindow(FALSE);
		m_CtrlProxy.EnableWindow(FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgTuneConnection::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);
	CString err_mess;
	if(!IsNameCorrect(m_NameConnect, err_mess, false))
	{
		AfxMessageBox(err_mess);
		return;
	}
	if(!IsNameCorrect(m_BaseName, err_mess, true))
	{
		AfxMessageBox(err_mess);
		return;
	}

	if(m_missed_names != 0)
	{
		for(int i = 0;i<m_missed_names->GetSize();i++)
		{
			if(m_NameConnect==m_missed_names->GetAt(i))
			{
				MessageBox( APL_T("     !"), APL_T("!"),MB_OK|MB_ICONEXCLAMATION);
				return;
			}
		}
	}

	if(m_ChkPortDef)
		m_PortEdit=DEF_PORT_NUM;
	if(m_CtrlProxy.GetCurSel()== 0)
	{
		m_Proxy = _T("DIRECT");
	}
	else if(m_CtrlProxy.GetCurSel()==1)
	{
		m_Proxy = _T("IE");
	}
	else
	{
		if(m_StrProxyName.Find(_T('/'))!=-1)
		{
			MessageBox( APL_T("      \'/\' ( )!"), APL_T("!"),MB_OK|MB_ICONEXCLAMATION);
			return;
		}
		if(_atoi(m_StrProxyPort)== 0)
		{
			MessageBox( APL_T("    !"), APL_T("!"),MB_OK|MB_ICONEXCLAMATION);
			return;
		}

		m_Proxy = m_StrProxyName + _T(":") + m_StrProxyPort;
	}

	UpdateData(FALSE);	

// 	m_data->WriteLastProxyList(m_proxy_list);


	CaplTranslateDialog::OnOK();
}


void CDlgTuneConnection::OnCbnSelchangeComboProtocol()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	if(m_Protocol== 0)
	{
		m_CtrlProxy.EnableWindow(FALSE);
		m_CtrlProxy.SetCurSel(0);
	}
	else
	{
		m_CtrlProxy.EnableWindow(TRUE);
	}
	OnPortDef();
}

