/*****************************************************************\
            Author:  .
              Date: 
              
              File: MiddleWare.h
   Version of file: 0.10
           Progect: AplNetTransportServTCP
Version of project: 3.0
              
             Notes:    ,   
		 ,     AplBaseOperation 
		 AplTransport   ,   
              
\******************************************************************/
#ifndef APL_NET_H
#define APL_NET_H

#include "aplAggr.h"

#define MAX_STR_LEN 4096

// ,  
enum AplNetErrors{
	APL_NET_OK					=  0,
	APL_NET_SRV_MISSED_CONFIG	=100,	//
	APL_NET_SRV_MISSED_DATA		=101,	//
	APL_NET_SRV_UNKNOWN_USER	=102,	//
	APL_NET_SRV_NOT_CONNECT		=103,	//
	APL_NET_SRV_USER_ALREADY_CONNECTED =104,
	APL_NET_SRV_USER_IS_ACTIVE	=105,
	APL_NET_SRV_ERROR_PROCESSED	=106,	//
	APL_NET_SRV_MISSED_NAME_BASE	=107,	//
	APL_NET_SRV_CORRUPTED_BASE  =108,
	APL_NET_SRV_UNKNOWN_ERROR	=109,	//
	APL_NET_SRV_SMALL_BUF		=110,	//
	APL_NET_SRV_BLOB_BUSY		=111,	//
	APL_NET_SRV_BLOB_NOT_FOUND	=112,
	APL_NET_SRV_BLOB_NOT_DEFINE	=113,
	APL_NET_SRV_NOT_UNIQUE	    =114,
	APL_NET_SRV_ORACLE_ERROR    =115,
	APL_NET_SRV_LIMIT_CONNECT_EXESS =116,
	APL_NET_SRV_BREAK =117,
	
	APL_NET_SRV_MISSED_PROTECTED_CODE		=118,
	APL_NET_SRV_ORACLE_NAVAIL    =119,
	APL_NET_SRV_MISSED_BASE_VERSION    =120,
//	APL_NET_SRV_AGGR_TOO_MUCH_LONG	=121, -    
	APL_NET_SRV_STRING_TOO_MUCH_LONG	=122,
	APL_NET_SRV_TEMPORARY_BUF_CORRUPTED	=123,
	APL_NET_SRV_MISSED_ATTR_VAL_TYPE	=124,
	APL_NET_SRV_ACCESS_DENY		=125,
	APL_NET_SRV_SET_ACCESS_ERROR		=126,
	APL_NET_SRV_MISSED_BUF_FORMAT		=127,
	APL_NET_SRV_QUERY_PARSE_ERROR		=128,
	APL_NET_SRV_ILLEGAL_ATTR_TYPE		=129,
	APL_NET_SRV_MISSED_OBJECT			=130,
	APL_NET_SRV_CORRUPTED_ACLST			=131,
	APL_NET_SRV_USER_DISABLED			=132,	//
	APL_NET_SRV_CLIENT_NOT_FOUND		=133,	//
	APL_NET_SRV_USER_READ_ONLY			=134,	//
	
	APL_NET_SRV_SINGLE_CONNECT_DB	    =  135,
	APL_NET_SRV_SINGLE_CONNECT_LITE_D	=  136,
	APL_NET_SRV_SINGLE_CONNECT_LITE_SRV	=  137,
	APL_NET_SRV_FUNCTION_ONLY_DB	=  138,
	APL_NET_SRV_LOAD_DONT_EXECUTABLE	=  139,
	APL_NET_SRV_EXPIRE_SRC_LIC_D		=  140,
	

	//   res
	APL_NET_BO_SRV_MISSED_DATA		=141,	//
	APL_NET_BO_SRV_NOT_CONNECT		=142,	//
	APL_NET_BO_SRV_ERROR_PROCESSED	=143,	//
	APL_NET_BO_SRV_SERVER_LOCKED	=144,	//
	APL_NET_BO_SRV_TOO_MANY_SERVER	=145,	//
	APL_NET_BO_ERROR_CREATE_BASE	=146,
	APL_NET_BO_BASE_LIST_EMPTY		=147,

	APL_NET_SRV_EXPIRE_SRC_LIC_SRV		=  148,
	APL_NET_SRV_EXPIRE_KEY_IN_SRV_LIC_EXCLUSIVE	=  149,

	APL_SOCK_MISSED_VERSION			=150,
	APL_SOCK_MISSED_COMMAND			=151,
	APL_SOCK_MISSED_FUNCTION		=152,
	APL_SOCK_MISSED_FUNCT_PARAM		=153,
	APL_SOCK_FUNCTION_OBSOLETTE		=154,

	APL_NET_SRV_EXPIRE_KEY_IN_SRV_LIC_BREAK	=  155,
	APL_NET_SRV_MISSED_LAST_ACTION	=  156,
	APL_NET_SRV_MISSED_CLIENTS_SQL	=  157,
	APL_NET_SRV_DICT_NOT_FOUND		=  158,
	APL_NET_SRV_DICT_NOT_INI		=  159,

	APL_SOCK_ERROR_PROCESSED		=160,
	APL_SOCK_CONNECT_FAULT			=161,
	APL_SOCK_OPERATION_IN_PROGRESS	=162,
	APL_NET_SRV_MISSED_VERSION_SRV_LIC	=  163,
	APL_NET_SRV_CORRUPTED_ORA_BD	=  164,
	APL_NET_SRV_USER_BD_DONT_ADMIN	=  165,
	APL_NET_SRV_IP_BLOCKED	=  166,
	
	APL_NET_SRV_APPROACH_EXPIRE_SRC_LIC_SRV		=  167,
	APL_NET_SRV_INCOMPATIBLE_ORA_CLIENT		=  168,

	APL_NET_SRV_OS_USER_NOT_ADMIN		=  169,
	APL_NET_SRV_MISSED_KEY_IN_SRV_LIC	=  170,
	APL_NET_SRV_INST_LOCKED		=  171,
	APL_NET_SRV_INCOMPATIBLE_ORA_SERVER	= 172,

	APL_NET_SRV_EMPTY_PWD_DENIED	=  173,
	APL_NET_SRV_AD_SERVER_NOT_DEFINED	=  174,
	APL_NET_SRV_UNKNOWN_AD_USER	=175,	//
	APL_NET_SRV_AD_USER_CREATE_ERROR	=176,	//
	APL_NET_SRV_MISSED_LOAD_QUERY = 177, //    LoadEx
	APL_NET_SRV_INCOMPATIBLE_PG_CLIENT = 178,
	APL_NET_SRV_INCOMPATIBLE_PG_SERVER = 179,
	APL_NET_SRV_POSTGRES_ERROR = 180, 
	APL_NET_SRV_POSTGRES_NAVAIL = 181, 
	APL_NET_SRV_CORRUPTED_PG_BD =  182,
	APL_NET_SRV_SAFETY_EVENT	=  183,
	APL_NET_SRV_ERROR_INTEGRITY_CONTROL	=  184,
	APL_NET_SRV_PARALLES_SESSION_EXCEEDED	=  185,
	APL_NET_SRV_SQL_DISABLES	=  186,
	APL_NET_SRV_ADMIN_MODE_DISABLES	=  187,
	APL_NET_SRV_KERBEROS_ERROR	=  188,
	APL_NET_SRV_UNKNOWN_KERBEROS_USER	=189,	//
	APL_NET_SRV_INTERNAL_AUTH_DENY	=  190,
	APL_NET_SRV_INTERNAL_AUTH_NET_DENY	=  191,
	APL_NET_SRV_EXTERNAL_AUTH_ERROR	=  192,
	APL_NET_SRV_NEED_TO_UPDATE_THE_CLIENT	=  193,
	APL_NET_SRV_HASH_METHOD_CHANGED			=194,	//    Qt
	APL_NET_SRV_INTERNAL_ACCESS_MANAGEMENT_DENY	=  195,	//    Qt
	APL_NET_SRV_EXTERNAL_ACCESS_MANAGEMENT_ERROR	=  196,	//    Qt
	APL_NET_SRV_DICTIONARY_NEEDS_TO_BE_UPDATED = 197,
	APL_NET_SRV_SQL_TURNED_OFF	=  198,
	APL_NET_SRV_ADMIN_MODE_TURNED_OFF	=  199,
	//   200  250 .      ,    

	APL_NET_SRV_FEATURE_IS_DISABLED = 251,

	////////////////////////////////////////////////////////
	//   500  
	// ,  

	APL_NET_CLI_USER_APPLICATION_ERRORS	= 500,

	APL_NET_CLI_MISSED_DATA				= 501,
	APL_NET_CLI_MISSED_DATA_FROM_SERVER	= 502,
	APL_NET_CLI_NOT_CONNECT				= 503,
	APL_NET_CLI_ALREADY_CONNECT			= 504,
	APL_NET_CLI_ERROR_PROCESSED			= 505,
	APL_NET_CLI_FNF						= 506,
	APL_NET_CLI_FNCREATE				= 507,
	APL_NET_CLI_NET_ERROR				= 508,
	APL_NET_CLI_LIST_OF_BASE_EMPTY		= 509,
	APL_NET_CLI_MISSED_ATTR_TYPE		= 510,
	APL_NET_CLI_MISSED_CONNECTION_REC	= 511,
	APL_NET_CLI_QUERY_BUF_FULL			= 512,
	APL_NET_CLI_BREAK					= 513,
	APL_NET_CLI_ERROR_REESTR			= 514,
	APL_NET_CLI_FILE_BIG				= 515,
	APL_NET_CLI_LOCAL_SERV_NOT_FOUND	= 516,
	APL_NET_CLI_MISSED_CONNECT_PARAM_USERNAME	= 517,
	APL_NET_CLI_MISSED_CONNECT_PARAM_CONNECTION	= 518,
	APL_NET_CLI_MISSED_ENCODING			= 519,
	APL_NET_CLI_MISSED_DLG_IN_HIDE_MODE	= 520,
	APL_NET_CLI_EXTERNAL_AUTH_ERROR		= 521,
	APL_NET_CLI_KERBEROS_ERROR			= 522,
	APL_NET_CLI_ACCESS_DENY				= 523,
	APL_NET_CLI_SERVER_DN_SUPPORT_FUNCTION	= 524,
	APL_NET_CLI_DNS_ERROR				= 525,

	////////////////////////////////////////////////////////


	//  CaplData - ,      
	//APLAPIERR_NOERROR 	 = 0
	//APLAPIERR_BADINPUTDATA 1
	APL_NET_SRV_APLAPIERR_NODATA 				=52,
	APL_NET_SRV_APLAPIERR_BADTYPE 				=53,
	APL_NET_SRV_APLAPIERR_FILE_IO 				=54,
	APL_NET_SRV_APLAPIERR_BADDICTIONARY 		=55,
	APL_NET_SRV_APLAPIERR_BADENT 				=56,
	APL_NET_SRV_APLAPIERR_BADATTR 				=57,
	APL_NET_SRV_APLAPIERR_BADDATA 				=58,
	APL_NET_SRV_APLAPIERR_ATTRNSET 				=59,
	APL_NET_SRV_APLAPIERR_BADFILENAME 			=60,
	APL_NET_SRV_APLAPIERR_BADINSTANCE 			=61,
	APL_NET_SRV_APLAPIERR_BADINSTANCETYPE 		=62,
	APL_NET_SRV_APLAPIERR_BADSCHEMANAME 		=63,
	APL_NET_SRV_APLAPIERR_NOACCESSRIGHT 		=64,
	APL_NET_SRV_APLAPIERR_BADDICTVERSION		=65,
	APL_NET_SRV_APLAPIERR_INVALIDDATAFORMAT		=66,
	APL_NET_SRV_APLAPIERR_INCOMPATIBLEDICT 		=67,
	APL_NET_SRV_APLAPIERR_FICTIVE_DATA 			=68,
	APL_NET_SRV_APLAPIERR_QUERY_ERROR 			=69,
	APL_NET_SRV_APLAPIERR_DICT_FILE_NOT_OPEN 	=70,
	APL_NET_SRV_APLAPIERR_BADDATA_INVALID_ENTINY_ID =71,
	APL_NET_SRV_APLAPIERR_BADDATA_INVALID_ATTR_ID 	=72,
	APL_NET_SRV_APLAPIERR_FILE_BD_NOT_FOUND		=73,
	APL_NET_SRV_APLAPIERR_FILE_BD_READ_ONLY		=74,
	APL_NET_SRV_APLAPIERR_MODE_READ_ONLY		=75,
	APL_NET_SRV_APLAPIERR_INCOMPATIBLDATAFORMAT	=76,
	APL_NET_SRV_APLAPIERR_OUT_OF_MEMORY			=77,
	APL_NET_SRV_APLAPIERR_UNKNOWN_EXEPTION		=78
	
};


/****************************************************************************/
/* .    .
/* ,   
/****************************************************************************/
#define apl_LT_DEF_TYPE		0 /**<  "PSS".   )*/
#define apl_LT_TYPE_1		1 /**<  "ILS"*/
#define apl_LT_TYPE_X		12 /**  .     )*/


/****************************************************************************/
/*    LoadQuery   Load
/****************************************************************************/
// 
struct apl_NET_LoadQuery
{
	apl_NET_LoadQuery(UINT32 _id = 0, char _type = 0, UINT32 _inst_or_id = 0, UINT32 _ent_id = 0, UINT32 _attr_id = 0, bool _in_result=true, bool _load_all_attr = false)
	{
		id=_id; type=_type; inst_or_id=_inst_or_id; ent_id=_ent_id; attr_id=_attr_id; in_result=_in_result; load_all_attr=_load_all_attr;
	};
	void Set(apl_NET_LoadQuery* src)
	{
		if(src== 0){return;} 
		id=src->id; type=src->type; inst_or_id=src->inst_or_id; ent_id=src->ent_id; attr_id=src->attr_id; in_result=src->in_result; load_all_attr=src->load_all_attr;
	};
	void Set(apl_NET_LoadQuery& src)
	{
		id=src.id; type=src.type; inst_or_id=src.inst_or_id; ent_id=src.ent_id; attr_id=src.attr_id; in_result=src.in_result; load_all_attr=src.load_all_attr;
	};
	
	UINT32 id;   		//  
	char type; 			//   
	
// :
// "a" -     
// "e" -    
// "i" -     
// "b" -   (FindInstanceUser)
// "d" -     . 
// "r" -     . 

	UINT32 inst_or_id;	//  instance  ;
	UINT32 ent_id;		//  entity ( )
	UINT32 attr_id; 	//  attribute;
	bool in_result;//     
	bool load_all_attr;//     
};

/****************************************************************************/
/*    AplBaseOperation  AplTransport
/*    ,  
/****************************************************************************/
enum FuctionCodes
{
	CAplBaseOperations__LoadListBase= 11,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *CountOfBuf, /*[out, size_is(*CountOfBuf)]*/ BYTE *Buf);
	CAplBaseOperations__QueryListBase= 12,   //(/*[in,out]*/ long *aplError,/*[out]*/ long *CountOfBuf);
	CAplBaseOperations__GetLicenseStatus= 13,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *ResultSize, /*[out, size_is(*ResultSize)]*/ BYTE *Result,/*[out]*/long *ServerCode);
//	CAplBaseOperations__GetNumConnectedUsers= 14,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *aplNum);
	CAplBaseOperations__LockServ= 15,   //(/*[in,out]*/ long *aplError);


	//     
	CAplTransport__DeleteIterator= 20,  // (/*[in,out]*/ long *aplError);
	//    
	CAplTransport__CloseIterator= 21,   //(/*[in,out]*/ long *aplError);
	//   ,   
	CAplTransport__ReadFromIterator= 22,  // (/*[in,out]*/ long *aplError,/*[in]*/ long *SizeDose, /*[out,size_is(SizeDose)]*/ BYTE *Dose,/*[out]*/ long *LastDose);
	//   ,   
	CAplTransport__WriteToIterator= 23,   //(/*[in,out]*/ long *aplError,/*[in]*/ long SizeDose,/*[in,size_is(SizeDose= ,   //]*/ BYTE *Dose,/*[in]*/ long LastDose);
	//        
	CAplTransport__CreateIterator= 24,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ long *SizeDose);
	//       
	CAplTransport__Connect= 25,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *size,/*[in,size_is(size)]*/ BYTE *LoginData);
	//           m_TempStor,    m_TempSize
	CAplTransport__Load= 26,   //(/*[in,out]*/ long *aplError,/*[in]*/ long Count, /*[in, size_is(Count)]*/ BYTE *Queries,/*[in,out]*/ long *ResultSize);
	//  ,   
	CAplTransport__QuerDelInst= 27,   //(long *aplError, long *ResultSize);

	CAplTransport__QuerSysTime= 28,   //(/*[in,out]*/ long *aplError,/*[out, size_is(8)]*/ BYTE *Result);
	CAplTransport__QuerActiveUserList= 29,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *ResultSize);
	
	//  ,   
	CAplTransport__LoadBuf= 30,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *ResultSize, /*[out, size_is(*ResultSize)]*/ BYTE *Result);
	//       
	CAplTransport__SaveChanges= 31,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *DataSize, /*[in, out, size_is(*DataSize)]*/ BYTE *Data);
	//    
	CAplTransport__Query= 32,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *QuerySize, /*[in, size_is(*QuerySize)]*/ BYTE *Query);
	//  
	CAplTransport__SetUsersAccess= 33,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufSize,/* [in,out, size_is(*BufSize)]*/ BYTE *Buf);
	//  
	CAplTransport__GetUsersAccess= 34,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufSize,/* [in,out, size_is(*BufSize)]*/ BYTE *Buf);
	//       
	CAplTransport__GetDictName= 35,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufNameSize, /*[in,out, size_is(*BufNameSize)]*/ BYTE *BufName,/*[in,out]*/ long *BufFilePathSize,/*[in,out, size_is(*BufFilePathSize)]*/ BYTE *BufFilePath);
	//,      
	CAplTransport__TestUniqueAttrValues= 36,
	//     
	CAplTransport__FindInstancesWithAttrValuesQuery= 37,
	//   
	CAplTransport__OperateIndexes = 38,
	// 
	CAplTransport__Test = 39,
	//        /  
	CAplTransport__LoadInstUserDataTimeInfo = 40,
	//   
	CAplTransport__Disconnect = 41,
	//    
	CAplTransport__QueryUsersLog = 42,
	//           m_TempStor,    m_TempSize
	CAplTransport__LoadEx= 43,
	//       ( ORACLE)  
	CAplTransport__WriteToLog= 44,
	//    -  
	CAplTransport__LoadBDInfo= 45,
	//  SQL-     -   (  ORACLE  Postgres)
	CAplTransport__ExecuteSQL= 46,
	//  SQL-     -   (  ORACLE  Postgres) 
	// (     ,   )
	CAplTransport__ExecuteSQLS= 47,
	//        -  
	CAplTransport__ConnectEx= 48,   
	//      
	CAplTransport__SaveBlob2Disk= 49,  
	//         
	CAplTransport__ReadBlobFromSrv= 50,   
	//     -  
	CAplTransport__QueryEx=51,
	//    
	CAplTransport__ClearUsersLog = 52,
	//    
	CAplTransport__StartAdminMode = 53,   
	//    
	CAplTransport__ExitAdminMode = 54,   
	//   
	CAplTransport__BeginLongOperation = 55,   
	//       
	CAplTransport__CopyAccessFromExt2Ext = 56,   
	//       
	CAplTransport__CopyAccessFromInst2Ext = 57,   
	//  SQL-     -   (  ORACLE  Postgres)( )
	CAplTransport__ExecuteSQLEx = 58,
	//     -  
	CAplTransport__QueryUsersLogEx = 59,
	//    
	CAplTransport__ServiceAccessPatterns = 60,
	//       -    
	CAplTransport__ServiceTestVersions = 61,
	//   -    
	CAplTransport__CreateMultiReadIterator= 62,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ long *SizeDose);
	//  -  
	CAplTransport__CloseMultiReadIterator= 63,   //(/*[in,out]*/ long *aplError);
	//   ,   -
	CAplTransport__ReadFromMultiReadIterator= 64,  // (/*[in,out]*/ long *aplError,/*[in]*/ long *SizeDose, /*[out,size_is(SizeDose)]*/ BYTE *Dose,/*[out]*/ long *LastDose);
	//   ,   - -   ,   
	//CAplTransport__Write2MultiReadIterator= 65,  // (/*[in,out]*/ long *aplError,/*[in]*/ long *SizeDose, /*[out,size_is(SizeDose)]*/ BYTE *Dose,/*[out]*/ long *LastDose);
	//  oracle -    ,       entity
	CAplTransport__LoadEntityTables = 66,  // 
	//  oracle -             
	CAplTransport__LoadOraAlias = 67,  // 
	//      ,   .   - 2  1)    2)    
	CAplTransport__Autoupdate_LoadListNamesFiles = 68,  // 
	//   -    
	CAplTransport__Autoupdate_CreateMultiReadIterator= 69,
	//  -  
	CAplTransport__Autoupdate_CloseMultiReadIterator= 70,
	//   ,   -
	CAplTransport__Autoupdate_ReadFromMultiReadIterator= 71,
	CAplTransport__QuerActiveUserListEx= 72,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *ResultSize);
	//      
	CAplTransport__GetUsersAccessBI = 73,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufSize,/* [in,out, size_is(*BufSize)]*/ BYTE *Buf);
	//     
	CAplTransport__SetUsersAccessBI = 74,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufSize,/* [in,out, size_is(*BufSize)]*/ BYTE *Buf);
	//   
	CAplTransport__GetAttrsHistory = 75,   //(/*[in,out]*/ long *aplError,/*[in,out]*/ long *BufSize,/* [in,out, size_is(*BufSize)]*/ BYTE *Buf);
	//      -  
	CAplTransport__DeleteIteratorEx = 76,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ long *SizeDose,int inst_id,int attr_id);
	//            
	CAplTransport__RunUpdateDictionary = 77,   
	//   ,     
	CAplTransport__GetAttrs4Blobs = 78,
	//    
	CAplTransport__RunApp = 79,
	//       
	CAplTransport__LockInstance = 80,
	//      
	CAplTransport__ServiceOp = 81,
	//          
	CAplTransport__GetAllAttrValues = 82,
	//       
	CAplTransport__GetString4DupSession = 83,
	//      ,   .   - 2  1)    2)    
	//   CAplTransport__Autoupdate_LoadListNamesFiles:
	//    
	//       
	//      "*.luf",     luf     ,  
	CAplTransport__Autoupdate_LoadListNamesFilesEx = 84,  // 
	
	//           ,       
	CAplTransport__ControlAccessDoc = 85,
	//     -   c     
	CAplTransport__QueryExS=86,
	//  SQL-     -   (  ORACLE  Postgres)( )
	// (     ,   )
	CAplTransport__ExecuteSQLExS = 87,
	//         -  64   
	CAplTransport__CreateIterator64 = 88,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ __int64 *SizeDose);
	//   -     -  64   
	CAplTransport__CreateMultiReadIterator64= 89,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ long *SizeDose);
	//          ( 64  )
	CAplTransport__ReadBlobFromSrv64= 90,   
	//      (       )
	CAplTransport__GetMaxBlobSize64= 91,   
	//         -   
	CAplTransport__CreateIteratorEx = 92,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ long *SizeDose,/*[in]*/ long SizeParams,/*[in,out,size_is(SizeNameFile)]*/ BYTE *Params);
	CAplTransport__CreateIteratorEx64 = 93,   //(/*[in,out]*/ long *aplError,/*[in]*/ long *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ long SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in]*/ __int64 *SizeDose,/*[in]*/ long SizeParams,/*[in,out,size_is(SizeNameFile)]*/ BYTE *Params);
	//  PG -      PG
	CAplTransport__LoadPGAlias = 94,  // 

	//  Qt -    -    
	CAplTransport__ServiceGetAuthParam = 95,
	//  Qt -          ( )   
	CAplTransport__LoadDomainUserInfo = 96,
	//  Qt -     
	CAplTransport__LoadDomainInfo = 97,
	//  Qt -      
	CAplTransport__Write2SafetyLog = 98,
	//  Qt -    ,             
	CAplTransport__ValidateStrings = 99,
	//  Qt -           
	CAplTransport__ValidateFilesHashes = 100,
	//        
	//         CAplTransport__ConnectEx!
	CAplTransport__AuthKerberos = 102,
	//    ,    
	CAplTransport__LoadDomainUsersFromGroupe = 103,
	//     
	CAplTransport__QuerySafetyLog = 104,
	//    
	CAplTransport__ClearSafetyLog = 105,
	//  ,      ( Qt)
	CAplTransport__LoadAccess4User = 106,
	//      
	CAplTransport__SessionPartsOperate = 107,
	//      
	CAplTransport__QueryServerVersion = 108 ,
	//    
	CAplTransport__LicOperate = 109,
	//     . (   Qt)
	CAplTransport__ClientParameters = 110,


	AplCommand = 0,

	AplCommandTestLive = 101,		//      
	
};

typedef enum{
	RPCError	=	1
} RPCCommands;

#define DEFAILT_ID_ADMIN_GROUP 3901
#define DEFAILT_ID_ADMIN_USER 3902

#define BEGIN_MAX_INST_NUM 4000

#define VERSION_OF_RPC_BUFFER 0x00000001
#define VERSION_OF_RPC_BUFFER_2 0x00000002
#define VERSION_OF_RPC_BUFFER_3 0x00000003
#define VERSION_OF_RPC_BUFFER_4 0x00000004


class CaplInstance;

/**             */
struct SUserLogInfo
{
	SUserLogInfo()
	{
		AUSId = 0;
		user = 0; user_id = 0; user_name.Empty(); ip_srv.Empty(); ver_srv.Empty(); ip_cli.Empty(); ip_cli_num = 0; ver_cli.Empty();
		date_login = 0; date_logout = 0; exit_status=-1; exe_name.Empty(); user_base4admin = 0; user_id_base4admin = 0; count_load = 0;
	}
	SUserLogInfo(SUserLogInfo* base)
	{
		AUSId=base->AUSId;
		user=base->user; user_id=base->user_id; user_name=base->user_name; ip_srv=base->ip_srv; ver_srv=base->ver_srv;
		ip_cli=base->ip_cli; ip_cli_num=base->ip_cli_num; ver_cli=base->ver_cli;
		date_login=base->date_login; date_logout=base->date_logout; exit_status=base->exit_status;
		exe_name=base->exe_name; user_base4admin=base->user_base4admin; user_id_base4admin=base->user_id_base4admin; count_load=base->count_load;
	}
	UINT32 AUSId;
	CaplInstance* user;
	UINT32 user_id;
	CString user_name;
	CString ip_srv;
	CString ver_srv;
	CString ip_cli;
	UINT32 ip_cli_num;
	CString ver_cli;
	DATE date_login;
	DATE date_logout;
	int exit_status;
	CString exe_name;
	CaplInstance* user_base4admin;
	UINT32 user_id_base4admin;
	__int64 count_load;
};

/**          /  , 
/  <B>instance</B>*/

struct SInstInfo
{
	SInstInfo(){inst = 0; create_user = 0; create_date = 0; update_user = 0; update_date = 0;}
	SInstInfo(CaplInstance* inst_def){inst=inst_def; create_user = 0; create_date = 0; update_user = 0; update_date = 0;}
	CaplInstance* inst;
	CaplInstance* create_user;
	DATE create_date;
	CaplInstance* update_user;
	DATE update_date;
};

//  ,     
struct SQAH_Filter
{
	SQAH_Filter()
	{
		AUSId = 0;
		user_id = 0;
		ent_id = 0;
		date_beg_1 = _T("");
		date_end_1 = _T("");
	}

	int AUSId;
	UINT32 user_id;
	UINT32 ent_id;
	CString date_beg_1;
	CString date_end_1;
};

/**           */
struct SQAH_Info
{
	SQAH_Info()
	{
		AUSId = 0; inst_id = 0; user_id = 0; attr_id = 0; update_date = 0;
		int_val_new = 0; int_val_old = 0; str_val_new.Empty(); str_val_old.Empty(); rea_val_new = 0; rea_val_old = 0;
		single_val = true;
	}
	SQAH_Info(SQAH_Info* base)
	{
		AUSId=base->AUSId; inst_id=base->inst_id; user_id=base->user_id; attr_id=base->attr_id; update_date=base->update_date;
		single_val=base->single_val;
		if(single_val)
		{
			val_new=base->val_new; val_old=base->val_old;
		}
		else
		{
			int_val_new=base->int_val_new; int_val_old=base->int_val_old;
			str_val_new=base->str_val_new; str_val_old=base->str_val_old;
			rea_val_new=base->rea_val_new; rea_val_old=base->rea_val_old;
		}
	}
	int AUSId;
	UINT32 inst_id;
	UINT32 user_id;
	UINT32 attr_id;
	DATE update_date;
	//       
	int int_val_new;
	int int_val_old;
	CString str_val_new;
	CString str_val_old;
	double rea_val_new;
	double rea_val_old;
	//   (  aplNOTYPE / null)
	CaplValue val_new;
	CaplValue val_old;
	bool single_val;
};

// -      
enum AuthExtendetBufCodes
{
	CEB_username = 1,		// ->:  
	CEB_pwd = 2,			// ->: 
	CEB_name_base = 3,		// ->:  
	CEB_client_ip = 4,		// ->: Ip-    
	CEB_client_id = 5,		// ->:   
							// ->:      
	CEB_user_id = 6,		// ->:   (instance_id   apl_user)
	CEB_type_license = 7,	// !!  CEB_type_license_str!! ->:     (,  )
	CEB_ver_srv = 8,		// ->:  
	CEB_type_srv = 9,		// ->:   (, Oracle, PostgreSQL)
	CEB_ver_cli = 10,		// ->:   
	CEB_exe_cli = 11,		// ->:    ( )
	CEB_can_find_in_blob = 12, 		// ->:      
	CEB_sec_code_1 = 13,	// ->: 
	CEB_sec_code_2 = 14,	// ->: 
	CEB_about = 15,			// ->:   ,       
	CEB_server_ses_id = 16,		// ->: Id     
	CEB_domain = 17,		// ->:  
	CEB_comp_name = 18,		// ->:   
	CEB_os_domain = 19,		// ->:     
	CEB_os_user = 20,		// ->:      ( ,   )
	CEB_name_con = 21,		// ->:  
	CEB_type_license_str = 22,	// ->:   ( Qt)(    )
	CEB_class_srv = 23,		// ->:   (MSVC32, Qt)
	CEB_client_id_s1 = 24,		// ->:    
	CEB_client_id_s2 = 25,		// ->:    
	CEB_id_base_sess = 26,	// ->:      
	CEB_build_srv = 27		// ->:     apl 
};

//   .     Qt
enum AuthParamCodes
{
	APC_GetSPN = 1,
	APC_GetExtAuthName = 2,
	APC_GetHashMethod = 3,
	APC_GetAccessDll = 4,
};


//   
//      !!!!!!
#define std_databuf_header "apl_step_data V 0.2\0x0"
//   c  
//      !
#define std_databuf_header_u "apl_step_data Vu0.2\0x0"

#define apl_step_format_mask "apl_step_data V"

#define std_databuf_ret_header "apl_step_data V 0.101\0x0"

#define std_access_list_header "apl_accesslist V 0.102\0x0"
#define std_access_list_header101 "apl_accesslist V 0.101\0x0"

#define std_test_find_header "apl_TestFindBuf V 0.104\0x0"
#define std_test_find_header2 "apl_TestFindBuf V 0.102\0x0"
#define std_test_find_header3 "apl_TestFindBuf V 0.103\0x0"

#define std_LoadInstUserDataTimeInfoQuery_header "apl_LoadInstUserDataTimeInfoQuery V 0.100\0x0"

#define std_LoadInstUserDataTimeInfoData_header "apl_LoadInstUserDataTimeInfoData V 0.101\0x0"

#define std_LoadBDParam_header "apl_LoadBDParam_header V 0.101\0x0"

#define std_ClientSQLQuery_header "apl_ClientSQLQuery_header V 0.102\0x0"
#define std_ClientSQLQuery_header_01 "apl_ClientSQLQuery_header V 0.101\0x0"

#define std_ClientSQLQueryEx_header "apl_ClientSQLQuery_headerEx V 0.103\0x0"
#define std_ClientSQLQueryEx_header_02 "apl_ClientSQLQuery_headerEx V 0.102\0x0"
#define std_ClientSQLQueryEx_header_01 "apl_ClientSQLQuery_headerEx V 0.101\0x0"

#define std_ClientSQLResult_header "apl_ClientSQLResult_header V 0.101\0x0"

// !!! ,        !
#define std_ExtendedBuf_header "apl_ExtendedBufHeader v0.1\0x0"

#define std_AuthExBuf_header "apl_AuthExBufHeader v0.1\0x0"

#define std_DCServisAccessPatterns_header "apl_DCServisAccessPatterns v0.001\0x0"

#define std_DCAttrsHistory_header_0001 "apl_DCAttrsHistory_header v0.001\0x0"
//  0.002    null
#define std_DCAttrsHistory_header "apl_DCAttrsHistory_header v0.002\0x0"

#define std_DCAttrs4Blob_header "apl_DCAttrs4Blob_header v0.001\0x0"

#define std_DCRunUpdateDictionary_header "apl_DCRunUpdateDictionary_header v0.001\0x0"

#define std_DCLockInstance_header "apl_DCLockInstance_header v0.001\0x0"

#define std_DCServiceOp_header "apl_DCServiceOp_header v0.001\0x0"

#define std_License_header "apl_License_header v0.002\0x0"
#define std_License_header_001 "apl_License_header v0.001\0x0"

#define std_GetAllAttrValues_in_header "std_GetAllAttrValues_in_header v0.01\0x0"

#define std_GetAllAttrValues_out_header "std_GetAllAttrValues_out_header v0.01\0x0"

//    -   ,     std_LoadUserLogInfo_header
#define std_QueryUsersLogFilter_001_h "apl_QueryUsersLogFilter v0.001\0x0"
#define std_QueryUsersLogFilter_002_h "apl_QueryUsersLogFilter v0.002\0x0"
#define std_QueryUsersLogFilter_004_h "apl_QueryUsersLogFilter v0.004\0x0"

//    -     
//       
#define std_LoadUserLogInfo_header104 "apl_UserLogInfoData V 0.104\0x0"
#define std_LoadUserLogInfo_header103 "apl_UserLogInfoData V 0.103\0x0"
#define std_LoadUserLogInfo_header102 "apl_UserLogInfoData V 0.102\0x0"
#define std_LoadUserLogInfo_header101 "apl_UserLogInfoData V 0.101\0x0"

//    ,        
#define ACTIVE_LIST_header_01	 "ACTIVE_LIST_header v0.1\0x0"
#define ACTIVE_LIST_header_02	 "ACTIVE_LIST_header v0.2\0x0"
#define ACTIVE_LIST_header_04	 "ACTIVE_LIST_header v0.4\0x0"
#define ACTIVE_LIST_header_05	 "ACTIVE_LIST_header v0.5\0x0"


//    
#define ACCESS_BUF_SET_header "Access bufer set v0.4"
//#define ACCESS_BUF_SET_header "Access bufer set v0.3"
#define ACCESS_BUF_SET_header_03 "Access bufer set v0.3"
#define ACCESS_BUF_SET_header_base "Access bufer set v"

#define ACCESS_BUF_GET_header "Access bufer get v0.2"
#define ACCESS_BUF_GET_header_01 "Access bufer get v0.1"
#define ACCESS_BUF_GET_header_base "Access bufer get v"

#define ACCESS_BUF_BI_header "Access bufer BI v0.1"
#define ACCESS_BUF_BI_header_base "Access bufer BI v"


#define LOAD_QUERY_BUF_header	  "Load query bufer v0.1\0x0"
#define LOAD_QUERY_BUF_header_2 "Load query bufer v0.2\0x0"
#define LOAD_QUERY_BUF_header_3 "Load query bufer v0.3\0x0"
#define CLIENT2SERVER_LOG_BUF_header "Client2Server log bufer v0.1\0x0"
#define CLIENT2SERVER_DOC_CONTR_header "Client2Server doc conytrol bufer v0.1\0x0"
//       EX
//#define FIND_BUF_HEADER_SET "FindEX bufer set v0.1"

#define LoadListNamesFiles_header		  "LoadListNamesFiles_header v0.1\0x0"

#define std_SessionPartsOperate_header "std_SessionPartsOperate_header v0.01\0x0"

#define std_LicOperate_header "std_LicOperate_header v0.01\0x0"

enum LicOperate
{
	LO_TestTake = 1,
	LO_Remove = 2
};


//          
enum BuffersCodes{
std_databuf = 0,
std_databuf_ret = 1,
std_access_list = 2,
std_test_find = 3,
std_LoadInstUserDataTimeInfoQuery = 4,
std_LoadInstUserDataTimeInfoData = 5,
std_LoadUserLogInfo = 6,
std_LoadBDParam = 7,
std_ClientSQLQuery = 8,
std_ClientSQLQueryEx = 9,
std_ClientSQLResult = 10,
std_ExtendedBuf = 11,
std_QueryUsersLogFilter = 12,
std_DCServisAccessPatterns = 13,
ACCESS_BUF_SET = 14,
ACCESS_BUF_GET = 15,
LOAD_QUERY_BUF = 16,
CLIENT2SERVER_LOG_BUF = 17,
ACCESS_BUF_BI =18,
std_DCAttrsHistory = 19,
std_DCAttrs4Blob = 20,
std_LicOperate = 21

};


#define QUL_F_AUSId			0
#define QUL_F_user			1
#define QUL_F_admin_user	2
#define QUL_F_date_beg_1	3
#define QUL_F_date_beg_2	4
#define QUL_F_date_end_1	5
#define QUL_F_date_end_2	6
#define QUL_F_status		7
#define QUL_F_ip_cli		8
#define QUL_F_ip_srv		9
#define QUL_F_ver_cli		10
#define QUL_F_ver_srv		11
#define QUL_F_time_connect	12
#define QUL_F_module_name	13
#define QUL_F_ent			14


	
#endif




