// TransportSocketClient.h: interface for the CtransportSocketClient class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRANSPORTSOCKETCLIENT_H__130138C3_0463_4571_836D_127B95B69339__INCLUDED_)
#define AFX_TRANSPORTSOCKETCLIENT_H__130138C3_0463_4571_836D_127B95B69339__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <aplSocketTransport.h>
#include <aplAggr.h>
#include "MiddleWare.h"
#include "DlgReconnect.h"

#define	FILL_SERVICE_TEST(param) \
	code=param; test_ver_buf.Add(&code,4); cs_buf=param##_header; size=cs_buf.GetLength()+1; test_ver_buf.Add(&size,4); test_ver_buf.Add((void*)(const char*)cs_buf, size);


#define SPEC_ERR_CODES(err_code) \
	err_code!=APL_NET_OK && \
	err_code!=APL_NET_SRV_SINGLE_CONNECT_DB && \
	err_code!=APL_NET_SRV_SINGLE_CONNECT_LITE_D && \
	err_code!=APL_NET_SRV_EXPIRE_SRC_LIC_D && \
	err_code!=APL_NET_SRV_EXPIRE_KEY_IN_SRV_LIC_EXCLUSIVE && \
	err_code!=APL_NET_SRV_MISSED_KEY_IN_SRV_LIC

#define APL_ERROR_CONDITION SPEC_ERR_CODES(aplError)

#define APL_ERROR_STOP_TIME 5000

#define DEF_PORT_NUM 7239

///////////////////////////////////////////////////////////
//      
//	#define REG_KEY "Software\\ CALS \" \"\\NetApi"
#define		REG_KEY _T("Software\\CALS Centre \"Applied Logistic\"\\NetApi\\Client")

#define PROXY_TEXT__USE_IE APL_T("  Internet Explorer")
#define PROXY_TEXT__USE_DIRECT APL_T("  ")
#define PROXY_TEXT__USER_PROXY APL_T(" ")


/****************************************************************************/
/*   (     )
/****************************************************************************/
struct apl_NET_LoginData
{
	apl_NET_LoginData(){Clear();}
	void Clear()
	{
		client_ip = 0; s1 = 0; s2 = 0; client_id = 0; user_id = 0; type_license = _T("");
		username=_T(""); domain=_T("") ;pwd=_T(""); name_base=_T("");
		/*isKerberos=false; isCurrDomainUser=false;*/sOsUser=_T("");name_connect=_T("");
	}
	///  
	CString username;
	/// 
	CString domain;
	///      (     Qt)
	CString pwd;
	///      
	CString name_base;
	/// IP- ,    
	UINT32 client_ip;
	//           (,   -)
	UINT32 s1;
	UINT32 s2;

	///   
	UINT32 client_id;
	///   ( id   apl_user)
	UINT32 user_id;
	///  
	CString type_license;
	/*	 ,       AD
	/// :   
	bool isKerberos;
	*/
	/// :      
	bool isCurrDomainUser;
	///    
	CString sOsUser;
	/// 	   
	CString name_connect;

};

class CaplNetStepData;
class CConnectInfo;

class CTransportSocketClient 
{
	friend CaplNetStepData;
public:
	CTransportSocketClient(CaplNetStepData* data);
	~CTransportSocketClient();
	void OnClose();
	
	// !!!   const char*        
	AplNetErrors TestParamIdent(CaplDataBuf &dbuf, FuctionCodes code, const char* _param_def);
	AplNetErrors TestParamIdent(CaplDataBuf &dbuf, FuctionCodes code, CaplTAggr<const char*, const char*, APLAGGR_LIST> &params, int &param);

	// !!!   const char*        
	bool FillStdHeader(CaplDataBuf &dbuf, FuctionCodes code, const char* _param_cur);

	//      m_source (  ,    NET_xx)
	inline void AddSource2Dbuf(CaplDataBuf &dbuf);

	//     ,   , 
	void ReadErrAdditionalBuf(CaplDataBuf &dbuf, CaplDataBuf &dbuf_add, AplNetErrors &aplError, BYTE &is_warning_data, BYTE &can_repeat);

	bool Call(CaplDataBuf &dbuf, CaplDataBuf *dbuf_ext, bool can_break=true, bool pause_wait_dlg=true, bool wait_answer=true, bool can_reconnect=true);

	bool ABO_DCQueryListBase(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_out);
	bool ABO_DCGetLicenseStatus(/*[in,out]*/ AplNetErrors &aplError, CString &status, /*[out]*/UINT32 *ServerCode);

	bool ABO_DCLockServ(/*[in,out]*/ AplNetErrors &aplError);
	
	//      
	bool AT_DCQueryServerVersion(/*[in,out]*/ AplNetErrors &aplError, CString *ver_srv, CString *type_srv, CString *ClassSrv, CString *build_date);

	//    API Kerberos  API ExternalAuthentication             API
	// Kerberos  ExternalAuthentication ;      Kerberos     API  
	//     
	bool DC_AuthExternal(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _domain);
	//     
	bool AT_DCAuthExternal(/*[out]*/ AplNetErrors &aplError, CaplDataBuf &dbuf_in, CaplDataBuf &dbuf_out);

	//       
	//bool AT_DCConnect(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ long *size, /*[in,size_is(size)]*/ apl_NET_LoginData *LoginData, bool *can_find_in_blob);
	bool AT_DCConnectEx(AplNetErrors &aplError, UINT32 *user_id = 0, CString *ver_srv = 0, CString *type_srv = 0, 
							UINT32 *ServerAUSessionId = 0, bool *can_find_in_blob = 0, CString *class_srv = 0);
	bool AT_DCDisconnect(/*[in,out]*/ AplNetErrors &aplError);

	bool AT_DCLicOperate(AplNetErrors &aplError, LicOperate command, CStringArray &listIn, CStringArray &listOut);

	bool AT_DCStartAdminMode(AplNetErrors &aplError, LPCTSTR username, LPCTSTR pwd, UINT32 *admin_id, int code1, int code2, LPCTSTR str_about);
	bool AT_DCExitAdminMode(AplNetErrors &aplError, UINT32 *user_id);
	bool AT_DCLoadEntityTables(AplNetErrors &aplError, CaplMap &Entity2Tabl);
	bool AT_DCGetOraAlias(AplNetErrors &aplError, LPCTSTR username, LPCTSTR pwd, int code1, int code2, CaplDataBuf &data_out);

	bool AT_DCSessionPartsOperate(AplNetErrors &aplError, CaplDataBuf &data_in, CaplDataBuf &data_out);
	
	bool AT_DCBeginLongOperation(AplNetErrors &aplError, UINT32 time_in_minuts);

	//           m_TempStor,    m_TempSize
	bool AT_DCLoad(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, 
											CaplDataBuf &data_out, CaplDataBuf *data_out2, __int64 *size_64_1);
	//  ,   
	bool AT_DCQuerDelInst(AplNetErrors &aplError, CaplDataBuf &data_out);
	//     
	bool AT_DCServiceAccessPatterns(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, CaplDataBuf &data_out);
	
	bool AT_DCQuerSysTime(/*[in,out]*/ AplNetErrors &aplError, /*[out, size_is(8)]*/ BYTE Result[8]);
	bool AT_DCQuerActiveUserList(/*[in,out]*/ AplNetErrors &aplError, /*[in,out]*/ CaplDataBuf &data_out);
	bool AT_DCQuerActiveUserListEx(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, /*[in,out]*/ CaplDataBuf &data_out);


	//        
	bool AT_DCCreateIterator(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ UINT32 *SizeNameBLOB, /*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,
		/*[in]*/ UINT32 SizeNameFile, /*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile, /*[in]*/ UINT32 *SizeDose, /*[in,out*/UINT32 *SizeBLOB,
		/*[in]*/ UINT32 inst_id = 0, /*[in,out*/ int crc32 = 0);
	bool AT_DCCreateIterator64(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ UINT32 *SizeNameBLOB, /*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,
		/*[in]*/ UINT32 SizeNameFile, /*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile, /*[in]*/ UINT32 *SizeDose, /*[in,out*/__int64 *SizeBLOB,
		/*[in]*/ UINT32 inst_id = 0, /*[in,out*/ int crc32 = 0);
	//    
	bool AT_DCCloseIterator(/*[in,out]*/ AplNetErrors &aplError);
	//     
	bool AT_DCDeleteIterator(/*[in,out]*/ AplNetErrors &aplError, int inst_id, int attr_id);
	//   ,   
	bool AT_DCReadFromIterator(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ UINT32 *SizeDose, /*[out,size_is(SizeDose)]*/ BYTE *Dose, /*[out]*/ UINT32 *LastDose);
	//   ,   
	bool AT_DCWriteToIterator(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ UINT32 SizeDose, /*[in,size_is(SizeDose)]*/ BYTE *Dose, /*[in]*/ UINT32 LastDose);

	//        
	bool AT_DCCreateMultiIterator(AplNetErrors &aplError, /*[in]*/ CaplDataBuf &data_in, /*[in]*/ UINT32 *SizeDose, /*[in,out*/ CaplDataBuf &data_out);
	bool AT_DCCreateMultiIterator64(AplNetErrors &aplError, /*[in]*/ CaplDataBuf &data_in, /*[in]*/ UINT32 *SizeDose, /*[in,out*/ CaplDataBuf &data_out);
	//   -
	bool AT_DCCloseMultiIterator(/*[in,out]*/ AplNetErrors &aplError);
	//   ,   
	bool AT_DCReadFromMultiIterator(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/UINT32 *SizeDose, /*[out]*/ CaplDataBuf &data_out, /*[out]*/ CaplDataBuf &data_out2);
	//      (       )
	bool AT_GetMaxBlobSize64(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ __int64 &MaxSizeBLOB);
	//      ,   . ( ,   ,    crc32 )
	bool AT_DCAutoupdate_LoadListNamesFiles(/*[in,out]*/AplNetErrors &aplError, /*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	//      ,   .   - 2  1)    2)    
	//   CAplTransport__Autoupdate_LoadListNamesFiles:
	//    
	//       
	//      "*.luf",     luf     ,  
	bool AT_DCAutoupdate_LoadListNamesFilesEx(/*[in,out]*/AplNetErrors &aplError, /*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	//        
	bool AT_DCAutoupdate_CreateMultiIterator(AplNetErrors &aplError, /*[in]*/ CaplDataBuf &data_in, /*[in]*/ UINT32 *SizeDose, /*[in,out*/ CaplDataBuf &data_out);
	//   -
	bool AT_DCAutoupdate_CloseMultiIterator(/*[in,out]*/ AplNetErrors &aplError);
	//   ,   
	bool AT_DCAutoupdate_ReadFromMultiIterator(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/UINT32 *SizeDose, /*[out]*/  CaplDataBuf &data_out, /*[out]*/ CaplDataBuf &data_out2);

	//      
	bool AT_DCSaveBlob2Srv(/*[in,out]*/ AplNetErrors &aplError, /*[in]*/ UINT32 SizeNameBLOB, /*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,
								/*[in]*/ UINT32 SizeNameFile, /*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile);
	//         
	bool AT_DCReadBlobFromSrv(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/ UINT32 *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ UINT32 SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile, /*[in,out*/UINT32 *SizeBLOB);
	bool AT_DCReadBlobFromSrv64(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/ UINT32 *SizeNameBLOB,/*[in,out,size_is(*SizeNameBLOB)]*/ BYTE *NameBLOB,/*[in]*/ UINT32 SizeNameFile,/*[in,out,size_is(SizeNameFile)]*/ BYTE *NameFile,/*[in,out*/__int64 *SizeBLOB);
	
	//       
	bool AT_DCSaveChanges(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	// 
	bool AT_DCQuery(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/  CaplDataBuf &data_in, CaplDataBuf &data_out);
	bool AT_DCQueryEx(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/  CaplDataBuf &data_in, CaplDataBuf &data_out,CaplDataBuf &data_out2, LPCTSTR def_source, __int64 *size_all = 0);
	//  
	bool AT_DCSetUsersAccess(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in);
	//      
	bool AT_DCSetUsersAccessBI(/*[in,out]*/ AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	//  
	bool AT_DCGetUsersAccess(/*[in,out]*/ AplNetErrors &aplError,CaplDataBuf &data_in, CaplDataBuf &data_out);
	//      
	bool AT_DCGetUsersAccessBI(/*[in,out]*/ AplNetErrors &aplError,CaplDataBuf &data_in, CaplDataBuf &data_out);
	//       
	bool AT_DCGetDictName(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ UINT32 *BufNameSize, /*[in,out, size_is(*BufNameSize)]*/ BYTE *BufName,/*[in,out]*/ UINT32 *BufFilePathSize,/*[in,out, size_is(*BufFilePathSize)]*/ BYTE *BufFilePath);
	//,      
	bool AT_DCTestUniqueAttrValues(/*[in,out]*/AplNetErrors &aplResult,/*[in]*/ CaplDataBuf &data_in);
	//     
	bool AT_DCFindInstancesWithAttrValuesQuery(/*[in,out]*/AplNetErrors &aplResult,/*[in]*/ CaplDataBuf &data_in,CaplDataBuf &data_out);
	//   
	bool AT_DCOperateIndexes(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ UINT32 attr_id, UINT32 state);

	bool AT_DCTest(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	//        /  
	bool AT_DCLoadInstUserDataTimeInfo(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out);
	//  SQL-     -   (  ORACLE  Postgre)
	bool AT_DCExecuteSQL(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out, LPCTSTR def_source);
	//  SQL-     -   aplExtent (  ORACLE  Postgre)
	bool AT_DCExecuteSQLEx(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, CaplDataBuf &data_out, bool old, CaplDataBuf &data_out2, LPCTSTR def_source);

	//    
	bool AT_DCLoadBDInfo(/*[in,out]*/AplNetErrors &aplError, /*[OUT]*/ CaplDataBuf &data_out);
	//   
	bool AT_DCQueryUsersLog(/*[in,out]*/AplNetErrors &aplError,/*[OUT]*/ CaplDataBuf &data_out);
	//    c 
	bool AT_DCQueryUsersLogEx(/*[in,out]*/AplNetErrors &aplError, CaplDataBuf &data_in, CaplDataBuf &data_out);
	//   
	bool AT_DCClearUsersLog(/*[in,out]*/AplNetErrors &aplError,/*[OUT]*/ CaplDataBuf &data_in);
	
	//       ( ORACLE)  
	bool AT_DCWriteToLog(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ CaplDataBuf &data_in);
	
	bool AT_DCControlAccessDoc(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ CaplDataBuf &data_in, UINT32 &result);

	//       
	bool AT_DCCopyAccessFromExt2Ext(/*[in,out]*/AplNetErrors &aplError,/*[IN]*/ CaplDataBuf &data_1,/*[IN]*/ CaplDataBuf &data_2, int code1, int code2);
	//       
	bool AT_DCCopyAccessFromInst2Ext(/*[in,out]*/AplNetErrors &aplError,/*[OUT]*/ CaplDataBuf &data_in, int code1, int code2);
	//     -    
	bool AT_DCServiceGetAuthParam(/*[in,out]*/ AplNetErrors &aplError, UINT32 param, CString &value);
	//        -    
	bool AT_DCServiceTestVersions(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in);
	//    
	bool AT_DCGetAttrsHistory(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, CaplDataBuf &data_out);
	//   ,     
	bool AT_DCGetAttrs4Blobs(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_out);
	//            
	bool AT_DCRunUpdateDictionary(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ CaplDataBuf &data_in);
	bool AT_DCRunApp(/*[in,out]*/ AplNetErrors &aplError,/*[in,out]*/ CaplDataBuf &data_in);
	//       
	bool AT_DCLockInstance(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, int &result);
	//      
	bool AT_DCServiceOp(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_in, CaplDataBuf &data_out);
	//       
	bool AT_DCGetString4DupSession(CString &spetial_string);
	bool AT_DCGetString4DupSession(/*[in,out]*/ AplNetErrors &aplError, CaplDataBuf &data_out);

	//      
	bool AT_DCGetAllAttrValues(/*[in,out]*/AplNetErrors &aplError,/*[in]*/ CaplDataBuf &data_in, /*[out]*/ CaplDataBuf &data_out);



	bool IsOperated();
	void Disconnect();
	bool IsConnected();
	bool Reconnect(bool asked=true, LPCTSTR file = 0, int line = 0, LPCTSTR date = 0);
	bool ForceReconnect();
	apl_NET_LoginData m_login_data;

	bool m_is_saved_login;

	//        
	int m_num_auto_repeat;
	//         
	int m_timer_auto_repeat;

	//    /         
	CaplTimeMeter m_tick_repeated_mess_time;

	// NetStepData     true       
	//    -     
	bool m_need_reconnect;
	//        
	bool m_need_relogin;

	CDlgReconnect *m_dlg_reconnect;
	//    
	// 0 -     
	// 1 -    
	// 2 -     
	int m_internal_reconnect;
	//   
	bool m_isGlobalClose;

	void CloseReconnectDlg();

	DWORD m_tick_op;
	void ClearTickOp(){m_tick_op = 0;}
	DWORD GetTickOp(){return m_tick_op;}

	//         ""  " "
	//       -    
	long (__cdecl *m_application_close_funct)(LPVOID param);
	CString m_application_reconnect_text;
	CaplNetStepData* m_data;

	void SetApplicationLevelLogMessage(bool (__cdecl *_ApplicationLevelLogMessageDlg)(LPCTSTR message));


protected:
	CConnectInfo* m_cif;

	CString m_am_user;
	CString m_am_pwd;
	int m_am_code1;
	int m_am_code2;

	//          "--"
	//   ""      2     false
	DWORD m_TickStop;

	bool m_server_stopping;
	CString m_def_server_name;
	CString m_description_serv_error;

	CString m_class_info;
	int m_used_version;
	CWnd* m_parent_wnd;

	CaplSocketClient* m_aplSocket;
	CString m_last_calling;

	AplNetErrors m_aplError;
	ASC_ERROR_CODES m_ascError;
	int m_wsaError;
	bool m_hide_mode;
	SOCKET m_temp_socket;
	DWORD m_thread_id;

	//        
	bool m_IsServer4AddLic; 

public:
	CaplDataBuf m_tmp_buf;
	CaplDataBuf m_TempStore;
	CString m_source;

protected:
	HANDLE m_event_TempStore; //??       
	CRITICAL_SECTION m_CS_TempStore;
	CString m_CompName;

public:

	// ip    (     !)
	UINT32 GetCompIp(){if(m_aplSocket == 0)return 0; return m_aplSocket->GetCompIp();}
	// ip    (     !)
	bool GetCompName(CString &name);
	bool GetCompName();
	//   CaplSocketClient-   
	ASC_ERROR_CODES GetLastAscError();
	void ClearInternalData();
	bool TestTempStoreFree(bool block);
	CString	GetDescriptionLastError();
	CString	GetDescriptionServError();
	bool Connect(bool bDlgMode = true);
	void SetWaitDlgText(LPCTSTR waitdlg_text = 0);
	bool IsServerLocal();
	void SetBreak(bool state);
	void SetManageMode(int manage_mode);
	void SetHideMode(bool mode = false);
	void Attach();
	void Detach();
	void SetHalt();
	
		

	//   .    -   
	// !    !
	bool ConnectWithTestLocal(CConnectInfo* cif, CString def_server_name, bool foreground_main_wnd=true, bool bDlgMode = true);

	//    tcp
	void DisconnectFull();

};

void TestReadServError(CaplDataBuf &readed_data_buf, CaplNetStepData* m_data, CString &m_description_serv_error);

#endif // !defined(AFX_TRANSPORTSOCKETCLIENT_H__130138C3_0463_4571_836D_127B95B69339__INCLUDED_)
