#include "stdafx.h"

#include "aplNetStepData.h"


#define MAKE_LAST_LINE_EX(par)


//////////////////////////////////////////////////////////
//      

CaplLoadData::CaplLoadData(CaplNetStepData* data):m_iStartQueryIndex(0)
{
	m_data=data;
	m_placement = 0;
	source = _T("");
	ClearQuery();
}

CaplLoadData::CaplLoadData(CaplNetStepData* data, CString _source) : m_iStartQueryIndex(0)
{
	m_data = data;
	m_placement = 0;
	source = _source;
#ifdef _DEBUG
	if(_source == _T(""))
	{
		AfxMessageBox(
			CString(APL_T("     CaplLoadData     DEF_SOURCE,  :\r\n CaplLoadData ld(data,DEF_SOURCE);\r\n"))
			+ APL_T("       "));
	}
#endif
	ClearQuery();
}

CaplLoadData::~CaplLoadData()
{
	m_data = NULL;
}

void CaplLoadData::SetStartedQueryIndex(int iStartIndex)
{
	ASSERT(iStartIndex > -1);
	m_iStartQueryIndex = iStartIndex;
}

//	  
bool CaplLoadData::ClearQuery()
{
	if(m_data == NULL) return false;
	m_queries.Clear();
	m_critical_err = false;
	m_err_string_quer = _T("");
	m_used_id.RemoveAll();
	m_used_id.bAutoSort = true;
	return true;
}//bool CaplLoadData::ClearQuery()


bool CaplLoadData::TestFindId(int &id, TCHAR type, int prev_id)
{
	int i_type = (int)type;
	int i_type_found;
	bool flag_add = true;
	CString str;

	if(id == -1)
	{
		if(m_used_id.Size == 0)
		{
			id = 0;
		}
		else
		{
			// ..        
			int iMaxId(m_iStartQueryIndex-1), i;
			for(i=0; i <m_used_id.Size; ++i)
			{
				if(iMaxId < m_used_id.Data[i].in)
					iMaxId = m_used_id.Data[i].in;
			}
			id = iMaxId + 1;
		}
	}
	else
	{
		//          
		i_type_found = m_used_id.QGetByIn(id);
		if(i_type_found != -1)
		{
			//,     .   
			//    id .
			//     'a'  'u' -        
			if(type == _T('a') || type== _T('u'))
			{
				if(i_type_found != i_type)
				{
					str.Format( APL_T("\n : id: %i  : '%c'. :                ('%c')!!!\n"),
						id, i_type, i_type_found); 
					m_err_string_quer += str;
					return false;
				}
				else
				{
					//         
					flag_add = false;
				}
			}
			//    'd'  'r'    -       !
			else if(type== _T('d') || type== _T('r'))
			{
				if(i_type_found != i_type)
				{
					str.Format( APL_T("\n : id: %i  : '%c'. :                ('%c')!!!\n"),
						id, i_type, i_type_found);
					m_err_string_quer += str;
					return false;
				}
				else if(prev_id == id)
				{
					str.Format( APL_T("\n : id: %i  : '%c'. :       ,     !!!\n"),
						id, i_type);
					m_err_string_quer += str;
					return false;
				}
				else
				{
					//         
					flag_add = false;
				}
			}
			//        
			else
			{
				TCHAR c1 = i_type;
				TCHAR c2 = (TCHAR)i_type_found;
				TCHAR c3 = i_type;
				str.Format( APL_T("\n : id: %i  : '%c'. :                '%c',    '%c'      !!!\n"),
					id, c1, c2, c3);
				m_err_string_quer += str;
				return false;
			}
		}

	}
	//   id     -   
	if(flag_add) m_used_id.Add(id, i_type);

	return true;
}

//   'a'    
//:   ,   headere
/*int CaplLoadData::AddQuery(CaplInstance *inst, bool load_all_attr)
{
	return AddQuery(-1,inst,load_all_attr);
}*/


//   'a'   
int CaplLoadData::AddQuery(int id, CaplInstance *inst, bool load_all_attr)
{
	if(m_data== 0)
	{
		m_err_string_quer += APL_T("     !\n");
		return -1;
	}
	if(inst== 0)  
	{
		CString str; str.Format( APL_T(" instance (inst== 0);   %i\n"), id);
		m_err_string_quer += str; return -1;
	}
	if(inst->GetTemporary()) 
	{
		CString str; str.Format( APL_T(" instance (temporary==true);   %i\n"), id);
		m_err_string_quer += str; return -1;
	}
	if(inst->GetId() == 0) 
	{
		CString str; str.Format( APL_T(" instance (id== 0);   %i\n"), id);
		m_err_string_quer += str; return -1;
	}
	if(inst->GetType() == 0) 
	{
		CString str; str.Format( APL_T(" instance (type== 0)(inst_id==%i);   %i\n"), inst->GetId(), id);
		m_err_string_quer += str; return -1;
	};
	if(!TestFindId(id, _T('a'), 0))
	{
		return -1;
	}

	apl_NET_LoadQuery* query = new apl_NET_LoadQuery(id, 'a', inst->GetId(), inst->GetType()->id, 0, true, load_all_attr);
	if(query == NULL){ return -1;}
	m_queries.Add(query);

	return query->id;
}

//      
int CaplLoadData::AddQuery(TCHAR _type, long _inst_or_id, LPCTSTR ent_name, LPCTSTR attr_name, bool _in_result, bool _load_all_attrs)
{
	if(m_data == 0) return -1;
	CaplEntity *ent = m_data->GetEntityBN(ent_name);
	if(ent == 0) {m_err_string_quer += APL_T(" entity ") + CString(ent_name) + APL_T("   !\n"); m_critical_err = true; return -1;}

	CaplAttr *attr = m_data->GetAttrDefinition(ent, attr_name);
	if(attr == 0) {m_err_string_quer += APL_T("  ") + CString(attr_name) + APL_T("  entity ") + ent->name + APL_T("   !\n"); m_critical_err = true; return -1;}
	return AddQuery(_type, _inst_or_id, ent, attr, _in_result, _load_all_attrs);
}

//         
int CaplLoadData::AddQuery(TCHAR _type, long _inst_or_id, CaplEntity *ent, CaplAttr *attr, bool _in_result, bool _load_all_attrs)
{
	if(_inst_or_id == -1){m_err_string_quer += APL_T("   !\n"); return -1;}
	return AddQuery(-1, _type, _inst_or_id, ent, attr, _in_result, _load_all_attrs);
}

//	     
int CaplLoadData::AddQuery(TCHAR _type, long _inst_or_id, long _ent_id, long _attr_id, bool _in_result, bool _load_all_attrs)
{
	if(m_data == NULL) return -1;
	CaplEntity* ent = 0;
	CaplAttr* attr = 0;
	if(_ent_id != 0)
	{
		ent = m_data->GetEntityById(_ent_id);
	}		
	if(_attr_id != 0)
	{
		attr = m_data->GetAttrDefinitionById(_attr_id);
	}
	return AddQuery(-1, _type, _inst_or_id, ent, attr, _in_result, _load_all_attrs);

}//int CaplLoadData::AddQuery(char _type,long _inst_or_id,long _ent_id,long _attr_id, bool _in_result)


/**    'd'  'r'    attr_path */
int CaplLoadData::AddQuery(int  prev_id, AttrPath attr_path)
{
	if(attr_path.attr==0) return -1;
	if(attr_path.type!=_T('d') && attr_path.type!=_T('r')) return -1;
	int curr_id = AddQuery(attr_path.type, prev_id, attr_path.ent, attr_path.attr, true, attr_path.next_step.size()==0);
	for ( std::list<AttrPath>::iterator it=attr_path.next_step.begin(); it!= attr_path.next_step.end(); ++it )
		AddQuery(curr_id, *it);
		
	return curr_id;
}


//   ,    
//  
int CaplLoadData::AddQuery(int  id, TCHAR _type, long _inst_or_id, CaplEntity *ent, CaplAttr *attr, bool _in_result, bool _load_all_attrs)
{
	CString str;

	if(m_data == NULL) return -1;
	if(_inst_or_id == -1) return -1;
	MAKE_LAST_LINE_EX(m_data);

	//     ,    
	if(!TestFindId(id, _type, _inst_or_id))
	{
		return -1;
	}
	if((ent == 0) && (attr == 0) && (_inst_or_id == 0) && (_type != _T('u'))) 
	{
		str.Format( APL_T("\n:     id %i  !         -      ,  "),id);
		
		m_err_string_quer += str;
	}
#ifdef _DEBUG
	if(m_queries.GetSize() == 0 && (_type == _T('d') || _type == _T('r') || _type == _T('u')))
	{
		AfxMessageBox(APL_T("       '") + CString(_type) + 
			APL_T("'!\r\n /  ,    !"));
		return -1;
	}
#endif

	// 
	//  
	if(_type != _T('a') && _type != _T('e') && _type != _T('i') && _type != _T('b') && _type != _T('d') && _type != _T('r') && _type != _T('u'))
	{
		str.Format(APL_T(" _type '%c' not defined !!!"), _type); 
		str.Format( APL_T("   id %i -   '%c'   !!!\n"), id, _type);
		m_err_string_quer += str;
		return -1;
	}
	if((_type == _T('a')) && (_inst_or_id == 0))
	{
		str.Format( APL_T(" (_type== 'a')&&(_inst_or_id== 0) !!!"));
		str.Format( APL_T("   id %i -    'a'  _inst_or_id     !!!\n"), id);
		m_err_string_quer += str;
		return -1;
	}
	if(_type == _T('i'))
	{
		if(_inst_or_id == 0)
		{
			str.Format(_T(" (_type== 'i')&&(_inst_or_id== 0) !!!"));
			str.Format( APL_T("   id %i -    'i'  _inst_or_id     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(attr== 0)
		{
			str.Format(_T(" (_type== 'i')&&(attr== 0) !!!"));
			str.Format( APL_T("   id %i -    'i'     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
	}
	if(_type == _T('b'))
	{
		if(_inst_or_id == 0)
		{
			str.Format(_T(" (_type== 'b')&&(_inst_or_id== 0) !!!"));
			str.Format( APL_T("   id %i -    'b'  _inst_or_id     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(attr == 0)
		{
			str.Format(_T(" (_type== 'b')&&(attr== 0) !!!"));
			str.Format( APL_T("   id %i -    'b'     !!!\n") ,id);
			m_err_string_quer += str;
			return -1;
		}
		if(ent == 0)
		{
			str.Format(_T(" (_type== 'b')&&(ent== 0) !!!"));
			str.Format( APL_T("   id %i -    'b'     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
	}
	if(_type == _T('d'))
	{
		if(_inst_or_id < 0)
		{
			str.Format(_T(" (_type== 'd')&&(_inst_or_id<0) !!!"));
			str.Format( APL_T("   id %i -    'd'     _inst_or_id!!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(attr == 0)
		{
			str.Format(_T(" (_type=='d')&&(attr== 0) !!!"));
			str.Format( APL_T("   id %i -    'd'     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
	}
	if(_type == _T('r'))
	{
		if(_inst_or_id < 0)
		{
			str.Format(_T(" (_type=='r')&&(_inst_or_id<0) !!!"));
			str.Format( APL_T("   id %i -    'r'     _inst_or_id!!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(attr == 0)
		{
			str.Format(_T(" (_type=='r')&&(attr== 0) !!!"));
			str.Format( APL_T("   id %i -    'r'     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(ent == 0)
		{
			str.Format(_T(" (_type=='r')&&(ent== 0) !!!"));
			str.Format( APL_T("   id %i -    'r'     !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
	}
	if(_type == _T('u'))
	{
		if(_inst_or_id < 0)
		{
			str.Format(_T(" (_type== 'u')&&(_inst_or_id<0) !!!"));
			str.Format( APL_T("   id %i -    'u'     _inst_or_id!!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
		if(attr != 0 || ent != 0)
		{
			str.Format(_T(" (_type== 'u')&&(attr != 0 || ent != 0) !!!"));
			str.Format( APL_T("   id %i -    'u'      .   !!!\n"), id);
			m_err_string_quer += str;
			return -1;
		}
	}

	//       
	long _ent_id = (ent== 0) ? 0 : ent->id;
	long _attr_id = (attr == 0) ? 0 : attr->id;



	MAKE_LAST_LINE_EX(m_data);
	apl_NET_LoadQuery* query = NULL;
#ifdef _UNICODE
	char __type = ' ';
	switch(_type)
	{
	case L'a':
		__type = 'a';
		break;
	case L'e':
		__type = 'e';
		break;
	case L'i':
		__type = 'i';
		break;
	case L'd':
		__type = 'd';
		break;
	case L'b':
		__type = 'b';
		break;
	case L'r':
		__type = 'r';
		break;
	case L'u':
		__type = 'u';
		break;
	default:
		ASSERT(false);
	}
	query = new apl_NET_LoadQuery(id, __type, _inst_or_id, _ent_id, _attr_id, _in_result ,_load_all_attrs);
#else
	query = new apl_NET_LoadQuery(id, _type, _inst_or_id, _ent_id, _attr_id, _in_result ,_load_all_attrs);
#endif
	if(query == NULL){return -1;}
	m_queries.Add(query);

	return id;
}

//	   
bool CaplLoadData::LoadEx(bool clear_query, aplExtent * ext_out, LPCTSTR wait_text, bool /*hide_error*/)
{
	CaplStackLogger logger(__APL_FUNC__);
	return LoadEx(clear_query, ext_out, 0, -1, wait_text);

}
//	   
bool CaplLoadData::LoadEx(bool clear_query, aplExtent *ext_out, CaplPagin *pagin, int pagin_query_num, LPCTSTR wait_text)
{
	CaplStackLogger logger(__APL_FUNC__);

	bool ret_code = LoadExNoInstUserDataTimeInfo(clear_query, ext_out, pagin, pagin_query_num, wait_text);

	//   Oracle
	if (m_data->CanLoadInstUserDataTimeInfo() && (m_data->m_TypeSrv[0] == _T('O') || m_data->m_TypeSrv[0] == _T('P')))
	{
		//   CAplInstance   :  /, 
		int iSize = m_data->m_last_load_result.GetSize();
		if (iSize == 0)
			return ret_code;

		CaplTAggr<SInstInfo*,SInstInfo*,APLAGGR_AUTOKILLREF> data;
		CaplInstance* pInst = NULL;
		SInstInfo* el;

		int i;
		for (i=0; i < iSize; ++i)
		{
			pInst = m_data->m_last_load_result.GetAt(i);
			if (pInst == NULL)
				continue;
			if (pInst->GetId() == 0)
				continue;

			el = new SInstInfo(pInst);
			data.Add(el);
		}

		iSize = data.GetSize();
		if (iSize == 0)
			return ret_code;

		ret_code &= m_data->NET_LoadInstUserDataTimeInfo(data, wait_text);

		SInstInfo* pEl = NULL;
		for (i=0; i < iSize; ++i)
		{
			pEl = data[i];
			pEl->inst->SetCreateDate(pEl->create_date);
			pEl->inst->SetCreateUser(pEl->create_user);
			pEl->inst->SetUpdateDate(pEl->update_date);
			pEl->inst->SetUpdateUser(pEl->update_user);
		}

		data.Clear();
	}

	return ret_code;
}

//	    (     instance,    :  /, )
bool CaplLoadData::LoadExNoInstUserDataTimeInfo(bool clear_query, aplExtent * ext_out, 
												CaplPagin *pagin, int pagin_query_num, LPCTSTR wait_text, bool /*hide_error*/)
{
	CaplStackLogger logger(__APL_FUNC__);

	if(m_data == NULL) return false;
	if(m_queries.Size == 0)
	{
		//		m_data->SetAPLErrorWithFileInfo(APL_NET_CLI_MISSED_DATA);
		return false;
	}
	MAKE_LAST_LINE_EX(m_data);
	if(m_err_string_quer != _T(""))
	{
		bool old_hide = m_data->m_hide_mode;
		m_data->m_hide_mode = true;
		CString str;
		str= APL_T("       :\n")+
			m_err_string_quer + APL_T("\n : ") + this->source;

		if(this->source == _T(""))
		{
			str += APL_T("<>\r\n    \r\n CaplLoadData ld(data,DEF_SOURCE);\r\n           ,   ");
		}
		m_data->m_ErrorAnnotation = str; 
		m_data->SetLastErrorEx(APL_NET_CLI_ERROR_PROCESSED, false, _T(__FILE__), __LINE__);

		logger.SetFunctionInfo(str);

		m_data->m_hide_mode = old_hide;
		if(m_data->m_hide_mode && m_critical_err) return false;
		if(!m_data->m_hide_mode)
		{
			AfxMessageBox(m_data->GetLastErrorDescription()+ APL_T("\n\n     .\n\n    ."), MB_OK);
		}
	}
	if(m_queries.Size > 10000)
	{
		CString str;
		str.Format(APL_T("      (%i).\n    \n    "),m_queries.Size);
		str += APL_T("\n : ") + this->source;
		if(this->source == _T(""))
		{
			str += APL_T("<>\r\n    \r\n CaplLoadData ld(data,DEF_SOURCE);\r\n           ,   ");
		}
		m_data->m_ErrorAnnotation = str; 
		m_data->SetLastErrorEx(APL_NET_CLI_ERROR_PROCESSED, false, _T(__FILE__), __LINE__);

		logger.SetFunctionInfo(str);

		if(clear_query)
		{
			ClearQuery();
		}
		return false;
	}
	int i = 0;
	apl_NET_LoadQuery* arr_query=NULL;
	arr_query = new apl_NET_LoadQuery[m_queries.Size];

	for(i=0; i <m_queries.Size; i++)
	{
		apl_NET_LoadQuery *src = m_queries[i];
		apl_NET_LoadQuery &dst = arr_query[i];
		dst.Set(src);
		/*
		dst.id=src->id;
		dst.type=src->type;
		dst.inst_or_id=src->inst_or_id;
		dst.ent_id=src->ent_id;
		dst.attr_id=src->attr_id;
		dst.in_result=src->in_result;
		*/

	}
	bool last_err_mess_mode = m_data->m_NetErrorMessageMode;
	bool ret_code = m_data->NET_Load(arr_query, m_queries.Size, ext_out ,m_placement, pagin, pagin_query_num, wait_text, source);

	delete []arr_query;
	if(clear_query)
	{
		ClearQuery();
	}
	m_data->SetNetErrorMessageMode(last_err_mess_mode);
	return ret_code;
}//bool CaplLoadData::LoadEx(bool clear_query)



/** 
	 ,     AdminMode     
*/

CaplAdminModeProvider::CaplAdminModeProvider(CaplNetStepData *data, LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _source)
{
	m_my_admin = false;
	m_data = data;
	m_source = _source;

#ifdef _DEBUG
	if(m_source == _T(""))
	{
		AfxMessageBox(CString(APL_T("     CaplAdminModeProvider    DEF_SOURCE,  :\r\n CaplAdminModeProvider amp(data, .. , .. ,DEF_SOURCE);\r\n"))
			+ APL_T("       "));
	}
#endif

	StartAdminMode(_username, _pwd, _source);
}


CaplAdminModeProvider::CaplAdminModeProvider(CaplNetStepData *data, int code1, int code2, LPCTSTR _source)
{
	m_my_admin = false;
	m_data = data;
	m_source = _source;

#ifdef _DEBUG
	if(m_source == _T(""))
	{
		AfxMessageBox(CString(APL_T("      CaplAdminModeProvider    DEF_SOURCE,  :\r\n CaplAdminModeProvider amp(data, .. , .. ,DEF_SOURCE);\r\n"))
			+ APL_T("       "));
	}
#endif
	StartAdminMode(code1, code2, _source);

}
CaplAdminModeProvider::CaplAdminModeProvider()
{
	m_data = 0; m_my_admin = false;
}; 


CaplAdminModeProvider::~CaplAdminModeProvider()
{
	ExitAdminMode();	
}

bool CaplAdminModeProvider::StartAdminMode(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _source)
{
	if(m_data == 0) return false;
	if(m_data->GetAdminMode())return false;
	if(m_data->NET_StartAdminMode2(_username, _pwd, _source))
	{
		m_my_admin = true;
		return true;
	}
	return false;
}

bool CaplAdminModeProvider::StartAdminMode(int code1, int code2, LPCTSTR _source)
{
	if(m_data == 0) return false;
	if(m_data->GetAdminMode())return false;
	if(m_data->NET_StartAdminMode2(code1, code2, _source))
	{
		m_my_admin = true;
		return true;
	}
	return false;
}

bool CaplAdminModeProvider::ExitAdminMode()
{
	if(m_data == 0) return false;
	if(m_my_admin && m_data->GetAdminMode())
	{
		if(m_data->NET_ExitAdminMode())
		{
			m_my_admin = false;
			return true;
		}
	}
	return false;
}