#if !defined(AFX_aplNetStepData_H__53498523_74F0_11D3_B380_00C026EE2281__INCLUDED_)
#define AFX_aplNetStepData_H__53498523_74F0_11D3_B380_00C026EE2281__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// aplNetStepData.h : header file
//

// 1.0.1
// 1.1.0  5.10.2000      Inst

#include <afxwin.h>
#include <list>
#include <StepData.h>
#include "MiddleWare.h"
#include <aplStepQL.h>

// #include "TransportSocketClient.h"

#ifdef APL_NSD_IMPL
#define CLASS_DECL_APL_NSD  _declspec(dllexport)
#else
#define CLASS_DECL_APL_NSD  _declspec(dllimport)
#endif


#ifndef APL_NET_STEP_DATA_NOAUTOLIB
#ifdef _DEBUG
#ifdef _UNICODE
#pragma comment (lib,"CaplData_ud.lib")
#pragma comment (lib,"AplTransportClient_ud.lib")
#else
#pragma comment (lib,"CaplDataD.lib")
#pragma comment (lib,"AplTransportClientD.lib")
#endif
#else
#ifdef _UNICODE
#pragma comment (lib,"CaplData_u.lib")
#pragma comment (lib,"AplTransportClient_u.lib")
#else
#pragma comment (lib,"CaplData.lib")
#pragma comment (lib,"AplTransportClient.lib")

#endif
#endif
#endif

extern CString global_name_ini;

typedef CArray<int,int> TListInt;

class CaplNetStepData;
class aplUsers;
class aplAccessEl;
class aplAccessList;
class CTransportSocketClient;
class CaplQLQueryParse;

#ifndef APL_NO_INSET_IN_DOC

class CConnectInfo{
public:
	CConnectInfo(){Clear();}
	int id;
	CString name;
	CString comp_name;
	// 0 -  
	// 1 - http
	int protocol;
	int port;
	CString base_name;
	CString def_user_name;
	//   http      -       IE
	CString proxy;

	void Clear(){id=-1;port=7239; protocol = 0;proxy = _T("");def_user_name = _T("");}
	void Set(CConnectInfo *cif)
	{
		if(cif== 0){Clear();return;}
		id=cif->id;
		protocol=cif->protocol;
		port=cif->port;
		name=cif->name;
		comp_name=cif->comp_name;
		base_name=cif->base_name;
		def_user_name=cif->def_user_name;
		proxy=cif->proxy;
	};
	bool IsEqu(CConnectInfo *cif)
	{
		if(0==cif) return false;
		return (name==cif->name && comp_name==cif->comp_name && port==cif->port 
			&& base_name==cif->base_name && def_user_name==cif->def_user_name
			&& protocol==cif->protocol && proxy==cif->proxy);
	};
};

#endif

//     
#define CONNECT_DLG_MODE__SUPRESS -1
#define CONNECT_DLG_MODE__ONLY_ERROR 0
#define CONNECT_DLG_MODE__SHOW_ALVAYS 1


/**    */
BOOL AFX_EXT_API ClientPing(LPCTSTR strHost);

/**    
	@param res  
	@param buf ,     
	@return    buf*/
LPTSTR AFX_EXT_API HRESULT2char(HRESULT res, LPTSTR* buf);

/**       PSS
	@param res  
	@return    buf*/
CString AFX_EXT_API APL_NET_ERROR2char(int error, CString add_text=_T(""));

//      -      exe-   log
void AFX_EXT_API APL_NET_LogMessage(LPCTSTR message);

/**        
	*/
void AFX_EXT_API PumpTimerPaint();

/// 
bool AFX_EXT_API GetVersionClient(CString *version = 0);
///  ,     CaplNetStepData
CString AFX_EXT_API GetAppName();

///  ini  ( ),    .
///      CaplNetStepData
CString AFX_EXT_API GetIniFullName();

///  ,      (    )
///      ini ( Paths  ClientSettingsPath),  
///  -      exe
CString AFX_EXT_API GetPathSetting();

/**        (  apl_access_pattern);    
@param data        
@param curr_pattern    
@param bPressOk -     OK.      Cancel   "<   >"
@return     0      (  Cancel)*/
CaplInstance AFX_EXT_API *SelectAccessPatternC(CaplNetStepData *data, CaplInstance *curr_pattern = 0, bool *bPressOk = NULL);

/**        (  apl_access_pattern);  , ,   
@param lpParameter        ,    LPVOID
@param IsUsed call-back ,  ,        (,  , 
 ).       ,    true       , 
  ;        .    false -   
   .
 call-back :
bool IsUsed(CString &pattern_name, CString &option_used);
 pattern_name  -   (  name   apl_access_pattern)
	option_used -  ,    
*/
void AFX_EXT_API EditAccessPatternC(LPVOID lpParameter, bool ( *IsUsed)(CString &, CString &) = 0, double add_param = 0);


//     
typedef enum {aplLogModeNo=0, aplLogModeError=1, aplLogModeWarning=2, aplLogModeInfo=3, aplLogModeVerbose=4, aplLogModeDebug=5, aplLogModeParanoid=6  } aplLogMode;


//      BLOB
#define SIZE_DOSE_BLOB 1024*1024
#define SIZE_DOSE_BLOB_HTTP 1024


typedef CaplTAggr <apl_NET_LoadQuery*, apl_NET_LoadQuery*, APLAGGR_AUTOKILLREF> TAKQueriesAggr;

CString AFX_EXT_API MakeSourceDescr(CString file, int line, CString date);

#define DEF_SOURCE MakeSourceDescr(_T(__FILE__), __LINE__, _T(__DATE__))

/**  ,     AdminMode     */
class CLASS_DECL_APL_NSD CaplAdminModeProvider
{
public:
	/** 
	@param 
	@param _username      . 
	@param _pwd  
	$param _source ,    .       DEF_SOURCE
	*/
	CaplAdminModeProvider(CaplNetStepData *data, LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _source);
	/** 
	@param 
	@param code1  ,    
	@param code2  ,    
	$param _source ,    .       DEF_SOURCE
	*/
	CaplAdminModeProvider(CaplNetStepData *data, int code1, int code2, LPCTSTR _source);

	/**  ,   */
	CaplAdminModeProvider(); 

	~CaplAdminModeProvider();

	/**      
	@param _username      . 
	@param _pwd  
	@return <b>true</b>     <b>false</b>    */
	bool StartAdminMode(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _source);


	/**      
	@param code1  ,    
	@param code2  ,    
	@return <b>true</b>     <b>false</b>    */
	bool StartAdminMode(int code1, int code2, LPCTSTR _source);
	
	/**        
	*/
	bool ExitAdminMode();	

	void SetData(CaplNetStepData *data){m_data=data;};

protected:
	/** c */
	CaplNetStepData* m_data;
	CString m_source;
	bool m_my_admin;
};

/**        'd'  'r' 
    (    NET_LoadExtAttrPaths)
*/
struct AttrPath
{
    /**
     * @brief AttrPath   .    'd'  'r'.
     * @param _attr    'd'  .  'r'  
     * @param _ent    'd'  .  'r' ,    attr
     *    
     * @param _type  .    'd'  'r'.
     * @param _next_step     .  _next_step ,   
     *  aplINSTANCE,      .    
     *      .
     */
	AttrPath(CaplAttr* _attr, CaplEntity* _ent=0, TCHAR _type=_T('d'), std::list<AttrPath> _next_step=std::list<AttrPath>())
	{
		attr=_attr, ent=_ent, type=_type, next_step=_next_step;
	}

#ifdef _UNICODE
	/**  ,         c _T()     */
	AttrPath(CaplAttr* _attr, CaplEntity* _ent, char _type, std::list<AttrPath> _next_step=std::list<AttrPath>())
	{
		attr=_attr, ent=_ent, type=static_cast<TCHAR>(_type), next_step=_next_step;
	}
#endif // #ifdef _UNICODE

	CaplAttr* attr;
	CaplEntity* ent;
	TCHAR type;
	std::list<AttrPath> next_step;
};



/**  ,   ,       ,      */
class CLASS_DECL_APL_NSD CaplLoadData 
{
/**@name  
	<B>"a"</B> -   <B>instance</B>   
	<B>"e"</B> -    <B>instance</B>   ( ) <BR>
	<B>"i"</B> -      <B>instance</B> ( ) <BR>
	<B>"b"</B> -   <B>instance</B>,      <B>instance</B> ( ) <BR>
	<B>"d"</B> -      <B>instance</B>,    (    ) <BR>
	<B>"r"</B> -   <B>instance</B>,      <B>instance</B>,    (    ) <BR>
	<B>"u"</B> -      
	 .  "   PSS API" ("\PDM STEP Suite\  API")  " CaplLoadData"
*/

public:
	/**  
	@param  data       
	$param _source ,    .       DEF_SOURCE
	*/
	CaplLoadData(CaplNetStepData *data);
	CaplLoadData(CaplNetStepData *data, CString _source);
	virtual ~CaplLoadData();

	/** c */
	CaplNetStepData* m_data;
	/**    LoadEx*/
	TAKQueriesAggr m_queries;
	CaplNetStepData* m_placement;
	//
	CString source;

	bool IsQueryNotEmpty(){return m_queries.GetSize()>0;}

	//    
	/**	   */
	bool ClearQuery();
	/**       
		@param _type  
		@param _inst_or_id  <B>instance</B>    
		@param _ent_id  <B>entity</B>
		@param _attr_id  
		@param _in_result       
		@param load_all_attrs         <B>instance</B>
		@return     */

	int AddQuery(TCHAR _type, long _inst_or_id, long _ent_id, long _attr_id, bool _in_result, bool _load_all_attrs = false);
	/**       
		@param _type  
		@param _inst_or_id  <B>instance</B>    
		@param ent_name  <B>entity</B>
		@param attr_name  
		@param _in_result       
		@param load_all_attrs         <B>instance</B>
		@return     */
	int AddQuery(TCHAR _type, long _inst_or_id, LPCTSTR ent_name, LPCTSTR attr_name, bool _in_result, bool _load_all_attrs = false);

	/**        
		@param _type  
		@param _inst_or_id  <B>instance</B>    
		@param ent    <B>entity</B>
		@param attr    
		@param _in_result       
		@param load_all_attrs         <B>instance</B>
		@return     */
	int AddQuery(TCHAR _type, long _inst_or_id, CaplEntity *ent, CaplAttr *attr, bool _in_result, bool _load_all_attrs = false);

	/**            
		@param id  
		@param _type  
		@param _inst_or_id  <B>instance</B>    
		@param ent    <B>entity</B>
		@param attr    
		@param _in_result       
		@param load_all_attrs         <B>instance</B>
		@return     */
	int AddQuery(int  id, TCHAR _type, long _inst_or_id, CaplEntity *ent, CaplAttr *attr, bool _in_result, bool _load_all_attrs = false);

	/**    "a"
		@param inst   <B>instance</B>
		@return     */
	/* :  =    
	int AddQuery(CaplInstance *inst,bool load_all_attr = false);

	**    "a"    
		@param id  
		@param inst   <B>instance</B>
		@return     */
	int AddQuery(int  id, CaplInstance *inst, bool load_all_attr = false);

	/**    
		@param clear_query    
		@param ext_out   ,       <B>instance</B>,          0
		@param wait_text ,        .       
		@param hide_error -  .  CaplNetStepData::SetHideMode.
		@return <b>true</b>     <b>false</b>    */
	bool LoadEx(bool clear_query=true, aplExtent *ext_out = 0, LPCTSTR wait_text = 0, bool /*hide_error*/ = false);

    /**    .
               pagin  pagin_query_num,   ext_out  
              pagin_query_num   pagin; 
        pagin.m_size_all         .
              pagin  pagin_query_num  ,   ext_out    <B>instance</B>,
              in_result.
                          in_result.
        @param clear_query    
        @param ext_out   ,     <B>instance</B>,   
                   pagin.  pagin  ,     0
        @param pagin  ,       ,   
              pagin.start   pagin.size_p       pagin.size_all
        @param pagin_query_num  ,        ext_out. 
              : 'e'  'r'  'b'
        @param wait_text ,        .       
        @return <b>true</b>     <b>false</b>    */
    bool LoadEx(bool clear_query, aplExtent *ext_out, CaplPagin *pagin, int pagin_query_num, LPCTSTR wait_text = 0);

    /**    'd'  'r'    attr_path
        @param attr_path    ,     
        @return     */
    int AddQuery(int  prev_id, AttrPath attr_path);

    /**	   (   CAplInstance   : 
            /, )
               pagin  pagin_query_num,   ext_out  
              pagin_query_num   pagin; 
        pagin.m_size_all         .
              pagin  pagin_query_num  ,   ext_out    <B>instance</B>,
              in_result.
                          in_result.
        @param clear_query    
        @param ext_out   ,     <B>instance</B>,   
                   pagin.  pagin  ,     0
        @param pagin  ,       ,   
              pagin.start   pagin.size_p       pagin.size_all
        @param pagin_query_num  ,        ext_out. 
              : 'e'  'r'  'b'
        @param hide_error -  .  CaplNetStepData::SetHideMode.
		@param wait_text ,        .    
			 "  "
        @return <b>true</b>     <b>false</b>    */
    bool LoadExNoInstUserDataTimeInfo(bool clear_query=true, aplExtent *ext_out = 0,
                        CaplPagin *pagin = 0, int pagin_query_num =-1, LPCTSTR wait_text = 0, bool /*hide_error*/ = false);

	LPCTSTR GetLastErrorDescription(){return m_err_string_quer;}

	/**	        */
	void SetStartedQueryIndex(int iStartIndex = 0);
protected:
	bool TestFindId(int &id, TCHAR type, int prev_id);

	CString m_err_string_quer;
	bool m_critical_err;
	CaplMap m_used_id;

	int		m_iStartQueryIndex;
};


//   . :             
struct SaplSQLResult
{
	SaplSQLResult() : field(_T("")), type(aplNOTYPE) {}
	SaplSQLResult(const SaplSQLResult& item) 
	{ 
		field = item.field;
		type = item.type;
		values.Append(item.values);
	}
	CString field; //  .   - 
	aplValueType type; //   (IN)
	CaplTAggr<CaplValue*, CaplValue*,APLAGGR_LIST_OR_AUTOKILLREF> values; //   (OUT)
};

//       
struct SaplFileDescr
{
	SaplFileDescr(){name = _T(""); crc32 = 0;}
	CString name; 
	CFileStatus fstatus;
	UINT32 crc32;
};

//     Oracle  PostgreSQL!
// -  ORACLE
struct SaplSQLError
{
	SaplSQLError(){Clear();}
	void Clear(){m_LastErrDescr = _T(""); m_err_offset = 0; m_err_code = 0; m_missed_field=-1;}
	CString m_LastErrDescr; //  
	int m_err_offset;	//    SQL
	int m_err_code;		//   (  ORACLE)
	int m_missed_field;	//  ,       -1      - 
};
 
typedef CArray<__int64,__int64> C__int64Array;

class CDlgLogin;
class CDlg4Log;
class CDlgTuneListConnections;
class CDlgTuneConnection;
class CaplParentWndProcesser;
class CaplQLQueryParse;
/////////////////////////////////////////////////////////////////////////////
// CaplNetStepData 
class CLASS_DECL_APL_NSD CaplNetStepData : public CaplStepData
{
	friend CDlgLogin;
	friend CDlg4Log;
	friend CDlgTuneListConnections;
	friend CDlgTuneConnection;
	friend CaplLoadData;
	friend CaplAdminModeProvider;
	friend CaplParentWndProcesser;
	friend CaplQLQueryParse;
	friend CTransportSocketClient;
// Construction
public:

	//  ,      
	struct QUL_Filter
	{
		QUL_Filter()
		{
			AUSId = 0;
			user_id = 0;
			admin_user_id = 0;
			date_beg_1 = _T("");
			date_beg_2 = _T("");
			date_end_1 = _T("");
			date_end_2 = _T("");
			status=100;
			ip_cli =  _T("");
			ip_srv =  _T("");	
			ver_cli = _T("");
			ver_srv = _T("");		
			module_name = _T("");
			time_connect = _T("");
		}

		int AUSId;
		int user_id;
		int admin_user_id;
		CString date_beg_1;
		CString date_beg_2;
		CString date_end_1;
		CString date_end_2;
		//exit_status: -1 else work; 0 successful; 1 crash of client; 2 crash of server; 3 stopping server
		//        - 100
		int status;
		CString ip_cli;
		CString ip_srv;	
		CString ver_cli;
		CString ver_srv;		
		CString time_connect;
		CString module_name;
	};

	/// 
	CaplNetStepData();
	virtual ~CaplNetStepData();

	CString m_class_info;

	static aplLogMode g_CurLogMode;

	CTransportSocketClient* m_AplTransport;
	bool m_IsWaitDlg;
	//          ..
	bool m_check_access_from_server;
	//  true -    apl_access_agent    
	bool m_load_access_agent_from_serv;
	// ip    (     !)
	UINT32 GetCompIp();
	//    (     !)
	bool GetCompName(CString &name);
	/**  ,       
		@param version        (  pss*.ver)
		@param type       .  : _T("LITE"), _T("ORACLE"), _T("POSTGRES")
		@param ServerAUSessionId        PSS
		@param ClassSrv      : MSVC|QT, win|linux, dev|stable
		@return  true*/
	bool GetVersionServer(CString &version, CString &type, long *ServerAUSessionId = 0, CString *ClassSrv=0);

	bool m_AutoStartSrv;

	//            
	CaplTimeMeter m_last_read_users_timer;
	//    .        
	DWORD m_num_load; //   NET_Load
	DWORD m_num_save; //   NET_SaveChanges
	DWORD m_num_find; //   NET_FindInstancesWithAttrValues
	DWORD m_num_find_local_cache; //   FindInstancesWithAttrValuesInLocalCache
	DWORD m_num_query; //   NET_QueryExecute  NET_QueryExecuteEx
	DWORD m_num_run_sql; //   NET_RunSql
	DWORD m_num_run_sql_re; //   NET_RunSqlReturnExtent

	//     Oracle  PostgreSQL!
	//        entity.
	int GetTable4Entity(CaplEntity* entity);
	
	//    -      
	bool ApploadFromDataBuf(CaplDataBuf &dbuf, aplExtent *ext_inst = 0);

	//      -   
	/**  instance    entity*/
	virtual CaplInstance  *CreateInstance(CaplEntity *entity, bool is_temporary = false, bool create_attrs = true);
	/**  instance   entity*/
	virtual CaplInstance  *CreateInstanceBN(LPCTSTR type_name, bool is_temporary = false, bool create_attrs = true);

	/**  instance.       instance,
	  instance   
		@param inst   instance
		@param bChekReference        instance - <b>true</b>,
			   - <b>false</b>
		@param bNoSetChanged  <b>true</b> -      
			 <b>false</b> -    
		@return <b>true</b>     <b>false</b>    */
	virtual bool DeleteInstance(CaplInstance *inst, bool bChekReference = true, bool bNoSetChanged = false);
	virtual bool DeleteInstanceForced(CaplInstance *inst);


	CaplEntity* m_ent_apl_workgroup;
	CaplEntity* m_ent_apl_access_agent;
	CaplEntity* m_ent_apl_user;

	CaplAttr *m_attr_apl_user__name;
	CaplAttr *m_attr_apl_user__pass;
	CaplAttr *m_attr_apl_user__grop;
	CaplAttr *m_attr_apl_user__pers;

	CaplEntity* m_ent_apl_access_pattern;

	CaplAttr* m_attr_apl_acc_pat__name;
	CaplAttr* m_attr_apl_acc_pat__pattern;


	CaplEntity* m_ent_person_and_org;
	CaplAttr *m_attr_person_and_org__pers;

	CaplEntity* m_ent_person;
	CaplAttr *m_attr_person__last_name;
	CaplAttr *m_attr_person__first_name;
	CaplAttr *m_attr_person__middle_names;

	CaplEntity* m_ent_apl_GUID_access;
	CaplAttr *m_attr_apl_GUID_access__GUID;
	CaplAttr *m_attr_apl_GUID_access__access_def;
	CaplAttr *m_attr_apl_GUID_access__access_ind;
	CaplAttr *m_attr_apl_GUID_access__pattern;

	bool GetAplUserName(CaplInstance *user, CString &buf);

	CWnd* GetParentWnd() {return m_parent_wnd;};
	HWND GetParentHWND() 
	{
		CWnd* pWnd = GetParentWnd();
		if(pWnd != NULL)
		{
			return pWnd->m_hWnd;
		}
		return NULL;
	};

protected:
	CString m_NameCurrBase;
	CString m_NameCurrConnection;
	CString m_NameCurrUser;
	CString m_NameDomain;
	CaplInstance* m_CurrUser;
	CaplInstance* m_CurrAdminUser;
	CString m_FullDictName;

	CWnd* m_parent_wnd;
	void SetParentWnd(CWnd* parent_wnd);

	//     MessageBox-
	HWND m_hwnd;

	
	bool m_IsLoadedTable4Entity;

	// 2011       .        
	//              
	// 2011      -          
	//  m_IsAccessBI       
	//    2019  
	// bool m_IsAccessBI;

	aplExtent m_SavedDeleted;
	
	CString m_VerSrv;
	CString m_TypeSrv;
	CString m_ClassSrv;
	CString m_BuildSrv;
	UINT32 m_ServerAUSessionId;

	void ZeroBDParams();

	/************************************************************************/
	/*  .            
	/*        -    ,    
	/*    ansi   unicode -     temporary_buf 
	/*    .  size_buf     
	/************************************************************************/
	inline BYTE* ConvertString2ServerEnc(LPCTSTR source, BYTE* temporary_buf, UINT32 &size_buf);
	//     .    -  temporary_buf
	//     -         
	inline LPCTSTR ConvertStringFromServerEnc(BYTE* source, BYTE* temporary_buf);

	int m_LoadTimeOut;
	CaplTimeMeter m_last_load_time_meter;
	apl_NET_LoadQuery *m_last_load_queries;
	CaplPagin m_last_pagin;
	int m_last_load_queries_count;
	aplExtent m_last_load_result;

	bool m_IsConnected;
	int m_Protocol; 
	bool m_NetErrorMessageMode;
	
	inline bool CanProcessed(bool check_connect, bool check_processed, LPCTSTR _add_text, LPCTSTR file, int line, LPCTSTR funct_name);

	bool ActualizeChangedAggr(CaplLoadData &ld, aplExtent &ext);

	bool CheckInstState(aplExtent *extent);

	bool m_AutoDownloadAttr;
	//        :     / instance (  flase)
	bool m_bCanLoadInstUserDataTimeInfo;

	CString GetClassDescription();
	//  
public:
	void SetAPLError(AplNetErrors res, CString add_text=_T(""), LPCTSTR file = 0, int line = 0, LPCTSTR funct_name = 0, LPCTSTR context = 0);
	void SetAPLError(SaplErrorDescription &err, LPCTSTR context = 0);
protected:
	AplNetErrors m_LastAplErrorCode;
	//      NetStepData   ,  
	//    StepData     m_ErrorDescription .  
	//  hide-mode      APL_- 
	CString m_AplErrorDescription;
	//    
	int m_SizePortionSavedInst;
	bool m_can_find_in_blob;

	//   
	// bool m_lang_england; -    .       CaplTranslate.


public:
	//    is_process  false -     ..  
	//  WM_PAINT.    ILS.     , , gui.
	static bool SetGlobalProcessWmPaint(bool is_process);


	void SetUserAPLError(LPCTSTR user_error_description);

	//      m_IsAccessBI
	//  void SetAccessBI(bool IsAccessBI){m_IsAccessBI = IsAccessBI;}

	__int64 m_loadcount_all;
	__int64 m_loadcount_unique;

	bool CanFindInBLOB();
	void SetConnectDlgLang(bool lang_england = false);

	
	typedef CaplTAggr<CString*,CString*,APLAGGR_AUTOKILLREF|APLAGGR_LIST> CStrArr;
	
	/**@name <b>   </b> */
	//@{

	///    ,      
	AplNetErrors GetLastAplError();

	///     ,    StepData
	CString GetLastErrorDescription();
	///     ,      
	CString GetLastAplErrorDescription();
	//@}


	/**      
		@param comp_name  ,    
		@param port     
		@param protocol  . 0 -  , 1 - http
		@param proxy   http - ,    .      -       IE
		@param list_Db ,     
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetListDb(LPCTSTR comp_name, int port, int protocol, LPCTSTR proxy, CStringArray &BaseList);


	/**@name    */
	//@{

	// Methods
	/** @brief    /,   ,    
		@param _username  .    ,        
		@param _pwd  
		@param _name_connect  ,    .    
			,        
		@param wait_text ,        .  
			     
		@param license    ,     .  
			  ,    "PSS"
		@param supress_dig     .<br>
		@param load_titul_bd -  ,    
		@param _domain  ,         ""

		@param bIsCurrDomainUser  true,           
			       .  /  ;  
			     .  false,   
			  .      ,    
			,       supress_dig     
			 ,   .

		  ,        .
		     false.    (   ..) -
		    
		@return <b>true</b>     <b>false</b>    */
	bool NET_Connect(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _name_connect, LPCTSTR license = _T(""),
							 LPCTSTR wait_text = 0, bool supress_dlg = false, bool load_titul_bd = true, LPCTSTR _domain = _T(""), bool bIsCurrDomainUser = false);

	/** @brief      .     , 
		   .    /,   ,
		  .     ,       
		type_license.
		@param type_license  ,    .     <br>
			0	    PSS
			1	    ILS
			   ,    "  "
		@return <b>true</b>     <b>false</b>    */
	bool NET_Connect(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _name_connect, DWORD connection_type,
		LPCTSTR wait_text = 0, bool supress_dlg = false, bool load_titul_bd = true, LPCTSTR _domain = _T(""), bool bIsCurrDomainUser = false);


	/**      -   .   HideMode==true  
		@param asked  true -      . 
		@return <b>true</b>     <b>false</b>    */
	bool Reconnect(bool /*asked*/ = true);

	/** @brief     ,       
		  .
		   NET_Connect  license   ,      
			 ,   licenseTypeMain;       
			 .
		   NET_Connect  license     ,     
			      license,    licenseTypeMain 
			 . 
		         licenseTypesAdd.
		@param[in] licenseTypeMain   
		@param[in] licenseTypesAdd     .     
			    .
		@return true   licenseTypeMain    false   . */
	static bool NET_LIC_SetRequestedLicenseTypes(LPCTSTR licenseTypeMain, CStringArray &licenseTypesAdd);

	/** @brief     ,       
			  ,      .
		@param[in] licenseTypeMain   
		@return true   licenseTypeMain    false   . */
	static bool NET_LIC_SetRequestedLicenseTypes(LPCTSTR licenseTypeMain);

	/**     ,     
		@param[out] licenseTypeMain
		@param[out] licenseTypesAdd    */
	static void NET_LIC_GetRequestedLicenseTypes(CString &licenseTypeMain, CStringArray &licenseTypesAdd);

	/**         */
	static CString NET_LIC_GetRequestedLicenseTypes();
	
	/**    ,       , 
		 .        ,  -  .
		      .
		@param[out] licenseTypes    */
	void NET_LIC_GetUsedLicenseTypes(CStringArray &licenseTypes);

	/**       ,     */
	CString NET_LIC_GetUsedLicenseTypes();
	
	/**             ,  
		  .
		@param[in] licenseType   
		@return true       , false    .
		*/
	bool NET_LIC_TestTakeLicense(LPCTSTR licenseType);

	/**    .      
		@param[in] licenseType   
		@return true             ;
			false             . */
	bool NET_LIC_FreeLicense(LPCTSTR licenseType);

	/**           IP  
		  , ,  -
		@param[in] s1   1
		@param[in] s2   2
	*/
	void NET_LIC_SetSeansParams(UINT32 s1, UINT32 s2 = 0);

	
	/**      
		@param _username      . 
		@param _pwd  
		@param _source    (     ).    DEF_SOURCE
		@return <b>true</b>     <b>false</b>    */
	bool NET_StartAdminMode2(LPCTSTR _username, LPCTSTR _pwd, LPCTSTR _source);
	bool NET_StartAdminMode2(int code1, int code2, LPCTSTR _source);
	
	/**        
	*/
	bool NET_ExitAdminMode();

	/**             
		@return <b>true</b>       <b>false</b>        */
	bool NET_SessionPartTest();

	/**    .     Oracle/Postgre      
			 session_parts ( postgre base_service.session_parts),      
			  ATTR_VAL_HISTORY     .
			       NET_SessionPartEnd    NET_SessionPartStart 
			    
		@param PartName    .
		@param SessionPartId       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SessionPartStart(LPCTSTR PartName, UINT32 *SessionPartId=0);
	/**    . 
		@param SessionPartId        
		@return <b>true</b>     <b>false</b>    */
	bool NET_SessionPartEnd(UINT32 *SessionPartId=0);

protected:
	int m_count_admin;
public:
	/** :        5.780  !!
		 ,             . 
	       2 ,      
	 ( ,     ..)        
	,           ,   
	 .
		         ,     
	 .
		@param time_in_minuts   ,       ,    
	.            . 
			 : 
				0 -     ,     
			    .
				-1 -     ,      
			  ,        .
		@return <b>true</b>     <b>false</b>    */
	bool NET_BeginLongOperation(int time_in_minuts);


	bool NET_GetOraAlias(int code1, int code2, CString &alias, CString &username, CString &password);


	
	/**    
		@return <b>true</b>     <b>false</b>    */
	bool NET_Disconnect();

	/**    ;      (   .)*/
	void ClearData();
	
	/**    */
	virtual void ClearDict();

	/** ,       
		@return <b>true</b>   , <b>false</b>   */
    bool IsConnected();
	

	/** ,             
		@return <b>true</b>  , <b>false</b>  */
	inline bool IsAdmin();
  
	/** ,         
		@return <b>true</b>    , <b>false</b>   */
	bool CheckModified();
	
	/** ,       . ,   
		  ,          
		  
		@return <b>true</b>    , <b>false</b>       */
	bool TestNeedRestore();

	/**             
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadDictionaryFromServer( LPCTSTR wait_text = 0);

	/* .     SaveDictionaryToMemory(dBuf) - LoadDictionaryFromMemory(dBuf);
	void GetFullDictName(CString &FullDictName);*/
	
	/**   ,     
		@return     ,    */
    CString GetNameCurrBase();

	/**   ,     
		@return     ,    */
    CString GetNameCurrConnection();

		/**       true,      
		@return true         ; false   */
	bool IsCurrConnectionLocal();

	/**   -   
		@return     ,    */
	CString GetNameCurrUser();

	/**     ,    
		@return     ,        */
	CString GetNameCurrDomain();

	/**  <B>instance</B>,  -   
		@return    0,    */
	CaplInstance* GetCurrUser();
	//bool SetCurrUser(CaplInstance* user);

	/**  ,         
		    (   CDoc::SetTitle(...)).
		@param name_bd      
		@param name_connect     
		@param name_user     
		@param name_person      (    !)
		@param pid     
		@return   */
	CString GetTitulCurrBD(bool name_bd = true, bool name_connect = false,
						bool name_user = true, bool name_person = true, bool pid = false);

	/**      
		@return  ,      */
	int NET_TuningConnections(int last_selected);
	
	//   .    -   
	bool ConnectWithTestLocal(CConnectInfo* cif, bool foreground_main_wnd = true, bool bDlgMode = true);

	//     ini   
	bool ReadConnectionsInfo();
	bool WriteConnectionsInfo();

	///    
	void GetListConnections(CStrArr &list);


	/**       
	@return <b>false</b>     <b>true</b>   */
	virtual bool TestCycleInRelation(CaplEntity *ent, CaplAttr *in_attr, CaplAttr *out_attr, CaplInstance *in_val, CaplInstance *out_val);

protected:
	//   (?)   .    AdminMode     
	aplExtent m_loaded_in_admin;
	CString m_LocalServerPath;
	//  
	CaplTAggr<CConnectInfo*,CConnectInfo*,APLAGGR_AUTOKILLREF|APLAGGR_LIST> m_list_connection;
	int m_max_connection_num;

	//     .     .
	CString m_ServerHashMethod;

public:
	//@}
	
	/**@name      */
	//@{

	/**     
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveChanges( LPCTSTR wait_text = 0);
	/**        ,    
		@param ext -   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveExtent(aplExtent &ext_saved, LPCTSTR wait_text = 0);
	bool NET_SaveExtent(CaplInstance* inst_saved, LPCTSTR wait_text = 0);

	/**          .    <b>CaplLoadData</b>     
		@param queries  
		@param count   
		@param ext_out   ,     <B>instance</B>,   
			       pagin.  pagin  ,     0
		@param placement      ,       .    0
		@param pagin  ,       ,   
			  pagin.start   pagin.size_p       pagin.size_all
		@param pagin_query_num  ,        ext_out. 
			  : 'e'  'r'  'b'
		@param wait_text ,        .       
		@param source    (     ).    DEF_SOURCE
		@param forced  false -    ,    
		,    ,     
		-   -    ,  
		  .  true -   )
		@return <b>true</b>     <b>false</b>    */
	bool NET_Load(apl_NET_LoadQuery *queries, INT32 count, aplExtent* ext_out = 0,
		CaplNetStepData* placement = 0, CaplPagin *pagin = 0, int pagin_query_num =-1,
		LPCTSTR wait_text = 0, CString source = _T(""), bool forced = false);


    /**          ext.    
     *  ,      .  
     *    -    .   std::list<AttrPath>
     *     .
     *  :    person_and_organization 
     *   the_person,    person   id  code, 
     *           personality  name. 
     *    ext  person_and_organization,     attr_paths:
     *  (a_persorg_the_person, {{a_pers_id}, {a_pers_code}, {a_user_person,e_user,'r',{a_user_name, a_user_person}}})
        @param ext  ,      
        @param attr_paths    
        @param attrs    
        @param ext_out   ,       <B>instance</B>,     .    0
     */
    bool NET_LoadExtAttrPaths(aplExtent &ext, std::list<AttrPath> attr_paths, aplExtent *ext_out = 0);
    bool NET_LoadExtAttrs(aplExtent &ext, std::list<CaplAttr*> attrs = std::list<CaplAttr*>(), aplExtent *ext_out = 0);
    bool NET_LoadInstAttrs(CaplInstance *inst, std::list<CaplAttr*> attrs = std::list<CaplAttr*>(), aplExtent *ext_out = 0);

private:
	// ,       'd'   NET_LoadExtAttrPaths
	bool m_is_correct_d_branch;
public:

	/**
		@brief SetLoafForced          (
			 forced   NET_Load).    NetStepData     ,
			            -
		@param forced  true -   .  false - 
		@return   
	*/
	static bool SetLoadForced(bool forced);

	/**      ,    */
	void ClearLastQuery();

	/**       */
	void SetLoadTimeOut(int time_out);

	/**         instance:  /, */
	void SetLoadInstUserDataTimeInfo(bool bCanLoad) {m_bCanLoadInstUserDataTimeInfo = bCanLoad;}
	bool CanLoadInstUserDataTimeInfo() const {return m_bCanLoadInstUserDataTimeInfo;}

	/**            ( ). 
		 0 -       ( , )
	*/
	void SetWaitTimeOutWithoutDlg(int time_out);
	UINT RenewClientStateOnServer();

	/**   <B>instance</B>,   
		@param ext   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadDelInst(aplExtent &ext, LPCTSTR wait_text = 0);

	/**       /  , 
		/  <B>instance</B>
		@param data  ,      ,  
			   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadInstUserDataTimeInfo(CaplTAggr<SInstInfo*,SInstInfo*,APLAGGR_AUTOKILLREF> &data, LPCTSTR wait_text = 0);
	
	/**         /  , 
		/  <B>instance</B>
		@param ext_in  <B>instance</B>,    
		@param comments   (  )   instance. 
					           0
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_ViewInstUserDataTimeInfo(aplExtent &ext_in, CArray<CString,CString> *comments = 0, LPCTSTR wait_text = 0);
	//@}
	
	///       id.        auto_load == true,    
	CaplInstance* GetInstById(int id, bool auto_load = true, bool load_attr = false);
	
	/**@name     */
	//@{

	/**@name   */
	//@{

	/**     <B>instance</B>  ,   
		    .
	     .
		@param entity   <B>instance</B>
		@param tested_inst  <B>instance</B>;    0
		@param count   
		@param values   
		@param is_substring        .
			<b>true</b> -     <B>instance</B>, 
			    ,    .
			<b>false</b>   <B>instance</B>    
		@param wait_text ,        .       
		@return <b>true</b>  tested_inst  (,  tested_inst== 0 -     ),
				<b>false</b>   ,   tested_inst   */
	bool NET_TestUniqueAttrValues(CaplEntity *entity, CaplInstance *tested_inst, int count,
										CaplAttrValue *values, bool is_substring, LPCTSTR wait_text = 0, bool bIgnoreSpace = false);

	/**         <B>instance</B>,  , 
		      .
	     .
		@param entity   <B>instance</B>
		@param tested_inst <B>instance</B>, 
		@param count   
		@param values   
		@param bIgnoreSpace  true,      
		@param wait_text ,       
		@return <b>true</b>  tested_inst  (,  tested_inst== 0 -     ),
				<b>false</b>   ,   tested_inst   */
	virtual bool TestUniqueAttrValues(CaplEntity *entity, CaplInstance *tested_inst,
					int count, CaplAttrValue *values,bool bIgnoreSpace = false);

	/**         <B>instance</B>,  , 
		      .
	     .
		@param entity    <B>instance</B>
		@param tested_inst <B>instance</B>, 
		@param count   
		@param values   
		@param wait_text ,       
		@return <b>true</b>  tested_inst  (,  tested_inst== 0 -     ),
				<b>false</b>   ,   tested_inst   */
	virtual bool TestUniqueAttrValuesBN(LPCTSTR entity, CaplInstance *tested_inst,
					int count, CaplAttrValue *values);

	//@}
	/**@name   */
	//@{
	
	/**        <B>instance</B>  ,   ,
	  
		@param entity   <B>instance</B>
		@param count   
		@param values   
		@param extent_out  
		@param is_substring        .
			<b>true</b> -     <B>instance</B>, 
			    ,    .
			<b>false</b>   <B>instance</B>    
		@param match_case:          .
			<b>true</b> -  ("Id"!="id"), <b>false</b> -   ("Id"=="id"=="iD")
		@param wait_text ,        .       
		@param string_bind_mode     .    is_substring==true
		@return   <B>instance</B>*/
	int NET_FindInstancesWithAttrValues2(CaplEntity *entity, int count, CaplAttrValue *values,
		aplExtent &extent_out, bool is_substring, bool match_case = false, LPCTSTR wait_text = 0,
		aplStringBindMode string_bind_mode = aplSBMiddle, bool bIgnoreSpace = false, LPCTSTR _source = _T(""));
	   
	/**      <B>instance</B>  ,   , 
	  
		@param entity   <B>instance</B>
		@param tested_inst Instance,  
		@param count   
		@param values   
		@param extent_out  
		@param is_substring        .
			<b>true</b> -     <B>instance</B>, 
			    ,    .
			<b>false</b>   <B>instance</B>    
			@param match_case:          .
			<b>true</b> -  ("Id"!="id"), <b>false</b> -   ("Id"=="id"=="iD")
		@param test_only   . <b>true</b> -     
			<B>instance</B>     1; <b>false</b> -     
			 ;    <B>instance</B>
		@param string_bind_mode     .    is_substring==true
		@param only_new -  true,   extent_out     ( id== 0)
		@param bIgnoreSpace -  true,       
		@return   <B>instance</B>*/
	int FindInstancesWithAttrValuesInLocalCache(CaplEntity *entity, CaplInstance *tested_inst,
						int count, CaplAttrValue *values, aplExtent &extent_out, 
						bool is_substring, bool match_case, bool test_only,
						aplStringBindMode string_bind_mode = aplSBMiddle, bool only_new = false,
						 bool bIgnoreSpace = false);

	//@}
	/**@name        */
	//@{
	
	/**     ,     STEP_QL.
		@param query_lng  
		@param is_dlg     .  <b>true</b> -  
			,       <b>query_lng</b>; <b>false</b> -   .
		@param errmsg     ,       
		@param is_dlg_ro     ,     : 
			1)   0    
			2)   1,       ""  ReadOnly
			    " ".     
			" ",      0
			3)    ( ""  "")  ReadOnly
		@param name   (    CaplAPI)
		@param save2bd     (    CaplAPI)
		@param make_table_result      (    CaplAPI)
		@return <b>true</b>     <b>false</b>    */
	bool NET_QueryEditParse(CString &query_lng, bool is_dlg = false, CString *errmsg = 0,
		int *is_dlg_ro = 0, CString *name = 0, bool *save2bd = 0, bool *make_table_result = 0);

	/**        ,     STEP_QL.
		@param query_lng  
		@param end_of_edit call-back- ,     .   
			   DWORD -  ,      NET_QueryEditParseNoModal.
			         NET_QueryExecuteEx
		@param id_calling_object   ,    call-back- 
		@param query    ,       .  
			   NET_QueryExecuteEx       .  
			    "",     0.
		@param errmsg     ,       
		@param is_dlg_ro     ,     : 
			1)   0    
			2)   1,       ""  ReadOnly
			    " ".     
			" ",      0
			3)    ( ""  "")  ReadOnly
		@param name   (    CaplAPI)
		@param save2bd     (    CaplAPI)
		@param make_table_result      (    CaplAPI)
		@return <b>true</b>     <b>false</b>    */
	bool NET_QueryEditParseNoModal(CString &query_lng,
		int (__cdecl *end_of_edit)(DWORD *), DWORD id_calling_object, CaplQLQueryParse **query, CString *errmsg = 0,
		int *is_dlg_ro = 0, CString *name = 0, bool *save2bd = 0, bool *make_table_result = 0);
	
	/**     <B>instance</B>,  ,    <b>NET_QueryEditParse</b>
		@param ext  
		@param count_res   .         .    
		       ext -    ,     
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_QueryExecute(aplExtent &ext, LPCTSTR wait_text = 0);
	bool NET_QueryExecute(aplExtent &ext, LPCTSTR wait_text, LPCTSTR source);
	bool NET_QueryExecute(DWORD &count_res, LPCTSTR wait_text, LPCTSTR source);

	/**     <B>instance</B>,   query,    <b>NET_QueryEditParse</b>
		@param query ,     NET_QueryEditParseEx
		@param ext  
		@param count_res   .         .    
		       ext -    ,     
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_QueryExecuteEx(CaplQLQueryParse* query, aplExtent &ext, LPCTSTR wait_text);
	bool NET_QueryExecuteEx(CaplQLQueryParse* query, aplExtent &ext, LPCTSTR wait_text, LPCTSTR source);
	bool NET_QueryExecuteEx(CaplQLQueryParse* query, DWORD &count_res, LPCTSTR wait_text, LPCTSTR source);
	
    /**      STEP_QL.
        @param query_lng  
		@param ext   
        @param pagin  ,       ,   
              pagin.start   pagin.size_p       pagin.size_all
        @param wait_text ,        .    
             "  "
        @param source       (     )
        @return <b>true</b>     <b>false</b>      StepQL  
                 .      
             GetLastAplErrorDescription() */
    bool NET_QueryExecute(LPCTSTR _query_lng, aplExtent &ext, CaplPagin *pagin = 0, LPCTSTR wait_text = 0, LPCTSTR source = 0);

	//@}


protected:
    //void aplAppendBufValueEx(CaplDataBuf &data, CaplValue *value);
	//       
	bool FeelTestFindBuf(CaplDataBuf &dbuf, CaplEntity *ent, CaplInstance *test_inst,
		int count, CaplAttrValue *values, bool is_substring, bool match_case, aplStringBindMode string_bind_mode, bool *bIgnoreSpace = 0);

	bool m_processed_set_error;
public:

	
	/**@name    */
	//@{

	/**           .      
	  .
		@param users        ,   
		@param access      ,   
		@return true     Ok  false,   
    */
	bool SelectAplUsers(aplExtent &users, aplAccessModeType &access);
	
	/**  ,     (,     )  <B>instance</B>,
	 *	  <b>extent</b>.
		@param extent  pInstance    
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetInstancesAccess(aplExtent* extent, LPCTSTR wait_text = 0);

	/**    <b>user</b>   <b>access_def</b>  <B>instance</B>,
		  <b>extent</b>.
		  :
		<b>user</b>==-1 --          ( "  ")
		    access
		<b>user</b>== 0  <b>access_def</b>== -1 --     
		 :
		
		        (  ),
		    -  -  .,  
		          .
		     ,     
		   (  ),    
		  ,     .
		   ,  ,      ,   
		    ""
		  
		@param extent  pInstance    
		@param user     
		@param access_def   
		@param wait_text ,        .       
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetInstancesAccess(aplExtent* extent, CaplInstance* user, aplAccessModeType access_def, LPCTSTR wait_text = 0,
								CaplInstance *access_pattern_inst = (CaplInstance *)-1, bool only_show = false);
	bool NET_SetInstancesAccessBI(aplExtent* extent, CaplInstance* user, aplAccessModeType access_def, LPCTSTR wait_text = 0,
								CaplInstance *access_pattern_inst = (CaplInstance *)-1, bool only_show = false, int code1 = 0, int code2 = 0);
	//    .         
	// :
	//  *)    code1  code2 -       .
	//  *)         (       
	//		   -     
	bool NET_SetSpecialInstancesAccess(aplExtent* extent, CaplInstance* user, aplAccessModeType access_def, LPCTSTR wait_text = 0,
								int code1 = 0, int code2 = 0);

		
	/**     <b>ext</b>  (   ,     ), 
	 *    <b>str_pattern</b><br>
		@param extent -  instance,    
		@param str_pattern -  <br>
	 : <id >:< >;<id >:< >;...<br>
		<id > -  instance  "apl_workgroup"  "apl_user"<br>
		< > -   :<p>
			OWN -  <br>
			RW -   -<br>
			RO -    <br>
			NA -  <br>
		   (';')     <br>
		     <br>
		     ,  <id >   0;
	     .<br>
		     ,  <id >   1;
	     .<br>
		      ,  <id >   2;
	     <br>
		<p>
		:     ;   RO    (  )
		5176:RO;22809:RO;
		<br>    " ";       (  )
		0:RO;11042:OWN
		<br>    " ";     
		0:RO;1:OWN
		<br> ,     ,     . 
		   -    .   
		        , 
		       
		@param wait_text ,        .    
		  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetAccessFromPattern(aplExtent* extent, CString &str_pattern,
												LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);
	bool NET_SetAccessFromPatternBI(aplExtent* extent, CString &str_pattern,
												LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);


	/**     <b>extent</b>  (   ,     ), 
	 *   ,      <b>access_pattern_inst</b>    
	 *  apl_access_pattern,     pattern    (   NET_SetAccessFromPattern).<br>
        @param extent -  instance,    
		@param access_pattern_inst   apl_access_pattern       .
		@param wait_text ,        .    
			  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetAccessFromPatternInst(aplExtent* extent, CaplInstance *access_pattern_inst,
												LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);

	/**     <b>extent</b>  (   ,     ) 
	 *       <b>pattern_name</b><br>
		@param pattern_name -   ,     .   -    apl_access_pattern;
			     name
		@param wait_text ,        .    
			  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetAccessFromPatternName(aplExtent* extent, CString &pattern_name,
												LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);

	/**        "" (aplOWNER)  <B>instance</B>,
		  <b>extent</b>.      
		   " " (aplRO)
		@param extent  pInstance    
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_BecomeInstancesOwner(aplExtent* extent, LPCTSTR wait_text = 0);
	
	/**       <B>instance</B>,   
		<b>main_table</b>
		@param main_table    : instance   (apl_user)- -    
		@param wait_text ,        .    
		  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetGroupeAccess(aplUsers &main_table, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);
protected:
	bool NET_SetGroupeAccessInternal(aplUsers &main_table, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);
public:

	/**     pattern      destination
		@param pattern ,    
		@param destination  ,    
		@param wait_text ,        .    
		  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_CopyGroupeAccess(CaplInstance* pattern, aplExtent &destinations, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);	

	/**          patterns    
		 destination.        patterns      destination,  
		   patterns      destination  ..      ,
		 .
		@param patterns  ,    
		@param destination  ,    
		@param wait_text ,        .    
			  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_CopyAccessFromInst2Inst(aplExtent &patterns, aplExtent &destinations, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);


	/**      <B>instance</B>,   <b>main_table</b>
		@param main_table   : instance   (apl_user)- -    
		@param wait_text ,        .    
			  
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetGroupeAccess(aplUsers &main_table, LPCTSTR wait_text = 0);

	/**    <B>instance</B>,   <b>ListAccess</b>
		@param ListAccess   : instance -    -   -    (apl_user)- 
			  
		@param wait_text ,        .    
			  
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetGroupeAccessBI(aplListAccess2Inst &ListAccess, LPCTSTR wait_text = 0);

	/**    <B>instance</B>,   <b>ListAccess</b>
		@param ListAccess   : instance -    -   -    (apl_user)- 
			  
		@param wait_text ,        .    
			  
		@param code1 
		@param code2 
		@return <b>true</b>     <b>false</b>    */
	bool NET_SetGroupeAccessBI(aplListAccess2Inst &ListAccess, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);
protected:
	bool NET_SetGroupeAccessBIInternal(aplListAccess2Inst &ListAccess, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);
public:

	/**   ,      instance   
		@param extent -  ,     
		@param destination -      
		   .  NET_SetAccessFromPattern
		@param for_user -  false,     ;   , 
			   -
						-  true,       ;     ,
			     -.
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetExtentAccess2String(aplExtent &extent, CStringArray &destination, bool for_user=true, LPCTSTR wait_text = 0);
	bool NET_GetExtentAccess2StringBI(aplExtent &extent, CStringArray &destination, bool for_user=true, LPCTSTR wait_text = 0);
	
	/**  ,     instance 
		@param inst - ,     
		@param destination -     
		   .  NET_SetAccessFromPattern
		@param for_user -  false,     ;   , 
			   -
						-  true,       ;     ,
			     -.
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetExtentAccess2String(CaplInstance* inst, CString &destination, bool for_user=true, LPCTSTR wait_text = 0);

	/**     (  ) <b>access_agent</b>  ,   <B>extent</B>
		@param extent -    
		@param access_agent -    ,     
		@return <b>true</b>     <b>false</b>    */
	bool NET_RemoveAccessAgent(aplExtent &extent, CaplInstance* access_agent, LPCTSTR wait_text = 0, int code1 = 0, int code2 = 0);

	/**       
		*/
	bool NET_RefreshAccessPatterns();

	/** ,          
		@param access_pattern_inst -   
		@return <b>true</b>     <b>false</b>    */
	bool NET_IsUsedAccessPattern(CaplInstance* access_pattern_inst);

	/** ,            ext_access_pattern_inst
		@param ext_access_pattern_inst    (  apl_access_pattern)  
		@param used   ,     ext_access_pattern_inst.       
			 : 1      , 0 -   
		@return <b>true</b>     <b>false</b>    */
	bool NET_IsUsedAccessPatterns(aplExtent &ext_access_pattern_inst, CUIntArray &used);

	/**          
		@param access_pattern_inst -   
		@param users -  
		@return <b>true</b>     <b>false</b>    */
	bool NET_WherePatternUsed(CaplInstance* access_pattern_inst, CUIntArray &users);

	//       
	bool NET_GetString4DupSession(CString &spetial_string);

	/** ,       .    -         <b>true</b>.
	  -    <b>iMilliseconds</b> ,    .     ()   -  <b>false</b>
	 -      ( ) -   <b>false</b>
	     : 1)   SaveChange 2)   ,    .
	 lite       .
		@param instance -   
		@param extent -    
		@param iMilliseconds -   ,     .     50  -   50.
		@return <b>true</b>  ()    <b>false</b>  ()          */
	bool NET_LockInstanceForChange(CaplInstance *instance, int iMilliseconds);
	bool NET_LockInstancesForChange(aplExtent &extent, int iMilliseconds);


	/**      ,    
        @param str_pattern -   .    
			   .  NET_SetAccessFromPattern.     
			     
		@param definition -    ,      
		@return <b>true</b>     <b>false</b>    */
	bool PrepareAccessStringPattern(CString &str_pattern, CString *definition = 0);

	// ,       <B>instance</B>
	bool CheckOwner(aplExtent* extent, bool *is_RO = 0);
	// ,    <B>instance</B>
	bool CheckSaved(aplExtent* extent);

	//      
	bool NET_ServiceOp(BYTE command, CStringArray &list_strings, CaplDataBuf *dbuf_test = 0);


protected:
	bool CheckGUIDAccessDict();
	bool LoadGUIDAccess(CStringArray &GUIDs, CaplStrMap &GUID2inst);

public:
	//      LSS-  GUID 
	//    .      apl_GUID_access    
	bool SetGUIDAccess(CStringArray &GUIDs, bool read_only = false);
	//          GUID,      access_def ( 
	//	 ), access_pattern ( ), individual_access (  ;  in -   CaplInstance*  
	// apl_user,  out -     )
	//   / GUID     ,  aplOWN -      
	//    !
	bool SetGUIDAccess(CStringArray &GUIDs, aplAccessModeType access_def, CaplInstance* access_pattern, CaplMap &individual_access);
	//      GUID
	bool DelGUIDAccess(CStringArray &GUIDs);
	//     in GUID     apl_GUID_access;  
	//         out    
	bool GetGUIDAccess(CaplStrMap &GUIDs);
	// ,       <B>GUID</B>
	bool CheckGUIDOwner(CStringArray &GUIDs, bool *is_RO = 0);
	//       GUID-
	bool CopyAccessFromInst2GUIDs(CaplInstance* source, CStringArray &GUIDs);
	//        
	bool CopyInstAttrs(CaplInstance *from, CaplInstance *to);

	//     
	bool LoadAllUsers(aplExtent &users);
	CaplInstance* IsUserCorrect(LPCTSTR username, LPCTSTR password);
	void FillConnectionList(CComboBox &SelectConnection, LPCTSTR def_value, int &cur_select_connection);
	void SetSingleAlias(LPCTSTR SingleAlias);
protected:
	//     
	//bool MakeExtFromDbuf(CaplDataBuf &dbuf,aplExtent &ext); -  ,   apploadfromdb
	CString m_SingleAlias;
public:
	
	//@}

	//   -    
	#define RETURN_GA_PARENT  const {return CaplStepData::GetAttr(inst,attr,value);}
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, CaplValue &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, int &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, double &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, CString &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, pCaplInstance &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, bool &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, CaplAggr &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, aplExtent &value)RETURN_GA_PARENT;
	bool GetAttr(CaplInstance *inst, CaplAttr *attr, _std_string &value)RETURN_GA_PARENT;

/*	   -       .   
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, CaplValue **value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, CaplValue &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, int &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, double &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, CString &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, pCaplInstance &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, bool &value);
	bool GetAttrBN(CaplInstance *inst,LPCTSTR attr_name, CaplAggr &value);
*/
	
	/**@name     */
	//@{
protected:
	//     (       )
	__int64 m_MaxBlobSize;
public:

	/**         
		@param file_source   ( )
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	// 4del - ,       
	//bool NET_SaveFile2Spetial(LPCTSTR file_source, LPCTSTR wait_text = 0);

	/**               <B>instance</B>
		@param inst <B>instance</B>,    
		@param attr_name  ,     BLOB-
		@param file_source   ( )
		@param code      -  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveBlobBN(CaplInstance *inst, LPCTSTR attr_name, LPCTSTR file_source, long &code, LPCTSTR file_name = 0, LPCTSTR wait_text = 0, int crc32 = 0);

	/**               <B>instance</B>
		@param inst <B>instance</B>,    
		@param attr ,     BLOB-
		@param file_source   ( )
		@param file_name       source  apl_stored_document.   -     file_source
		@param code      -  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveBlob(CaplInstance *inst, CaplAttr *attr, LPCTSTR file_source, long &code, LPCTSTR file_name = 0, LPCTSTR wait_text = 0, int crc32 = 0);

	/**                 <B>instance</B>
		@param inst <B>instance</B>,    
		@param attr ,     BLOB-
		@param source    
		@param size_source   
		@param code      -  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveFileFromMemory(CaplInstance *inst, CaplAttr *attr, BYTE* source, long size_source, long &code, LPCTSTR wait_text = 0, int crc32 = 0);	

	/**  BLOB       <B>instance</B>  
		@param inst <B>instance</B>,      BLOB-
		@param attr_name  ,     BLOB-
		@param file_dest    ( )
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadBlobBN(CaplInstance *inst, LPCTSTR attr_name, LPCTSTR file_dest, LPCTSTR wait_text = 0);

	/**  BLOB       <B>instance</B>  
		@param inst <B>instance</B>,      BLOB-
		@param attr ,     BLOB-
		@param file_dest    ( )
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadBlob(CaplInstance *inst, CaplAttr *attr, LPCTSTR file_dest, LPCTSTR wait_text = 0);

	/**  BLOB         
		@param _ServNameBLOB  BLOB- (  ),    
		@param _ServNameFileDest    ( )   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveBlob2Srv(LPCTSTR _ServNameBLOB, LPCTSTR _ServNameFileDest, LPCTSTR wait_text = 0);
	
	/**  BLOB         
		@param inst <B>instance</B>,      BLOB-
		@param attr ,     BLOB-
		@param global_file_dest    ( )   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_SaveBlob2Srv(CaplInstance *inst, CaplAttr *attr, LPCTSTR _ServNameFileDest, LPCTSTR wait_text = 0);

	/**          BLOB  
		@param name_blob  BLOB- (  ),     
		@param global_file_src    ( )   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_CreateBlobFromSrv(LPCTSTR global_file_src, CString &name_blob, LPCTSTR wait_text = 0);

	/**          BLOB  
		@param inst <B>instance</B>,       BLOB-
		@param attr ,       BLOB-
		@param global_file_src    ( )   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_CreateBlobFromSrv(CaplInstance *inst, CaplAttr *attr, LPCTSTR global_file_src, LPCTSTR wait_text = 0);
	
	/**    BLOB       
		@param _ServNameBLOB  BLOB- (  ),    
		@param file_dest    ( )
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadFileFromSrv(LPCTSTR _ServNameBLOB, LPCTSTR file_dest, LPCTSTR wait_text = 0, LPCTSTR ext_info = 0);


	/**     BLOB      .       
	"blob_[ ].tmp".         -  
		@param blob_ids   BLOB-
		@param folder_dest  ,     
		@param blob_names   ;     
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadMultiBlobsFromSrv(CUIntArray &blob_ids, LPCTSTR folder_dest, CStringArray &blob_names, LPCTSTR wait_text = 0);

	/**     ,      ,       . 
		@param system    
		@param mask   ,    
		@param list_files    ,   ,   
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_Autoupdate_LoadListNamesFiles(LPCTSTR system, CStringArray &list_masks,
									CaplTAggr<SaplFileDescr*,SaplFileDescr*,APLAGGR_LIST_OR_AUTOKILLREF> &list_files, LPCTSTR wait_text = 0);

	/**     ,      ,     
		@param system    
		@param folder_dest  ,     
		@param list_files   ,   .     
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_Autoupdate_LoadListFiles(LPCTSTR system, LPCTSTR folder_dest, CStringArray &list_files, LPCTSTR wait_text = 0);

	/**     BLOB-     <B>instance</B>
		@param inst <B>instance</B>,     BLOB-
		@param attr ,     BLOB-
		@param blob_size  BLOB-.    -1.     long     2   .
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetBlobSize(CaplInstance *inst, CaplAttr *attr, long &blob_size, LPCTSTR wait_text = 0);
	bool NET_GetBlobSize(CaplInstance *inst, CaplAttr *attr, __int64 &blob_size, LPCTSTR wait_text = 0);

	/**      BLOB-
		@param _ServNameBLOB  BLOB-    
		@param blob_size  BLOB-.    -1.     long     2   .
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_FileSrvSize(LPCTSTR _ServNameBLOB, long &blob_size, LPCTSTR wait_text = 0);
	bool NET_FileSrvSize(LPCTSTR _ServNameBLOB, __int64 &blob_size, LPCTSTR wait_text = 0);

	/**     BLOB-     <B>instance</B>
		@param extent  <B>instance</B>,     BLOB-
		@param attr ,     BLOB-
		@param blob_size  BLOB-.     CUIntArray        2   .
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetBlobSize(aplExtent &extent, CaplAttr *attr, CUIntArray &blob_sizes, LPCTSTR wait_text = 0);
	bool NET_GetBlobSize(aplExtent &extent, CaplAttr *attr, C__int64Array &blob_sizes, LPCTSTR wait_text = 0);


	/**  BLOB       <B>instance</B>  
		@param inst <B>instance</B>,      BLOB-
		@param attr ,     BLOB-
		@param blob_dest    BLOB-
		@param size_buf  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadBlob2Memory(CaplInstance *inst, CaplAttr *attr, BYTE* blob_dest, long &size_buf, LPCTSTR wait_text = 0);

	/**  BLOB       <B>instance</B>  
		@param inst <B>instance</B>,      BLOB-
		@param attr_name  ,     BLOB-
		@param blob_dest    BLOB-
		@param size_buf  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadBlob2MemoryBN(CaplInstance *inst, LPCTSTR attr_name, BYTE* blob_dest, long &size_buf, LPCTSTR wait_text = 0);
	
	/**    BLOB     
		@param _ServNameBLOB  BLOB-    
		@param blob_dest    BLOB-
		@param size_buf  
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_LoadFileFromSrv2Memory(LPCTSTR _ServNameBLOB, BYTE* blob_dest, long &size_buf, LPCTSTR wait_text = 0, LPCTSTR ext_info = 0);

	/**  BLOB       <B>instance</B>
		@param inst <B>instance</B>,      BLOB-
		@param attr_name  ,     BLOB-
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_DeleteBlobBN(CaplInstance *inst, LPCTSTR attr_name, LPCTSTR wait_text = 0);

	/**         <B>instance</B>
		@param inst <B>instance</B>,      BLOB-
		@param attr ,     BLOB-
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_DeleteBlob(CaplInstance *inst, CaplAttr *attr, LPCTSTR wait_text = 0);
	bool NET_DeleteBlob(LPCTSTR _ServNameBLOB, LPCTSTR wait_text = 0, int inst_id = 0, int attr_id = 0);

	///      -  
	int GetBlobPortionDefSize();


	/**      BLOB         
		@param _ServNameBLOB  BLOB-    
		@param blob_dest     BLOB-
		@param size_buf   (      )
		@param last  true,     =
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_ReadFirstPortionFileFromSrv2Memory(LPCTSTR _ServNameBLOB, BYTE* blob_dest, long &size_buf, bool &last, LPCTSTR wait_text = 0);

	/**        BLOB-
		@param blob_dest     BLOB-
		@param size_buf   (      )
		@param last  true,     =
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_ReadNextPortionFileFromSrv2Memory(BYTE* blob_dest, long &size_buf, bool &last, LPCTSTR /*wait_text*/ = 0);

	
	//@}
	
	/**@name    */
	//@{

	/**    <b>attr</b>
		@return  */
    int GetAttrId(CaplAttr *attr);

	/**     <b>entity</b> c  <b>attr_name</b> 
		@return  */
	int GetAttrIdBN(CaplEntity *entity, LPCTSTR attr_name);

	/**   <b>entity</b>,   <b>ent</b>
		@return  <b>entity</b>*/
	int GetEntId(CaplEntity *ent);

	/**   <b>entity</b>  ,   <b>ent_name</b> 
		@return  <b>entity</b>*/
	int GetEntIdBN(LPCTSTR ent_name);

	/**   <b>instance</b>,   <b>inst</b>
		@return  <b>instance</b>*/
	int GetInstId(CaplInstance *inst);

	/**        -  true.  - false
		@return */
	bool IsAttrStoreBLOB(CaplAttr* attr);

	//@}

	// 
	virtual bool GetAttr(CaplInstance *inst, CaplAttr *attr, CaplValue **value);

protected:
	//           
	int m_count_cur_users;
	CaplInstance *m_def_curr_user, *m_def_curr_user_group;
public:
	inline bool TemporaryCurrUsersCreate()
	{
		m_def_curr_user = GetInstById(1);
		m_def_curr_user_group = GetInstById(2);
		if(m_count_cur_users > 0 && (m_def_curr_user == 0 || m_def_curr_user_group == 0)){	return false;}
		if(m_def_curr_user == 0){m_def_curr_user = CaplStepData::CreateInstance(m_ent_apl_user, true);}
		if(m_def_curr_user_group == 0){m_def_curr_user_group = CaplStepData::CreateInstance(m_ent_apl_workgroup, true);}
		if(m_def_curr_user == 0) return false; 
		if(m_def_curr_user_group == 0) return false;
		if(m_count_cur_users == 0)
		{ 
			m_def_curr_user->SetId(1); 
			PutAttr(m_def_curr_user, m_attr_apl_user__name, CString(_T(" ")) + UserNameDecode(m_def_curr_user, true, true));
			m_def_curr_user_group->SetId(2); 
			PutAttr(m_def_curr_user_group, m_attr_apl_user__name,  CString(_T(" ")) + UserNameDecode(m_def_curr_user_group, true, true));
			aplExtent ext_def_curr_user; ext_def_curr_user.Add(m_def_curr_user_group);
			PutAttr(m_def_curr_user, m_attr_apl_user__grop, ext_def_curr_user);
		}
		m_count_cur_users++;
		return true;
	}
	inline void TemporaryCurrUsersDelete()
	{
		m_count_cur_users--;
		if(m_count_cur_users == 0)
		{
			CaplStepData::DeleteInstanceForced(m_def_curr_user);
			CaplStepData::DeleteInstanceForced(m_def_curr_user_group); 
			m_def_curr_user = 0; m_def_curr_user_group = 0; 
		}
	}


	///   INI
	/// ,       ini
	bool CheckIniWrite(){return m_Ini.CheckWrite();}

	///    ini ,     NetStepData
	///  s   -   GetIniFullName
	///   / / ini
	bool GetIniParameter(LPCTSTR group_name, LPCTSTR key_name, CString &value, bool isExpandRelatedPath = false);
	int GetIniParameter(LPCTSTR group_name, LPCTSTR key_name);

	///    ini ,    
	///  s   -   GetIniFullName
	///   / / ini
	bool WriteIniParameter(LPCTSTR group_name, LPCTSTR key_name, LPCTSTR value);

protected:

	//     
	CaplQLQueryParse* m_query;
	int m_PercentSCh;
	//        <B>instance</B>
	bool _SaveExtToDataBuf(CaplDataBuf &dbuf, aplExtent &inSavInst, aplExtent &outSavInst, aplExtent &ext4attr);

	//        (    )
	bool PutExtToDataBuf(aplExtent &ext, CaplDataBuf &dbuf);

	long m_changed_thread;
	long m_external_exit;

	//   AplTransport.ini
	CaplINI m_Ini;

	//    (    exe,   ini   ..)
	bool InitAppName();

	//    (    protected
	//CaplAttr *FindAttr(CaplEntity *entity, LPCTSTR attr_name){
	//	return CaplStepData::FindAttr(entity, attr_name);
	//};


	//    ,   
	//    TCP   
	// !    !
	/*  dialog_mode: 
		CONNECT_DLG_MODE__SUPRESS    ,    -   
		CONNECT_DLG_MODE__ONLY_ERROR        ( username,  name_connect  ..)
		CONNECT_DLG_MODE__SHOW_ALVAYS   
	*/
	bool ConnectWithParam(int dialog_mode);

	//         
	bool ReadLastActive(CStringArray &reg_user_list, CString &reg_base, CStringArray &reg_domain_list);
	bool WriteLastActive(CStringArray &reg_user_list, CString name_base, CStringArray &reg_domain_list);

	//     ,  ,      
	void AppendString2List(CStringArray &list, CString &new_string);

	//             http
	bool ReadLastProxyList(CStringArray &proxy_list);
	bool WriteLastProxyList(CStringArray &proxy_list, bool clear = false);
	
	//   -          
	CaplNetStepData* m_local_data;

	//  ,     
	CaplMap m_list_attrs4blobs;

	//   
	CString m_type_lic_current;
	//   ,   
	CStringArray m_types_lic_adt;

	CStringArray m_reg_user_list;
	CStringArray m_reg_domain_list;
	bool m_ShowLastUser;
	int m_NumLastUsers;
	int m_NumLastDomains;

	//  true                   NET_SaveChanges
	bool m_SetAccessWithSave;
	CaplTAggr<aplUsers*,aplUsers*,APLAGGR_AUTOKILLREF> m_ListDelaedAccess;
	CaplTAggr<aplListAccess2Inst*,aplListAccess2Inst*,APLAGGR_AUTOKILLREF> m_ListDelaedAccessBI;

	//  true (  )             
	bool m_IsActualizeChangedAggr;

	//   ini  [Options]SetAccessShowInst=1         
	bool m_SetAccessShowInst;

	bool m_hide_mode;

	CaplStrStrMap m_bd_parameters;
	
	//   /      
	CaplMap m_not_compared_aggr;
	
	//  ,        
	//   
	bool m_check_cur_access_befor_set_access;
	//   
	bool m_check_cur_access_after_set_access;


public:
	//    m_IsActualizeChangedAggr (	//  true (  )             )
	bool NET_SetActualizeChangedAggr (bool bEnable) {bool bOld = m_IsActualizeChangedAggr ; m_IsActualizeChangedAggr = bEnable ; return bOld ;} ;
	bool NET_GetActualizeChangedAggr (bool /*bEnable*/) {return m_IsActualizeChangedAggr;} ;

	/**@name   */
	//@{
	///    
	bool NET_GetLicenseStatus(CString &status, long &code);
	///   ,   
	bool NET_GetActiveUserList(CaplTAggr <CaplInstance*, CaplInstance*, APLAGGR_LIST> &ext, LPCTSTR wait_text = 0, CUIntArray *array_ip = 0);
	bool NET_GetActiveUserList(CaplTAggr<SUserLogInfo*,SUserLogInfo*,APLAGGR_AUTOKILLREF> &ListConnects, bool only_me = false, LPCTSTR wait_text = 0);
		
	/**      .  lite/   ,  ORACLE / PostgreSQL     */
	bool NET_GetServerDateTime(COleDateTime &odt);
	CString NET_GetServerDateTime();

	///          
	bool ShowAttrsHistoryDlg();
	///   ,   ,        
	bool NET_GetAttrsHistoryEntities(CArray<CaplEntity*,CaplEntity*> &list_active, CArray<CaplEntity*,CaplEntity*> &list_all, aplExtent &users, LPCTSTR wait_text = 0);

	///     
	bool NET_GetAttrsHistory(SQAH_Filter &filter, CaplTAggr<SQAH_Info*,SQAH_Info*,APLAGGR_LIST_OR_AUTOKILLREF> &list_rez, LPCTSTR wait_text = 0);

	/**          
		@param attr ,    
		@param count_in_result  ,     
		@param values   
		@param real_size      
		@param source    (     ).    DEF_SOURCE
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool NET_GetAllAttrValues(CaplAttr* attr, DWORD count_in_result, CaplTAggr <CaplValue*,CaplValue*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> &values, DWORD &real_size,
								LPCTSTR source = 0, LPCTSTR wait_text = 0);


	///   ,     .    id 
	/// in -  , out -   CaplAttr
	bool NET_GetAttrs4Blobs(CaplMap &list_attrs, LPCTSTR wait_text = 0);


	///    
	bool NET_QueryUsersLog(CaplTAggr<SUserLogInfo*,SUserLogInfo*,APLAGGR_AUTOKILLREF> &array, LPCTSTR wait_text = 0, QUL_Filter* filter = 0);

	/**    
	@param mode  :
	0 -    ( array   )
	1 -  ,    array (   - ;  
		  SUserLogInfo   )
	2 -  ,     0   array (   
		-  ;    SUserLogInfo   )*/
	bool NET_ClearUsersLog(CaplTAggr<SUserLogInfo*,SUserLogInfo*,APLAGGR_AUTOKILLREF> &array, int mode, LPCTSTR wait_text = 0);	

	///    
	bool NET_LoadBDInfo();
	///         .    -  
	bool NET_GetBDStringInfo(LPCTSTR param_name, CString &param_value);
	CString NET_GetBDStringInfo(LPCTSTR param_name);
	///   -,           SaveChange
	void AppendNotComparedAggr(CaplInstance *inst, CaplAttr *attr);

/*
	CaplSQLResult myValues[5];
	myValues[0].field="sss";
	myValues[0].type=aplString;
	aplRunSql("", myValues ,5)
*/
	///     Oracle  PostgreSQL!  SQL       -
	bool NET_RunSql(LPCTSTR sql, SaplSQLResult *result, int count, SaplSQLError* oracle_error,
				int code1 = 0, int code2 = 0, LPCTSTR wait_text = 0, LPCTSTR sql_prev = 0, LPCTSTR source = _T("")); 
	///     Oracle  PostgreSQL!  SQL      
	bool NET_RunSqlReturnExtent(LPCTSTR base_sql, aplExtent &result, SaplSQLError* oracle_error,
					LPCTSTR sql_get_result = 0, int code1 = 0, int code2 = 0, LPCTSTR wait_text = 0, bool load_all_attrs = false, LPCTSTR source = _T("")); 

	/**        .   ORACLE/PostgreSQL  is_oracle==true,
	 log_name   
		@param log_name     (       )
		@param message 
		@param is_oracle  true   ORACLE/PostgreSQL -     Clients_log (   3000 )
		@return <b>true</b>     <b>false</b>    */
	bool NET_WriteLog(CString log_name, CString message, bool is_oracle = false);

	/**     Oracle  PostgreSQL!
	 *                .    
	 *  ,   ,    "\\\\   ", 
	 *  60 ,    
        @param doc ,    
		@param num_readed       ,      
		@param log_name   
		@param message  ,      
		@param is_oracle  true,      Clients_log  .  false,   
		@return <b>true</b>     <b>false</b>    */
	bool NET_ControlAccessDocAndWriteLog(CaplInstance *doc, long &num_readed, CString log_name, CString message, bool is_oracle = false);
	
	/// 
	bool NET_Test(LPCTSTR wait_text = 0, int id = 0, int id2 = 0);

	/// 
	bool NET_RunUpdateDictionary(CString new_dict_path = _T(""), bool autostart = false);
protected:
	bool NET_RunUpdateDictionaryInt(CString new_dict_path);

	SUserLogInfo* ReadUserLogInfoFromDataBuf(CaplDataBuf &dbuf, int i_ver_buf);
public:
	bool NET_RunApp(CString app_name, CString cmd_line, bool print2log);


	//            ini
	void ForceAutoReconnect();

	///     
	void SetAutoDownloadMode(bool mode);

    /**     . !   ini   Options\SetAccessWithSave -  
	       ini    ,   ini.
		@param mode  true -            ;     
				      NET_SaveChanges    
		@return     */
	bool SetModeSetAccessWithSave(bool mode);
	
	///      
	bool GetAutoDownloadMode();
	
	///      
	bool SetNetErrorMessageMode(bool mode);
	
	///     (   )
	///   
	bool SetHideMode(bool mode = false);
	bool GetHideMode();

	///      
	bool SetPortionSavedInst(int size);
	///          
	int GetPercentSCh();
	
	void Detach();
	void Attach();
	void SetHalt();

	//   temporary instance     BLOB -        
	//     -    .      
	CaplTAggr<CaplDataBuf*,CaplDataBuf*,APLAGGR_LIST_OR_AUTOKILLREF> m_query_temporary_data;

	//  ,        
	//   
	//   
	void SetCheckCurAccess(bool befor_set_access, bool after_set_access);
	
	//     ,  ,  false
	//       pss.ver    
	bool IsVersionOk();

	bool ReadFromBuferUserArray(CaplDataBuf &buf_out, aplAccessList *list, int start_in_portion, int size_in_user);
	bool AppendInBufUserArray(CaplDataBuf &buf_in, aplAccessList *list, int start_in_portion, int size_in_user, aplExtent* ext = 0, bool setaccess = false);

	bool WriteLocalLog(LPCTSTR message);
	bool WriteLocalLog(aplLogMode minLogMode, LPCTSTR message); //           minLogMode

	bool SetApplicationCloseFunction(long (__cdecl *_application_close_funct)(LPVOID), LPCTSTR message = 0);

	//  MessageBox c    inst
	void ShowInstancesDebugInfo(CaplInstance *inst1, CaplInstance *inst2 = 0, CaplInstance *inst3 = 0, CaplInstance *inst4 = 0, CaplInstance *inst5 = 0);	
	void ShowExtentDebugInfo(aplExtent  *ext);				//  MessageBox c   ext
	void PrintInstanceDebugInfo(CaplInstance *inst, CString &str); //     inst
	void PrintQuery(CString &query_lng_out);

	//      
	bool RecoveryInst(CaplInstance* ciInst);

#ifdef _DEBUG
	CString m_csTestFileName;

#endif

};


#define NET_StartAdminMode(par1, par2) NET_StartAdminMode2(par1, par2, DEF_SOURCE)


/**        <B>instance</B>  ,   ,
  .       ("Id"  "id" -    ).
        
	@param entity   <B>instance</B>
	@param count   
	@param values   
	@param extent_out  
	@param is_substring        .
		<b>true</b> -     <B>instance</B>,
		    ,    .
		<b>false</b>   <B>instance</B>    
	@return   <B>instance</B>*/
#define NET_FindInstancesWithAttrValues(entity ,count, values, extent_out, is_substring) \
			NET_FindInstancesWithAttrValues2(entity, count, values, extent_out, is_substring, false, 0, aplSBMiddle, false, DEF_SOURCE)

/**        <B>instance</B>  ,   ,
  .      ("Id"  "id" - )
      id  
	@param entity   <B>instance</B>
	@param count   
	@param values   
	@param extent_out  
	@param is_substring        .
		<b>true</b> -     <B>instance</B>,
		    ,    .
		<b>false</b>   <B>instance</B>    
	@return   <B>instance</B>*/
#define NET_FindInstancesWithAttrValuesMatchCase(entity ,count, values, extent_out, is_substring) \
			NET_FindInstancesWithAttrValues2(entity, count, values, extent_out, is_substring, true, 0, aplSBMiddle, false, DEF_SOURCE)



class CaplStr2InstMap:public CaplMap{
	// in -   , out - instance
public:
	int Add(CString* str, CaplInstance* inst){return CaplMap::Add((long)str, (long)inst); }
	void SortStr(){qsort(Data, Size, sizeof(aplMap_element), CompareInstId); }
	int static CompareInstId( const void *p1, const void *p2)
	{
		aplMap_element *i1, *i2;
		i1 = ((aplMap_element*)p1);
		i2 = ((aplMap_element*)p2);
		return ((CString*)i1->in)->CompareNoCase(*(CString*)i2->in);
	}
	CaplInstance* GetInstByIndx(int indx){ return (CaplInstance*)Data[indx].out; }
	CString* GetStrByIndx(int indx){ return (CString*)Data[indx].in; }
	void Clear(){ for(int i = 0; i<Size; i++){ delete GetStrByIndx(i); }CaplMap::Clear(); }
	virtual ~CaplStr2InstMap(){ Clear(); }
};

class CLASS_DECL_APL_NSD CaplParentWndProcesser
{
public:
	CaplParentWndProcesser(CaplNetStepData* data=0, CWnd* parent=0)
	{
		m_setted = false;
		SetDataParentWnd(data, parent);
	}
	CaplParentWndProcesser(CaplNetStepData& data, CWnd* parent=0)
	{
		m_setted = false;
		SetDataParentWnd(&data, parent);
	}
	void SetDataParentWnd(CaplNetStepData* data, CWnd* parent)
	{
		m_data = data;
		m_oldParentWnd = NULL;
		//    
		if(m_setted)
			return;
		if(m_data != 0)
		{
			m_oldParentWnd = m_data->GetParentWnd();
			m_data->SetParentWnd(parent);
			m_setted = true;
		}
	}
	~CaplParentWndProcesser()
	{
		if(m_data != 0) 
			m_data->SetParentWnd(m_oldParentWnd);
	}
protected:
	CaplNetStepData* m_data;
	CWnd* m_oldParentWnd;
	bool m_setted;
};

//        Wait     
//       ,     
//        CaplNetStepData,   .
#define CORRECT_LOOSE_MODAL(CaplData) CaplParentWndProcesser pwp(CaplData,this);

//        Wait     
//       CaplParentWndProcesser m_pwp
//      CaplParentWndProcesser pwp     OnInitDialig     
#define CORRECT_LOOSE_MODAL_ON_CLASS(CaplData)  m_pwp.SetDataParentWnd(CaplData,this);

//  
#define CORRECT_LOOSE_MODAL_WITH_WINDOW(CaplData, pWnd)  CaplParentWndProcesser pwp(CaplData,pWnd);

//       inst1    inst2.      .   bUseSelect====true -     Select  Aggr
// bAutoRun==true -    (  )
// bAutoHide==true -     .    bAutoRun==true
bool AFX_EXT_API aplReplaceInstance(CaplNetStepData *data, CaplInstance *inst1, CaplInstance *inst2, bool bUseSelect, bool bAutoRun = false, bool bAutoHide = false);

//       inst1.      .   bUseSelect====true -     Select  Aggr
//  ext_with_ref !=-      inst.
//  sReport  != 0 -      
bool AFX_EXT_API aplFindAllInstanceRef(CaplNetStepData *data, CaplInstance *inst1, bool bUseSelect, aplExtent *ext_with_ref, CString *sReport);

// ,   ,   filename
//    -  ,    
//   filename   
bool AFX_EXT_API CheckAndCreateFolder(LPCTSTR filename);

//  email    server 
//      true,  err_mess -  
//   - false,  err_mess -  .
bool AFX_EXT_API SendSimpleEMail(CString &err_mess, LPCTSTR server, LPCTSTR recipient_email,
								 LPCTSTR sender_email, LPCTSTR sublect, LPCTSTR message);


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.


#endif // !defined(AFX_aplNetStepData_H__53498523_74F0_11D3_B380_00C026EE2281__INCLUDED_)
