/*****************************************************************\
            Author:  .
              Date: 
              
              File: sl_struct.h
   Version of file: 0.10
           Progect: AplNetTransportServTCP
Version of project: 3.0
              
             Notes:    ,   
		     ORACLE   
              
\******************************************************************/
#ifndef APL_SL_STRUCT_H
#define APL_SL_STRUCT_H

#include "aplSocketTransport.h"

#define SPEC_LIC_TYPE _T("XXX-YYY-ZZZ")
#define SPEC_LIC_MESS APL_T("<>")

#define SL_VER_UNKNOWN 0xFFFFFFFF
#define SL_VER_OBSOLETE 0
//                 
#define SL_DESCR_DEL_COUNTER 5

//  1100 - ReportConstructor   
//  1102 -    ( 2024)
//  1104 -     ( 2024)
#define VER_SL_DATA_OLD 1100
#define VER_SL_DATA_1102 1102
#define VER_SL_DATA 1104

enum eSLBufGeneration
{
	SLBufGen_0 = 0,
	SLBufGen_1 = 1,
	SLBufGen_2 = 2
};


#define LIC_MODE_DEFAULT	0x0

/////////////////////////////////////////////////////////////////////////////
//     
#define ERR_MESSAGE_SL_CONNECTING APL_T("    ...")
#define ERR_MESSAGE_SL_NOT_CONNECT APL_T("    !")
//#define ERR_MESSAGE_SL_KEY_NOT_FOUND APL_T("    !")
#define ERR_MESSAGE_SL_MISSED_VERSION APL_T("   !")

// -   
//         -        SL_CONNECT_ATTEMPT_TICK 
#define SL_CONNECT_ATTEMPT_TICK 5000
//     (, )           SL_REQUEST_TIME 
#define SL_REQUEST_TIME 5000



/****************************************************************************/
/*  -> 
/****************************************************************************/
enum EaplSLCommand: UINT32
{
	apl_SL_ADD		= 0,	//    /  
	apl_SL_DELETE	= 1,	//   
	apl_SL_GET_LIC	= 2,	//       
	apl_SL_GET_DATE	= 3,	//       
	apl_SL_RENEW	= 4,	//        
	apl_SL_GET_VER	= 5,	//   /  
	apl_SL_REVOKES	= 6		//      
};


struct SOCKET_TRANSPORT_API apl_SL_PS_DATA{
public:
	apl_SL_PS_DATA(){
		ver=VER_SL_DATA;	server_ip=0; server_port=0; client_id_m=0;client_id_s1=0;client_id_s2=0;client_ip=0;
		type_license=0xFFFFFFFF;data_1=0xFFFFFFFF;data_2=0xFFFFFFFF;data_3=0xFFFFFFFF;
	}
	long Get(){return ver;}
	void Set(long _ver){ver=_ver;}
	bool ReadFromIterator(CaplDataBufEx &dbuf, eSLBufGeneration mode);
	bool Add2Iterator(CaplDataBufEx &dbuf, eSLBufGeneration mode);
	bool Compare(apl_SL_PS_DATA *p_sl_data);
	EaplSLCommand command; // long action;
	UINT32 server_ip;	//Ip      (      win  lin)
	UINT32 server_port; 
	UINT32 client_id_m; //  
	UINT32 client_id_s1; //   
	UINT32 client_id_s2; //   
	UINT32 client_ip;
	UINT32 type_license;
	UINT32 data_1;
	UINT32 data_2;
	UINT32 data_3;
protected:
	UINT32 ver;
};

//  
#define apl_NUMBER_0  0xB0B322F3
#define apl_NUMBER_1  0x18BE4EC6
#define apl_NUMBER_2  0x4AE0F28B  
#define apl_NUMBER_3  0x2CD645D8
#define apl_NUMBER_4  0x6951F63E
#define apl_NUMBER_5  0x164957A8
#define apl_NUMBER_6  0x5AF0E6CA
#define apl_NUMBER_7  0x12DB0261
#define apl_NUMBER_8  0x7E86BA85
#define apl_NUMBER_9  0x4D0600B1

#define HEADER_ACCESS_BUFER_N_V_001 _T("HEADER_ACCESS_BUFER_N_V_001")


struct SOCKET_TRANSPORT_API SLTransportData
{
	SLTransportData();
	SLTransportData(SLTransportData *src);
	void Set(SLTransportData *src, bool bAllData=false);
	void Get(apl_SL_PS_DATA *dest, CStringArray &types, CaplStrMap &indexes);
	bool Compare(SLTransportData *src);
	bool Read(CaplDataBufEx& dbuf);
	bool Write2Iterator(CaplDataBufEx& dbuf);
	//   
	UINT32 SL_ip;
	UINT32 SL_port;
	////////     
	// 
	EaplSLCommand command;
	//   
	UINT32 Client_ip;
	UINT32 client_id_m; //  
	UINT32 client_id_s1; //   
	UINT32 client_id_s2; //   

	//   .        
	UINT32 server_ip;
	UINT32 server_port;
	//  
	CString Type_license;
	///////     
	//   -       
	UINT32 is_use_by_date;
	DATE dt;
	//     
	UINT32 key_error;
	// 
	int aplError;
	//      
	CString SL_status;
};



class SOCKET_TRANSPORT_API CServLicDescription
{
public:
	CServLicDescription(UINT32 sl_ip, UINT32 sl_port);
	~CServLicDescription();

public:
	/**
		    arr_transport_data       .
		     apl_SL_ADD ( )  apl_SL_DELETE    
			        .
		              
			    m_transport_data.
		  ""  " ",          
			     
	*/
	bool ProcessRequest(CaplTAggr<SLTransportData*, SLTransportData*, APLAGGR_AUTOKILLREF> &arr_transport_data);
	//    .
	inline bool ProcessRequest(){CaplTAggr<SLTransportData*, SLTransportData*, APLAGGR_AUTOKILLREF> arr; return ProcessRequest(arr);}

	bool RemoveClient(int client_id);
	void AddClient(UINT32 client_id)
	{
		CaplEnterCriticalSection ecs(&m_data_protect);
		m_list_clients_users.Add(client_id, 0);
		m_live_counter = SL_DESCR_DEL_COUNTER;
	}

	inline UINT32 GetSLPort(){return m_sl_data.SL_port;};
	inline UINT32 GetSLIp(){return m_sl_data.SL_ip;};
	inline CString GetStatus(){return m_sl_data.SL_status;}
	inline CString GetErrDescr(){return m_ErrDescr;}

	//          ; 0-  ;   0 - 
	//        ( 15), -1 -      
	static void SetTimeLogStatLicense(int _TimeLogStatLicense);

	int m_TimeLogStatLicense;
	inline void LogStatistic(){if(m_TimeLogStatLicense != 0 && m_num_request != 0){LogStatisticB();}}
	void LogStatisticB();

	CaplMap m_list_clients_users;

	int m_live_counter;
	DWORD m_SL_ver;

	//     
	DWORD m_time_request_max;
	DWORD m_time_request_all;
	DWORD m_num_pakets_max;
	DWORD64 m_num_pakets_all;
	DWORD64 m_num_request;
	COleDateTime m_odt_stat_print;

	CAplCriticalSection m_data_protect;

protected:
	bool TestConnect();
	bool ProcessRequestData();
	bool ProcessRequestVer();

	CaplTimeMeter m_LastTick;
	DWORD m_last_bad_tick;

	bool m_old_ver;

	CaplSocketClient m_slSocket;

	bool m_messagin_err;
	bool m_after_halt;

	CaplTAggr<SLTransportData*, SLTransportData*, APLAGGR_LIST_OR_AUTOKILLREF> m_list_sl_queries;

	//       -   apl_SL_RENEW  " "
	SLTransportData m_sl_data;

	CString m_class_info;
	CString m_ErrDescr;
};


bool SOCKET_TRANSPORT_API EnMaskSL_PS_DATA(apl_SL_PS_DATA *p_sl_data, const char* mask_data, int mask_size);

#endif // APL_SL_STRUCT_H

