// OptionsDlg.cpp : implementation file
//

#include "stdafx.h"
//#include "	\ add additional includes here"
#include "OptionsDlg.h"
#include "sel_fold.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//extern TCHAR def_ext[];
/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(COptionsDlg::IDD, pParent)
	, m_source(0)
{
	//{{AFX_DATA_INIT(COptionsDlg)
	m_module = _T("");
	m_fold = _T("");
	m_hours = 0;
	m_autoupdate = FALSE;
	//}}AFX_DATA_INIT
}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionsDlg)
	DDX_Control(pDX, IDC_AUTOUPDATE, m_autoupdate_ctrl);
	DDX_Control(pDX, IDC_HOURS, m_hours_ctrl);
	DDX_Control(pDX, IDC_STATIC_HOUR, m_st_hours_ctrl);
	DDX_Control(pDX, IDC_STATIC_EVRY, m_hours_evry_ctrl);
	DDX_Control(pDX, IDC_FOLDER, m_fold_ctrl);
	DDX_Text(pDX, IDC_MODULE, m_module);
	DDX_Text(pDX, IDC_FOLDER, m_fold);
	DDX_Text(pDX, IDC_HOURS, m_hours);
	DDV_MinMaxUInt(pDX, m_hours, 0, 48);
	DDX_Check(pDX, IDC_AUTOUPDATE, m_autoupdate);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_COMBO_SELECT_SOURCE, m_CtrlSelectSource);
	DDX_Control(pDX, IDC_DIR_BRWS, m_FolderSelect);
	DDX_CBIndex(pDX, IDC_COMBO_SELECT_SOURCE, m_source);
}


BEGIN_MESSAGE_MAP(COptionsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(COptionsDlg)
	ON_BN_CLICKED(IDC_DIR_BRWS, OnDirBrws)
	ON_BN_CLICKED(IDC_AUTOUPDATE, OnAutoupdate)
	//}}AFX_MSG_MAP
	ON_CBN_SELCHANGE(IDC_COMBO_SELECT_SOURCE, &COptionsDlg::OnCbnSelchangeComboSelectSource)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

int __stdcall BrowseProc(HWND hwnd,UINT uMsg, LPARAM lParam, LPARAM lpData )
{
	TCHAR szDir[MAX_PATH];
	COptionsDlg* dlg=(COptionsDlg*)lpData;
	CString str;

	switch(uMsg)
	{
	case BFFM_INITIALIZED:
		// Set the initial directory. If WPARAM is TRUE, then LPARAM is a
		// string that contains the path. If WPARAM is FALSE, then LPARAM
		// should be a lovely PIDL
		if(dlg!=0)
		{
			dlg->m_fold_ctrl.GetWindowText(str);
			SendMessage(hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)(LPCTSTR)str);
		}
		break;
	case BFFM_SELCHANGED:
		SHGetPathFromIDList((LPITEMIDLIST)lParam, szDir);
		SendMessage(hwnd, BFFM_SETSTATUSTEXT,0, (LPARAM)szDir);
		break;
	case BFFM_VALIDATEFAILED:
		AfxMessageBox(APL_T("        !"));
		break;
	}
	return 0;
}

void COptionsDlg::OnDirBrws() 
{
	CString buf;

	m_fold_ctrl.GetWindowText(buf);

// 	CAutoUpdateSelectFolderDialog dlg(TRUE, buf,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY ,	NULL, NULL);
// 	dlg.SetSelectedPath(buf);
// 	if(dlg.DoModal()==IDOK)
// 	{
// 		buf=dlg.GetSelectedPath();
// 		m_fold_ctrl.SetWindowText(buf);
// 	}

	bool success=false;
	LPITEMIDLIST selected_d=0;
	CoInitialize(0);
	TCHAR			szPath[MAX_PATH];
	HRESULT			hr;
	_sprintf(szPath,_T("::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"));

	BROWSEINFO lpbi;
	lpbi.hwndOwner=this->m_hWnd; 
	lpbi.pidlRoot=selected_d; 
	lpbi.pszDisplayName=new TCHAR[MAX_PATH]; 
	lpbi.lpszTitle=APL_T("    "); 
	lpbi.ulFlags=BIF_RETURNONLYFSDIRS|BIF_STATUSTEXT;//| BIF_NEWDIALOGSTYLE; 
	lpbi.lpfn=BrowseProc; 
	lpbi.lParam=(long)this; 

	selected_d=SHBrowseForFolder(&lpbi); 
	if(selected_d!=0){
		BOOL bres=SHGetPathFromIDList(selected_d,szPath);
		m_fold_ctrl.SetWindowText(szPath);
	}

	LPMALLOC ppMalloc;
	hr=SHGetMalloc(&ppMalloc);
	ppMalloc->Free(selected_d);
	delete lpbi.pszDisplayName;

	success=true;
	CoUninitialize();

}

void COptionsDlg::OnAutoupdate() 
{
	if(m_autoupdate_ctrl.GetCheck())
	{
		m_hours_ctrl.EnableWindow(TRUE);
		m_hours_evry_ctrl.EnableWindow(TRUE);
		m_st_hours_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_hours_ctrl.EnableWindow(FALSE);
		m_hours_evry_ctrl.EnableWindow(FALSE);
		m_st_hours_ctrl.EnableWindow(FALSE);
	}
}

BOOL COptionsDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	int pos;
	pos=m_CtrlSelectSource.AddString(APL_T("    "));
	m_CtrlSelectSource.SetItemData(pos,0);
	pos=m_CtrlSelectSource.AddString(APL_T("     PSS"));
	m_CtrlSelectSource.SetItemData(pos,1);

	m_CtrlSelectSource.SetCurSel(m_source);
	
#ifndef _DEBUG
//	m_CtrlSelectSource.EnableWindow(FALSE);
#endif
	OnCbnSelchangeComboSelectSource();
	OnAutoupdate();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionsDlg::OnOK() 
{
	// TODO: Add extra validation here
	BOOL res=UpdateData(TRUE);
	if(res==FALSE) return;
	if(m_source==0)
	{
		m_fold.TrimLeft();
		m_fold.TrimRight();
		if(m_fold==_T(""))
		{
			if(IDNO!=AfxMessageBox(APL_T("     .   !!!\n    ?"),MB_YESNO)) return;
		}
		if(m_fold!=_T(""))
		{
			if(m_fold[m_fold.GetLength()-1]!=_T('\\'))
			{	
				m_fold+=_T('\\');
				m_fold_ctrl.SetWindowText(m_fold);
			}
		}
	}
	CaplTranslateDialog::OnOK();
}


void COptionsDlg::OnCbnSelchangeComboSelectSource()
{
	// TODO: Add your control notification handler code here
	if(m_CtrlSelectSource.GetCurSel()==0)
	{
		m_fold_ctrl.EnableWindow(TRUE);
		m_FolderSelect.EnableWindow(TRUE);
	}
	else
	{
		m_fold_ctrl.EnableWindow(FALSE);
		m_FolderSelect.EnableWindow(FALSE);
	}
}
