#include <wincrypt.h>

#pragma once

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0500
#endif
//#define _WINVER 0x0400


#ifdef  APL_CRYPT_CLASS_EXPORT_DLL
#define  APL_CRYPT_CLASS_EXPORT	__declspec(dllexport)
#else
#define  APL_CRYPT_CLASS_EXPORT	__declspec(dllimport)

#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"aplCryptManager_ud.lib")
#else
#pragma comment (lib,"aplCryptManagerD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"aplCryptManager_u.lib")
#else
#pragma comment (lib,"aplCryptManager.lib")
#endif
#endif
#endif


#define APL_CRYPT_MGR _T("AplCryptManager")
#define APL_CRYPTO_PRO_34_10_2001 _T("APL    34.10-2001")
#define APL_CRYPTO_PRO_34_10_2012 _T("APL    34.10-2012")
#define APL_OPENSSL_34_10_2001 _T("APL OpenSSL   34.10-2001")
#define APL_CSP_REG_ROOT _T("Software\\CALS Centre \"Applied Logistic\"\\Apl Cryptographic Provider\\CSP\\")

#define APL_CSP_2001 0 //    APL_CRYPTO_PRO_34_10_2001
#define APL_CSP_2012 1 //    APL_CRYPTO_PRO_34_10_2012


#define MY_ENCODING_TYPE  (PKCS_7_ASN_ENCODING | X509_ASN_ENCODING)
#define APL_CRYPT_NO_ERROR			0
#define APL_CRYPT_UNKNOWN_ERROR		1
#define APL_CRYPT_INVALID_HASH		2
#define APL_CRYPT_INVALID_SIGNATURE	3
#define APL_CRYPT_BAD_FILE			4
#define APL_CRYPT_BAD_PASSWORD		5
#define APL_CRYPT_NO_SIGN			6
#define APL_ERROR_DO_NOT_SHOW		7
#define APL_CRYPT_INVALID_CERT		8
#define APL_CRYPT_NO_CRYPTOPRO		9 //    
#define APL_CRYPT_NO_RSA		   10 //    RSA
#define APL_CRYPT_NO_OSSL		   11 //    OpenSSL
#define APL_CRYPT_ERROR_IMPORT_OPEN_KEY 12
#define APL_CRYPT_ERROR_RET_CREATE_KEY 13 //   " "


#define APL_CRYPT_INVALID_PARAM		21  //     
#define APL_CRYPT_NO_MEM_4_RESULT	22

//    
enum ESignMode {APL_SIMPLE_MODE=0, APL_QUICK_MODE_WITH_DLG=1, APL_QUICK_MODE_WITHOUT_DLG=2, APL_MODE_WITHOUT_DLG_4_TGB=3};

class APL_CRYPT_CLASS_EXPORT CaplCryptographicManager
{
public:

	struct TCertInfo
	{
		//   ,     , 
		//   
		bool bCheckRootKey;
		CStringArray saConfidentOpenKeys;

		//   
		CString sOpenKey;
		CString sCertFilePath;
		//CString sUserName;
		CString sUserRoles;
		CString sFullName;
		CString sSerialNumber;

		//  
		CString sSurName;			// SN = 
		CString sGivenName;			// G =  
		CString sTitle; 			// T =  	
		CString sStreet;			// STREET =   , .17
		CString sCommonName;		// CN =   
		CString sMail;				// E = ivanov@tupolev.ru
		CString sOrganization;		// O =  ""
		CString sOrganizationUnit;  // OU =
		CString sLocality;			// L = 
		CString sRegion;			// S = 77 . 
		CString sCountry;			// C = RU
		COleDateTime dNotBefor;
		COleDateTime dNotAfter;

		CString sNewContainer;				//  ,         
		CString sNewContainerPath;			//   
		CString sNewContainerPassword;		//    

		//    
		CString sContainerCA;				//   
		CString sPasswordCA;				//   
		CString sContentContainerCA;		//   (,    "sContainerCA")

		//  
		BYTE *pbRootCertBlob;
		DWORD nRootCertBlobSize;

		//  
		CString sSystem;
	};


	CaplCryptographicManager();
	~CaplCryptographicManager();

	/* Public Operations */
	static bool EditCSPSet();	//       (    ..  )

	ESignMode SetSignMode(ESignMode mode);

	void ResetSignTime(); //    (   

	static bool CheckCryptoProProvaider2001(); //   	    2001.
	static bool CheckCryptoProProvaider2012(); //   	    2012.

	// forsign==false,      	
	// forsign==false,    ,   
	static BOOL GetAllCSP(CStringArray &allValues, bool forsign);	
	
	static CString GetDefaultCSP(); //      	
	static bool SetDefaultCSP(CString sNameDefCSP); //      	

	/************************************************************************/
	/*						                             */
	/************************************************************************/
	// sUserName -   
	//  lBufferLen==0,   pszBuffer -    
	//  pszBuffer -     lBufferLen

	int Sign(LPCTSTR sUserName, LPCTSTR sPassword, byte* pszBuffer, long lBufferLen, CString &sHash, CString &sOpenKey, CString &sSignature, CString &sCert, CString sSystem, bool &bOldFormat, CStringArray &saKeys, char *addInfo, int infoSize);	
	int SignEx(bool doCheckEqualName, LPCTSTR sUserName, LPCTSTR sPassword, byte* pszBuffer, long lBufferLen, CString &sHash, CString &sOpenKey, CString &sSignature, CString &sCert, CString sSystem, bool &bOldFormat, CStringArray &saKeys, char *addInfo, int infoSize);	
	
	// RSA (Windows) (sUserName -   )
	int SignNewContainer(LPCTSTR sUserName, LPCTSTR sPassword, byte* pszBuffer, long lBufferLen, CString &sHash, CString &sOpenKey, CString &sSignature, CString &sCert, char *addInfo, int infoSize);
	int SignNewContainerEx(bool doCheckCorrectName, LPCTSTR sUserName, LPCTSTR sPassword, byte* pszBuffer, long lBufferLen, CString &sHash, CString &sOpenKey, CString &sSignature, CString &sCert, char *addInfo, int infoSize);
	int SignOldContainer(LPCTSTR sPassword, byte* pszBuffer, long lBufferLen, CString &sHash, CString &sOpenKey, CString &sSignature, CString &sCert, char *addInfo, int infoSize);

	// 
	int csp_Sign(void *data_buffer, DWORD data_buffer_len, CString &user_name, CString &cert_file_name, CString &sHash, CString &sOpenKey, CString &sSign, char *addInfo, int infoSize, int cspParamMode);


	/************************************************************************/
	/*						                                 */
	/************************************************************************/
	//  lBufferLen==0,   buffer      
	//   buffer    lBufferLen

	// RSA (Windows)
	int rsa_CheckSign(void *buffer, long lBufferLen, CString sHash, CString sOpenKey, CString sSignature, char *addInfo, int infoSize);
	int rsa_CheckSign(void *buffer, long lBufferLen, CString sHash, BYTE *pbCertBlob, int nCertBlobSize, CString sSignature, char *addInfo, int infoSize);
	
	// 
	int csp_CheckSign(void *data_buffer, long data_buffer_len, CString &sHash, BYTE *pbKeyBlob,  DWORD dwBLen, CString &sSign, char *addInfo, int infoSize, int cspParamMode);	
	int csp_CheckSign(void *data_buffer, long data_buffer_len, CString &sHash, CString &sOpenKey, CString sSign, char *addInfo, int infoSize, int cspParamMode);
	
	// OpenSSL
	int ossl_CheckSign(void *buffer, long lBufferLen, LPCTSTR sHash, LPCTSTR sOpenKey, LPCTSTR sSignature, char *addInfo, int infoSize);
	int ossl_CheckSign(void *buffer, long lBufferLen, LPCTSTR sHash, BYTE *pbCertBlob, int nCertBlobSize, LPCTSTR sSignature, char *addInfo, int infoSize);


	/************************************************************************/
	/*						                                  */
	/************************************************************************/
	//    (  +  		
	//  buf_len==0,   buffer      
	//   buffer    buf_len

	bool GetHash(void *buffer, long buf_len,  LPCTSTR szCryptSystem, CString &sHash);
	
	// RSA (Windows)	{hHash   : if(hHash) CryptDestroyHash(hHash);}
	bool rsa_GetHash(void *buffer, long buf_len, HCRYPTHASH &hHash, CString &sHash, char *addInfo, long infoSize);
	
	//   {hHash   : if(hHash) CryptDestroyHash(hHash);}
	int csp_GetHash(void *data_buffer, DWORD data_buffer_len, CString &ErrorDescr, HCRYPTPROV &hProv, HCRYPTHASH &hHash, CString &strHash, char *addInfo, int infoSize, int cspParamMode);

	// OpenSSL  (bHash,   0,      32 )
	bool ossl_GetHash(void *buffer, long buf_len, CString &sHash, BYTE *bHash, char *addInfo, long infoSize);


	/************************************************************************/
	/*					  					*/
	/************************************************************************/

	bool CreateKey(TCertInfo &certInfo, bool bRoot=false);
	
	//     	
	bool GetPrivateKeyFromContainer(BYTE *&pbData, int &nLenght, CString sContainerCA, CString sPassword, CString container);
	
	// 	   		
	static bool CheckPassword(CString sContainerCA, CString sPassword); //   
	static bool CheckPasswordByContentOfFile(CString sContent, CString sPassword);  //   

	//  
	static bool ChangePassword(CString sContainerCA, CString sPassword); //   
	static bool ChangePasswordByContentOfFile(CString sContent, CString sPassword);  //   


	/************************************************************************/
	/*				   			            	*/
	/************************************************************************/

	//          
	static bool GetDataFromCertFile(LPCTSTR cert_file, CString &sSubject, CString &sOpenKey, COleDateTime &dNotBefore, COleDateTime &dNotAfter, CString &sIssuer, CString &sCertSerialNum, CString &sAlgorithm); 
	static bool GetDataFromCert(const BYTE *cert_buf, DWORD  cert_size, CString &sSubject, CString &sOpenKey,	COleDateTime &dNotBefore, COleDateTime &dNotAfter, CString &sIssuer, CString &sCertSerialNum, CString &sAlgorithm); 

	//     (   
	static bool  GetKeyUsageFromCert(CString sCertFile, CStringArray &saKeyUsage);

	//     ,    		
	static void GetOpenKeyFromCertInContainer(CString sPath, CString &sKey);

	//  ,    	
	static bool GetCertFromContainer(CString sPath, CString sContent, BYTE *&pbData, DWORD &dSize);

	//    	
	static bool GetCertSubjectNameAndSN(CString sCert, CString& sSubjName, CString& sSN, CString& sRoles, COleDateTime &tBefore, COleDateTime &tAfter);
	static bool GetCertSubjectNameAndSN(BYTE *pbCert, int dwSLen, CString& sSubjName, CString& sSN, CString& sRoles, COleDateTime &tBefore, COleDateTime &tAfter);

	//       "CN=, S=..."
	static CString GetParamFromSubject(CString str, CString sParam); 

	//   c     	
	static bool ParseCertificateParams(CString str, CStringArray &saValues);

	/************************************************************************/
	/*				  CRL    	        	*/
	/************************************************************************/

	//       
	void GetInfoFromCRL(CString sCRLPath, CStringArray &saSNandRevocationDate);

	//   	
	int CreateCRL(CStringArray &saSNcert, CArray<COleDateTime, COleDateTime> &RevocationDate, TCertInfo &certInfo);

	//       
	PCCERT_CONTEXT FindCertificate(LPSTR szCertName, LPSTR szStore,	DWORD dwFlags, PCRYPT_DATA_BLOB *KeyId,	HCRYPTPROV *hProv, LPDWORD dwKeyType);
	static bool AddCertToStore(CString sPath); ///   		

	static int GetPublicKey(LPCTSTR sFile, LPCTSTR sPassword, CString &sOpenKey);	//
	
	static long GetCRC32(char *data,long size);
	static bool _xOR_Revers(BYTE* from, const DWORD fromlen, BYTE* to, const DWORD tolen);
	static bool _xOR_Revers(BYTE* from, const DWORD fromlen, const CString &to);
	static bool ReadFromFile(LPCTSTR szFileName, void* pvBuffer, int &iBufferSize);
	static bool WriteToFile(LPCTSTR szFileName, void* pvBuffer, int &iBufferSize);

	static CString GenRandom(); //     8   
	static CString CreateRandomGUIDString();
	
	static void StrToByte(DWORD cb, LPCSTR sz, BYTE* pv);
	static void ByteToStr(DWORD cb, void *pv, LPSTR sz);
	static void ByteToStr(DWORD cb, void *pv, CString  &sz);

	static bool Date2String(COleDateTime &time, CString &buf);

	static void SaveStr2Buf(CString str, char *pBuf, int &index);
	static void SaveInt2Buf(int val, char *pBuf, int &index);

	static bool IsCertUser(LPCTSTR s_sys_user, LPCTSTR s_cert_user);
	
	static bool bNoAllMessage; //   TGB

private:
	static void ShowError(LPCTSTR s);
	static void ShowError(DWORD state);
	static void DeleteKeySet(HCRYPTPROV hProv, LPCTSTR szContainer);

	static bool MakeSecretKeyFile(HCRYPTPROV *phProv, LPCTSTR szFile, LPCTSTR szPassword, HCRYPTKEY hPubKey, DWORD dwCertSize, BYTE *bpCert, CString &sConainer);	

	COleDateTime m_last_sign_time; //   
	ESignMode m_SignMode;

public:
	CString m_sLastKeyContent;
	static bool bNoShowCheckResult; //    TGB.     ,     .

	bool m_bEnableBtnCreareCert4Me; //   " "  .
};


//**************************************************************************************
//  TGB

APL_CRYPT_CLASS_EXPORT 
// 
int aplSign(char *sUserName, char *sPassword, // sUserName -   (   ,     )
		 byte* pszBuffer, long lBufferLen,   //  lBufferLen==0,   pszBuffer -    ,  pszBuffer -     lBufferLen
		 char* HashBuf,    int *HashBufLen,      //      . . HashBufLen         , 
		 char* OpenKeyBuf, int *OpenKeyBufLen,   //       . .
		 char* SignatureBuf, int *SignatureBufLen, //      . .
		 char* CertBuf, int *CertBufLen,    //      . .
		 char* szCryptSystem);	// szCryptSystem -     . #define APL_CRYPT_MGR   #define APL_CRYPTO_PRO_34_10_2001
		 //    - .  #define 



APL_CRYPT_CLASS_EXPORT
//  
int aplGetHash(void *buffer, long buf_len, //   buf_len==0,   buffer -    ,  buffer -     lBufferLen
			char *szCryptSystem,	// sSystem -     . #define APL_CRYPT_MGR   #define APL_CRYPTO_PRO_34_10_2001
			char* HashBuf,    int *HashBufLen);	//      . . HashBufLen         , 	 
             //    - .  #define 

APL_CRYPT_CLASS_EXPORT
//  ( )
int aplCheckSign(void *buffer, long lBufferLen, //   buf_len==0,   buffer -    ,  buffer -     lBufferLen
				  char *szHash, //      
				  char *pbCertBlob, int nCertBlobSize, //     
				  char *szSignature, //      
		          char* szCryptSystem);	// szCryptSystem -     . #define APL_CRYPT_MGR   #define APL_CRYPTO_PRO_34_10_2001
	//    - .  #define 

APL_CRYPT_CLASS_EXPORT
//  
int aplCheckCryptoPro(); //   .  1,  ,  0,  .

//    TGB,    
#ifndef UNICODE

extern "C"
{
	APL_CRYPT_CLASS_EXPORT 
		// 
		// . doCheckEqualName -      Subject  User
	int aplSignEx(bool doCheckEqualName, char *sUserName, char *sPassword, // sUserName -   (   ,     )
		byte* pszBuffer, long lBufferLen,   //  lBufferLen==0,   pszBuffer -    ,  pszBuffer -     lBufferLen
		char* HashBuf,    int *HashBufLen,      //      . . HashBufLen         , 
		char* OpenKeyBuf, int *OpenKeyBufLen,   //       . .
		char* SignatureBuf, int *SignatureBufLen, //      . .
		char* CertBuf, int *CertBufLen,    //      . .
		char* szCryptSystem);	// szCryptSystem -     . #define APL_CRYPT_MGR   #define APL_CRYPTO_PRO_34_10_2001
	//    - .  #define 
	//extern "C"
	APL_CRYPT_CLASS_EXPORT
	bool aplCheckCertFileByRootCert(bool isFileCert, const char* cert_file_, const char *folderRootCert); 

	APL_CRYPT_CLASS_EXPORT
	bool aplGetDataFromCertFile(const char* cert_file, char* sSubject, char* sOpenKey, char* dNotBefore, char* dNotAfter, char* sIssuer, char* sCertSerialNum, char* sAlgorithm); 
};

#endif