// aplPrintDcDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "aplPrintDcDlg.h"


// CaplPrintDcDlg dialog

IMPLEMENT_DYNAMIC(CaplPrintDcDlg, CaplTranslateDialog)

CaplPrintDcDlg::CaplPrintDcDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CaplPrintDcDlg::IDD, pParent)
	, m_field_x(0)
	, m_field_y(0)
	, m_pages_x(1)
	, m_pages_y(1)
{
	m_bmp_cx=0;
	m_bmp_cy=0;
	m_page_cx=0;
	m_page_cy=0;
	m_min_offset_x=0;
	m_min_offset_y=0;

	m_ViewDC=0;
}

CaplPrintDcDlg::~CaplPrintDcDlg()
{
}

void CaplPrintDcDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PAGES, m_hPagesCtrl);
	DDX_Control(pDX, IDC_PAGES_V, m_vPagesCtr);
	DDX_Text(pDX, IDC_BMP_X_SIZE, m_bmp_cx);
	DDX_Text(pDX, IDC_BMP_Y_SIZE, m_bmp_cy);
	DDX_Text(pDX, IDC_FIELD_X, m_field_x);
	DDX_Text(pDX, IDC_FIELD_Y, m_field_y);
	DDX_Text(pDX, IDC_PAGES, m_pages_x);
	DDX_Text(pDX, IDC_PAGES_V, m_pages_y);
	DDX_Control(pDX, IDC_FIELD_X, m_field_x_ctrl);
	DDX_Control(pDX, IDC_FIELD_Y, m_field_y_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_PICT, m_pict);
}


BEGIN_MESSAGE_MAP(CaplPrintDcDlg, CaplTranslateDialog)
	ON_EN_CHANGE(IDC_PAGES, &CaplPrintDcDlg::OnEnChangePages)
	ON_EN_CHANGE(IDC_FIELD_X, &CaplPrintDcDlg::OnEnChangeFieldX)
	ON_EN_CHANGE(IDC_FIELD_Y, &CaplPrintDcDlg::OnEnChangeFieldY)
	ON_WM_PAINT()
END_MESSAGE_MAP()


// CaplPrintDcDlg message handlers

void CaplPrintDcDlg::OnEnChangePages()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CaplTranslateDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here

	CString buf;
	m_hPagesCtrl.GetWindowText(buf);
	int hPages=_atoi(LPCTSTR(buf));
	if(hPages==0) {hPages=1; m_hPagesCtrl.SetWindowText(_T("1"));}

	int vPages=-1;
	if(0!=m_page_cx) 
	{
		int dx=m_bmp_cx/hPages;
		int dy = (int) (m_page_cy*((double)dx)/m_page_cx);
		if(dy!=0)vPages=1+m_bmp_cy/dy;
	}
	buf.Format(_T("%i"),vPages);
	m_vPagesCtr.SetWindowText(buf);
	Invalidate();
}

BOOL CaplPrintDcDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplTableIco(APL_TABLE_PRINT));
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	// 
	m_field_x=m_min_offset_x;
	m_field_y=m_min_offset_y;
	UpdateData(FALSE);
	OnEnChangePages();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CaplPrintDcDlg::OnEnChangeFieldX()
{
	CString buf;
	m_field_x_ctrl.GetWindowText(buf);
	int field_x=_atoi(LPCTSTR(buf));
	if(field_x<m_min_offset_x)
	{
		AfxMessageBox(APL_T("    !\n\n    ."));
		field_x=m_min_offset_x;
		buf.Format(_T("%i"),field_x);
		m_field_x_ctrl.SetWindowText(buf);
	}
	if(2*field_x>(m_page_cx-10))
	{
		AfxMessageBox(APL_T("  !\n\n    ."));
		field_x=(m_page_cx-10)/2;
		buf.Format(_T("%i"),field_x);
		m_field_x_ctrl.SetWindowText(buf);
	}
	OnEnChangePages();
}

void CaplPrintDcDlg::OnEnChangeFieldY()
{
	CString buf;
	m_field_y_ctrl.GetWindowText(buf);
	int field_y=_atoi(LPCTSTR(buf));
	if(field_y<m_min_offset_y)
	{
		AfxMessageBox(APL_T("    !\n\n    ."));
		field_y=m_min_offset_y;
		buf.Format(_T("%i"),field_y);
		m_field_y_ctrl.SetWindowText(buf);
	}
	if(2*field_y>(m_page_cy-10))
	{
		AfxMessageBox(APL_T("  !\n\n    ."));
		field_y=(m_page_cy-10)/2;
		buf.Format(_T("%i"),field_y);
		m_field_y_ctrl.SetWindowText(buf);
	}
}

void CaplPrintDcDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here
	// Do not call CaplTranslateDialog::OnPaint() for painting messages

	if(0!=m_ViewDC && m_bmp_cx!=0 && m_bmp_cy!=0)
	{
		CRect rect;
		m_pict.GetWindowRect(LPRECT(rect));
		//m_pict.ClientToScreen(&rect);
		ScreenToClient(&rect);
		rect.DeflateRect(4,4);
		int cx=rect.right-rect.left;
		int cy=rect.bottom-rect.top;

		CRect outrect=rect;


		int cy1=m_bmp_cy*cx/m_bmp_cx;

		if(cy1<cy)
		{
			//  
			outrect.top+=(cy-cy1)/2;
			outrect.bottom=outrect.top+cy1;
		}
		else
		{
			//  
			int cx1=m_bmp_cx*cy/m_bmp_cy;
			outrect.left+=(cx-cx1)/2;
			outrect.right=outrect.left+cx1;
		}
		//dc.FillSolidRect(rect.left,rect.top,cx,cy,RGB(255,0,0));
		dc.StretchBlt(outrect.left,outrect.top,outrect.Width(),outrect.Height(),m_ViewDC,0,0,m_bmp_cx,m_bmp_cy,SRCCOPY);

		CPen pen(PS_SOLID,3,RGB(255,0,0));
		CPen *oldPen=dc.SelectObject(&pen);
		int i;
		CString buf;
		m_vPagesCtr.GetWindowText(buf);
		int vp=_atoi(LPCTSTR(buf));
		m_hPagesCtrl.GetWindowText(buf);
		int hp=_atoi(LPCTSTR(buf));
		if(vp>1 && hp>0 )
		{
			int dx=m_bmp_cx/hp;
			int dy = (int) (m_page_cy*((double)dx)/m_page_cx);
			int dh=dy*outrect.Height()/m_bmp_cy;
			for(i=1;i<vp;i++)
			{
				int h=outrect.top+dh*i;
				dc.MoveTo(outrect.left,h);
				dc.LineTo(outrect.right,h);
			}
		}

		if(hp>1)
		{
			for(i=1;i<hp;i++)
			{
				int w=outrect.left+(i*outrect.Width()/hp);
				dc.MoveTo(w,outrect.top);
				dc.LineTo(w,outrect.bottom);
			}
		}
		dc.MoveTo(outrect.left,outrect.top);
		dc.LineTo(outrect.right,outrect.top);
		dc.LineTo(outrect.right,outrect.bottom);
		dc.LineTo(outrect.left,outrect.bottom);
		dc.LineTo(outrect.left,outrect.top);
		dc.SelectObject(oldPen);
	}
}
