#include "StdAfx.h"
#include "apl_gui.h"

CaplToolTipListCtrl::CaplToolTipListCtrl(CaplToolTip* tooltip) : 
m_tooltip_ctrl(tooltip)
, m_nItem(-1)
{

}

CaplToolTipListCtrl::~CaplToolTipListCtrl()
{

}

BEGIN_MESSAGE_MAP(CaplToolTipListCtrl, CListCtrl)
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

void CaplToolTipListCtrl::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	if (m_tooltip_ctrl)
	{
		CRect rect;
		int nItem(-1);
		for(int i=0; i<GetItemCount(); ++i)
		{
			GetItemRect(i, &rect, LVIR_BOUNDS);
			if (point.x>=rect.left && point.x<=rect.right && point.y>=rect.top && point.y<=rect.bottom)
			{
				nItem = i;
				break;
			}
		}

		if (nItem<0)
		{
			m_tooltip_ctrl->Hide();
			if (m_nItem>=0)
				Update(m_nItem);
		}
		else
		{
			TMapTooltipTextFunction_it it = m_map_tooltip.find(nItem);
			if (it==m_map_tooltip.end())
			{
				m_tooltip_ctrl->Hide();
				if (m_nItem>=0)
					Update(m_nItem);
			}
			else if (it->second==NULL)
			{
				m_tooltip_ctrl->Hide();
				if (m_nItem>=0)
					Update(m_nItem);
			}
			else
			{
				CString sText;
				it->second(this, nItem, sText);
				if (sText.IsEmpty())
				{
					m_tooltip_ctrl->Hide();
					if (m_nItem>=0)
						Update(m_nItem);
				}
				else
				{
					POINT pt = point;
					ClientToScreen(&pt);
					//       ,     
					pt.x += 16;
					pt.y += 16;
					m_tooltip_ctrl->Show(pt.x, pt.y, sText, rect.Width());
				}
			}
		}

		m_nItem = nItem;
	}

	CListCtrl::OnMouseMove(nFlags, point);
}
