// StateDlg.cpp

#include "stdafx.h"
#include "apl_gui.h"
#include "StateDlg.h"


CaplStateDlg::CaplStateDlg()
{
	pDlg=0;
}

CaplStateDlg::~CaplStateDlg()
{
	if(0!=pDlg)
	{
		pDlg->DestroyWindow( );
		delete pDlg;
	}
}

//*********************************************************
void CaplStateDlg::Create(LPCTSTR header)
{
	if(0==pDlg)
	{
		pDlg=new CStateDlg;
		pDlg->Create(IDD_STATE_DLG);
		if(header!=0) pDlg->SetWindowText(header);
	}
}
//*********************************************************
void CaplStateDlg::Show(LPCTSTR header, LPCTSTR text)
{
	Create();
	if(0!=pDlg)
	{
		pDlg->ShowWindow(SW_SHOW);
		if(header!=0) pDlg->SetWindowText(header);
		if(text!=0) ((CStateDlg*)pDlg)->m_text_ctrl.SetWindowText(text);
	}
	Repaint();
}
//*********************************************************
void CaplStateDlg::Hide()
{
	if(0!=pDlg)
	{
		pDlg->ShowWindow(SW_HIDE);
	}
	Repaint();
}
//*********************************************************
#define REPAINT {MSG msg; while (::PeekMessage(&msg, NULL, WM_PAINT, WM_PAINT, PM_REMOVE|PM_NOYIELD)) DispatchMessage(&msg);while (::PeekMessage(&msg, NULL, WM_SHOWWINDOW, WM_SHOWWINDOW, PM_REMOVE|PM_NOYIELD)) DispatchMessage(&msg);}

void CaplStateDlg::Repaint()
{
	REPAINT
}
//*********************************************************

void CaplStateDlg::SetText(LPCTSTR text)
{
	if(pDlg==0) return;
	((CStateDlg*)pDlg)->m_text_ctrl.SetWindowText(text);
	Repaint();

}

CStatic *CaplStateDlg::GetTextCtrl()
{
	if(pDlg==0) return 0;
	return &(((CStateDlg*)pDlg)->m_text_ctrl);
}

//*********************************************************
void CaplStateDlg::SetRange(int nLower, int nUpper )
{
	if(pDlg==0) return;
	((CStateDlg*)pDlg)->m_progress.SetRange32(nLower,nUpper);
	((CStateDlg*)pDlg)->m_progress.ShowWindow(SW_SHOW);

}
//*********************************************************
void CaplStateDlg::SetPos( int nPos )
{
	if(pDlg==0) return;
	((CStateDlg*)pDlg)->m_progress.SetPos(nPos);
}
