// AplGuiEx.h: interface for the CaplListCtrl class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLLISTCTRL_H__DAAAF0AC_4F92_413D_B921_4197AF4D681B__INCLUDED_)
#define AFX_APLLISTCTRL_H__DAAAF0AC_4F92_413D_B921_4197AF4D681B__INCLUDED_

#ifdef PACKVERSION
#undef PACKVERSION
#endif
#define PACKVERSION(major,minor) MAKELONG(minor,major)

//      7 MFC
#ifndef TTS_BALLOON
#define TTS_BALLOON	0x40
#endif

// ToolTip Icons (Set with TTM_SETTITLE)
#ifndef TTI_NONE

#define TTI_NONE                0
#define TTI_INFO                1
#define TTI_WARNING             2
#define TTI_ERROR               3

#endif

#ifndef TTM_SETTITLEA

#define TTM_SETTITLEA           (WM_USER + 32)  // wParam = TTI_*, lParam = char* szTitle
#define TTM_SETTITLEW           (WM_USER + 33)  // wParam = TTI_*, lParam = wchar* szTitle

#ifdef _UNICODE
#define TTM_SETTITLE            TTM_SETTITLEW
#else
#define TTM_SETTITLE            TTM_SETTITLEA
#endif

#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef APL_GUI_EX_NO_AUTOLIB
#ifdef _DEBUG
	#ifdef _UNICODE
	#pragma comment (lib,"AplGuiEx_ud.lib")
	#else
	#pragma comment (lib,"AplGuiExD.lib")
	#endif
#else
	#ifdef _UNICODE
	#pragma comment (lib,"AplGuiEx_u.lib")
	#else
	#pragma comment (lib,"AplGuiEx.lib")
	#endif
#endif
#endif

#include <AFXTEMPL.H>
#include <afxcview.h>
#include <apl_image.h>

enum aplEditTypes {aplNone, aplTextCtrl, aplRealCtrl, aplRealWithoutExpCtrl, aplComboCtrl, aplComboWidthCtrl, aplComboTreeCtrl, aplTimeCtrl, aplDateCtrl, aplDateTimeCtrl, aplIntegerCtrl, aplNaturalCtrl, aplEditSpinCtrl, aplUser};

#define APL_DI_FIT_TO_RECT			1 //  
#define APL_DI_FIT_TO_RECT_WSCALE	2 // 


#define APL_LC_START_EDIT_MESSAGE		WM_USER + 776
#define APL_LC_BEFORE_END_EDIT_MESSAGE	WM_USER + 777
#define APL_LC_AFTER_END_EDIT_MESSAGE	WM_USER + 778
#define APL_LC_CBN_SELCHANGE			WM_USER + 779

#define APL_EXLC_SEL_CHANGING_MESSAGE	WM_USER + 780
#define APL_EXLC_SEL_CHANGED_MESSAGE	WM_USER + 781

#define APL_LC_DEF_DBLCLK				WM_USER + 782

#define ON_STARTEDIT(id, lpFunct)			ON_NOTIFY(APL_LC_START_EDIT_MESSAGE, id, lpFunct)
#define ON_BEFOR_ENDEDIT(id, lpFunct)		ON_NOTIFY(APL_LC_BEFORE_END_EDIT_MESSAGE, id, lpFunct)
#define ON_AFTER_ENDEDIT(id, lpFunct)		ON_NOTIFY(APL_LC_AFTER_END_EDIT_MESSAGE, id, lpFunct)
#define ON_LC_CBN_SELCHANGE(id, lpFunct)	ON_NOTIFY(APL_LC_CBN_SELCHANGE, id, lpFunct)

#define ON_LC_SEL_CHANGING(id, lpFunct)	ON_NOTIFY(APL_EXLC_SEL_CHANGING_MESSAGE, id, lpFunct)
#define ON_LC_SEL_CHANGED(id, lpFunct)	ON_NOTIFY(APL_EXLC_SEL_CHANGED_MESSAGE, id, lpFunct)


class CxImage;

#ifdef APL_CLASS_EXPORT
#undef APL_CLASS_EXPORT
#endif

#ifdef APL_APLGUIEX_IMPL
#define APL_CLASS_EXPORT	_declspec(dllexport)
#else
#define APL_CLASS_EXPORT	_declspec(dllimport)
#endif

class CAplGuiExResourceHandleChange
{
private:
	HINSTANCE hRes2Restore;
public:
	CAplGuiExResourceHandleChange();
	virtual ~CAplGuiExResourceHandleChange(){AfxSetResourceHandle(hRes2Restore);};
};

/************************************************************************/
/*                        CStringArrayAplEx                               */
/************************************************************************/
class APL_CLASS_EXPORT CStringArrayAplEx : public CStringArray  
{
public:
	int Find(LPCTSTR lpszStr, bool bMachCase = true);

	CStringArrayAplEx();
	virtual ~CStringArrayAplEx();

};
/*
   

class APL_CLASS_EXPORT CaplImageGuiEx  
{
protected:
	CxImage	*m_pImage;
public:
	bool SetImage(CxImage* pImage);
	bool SetImage(CaplImageGuiEx* pImage);
	bool HasImage();
	bool CreateFromBitmap(HBITMAP hBm);
	bool LoadFromBuf(BYTE *pBuf, DWORD size, DWORD type);
	bool SaveAs(LPCTSTR lpszFileName);
	bool GetImageDimensions(CSize &sizes);
	void Draw(CRect &rect, CDC *pDC, UINT flags = APL_DI_FIT_TO_RECT_WSCALE);
	bool LoadImage(LPCTSTR lpszFileName);
	bool Decode(BYTE *pBuf, DWORD size, DWORD type);

	// frame operations
	long GetNumFrames();
	long GetFrame();
	void SetFrame(long nFrame);

	void Clear();
	CaplImageGuiEx();
	virtual ~CaplImageGuiEx();
	
};
*/

class APL_CLASS_EXPORT CaplStaticImage : public CStatic
{
	// Construction
public:
	CaplStaticImage();
	
	// Attributes
public:
	bool GetDimensions(CSize &sizes);
	void Clear();
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplStaticImage)
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	bool HasImage();
	bool SetImage(CaplImage* pImage);
	bool LoadFromBuf(BYTE *pBuf, long iSzie, UINT flag = APL_DI_FIT_TO_RECT_WSCALE);
	bool LoadFromFile(LPCTSTR lpszFileName, UINT flag = APL_DI_FIT_TO_RECT_WSCALE);
	virtual ~CaplStaticImage();
	
	// Generated message map functions
protected:
	UINT m_Flags;
	bool m_bShowImage;
	CaplImage m_Image;
	//{{AFX_MSG(CaplStaticImage)
	afx_msg void OnPaint();
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

/************************************************************************/
/*       CaplListCtrl                                                   */
/************************************************************************/

/*
       
    :  , 
	 ,  .
*/

class APL_CLASS_EXPORT CaplLB_Edit : public CEdit
{
	DECLARE_DYNAMIC(CaplLB_Edit)
protected:
	CString m_Mask;
	// Construction
public:
	CaplLB_Edit();
	
	// Attributes
public:
	
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplLB_Edit)
	public:
	protected:
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	virtual ~CaplLB_Edit();
	
	// Generated message map functions
protected:
	CString m_CurString;
	//{{AFX_MSG(CaplLB_Edit)
	afx_msg void OnKillfocus();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};
/************************************************************************/
/*                        CaplLB_DateTimeCtrl                               */
/************************************************************************/
class CaplLB_DateTimeCtrl : public CDateTimeCtrl
{
	DECLARE_DYNAMIC(CaplLB_DateTimeCtrl)
	// Construction
public:
	CaplLB_DateTimeCtrl();
	
	// Attributes
public:
	
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplLB_DateTimeCtrl)
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	virtual ~CaplLB_DateTimeCtrl();
	
	// Generated message map functions
protected:
	//{{AFX_MSG(CaplLB_DateTimeCtrl)
	afx_msg void OnKillfocus();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDropDown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCloseUp(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

class CaplLB_Combobox : public CComboBox
{
	DECLARE_DYNAMIC(CaplLB_Combobox)
	// Construction
public:
	CaplLB_Combobox();
	
	// Attributes
public:
	
	// Operations
public:
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplLB_Combobox)
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	virtual ~CaplLB_Combobox();
	
	// Generated message map functions
protected:
	//{{AFX_MSG(CaplLB_Combobox)
	afx_msg void OnKillfocus();
	afx_msg void OnSelchange();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnDropDown();
	afx_msg void OnCloseUp();
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CComboTree;

//////////////////
// Generic class to hook messages on behalf of a CWnd.
// Once hooked, all messages go to CComboTreeSubclassWnd::WindowProc before going
// to the window. Specific subclasses can trap messages and do something.
//
// To use:
//
// * Derive a class from CComboTreeSubclassWnd.
//
// * Override CComboTreeSubclassWnd::WindowProc to handle messages. Make sure you call
//   CComboTreeSubclassWnd::WindowProc if you don't handle the message, or your
//   window will never get messages. If you write seperate message handlers,
//   you can call Default() to pass the message to the window.
//
// * Instantiate your derived class somewhere and call HookWindow(pWnd)
//   to hook your window, AFTER it has been created.
//	  To unhook, call Unhook or HookWindow(NULL).
//
// This is a very important class, crucial to many of the widgets Window
// widgets implemented in PixieLib. To see how it works, look at the HOOK
// sample program.
//
class CComboTreeSubclassWnd : public CObject {
public:
	CComboTreeSubclassWnd();
	~CComboTreeSubclassWnd();

	// Subclass a window. Hook(NULL) to unhook (automatic on WM_NCDESTROY)
	BOOL	HookWindow(HWND  hwnd);
	BOOL	HookWindow(CWnd* pWnd)	{ return HookWindow(pWnd->GetSafeHwnd()); }
	void	Unhook()				{ HookWindow((HWND)NULL); }
	BOOL	IsHooked()				{ return m_hWnd!=NULL; }

	friend LRESULT CALLBACK HookWndProc(HWND, UINT, WPARAM, LPARAM);
	friend class CSubclassWndMap;

	virtual LRESULT WindowProc(UINT msg, WPARAM wp, LPARAM lp);
	LRESULT Default();				// call this at the end of handler fns

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	HWND			m_hWnd;				// the window hooked
	WNDPROC			m_pOldWndProc;		// ..and original window proc
	CComboTreeSubclassWnd*	m_pNext;	// next in chain of hooks for this window

	DECLARE_DYNAMIC(CComboTreeSubclassWnd);
};

//////////////////
// Intercepts parent window messages
// To use:
// - used within ComboTree
// - call Init, passing parent window of ComboTree
//
class CComboTreeHook : public CComboTreeSubclassWnd {
protected:
	// subclass window proc
	virtual LRESULT WindowProc(UINT msg, WPARAM wp, LPARAM lp);

public:
	CComboTreeHook();
	~CComboTreeHook();
	void Init(HWND hParent, CComboTree* pTreeCombo, BOOL bHookNow = FALSE); // initialize

	void HookParent();    //Must call this when tree is dropped down
	void UnhookParent();  //Must call this when tree is hidden

protected:
	BOOL IsMsgOK(UINT nMsg, WPARAM wParam, LPARAM lParam);

private:
	CComboTree* m_pComboTree;
	HWND m_hParent;
};

class CComboTreeEdit : public CEdit
{
   friend class CComboTree;

// Construction
public:
	CComboTreeEdit();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboTreeEdit)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CComboTreeEdit();

// Generated message map functions
protected:
	//{{AFX_MSG(CComboTreeEdit)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnSetfocus();
	afx_msg void OnKillfocus();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg UINT OnGetDlgCode();
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	LRESULT OnIgnoreMessage(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

class CComboTreeButton : public CButton
{
// Construction
public:
	CComboTreeButton();

// Attributes
public:

// Operations
public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboTreeButton)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CComboTreeButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CComboTreeButton)
	afx_msg UINT OnGetDlgCode();
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

class CComboTreeDropList : public CTreeCtrl
{
	friend class CComboTree;
	friend class CaplLB_ComboTree;

// Construction
public:
	CComboTreeDropList();

// Attributes
protected:
	enum CheckState{ NOSTATE = 0, UNCHECKED, CHECKED, CHILD_CHECKED};
	enum CheckType{ CHECK, UNCHECK, TOGGLE, REFRESH };

// Attributes
protected:
	void SetCombo(CComboTree* pCombo)
	{
		m_pCombo = pCombo;
	}
	CComboTree* GetCombo()
	{
		return m_pCombo;
	}

	void SplitPath(const CString& strTreeBranch, CString& strRoot, CString& strRemainder);
	HTREEITEM MatchSibling(HTREEITEM hItem, CString& strMatch);
	HTREEITEM FindString(HTREEITEM hParent, CString strTreeBranch,
		HTREEITEM& hPreviousMatch, CString& strRoot, CString& strRemainder );
	HTREEITEM DropListAddItem(HTREEITEM hParent, CString strTreeBranch);

	HTREEITEM AddString( LPCTSTR lpszString);
	HTREEITEM FindString(CString strTreeBranch, HTREEITEM hParent = NULL );
	HTREEITEM SelectString( LPCTSTR lpszString, HTREEITEM hParent = NULL);
	CString GetTreePath(HTREEITEM hItem);
	CString GetCurrentTreePath();
	CString GetPathDelimiter() { return m_Delimiter; }
	void SetPathDelimiter(CString Delimiter) { m_Delimiter = Delimiter; }
	void SetChildState( HTREEITEM hItem, UINT nState );
	void SetParentState(HTREEITEM hItem);

	HTREEITEM FindChildItemData(DWORD SearchData, HTREEITEM hItem = NULL);
	HTREEITEM FindChildItem(LPCTSTR Label, HTREEITEM hItem = NULL);
	HTREEITEM GetLastItem( HTREEITEM hItem );
	HTREEITEM GetNextItem( HTREEITEM hItem );
	HTREEITEM GetPrevItem( HTREEITEM hItem );
	HTREEITEM GetLastSibling( HTREEITEM hItem );
	void CollapseBranch( HTREEITEM hItem);
	void ExpandBranch( HTREEITEM hItem );
	void CollapseAllSiblings( HTREEITEM hNode );
	BOOL SetCheck( HTREEITEM hItem, CheckType nCheck );
	BOOL IsItemChecked(HTREEITEM hItem);
	HTREEITEM GetFirstCheckedItem();
	HTREEITEM GetNextCheckedItem( HTREEITEM hItem );
	HTREEITEM GetPrevCheckedItem( HTREEITEM hItem );

protected:
	CComboTree* m_pCombo;
	CString     m_Delimiter;

// Operations
public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboTreeDropList)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CComboTreeDropList();

	// Generated message map functions
protected:
	//{{AFX_MSG(CComboTreeDropList)
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnActivateApp(BOOL bActive, DWORD hTask);
	afx_msg UINT OnGetDlgCode();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	CImageList m_imageState;
};

#define NOTIFY_TREECOMBO_CHECK WM_APP + 2291

class CComboTree : public CWnd
{
	friend class CComboTreeDropList;
	friend class CComboTreeEdit;
	friend class CComboTreeHook;

// Construction
public:
	CComboTree();

// Attributes
public:
	//Child control access functions
	CComboTreeDropList& GetTree() { return m_Tree; }
	CComboTreeEdit& GetEdit() { return m_Edit; }
	CComboTreeButton& GetDropDownButton() { return m_DropDownButton; }

	//    item/  "" 
	void SetSelectOnlyChilds(bool bSelectOnlyChilds=true) {m_bSelectOnlyChilds=bSelectOnlyChilds;};
	bool IsChildItem();
	//Tree specific extensions 
	CString GetTreePath(HTREEITEM hItem);
	CString GetCurrentTreePath();
	void SetDelimiter(CString delimiter);
	CString GetDelimiter();
	int  SetDroppedHeight(UINT nHeight);
	int  GetDroppedHeight();

	//Checked tree extensions	
	BOOL SetHasCheckboxes(BOOL bHasCheckboxes);
	BOOL GetHasCheckboxes();
	BOOL SetCheck(HTREEITEM hItem, BOOL bChecked = TRUE);

	//CComboBox emulation functions
	void SetWindowText(LPCTSTR Text);
	CString GetWindowText();
	int GetLBText(HTREEITEM hItem, CString& rText);
	HTREEITEM AddString(LPCTSTR lpszString);
	HTREEITEM FindString(LPCTSTR lpszString, HTREEITEM hParent = NULL);
	virtual HTREEITEM SelectString(LPCTSTR lpszString, HTREEITEM hParent = NULL);
	HTREEITEM GetCurSel();
	int   SetItemData(HTREEITEM hItem, DWORD dwItemData);
	DWORD GetItemData(HTREEITEM hItem);
	void ShowDropDown(BOOL bShowIt = TRUE);
	void ResetContent();
	int  SetDroppedWidth(UINT nWidth);
	int  GetDroppedWidth();
	BOOL GetDroppedState();
	virtual int  DeleteString(HTREEITEM hItem);
	void GetDroppedControlRect(LPRECT pRect);

	void ShowTree();
	void HideTree();

// Operations
public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CComboTree)
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL
public:
	BOOL Create(const RECT& rect, int DroppedWidth, int DroppedHeight, CWnd* pParentWnd, UINT nID);

// Implementation
public:
	virtual ~CComboTree();

protected:
	void DisplayTree();
	BOOL CreateTree();
	BOOL CreateButton();
	BOOL CreateEdit();
	void SetDroppedState(BOOL bState)
	{
		m_bDroppedState = bState;
	}

	LRESULT SendParentComboMessage(UINT Action);
	virtual void CalculateDroppedRect(LPRECT lpDroppedRect);
	virtual void OnCancel();
	virtual void OnSelection(bool bEnd = false);
	BOOL OnKeyDropdownActive(UINT message, UINT nChar);
	BOOL OnKeyDropdownInactive(UINT message, UINT nChar);

	BOOL IsMouseOnEdit();
	BOOL IsMouseOnButton();
	BOOL IsMouseOnTree();

	BOOL IsEditHighlightOn();

	// Generated message map functions
protected:
	//{{AFX_MSG(CComboTree)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnDropdownButton();
	afx_msg void OnDropdownEdit(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()

protected:
	CComboTreeDropList m_Tree;
	CComboTreeEdit     m_Edit;
	CComboTreeButton   m_DropDownButton;
	CString       m_BeginPath;
	int           m_ComboWidth;
	int           m_ComboHeight;
	BOOL          m_bDroppedState;
	BOOL		  m_bCreateWithCheckboxes;

	CComboTreeHook m_ComboTreeHook;
	bool m_bSelectOnlyChilds;
};

class CaplLB_ComboTree : public CComboTree
{
	DECLARE_DYNAMIC(CaplLB_ComboTree)
// Construction
public:
	CaplLB_ComboTree();

// Attributes
public:
	//  m_bFullWindowText == true,   m_Edit     
	bool m_bFullWindowText;

	virtual HTREEITEM SelectString(LPCTSTR lpszString, HTREEITEM hParent = NULL) override;
	virtual int  DeleteString(HTREEITEM hItem) override;

// Operations
public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplLB_ComboTree)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplLB_ComboTree();

protected:
	int m_x;
	int m_y;
	int m_cx;
	int m_cy;

	virtual void CalculateDroppedRect(LPRECT lpDroppedRect) override;
	virtual void OnCancel() override;
	virtual void OnSelection(bool bEnd = false) override;

	// Generated message map functions
protected:
	//{{AFX_MSG(CaplLB_ComboTree)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnKillfocus();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnSize(UINT nType, int x, int y);
	afx_msg int OnMouseActivate(CWnd* pDesktopWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
public:
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
protected:
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

enum aplCheckValue
{
	aplCheckNo = 0
	,	aplCheckSet
	,	aplCheckEnabled
	,	aplCheckDisabled
	,	aplCheckEmpty
};

class APL_CLASS_EXPORT CaplListCtrl : public CListCtrl  
{
	DECLARE_DYNAMIC(CaplListCtrl)

	friend class CaplLB_Edit;
	friend class CaplLB_Combobox;
	friend class CaplLB_ComboTree;
	friend class CaplLB_DateTimeCtrl;

	class CaplColTypes
	{
	public: 
		void Empty();
		CaplColTypes(const CaplColTypes &Val);
		CaplColTypes();
		virtual ~CaplColTypes(){};

		int nCol;
		int nItem;

		int MinVal;
		int MaxVal;
		aplEditTypes type;

		CStringArrayAplEx	m_Strings;
		CDWordArray		m_Dwords;

		aplCheckValue m_check;

		CaplColTypes& operator=(const CaplColTypes &Val);
		bool operator==(const aplEditTypes &Val);
	};

	class CaplListData
	{
	public:
		class CHeaderItem
		{
		public:
			CHeaderItem();
			virtual ~CHeaderItem();
			
			DWORD	m_dwData;
			CString	m_sName;
			int		m_iWidth;
		};
		
		class CRowItem
		{
		public :
			CRowItem();
			virtual ~CRowItem();

			CString	m_sText;
			
			CaplColTypes	m_EditType;
		};

		class CRowData : public CArray<CRowItem*, CRowItem*>
		{
		public:
			CRowData();
			virtual ~CRowData();
			
			DWORD	m_dwData;
		};

		public:
			CaplListData();
			virtual ~CaplListData();
			
			CString m_sName;
			CArray<CHeaderItem*, CHeaderItem*>	m_header;
			CArray<CRowData*, CRowData*>		m_data;

			bool SaveData(CaplListCtrl *pList);
			bool RestoreData(CaplListCtrl *pList);
	};

	class CaplItem
	{
	public:
		CaplItem()
		{
			m_BkColor = 0;
			m_Item = 0;
			m_SubItem = 0;
		}

		virtual ~CaplItem(){};

		COLORREF	m_BkColor;

		int m_Item;
		int m_SubItem;

	};

	// Construction
public:
	CaplListCtrl();
	
	// Attributes
public:
	//      -1 ( ),   Combobox 
	//   
	int m_HeightCombobox;

protected:
	//   ComboTree    item     
	//         "" .
	//        m_FullWindowTextColumn,
	//    - 
	CArray<int> m_OnlyLastSelectAnyItem;
public:
	void SetOnlyLastSelectAnyItem(int col);

	//     ComboTree
	void SetComboTreeDelimiter(CString delimiter);
	CString GetComboTreeDelimiter();

	//      ComboTree    
	void SetComboTreeFullWindowTextColumn(int col);
protected:
	CArray<int> m_FullWindowTextColumn;

	// Operations
public:
	void SetItemEditType(int item, int col, aplEditTypes type, CStringArray* StrArr = NULL, CDWordArray* DwArr = NULL, aplCheckValue check=aplCheckEmpty);

	BOOL SetItemText(_In_ int nItem, _In_ int nSubItem, _In_z_ LPCTSTR lpszText);

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplListCtrl)
	public:
	virtual BOOL DestroyWindow();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void PreSubclassWindow();
	//}}AFX_VIRTUAL
	virtual int OnToolHitTest( CPoint point, TOOLINFO* pTI ) const;

	// Implementation
public:
	void SetItemEditType(CaplColTypes col_type);
	
	bool SaveListData(LPCTSTR lpszName);
	bool RestoreListData(LPCTSTR lpszName);
	
	void SetDateTimeChecked(bool b = true);
	bool SetErrorMessageText(LPCTSTR lpszText);
	BOOL DeleteItem(int nItem);
	bool StartEdit(int row, int col);
	void SetReadOnly(BOOL bReadOnly = TRUE);
	int InsertItem( int nItem, LPCTSTR lpszItem, int nImage );
	int InsertItem( int nItem, LPCTSTR lpszItem );
	int InsertItem( const LVITEM* pItem );
	int InsertItem (UINT nMask, int nItem, LPCTSTR lpszItem, UINT nState, UINT nStateMask, int nImage, LPARAM lParam);
	CaplColTypes GetColumnType(int item, int col);
	// true    ( )  false -     (  )
	bool EndEdit(bool bUpdate = true);
	bool SetItemBkColor(int nItem, int nSubItem, COLORREF color);
	void ResetItemBkColor(int nItem, int nSubItem);
	bool aplString2Date(CString &buf, COleDateTime &time);
	
	void ClearModifiedItems();

	DWORD GetColData(int nItem, int nSubItem);

	//    -    (  true)
	void SetUseItemDataFromCmb(bool bUse = true);

	//   APL_LC_CBN_SELCHANGE     - (  false)
	void SetSendCmbSelChangeMsg(bool bSend = true);

	virtual ~CaplListCtrl();
protected:

	CArray<CaplListData*, CaplListData*> m_ListDataArray;

	CaplLB_Edit			m_edit_ctrl;
	CaplLB_Edit			m_time_ctrl;
	CaplLB_Edit			m_edit_num_ctrl;
	CaplLB_Combobox		m_combo_ctrl;
	CaplLB_ComboTree	m_combo_tree_ctrl;
	CaplLB_DateTimeCtrl	m_date_ctrl;
	
	CSpinButtonCtrl	m_spin_ctrl;
	
	int				m_EditCol;
	int				m_EditItem;
	CWnd*			m_pWarningMessageWnd;
	CString			m_sErrorText;
	CaplColTypes	m_EditCtrl;

	CToolTipCtrl	m_ToolTipCtrl;

	CArray<CaplColTypes, CaplColTypes> m_columns;
	CArray<CaplItem, CaplItem>	m_items;

	bool			m_bSetItemDataFromCmb;	//    -    (  true)
	bool			m_bSendCmbSelChangeMsg;	//   APL_LC_CBN_SELCHANGE     - (  false)
	
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	// Generated message map functions
protected:
	
	//{{AFX_MSG(CaplListCtrl)
	afx_msg void OnDblclkCharacteristics(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSetFocus(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCBNSelchange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnCBNTreeSelchange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_bReadOnly;
};

class APL_CLASS_EXPORT CTabCtrlEx : public CTabCtrl
{
public:
	CTabCtrlEx();
public:
	BOOL SetItemData(int nItem, DWORD dwData);
	DWORD GetItemData(int nItem);
	virtual ~CTabCtrlEx();
};

//////////////////////////////////////////////////////////////////////////
/************************************************************************/
/*                          CToolBarEx                                  */
/************************************************************************/

class APL_CLASS_EXPORT CToolBarEx : public CToolBar
{
private:
	// Construction
	typedef struct
	{
		UINT	idmID;
		UINT	idmMenuID;
		int		idmSubMenu;
	} TItemDropMode;

	bool m_bLBUP;
	CCmdTarget* m_pMsgTarget;
protected:
	bool m_bDropDown;

	CArray<TItemDropMode, TItemDropMode> m_ItemModes;
public:
	CToolBarEx();
	
	// Attributes
	
	// Operations
	
	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CToolBarEx)
	virtual BOOL DrawNonThemedGripper(CDC* pDC, const CRect& rect);
	virtual BOOL DrawThemedGripper(CDC* pDC, const CRect& rect, BOOL fCentered);
	//}}AFX_VIRTUAL
	
	// Implementation
public:
	void SetUserGradient(COLORREF clr1, COLORREF clr2);
	void SetButtonDropDownMode(UINT ButtonId,  bool bDropDown, UINT MenuId = 0, int SubMenu = -1, CCmdTarget* pMsgTarget = NULL);
	virtual ~CToolBarEx();

protected:
	bool m_bUserGradient;
	COLORREF m_userGradientColor1;
	COLORREF m_userGradientColor2;
	
	// Generated message map functions
protected:
	void DrawArrow(HDC hDC, CRect &rect);
	//{{AFX_MSG(CToolBarEx)
	afx_msg void OnButtonDropDown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	
	DECLARE_MESSAGE_MAP()
};

/************************************************************************/
/*                        CCheckTreeView                               */
/************************************************************************/


class APL_CLASS_EXPORT CCheckTreeView : public CTreeView
{
protected:
	CCheckTreeView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CCheckTreeView)

protected:
	struct sCheckData
	{
		DWORD m_data;
		bool m_bIsChecked;
		bool m_grey;
	};

	CArray<sCheckData*,sCheckData*> m_data_array;

// Attributes
protected:
	CArray<HTREEITEM, HTREEITEM> m_sel_array;
	CImageList m_ImageList;

	bool m_ReturnData;

// Operations
public:
	bool IsChecked(HTREEITEM hItem);
	void SetChecked(HTREEITEM hItem, bool bCheck);
	int GetCheckedCount();
	CArray<HTREEITEM, HTREEITEM>* GetSelectedArray();
	bool RefreshTree();

protected:
	sCheckData* GetCheckData(HTREEITEM hItem)
	{
		m_ReturnData=true;
		sCheckData *data = (sCheckData*)GetItemData(hItem);
		m_ReturnData = false;
		return data;
	}

	void CheckUncheckChild(HTREEITEM parent, bool check = TRUE);	//   
	bool CheckUncheckParent(HTREEITEM parent, bool check = TRUE);
	bool IsFullSelect(HTREEITEM hItem, bool check = TRUE, bool flag = TRUE);

	void MakeParentGrey(HTREEITEM hItem);	//      

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCheckTreeView)
	public:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual DWORD GetItemData(HTREEITEM hItem);
	virtual void SetItemData(HTREEITEM hItem, DWORD data);
	virtual HTREEITEM InsertItem(LPCTSTR lpszItem, int nImage, int nSelectedImage, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	virtual HTREEITEM InsertItem(LPCTSTR lpszItem, HTREEITEM hParent = TVI_ROOT, HTREEITEM hInsertAfter = TVI_LAST);
	virtual HTREEITEM InsertItem(UINT nMask, LPCTSTR lpszItem, int nImage, int nSelectedImage, UINT nState, UINT nStateMask, LPARAM lParam, HTREEITEM hParent, HTREEITEM hInsertAfter);
	virtual HTREEITEM InsertItem(LPTVINSERTSTRUCT lpInsertStruct);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CCheckTreeView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CCheckTreeView)
		afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
/************************************************************************/
/* aplExListCtrl                                                        */
/************************************************************************/
#define APLEXLISTCTL_BORDER 2
//(::GetSystemMetrics(SM_CYBORDER))

class CaplExListCtrlContent;
class CaplExHeaderRow;
typedef CArray<CaplExHeaderRow *,CaplExHeaderRow *> CHRArray;

typedef POSITION HLISTITEM;


struct NMEXLISTVIEW
{
	NMHDR hdr;
	HLISTITEM item;
	int subItem;
	aplEditTypes mode;
	CWnd *editWnd;
};


/**   */
class APL_CLASS_EXPORT CaplExListCtrl : public CWnd
{
// Construction
public:
	CaplExListCtrl();

// Attributes
public:
	
	//     
	struct SEditInfo
	{
		aplEditTypes m_curEdit;
		HLISTITEM m_edItem;
		CaplExListCtrlContent *lst;
		int ncol;
		CWnd *m_editWnd;
		bool ee;
		void NoEdit()
		{
			m_curEdit = aplNone;
			m_edItem = NULL;
			lst = NULL;
			if(m_editWnd)
				m_editWnd->ShowWindow(SW_HIDE);
			m_editWnd = NULL;
			ee = false;
		}
		SEditInfo() {	m_editWnd = NULL; NoEdit();}
	};

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplExListCtrl)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void PreSubclassWindow();
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CaplExListCtrl();

	// Header functions
	/**    
	  @param index      
	*/
	int AddRow(int index);

	/**    
	  @param rowIndex    ( )
	  @param colIndex     (  )
	  @param text    
	  @param w      
	  @param mode      
				(      )
	  @param pStrs   ( mode == aplComboCtrl)
	*/
	int AddColumn(int rowIndex, int colIndex, LPCTSTR text, int w, int nFormat = LVCFMT_LEFT, aplEditTypes mode = aplNone, CStringArray *pStrs = NULL);

	/**    
	  @param index   
	*/
	bool DeleteRow(int index);

	/**   col   row
	*/
	bool DeleteColumn(int row, int col);

	/**  */
	bool SplitColumn(int row, int col, int count);

	/**     col   row
	*/
	bool SetColumnText(int row, int col, LPCTSTR lpszTitle);

	// List functions

	/**       index 
			( -1,   )
	  @param text     
	  @param imageIndex    (-1  -  )
	*/
	HLISTITEM InsertItem(int index = -1, LPCTSTR text = NULL, int imageIndex = -1);
	
	/**       index 
			( -1,   )
	  @param text     
	  @param imageIndex   
	*/
	HLISTITEM InsertSubItem(HLISTITEM item, int index = -1, LPCTSTR text = NULL, int imageIndex = -1);
	
	/**    item */
	int GetSubItemsCount(HLISTITEM item);

	/**   index  item */
	HLISTITEM GetSubItem(HLISTITEM item, int index);

	/**    item */
	HLISTITEM GetFirstSubItem(HLISTITEM item);

	/**    item */
	HLISTITEM GetLastSubItem(HLISTITEM item);

	/**         */
	HLISTITEM GetNextItem(HLISTITEM item, bool bNext = true);

	/**  /  */
	HLISTITEM GetTrueNextItem(HLISTITEM item, bool bNext = true);

	/**    (NULL,    ) */
	HLISTITEM GetParentItem(HLISTITEM item);

	/**   col    (  ) */
	CString GetItemText(HLISTITEM item, int col);

	/**    col    (  ) */
	bool SetItemText(HLISTITEM item, int col, LPCTSTR lpszText);

	/**   */
	bool DeleteItem(int index);
	bool DeleteItem(HLISTITEM item);

	/**  */
	bool DeleteAllItems();

	/**    */
	bool EnsureVisible(HLISTITEM item);

	/**   */
	bool SelectItem(HLISTITEM item);

	/**   */
	HLISTITEM GetSelectedItem();

	/**       (   ) */
	bool MoveUp(HLISTITEM item);

	/**       (   ) */
	bool MoveDown(HLISTITEM item);

	/**   -   */
	bool SetItemData(HLISTITEM item, DWORD dwData);

	/**    */
	DWORD GetItemData(HLISTITEM item);

	/**   
	@param item - 
	@param subItem -   ( )
	@param mode -   aplEditTypes (. )
	@param pStrs -  ,   mode = aplComboCtrl
	@param bSharedStrs - 
	*/
	bool SetItemEditMode(HLISTITEM item, int subItem, aplEditTypes mode, CStringArray *pStrs = NULL, bool bSharedStrs = false);
	
	/**  .
	@param row -   () ( )
	@param col -  ,   
	*/
	bool Sort(int row, int col);

	/**  */
	bool ReSort();

	/**     */
	void PaintGrid(bool pg);

	/**   .    ,
	         ,     
		.
	*/
	void SetRowHeight(int rh);

	/**     */
	bool SetItemImage(HLISTITEM item, int imageIndex);

	/**     .
	 pImageList!=NULL,        ,
	  bSetRowHeightByIcons=true    
	*/
	bool SetImageList(CImageList *pImageList, bool bSetRowHeightByIcons = true);

	/**  
	@param bUpdate -    
	*/
	bool EndEdit(bool bUpdate);

	/**  ,    */
	bool IsEditing();

	/**        */
	void HeaderLayout();

	/**      */
	bool SetErrorMessageText(LPCTSTR lpszText);

protected:
	CaplExListCtrlContent *GetAllChilds(HLISTITEM item);
	

	CScrollBar m_sbVert;
	CScrollBar m_sbHorz;

	CaplExListCtrlContent *m_list;
	CHRArray *m_header;

	int m_nHeadersId;
	bool m_pg;
	CFont m_fo;
	int m_border;
	int m_RH;
	int m_UserDefRH;
	int m_iconsRH;
	int m_iconWidth;
	static int sm_sbSize;
	HLISTITEM m_curSel;

	CPoint m_ptLastSort;
	CImageList *m_pIL;

	int m_selind;
	bool m_bUnselItemDel;

	// editing
	SEditInfo m_ei;
	CComboBox m_combo_ctrl;
	CEdit m_edit_ctrl;
	CDateTimeCtrl m_date_ctrl;
	CDateTimeCtrl m_time_ctrl;

	CWnd	*m_pWarningMessageWnd;
	CString m_sErrorText;
	CToolTipCtrl	m_ToolTipCtrl;

	bool EndEdit(bool bUpdate, bool bTryUpdate);
	void SetBorder(bool b);
	bool VisibleItem(HLISTITEM item) { return true; }
	bool VisibleScrolls(bool bResize = false);
	void GetContentSize(CSize &sz, bool bWithHeader);
	void DoScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar, bool bH);
	void GetContentRect(RECT &re);
	void UpdateContent();
	int  ItemByPoint(const CPoint &point, POSITION &pos);
	bool StartEdit(int y0, HLISTITEM pos, int x);
	bool SendMessageAboutSCH(UINT code, HLISTITEM item);
	void ResizeHeader();
	//{{AFX_MSG(CaplExListCtrl)
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnItemchangedList1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnItemclickList1(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnDestroy();
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
/**       */
class AFX_EXT_CLASS CaplCtrlHelper
{
	static BOOL CALLBACK FnMove(HWND wnd, LPARAM par);
	static BOOL CALLBACK FnHideShow(HWND wnd, LPARAM par);
	static BOOL CALLBACK FnEnabWnd(HWND wnd, LPARAM par);
	struct SCB 
	{
		CRect re1;
		HWND dlg;
		bool bTest;
		bool bParentTest;
		SCB(){bTest = false;bParentTest = true;}
		virtual ~SCB(){}
		bool TestRect(LPCRECT re);
		bool TestRect(HWND wnd);
	};
	struct SMove : public SCB	{	CPoint pt1;	};
	struct SWisEn : public SCB	{	int en;		};
	static void ShowEnab(CWnd *dlg, int idcFrm, int bShowEn, WNDENUMPROC fn);
	static void ShowEnab(CWnd *dlg, const int *idcs, int cou, int bShowEn, WNDENUMPROC fn);
	static void SetEnabWnd(HWND wnd, bool bEn, int tp);
	static int CtrlType(HWND wnd);
	friend class CCollapsedBox_Impl;
	
public:
	/** ,   re1  re2 */
	static bool Rect1InRect2(LPCRECT re1, LPCRECT re2);

	/**    dx  dy . */
	static void MoveWnd(CWnd &wnd, int dx, int dy);
	static void MoveWnd(CWnd *dlg, int idc, int dx, int dy);
	static void MoveWnd(HWND hwnd, int dx, int dy);

	/**     (    idcs) */
	static void MoveWnds(CWnd *dlg, const int *idcs, int cou, int dx, int dy);
	
	/**    ,    idcFrm (  ) */
	static void MoveWnds(CWnd *dlg, int idcFrm, int dx, int dy);


	/**       */
	static void ShowWnds(CWnd *dlg, const int *idcs, int cou, bool bShow){ShowEnab(dlg, idcs, cou, bShow ? SW_SHOW : SW_HIDE, FnHideShow);}

	/**      ,    idcFrm ( ) */
	static void ShowWnds(CWnd *dlg, int idcFrm, bool bShow) {ShowEnab(dlg, idcFrm, bShow ? SW_SHOW : SW_HIDE, FnHideShow);}


	/** /    */
	static void EnableWnds(CWnd *dlg, const int *idcs, int cou, bool bEnable){ShowEnab(dlg, idcs, cou, bEnable ? TRUE : FALSE, FnEnabWnd);}

	/** /   ,    idcFrm ( ) */
	static void EnableWnds(CWnd *dlg, int idcFrm, bool bEnable) {ShowEnab(dlg, idcFrm, bEnable ? TRUE : FALSE, FnEnabWnd);}

	/** /     */
	static void AllEnab(CWnd *dlg, bool bEnable);
	
	/**    readonly,   - enable */
	static void EnableWnd(HWND wnd, bool bEn);
	static void EnableWnd(CWnd *dlg, int idc, bool bEn);

	/**     dw  dh . */
	static void ResizeWnd(CWnd &wnd, int dw, int dh);
	static void ResizeWnd(CWnd *dlg, int idc, int dx, int dy);

	/** ,    */
	static bool IsEnable(HWND wnd);
	
	/**       
	  @param bWithChild -     
	*/
	static HTREEITEM GetNextTreeItem(CTreeCtrl &tree, HTREEITEM item, bool bWithChild = true);
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//      
//    CollapsedBox.cpp

/**  notify-  CCollapsedBox  /  */
#define APL_COLLBOX_CHECKED_NMESSAGE	WM_USER + 147

/**  notify-  CCollapsedBox     */
#define APL_COLLBOX_EXPANDING_NMESSAGE	WM_USER + 151

/**  notify-  CCollapsedBox     */
#define APL_COLLBOX_EXPANDED_NMESSAGE	WM_USER + 149

/**    MESSAGE_MAP 
	@param idc -   (CCollapsedBox)
	@param lpFunct - - notify-
*/
#define ON_CBX_EXPANDING(idc, lpFunct)	ON_NOTIFY(APL_COLLBOX_EXPANDING_NMESSAGE, idc, lpFunct)
#define ON_CBX_EXPANDED(idc, lpFunct)	ON_NOTIFY(APL_COLLBOX_EXPANDED_NMESSAGE, idc, lpFunct)
#define ON_CBX_CHECKED(idc, lpFunct)	ON_NOTIFY(APL_COLLBOX_CHECKED_NMESSAGE, idc, lpFunct)

class CCollapsedBox;

/**   notify-  CCollapsedBox */
struct NMCOLLAPSEDBOX
{
	NMHDR hdr;
	bool bExpanded; // true,    (  )
	int dh;			//    
	CCollapsedBox *pCBX; // ,  
};

class CCollapsedBox_Impl;
class CCollapsedBoxList_Impl;

/**   */
class AFX_EXT_CLASS CCollapsedBox : public CButton
{
	DECLARE_DYNAMIC(CCollapsedBox)
public:
	CCollapsedBox();
	virtual ~CCollapsedBox();
	
	/**  ,    */
	int  Collapse(bool bSendMsg = true);

	/**  ,    */
	int  Expand(bool bSendMsg = true);

	/**   ,    */
	int  Change(bool bSendMsg = true);

	/**    */
	bool IsExpanded();

	/** Attach */
	BOOL Attach(HWND hWndNew);

	/**      dx  dy  */
	void Move(int dx, int dy);
	
	/**       */
	int GetDH();

	/**       ( ) */
	bool IsCtrlVisible(HWND ctrl);
	bool IsCtrlVisible(int nIDCtrl);

	/**      */
	static CCollapsedBox *GetCBoxByCtrl(HWND ctrl);

	/**    
	  @param bPlusMinus -   (    )
	  @param bCheckBox  -      (   )
	*/
	void SetOptions(bool bPlusMinus, bool bCheckBox);

	/** /   
		@param bSendMsg -    
	*/
	void SetCheckEnable(bool bEnable, bool bSendMsg = true);

	/** return true,    */
	bool IsChecked();

	/** return true,     -   */
	bool IsCtrlEnable(HWND w);
	bool IsCtrlEnable(int nIDCtrl);

	/**    ,    EnumProc.
	 ,  EnumProc  false
	*/
	void EnumCtrls();

	void SetMinH(int iMinH = 17);

	//{{AFX_VIRTUAL(CCollapsedBox)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void PreSubclassWindow();
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL
		
private:
	CCollapsedBox_Impl *m_impl;
	friend class CCollapsedBoxList_Impl;

protected:
	/**   EnumCtrls   
	@param wnd -  
	@param bVisible -      ( )
	@param bEnable  -     ( )
	@return true,   ,  false
	*/
	virtual bool EnumProc(HWND wnd, bool &bVisible, bool &bEnable){return true;}

	//{{AFX_MSG(CCollapsedBox)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnStaticPM();
	afx_msg void OnCheckBoxCh();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/**         .
	  . 
	@param wParam -   CCollapsedBoxList,   o
	@param lParam -      (   )
*/
#define WM_CBXLIST_H_CHANGE				WM_USER + 239

/**    */
class AFX_EXT_CLASS CCollapsedBoxList
{
public:
	CCollapsedBoxList();
	~CCollapsedBoxList();

	/**     */
	void SetDlg(CWnd *dlg);

	/**  .    nIDCtrl,    SetDlg */
	CCollapsedBox *Add(int nIDCtrl);
	void Add(CCollapsedBox &cb);

	/**    ,     
	  @param bSendMsg -      WM_CBXLIST_H_CHANGE
	*/
	int CollapseAll(bool bSendMsg = true);

	/**    ,     
	  @param bSendMsg -      WM_CBXLIST_H_CHANGE
	*/
	int ExpandAll(bool bSendMsg = true);

	/**    CCollapsedBox   n   nIDCtrl */
	CCollapsedBox *GetBox(int n);
	CCollapsedBox *GetBoxByIDC(int nIDCtrl);
	CCollapsedBox *operator[](int n){return GetBox(n);}
	
	/**     */
	int GetSize();

	/**  */
	void BeginMultiExpand();
	int  EndMultiExpand();
	void AddExpand(int n, bool bExpand);
	void AddExpandByIDC(int nIDCtrl, bool bExpand);

	/**     dx  dy  */
	void Move(int dx, int dy);
	
	/**      
	i-    /   
	( ,      )*/
	int BottomYChange(int i);

protected:
	CCollapsedBoxList_Impl *m_impl;
	friend class CCollapsedBox_Impl;
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////
//     MessageBox
//////////////////////////////////////////////////////////////////////////

// Message box style definitions (mostly taken from WinUser.h).

#ifndef MB_CANCELTRYCONTINUE
#define MB_CANCELTRYCONTINUE		0x00000006L	// Standard for Win 5.x.
#endif

#define MB_CONTINUEABORT			0x00000007L	// Additional style.
#define MB_SKIPSKIPALLCANCEL		0x00000008L	// Additional style.
#define MB_IGNOREIGNOREALLCANCEL	0x00000009L	// Additional style.

#define MB_APPWINDOW				0x00800000L	// Additional style.

#define MB_DONT_DISPLAY_AGAIN		0x01000000L	// Additional style.
#define MB_DONT_ASK_AGAIN			0x02000000L	// Additional style.
#define MB_YES_TO_ALL				0x04000000L	// Additional style.
#define MB_NO_TO_ALL				0x08000000L	// Additional style.

#define MB_RIGHT_ALIGN				0x10000000L	// Additional style.
#define MB_NO_SOUND					0x20000000L	// Additional style.
#define MB_DEFAULT_CHECKED			0x40000000L	// Additional style.
#define MB_FORCE_SAVE_CHECK			0x80000000L	// Additional style.

#define MB_DEFBUTTON5				0x00000400L	// Additional style.
#define MB_DEFBUTTON6				0x00000500L	// Additional style.

//////////////////////////////////////////////////////////////////////////////
// Dialog element IDs.

#ifndef IDTRYAGAIN
#define IDTRYAGAIN					10			// Standard for Win 5.x.
#endif

#ifndef IDCONTINUE
#define IDCONTINUE					11			// Standard for Win 5.x.
#endif

#define IDYESTOALL					14			// Additional element.
#define IDNOTOALL					15			// Additional element.
#define IDSKIP						16			// Additional element.
#define IDSKIPALL					17			// Additional element.
#define IDIGNOREALL					18			// Additional element.
#define IDCHECKBOX					19			// Additional element.
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Name of the registry section for storing the message box results.

#define REGISTRY_SECTION_MESSAGEBOX	_T("CaplMessageBoxes")

class AFX_EXT_CLASS CaplMessageBox : public CDialog
{

	DECLARE_DYNAMIC(CaplMessageBox)

public:

	//////////////////////////////////////////////////////////////////////////
	// Constructors and destructors of the class.

	// Constructor of the class for direct providing of the message strings.
	CaplMessageBox (	CWnd* pParent, CString strMessage, 
						CString strTitle = _T(""), UINT nStyle = MB_OK, UINT nHelp = 0 );

	// Constructor of the class for loading the strings from the resources.
	CaplMessageBox (	CWnd* pParent, UINT nMessageID, UINT nTitleID = 0,
						UINT nStyle = MB_OK, UINT nHelp = 0 );

	// Default destructor of the class.
	virtual ~CaplMessageBox ( );

public:

	//////////////////////////////////////////////////////////////////////////
	// Methods for setting and retrieving dialog options.

	// Method for setting the style of the message box.
	void SetStyle ( UINT nStyle );

	// Method for retrieving the style of the message box.
	UINT GetStyle ( );

	// Methods for setting the message to be displayed in the message box.
	void SetMessage ( CString strMessage );
	void SetMessage ( UINT nMessageID );

	// Method for retrieving the message to be displayed in the message box.
	CString GetMessage ( );

	// Methods for setting the title to be displayed in the message box.
	void SetTitle ( CString strTitle );
	void SetTitle ( UINT nTitleID );

	// Method for retrieving the title to be displayed in the message box.
	CString GetTitle ( );

	// Methods for setting the icon to be displayed in the message box.
	void SetMessageIcon ( HICON hIcon );
	void SetMessageIcon ( UINT nIconID );

	// Method for retrieving the icon to be displayed in the message box.
	HICON GetMessageIcon ( );

	// Method for setting a timeout.
	void SetTimeout ( UINT nSeconds, BOOL bDisabled = FALSE );

	// Method for retrieving the seconds for the timeout.
	UINT GetTimeoutSeconds ( );

	// Method for retrieving whether a timeout is disabled.
	BOOL GetTimeoutDisabled ( );

	//     .
	BOOL WasMessageVisible( );

public:

	//////////////////////////////////////////////////////////////////////////
	// Methods for handling the stored states.

	// Method for resetting the message boxes stored in the registry.
	static void ResetMessageBoxes ( );

public:

	//////////////////////////////////////////////////////////////////////////
	// Methods for handling common window functions.

	// Method for displaying the dialog.
#if _MSC_VER >= 1400
	virtual INT_PTR DoModal ( );
#else
	virtual BOOL DoModal ( );
#endif

	// Method for closing the dialog.
	void EndDialog ( int nResult );

	// Method for initializing the dialog.
	virtual BOOL OnInitDialog ( );

	// Method for handling command messages.
	virtual BOOL OnCmdMsg ( UINT nID, int nCode, void* pExtra,
		AFX_CMDHANDLERINFO* pHandlerInfo );

	// Method for handling messages before dispatching them.
	virtual BOOL PreTranslateMessage ( MSG* pMsg );

	// Method for handling a timer event.
	afx_msg void OnTimer ( UINT nIDEvent );

	// Method for adding a button to the list of buttons.
	void AddButton ( UINT nID, LPCTSTR sTitle, BOOL bIsDefault = FALSE,
		BOOL bIsEscape = FALSE );


protected:
	BOOL m_Visible;

	bool m_StyleButtons;

	//////////////////////////////////////////////////////////////////////////
	// Other methods for handling common window functions.

	// Method for handling window messages.
	virtual BOOL OnWndMsg ( UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult );

	DECLARE_MESSAGE_MAP()

private:

	//////////////////////////////////////////////////////////////////////////
	// Private member variables of this dialog.

	CString		m_strMessage;		// Message to be displayed.
	CString		m_strTitle;			// Title to be used.
	UINT		m_nStyle;			// Style of the message box.
	UINT		m_nHelp;			// Help context of the message box.

	HICON		m_hIcon;			// Icon to be displayed in the dialog.

	UINT		m_nTimeoutSeconds;	// Seconds for a timeout.
	BOOL		m_bTimeoutDisabled;	// Flag whether the timeout is disabled.
	UINT		m_nTimeoutTimer;	// Timer for the timeout.

	CString		m_strRegistryKey;	// Entry for storing the result in the
									// registry, if the MB_DONT_DISPLAY_AGAIN
									// or MB_DONT_ASK_AGAIN flag is given.

private:

	//////////////////////////////////////////////////////////////////////////
	// Control handling types and variables.

	typedef struct tagMSGBOXBTN
	{
		int		nID;				// ID of a dialog button.
		UINT	nTitle;				// ID of the title string resource.
		CString	sTitle;				// string of the title.
	} MSGBOXBTN;

	CArray<MSGBOXBTN, const MSGBOXBTN&> m_aButtons;
									// List of all buttons in the dialog.

	int			m_nDefaultButton;	// ID of the default button.
	int			m_nEscapeButton;	// ID of the escape button.

	CStatic		m_stcIcon;			// Static control for the icon.
	CStatic		m_stcMessage;		// Static control for the message.

private:

	//////////////////////////////////////////////////////////////////////////
	// Size handling variables.

	CSize		m_sDialogUnit;		// Variable for the size of a dialog unit.
	CSize		m_sIcon;			// Variable for the size of the icon.
	CSize		m_sMessage;			// Variable for the size of the message.
	CSize		m_sCheckbox;		// Variable for the size of the checkbox.
	CSize		m_sButton;			// Variable for the size of a button.

private:

	//////////////////////////////////////////////////////////////////////////
	// Helper methods.
	
	// Method for generating the registry key.
	CString	GenerateRegistryKey ( );

	// Method for adding a button to the list of buttons.
	void AddButton ( UINT nID, UINT nTitle, BOOL bIsDefault = FALSE,
		BOOL bIsEscape = FALSE );

	// Methods for converting a dialog units to a pixel values.
	int XDialogUnitToPixel ( int x );
	int YDialogUnitToPixel ( int y );

	// Method for parsing the given style.
	void ParseStyle ( );

	// Method for creating the icon control.
	void CreateIconControl ( );

	// Method for creating the message control.
	void CreateMessageControl ( );

	// Method for creating the checkbox control.
	void CreateCheckboxControl ( );

	// Method for creating the button controls.
	void CreateButtonControls ( );

	// Method for defining the layout of the dialog.
	void DefineLayout ( );

};
//////////////////////////////////////////////////////////////////////////
// CaplProgressCtrlEx

class AFX_EXT_CLASS CaplProgressCtrlEx : public CProgressCtrl
{
	DECLARE_DYNAMIC(CaplProgressCtrlEx)

protected:
	bool	m_bMarqueeMode;
	int		m_nInterval;
	double	m_dMarqueSize;

	int m_iOldLower;
	int m_iOldUpper;
	int m_iOldPos;

public:
	//    
	bool SetMarqueeMode(bool bMarqueeMode, int nInterval);

	//    
	double SetMarqueeSize(double dSize);

	bool IsMarqueeMode() { return m_bMarqueeMode; }

	//   (  ,    )
	void Start();

	//   (  ,    )
	void End();

public:
	CaplProgressCtrlEx();
	virtual ~CaplProgressCtrlEx();

protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnPaint();
};

//////////////////////////////////////////////////////////////////////////
// CaplCheckListCtrl

//  :
//	1 - 
//	0 - 
//	2 - 

//typedef CMap<int,int,int,int> TMapChecks;
//typedef std::map<int,aplCheckValue> TMapChecks;
//typedef std::map<int,aplCheckValue>::iterator TMapChecks_it;
//typedef std::pair<int,aplCheckValue> TPairChecks;

// -   - (  ())
class APL_CLASS_EXPORT CaplCheckListCtrl : public CaplListCtrl
{
protected:
	CImageList m_il;

	bool m_bOnceChecked;	//        ,    
	bool m_bOnceRowChecked;	//      ,    

	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	DECLARE_MESSAGE_MAP()
public:
	CaplCheckListCtrl();

	//CArray<TMapChecks> m_checks;

	//   " "       (. CRoleDlg)
	void SetOnceChecked(bool bOnceChecked) { m_bOnceChecked = bOnceChecked; }

	//   " "   -      
	void SetOnceRowChecked(bool bOnceChecked) { m_bOnceRowChecked = bOnceChecked; }

	//    (   )
	void SetCheck(int iRow, int iCol, aplCheckValue iCheck=aplCheckNo);

	//   
	aplCheckValue GetCheck(int iRow, int iCol);

	//    
	bool IsCheck(int iRow, int iCol);

	//////////////////////////////////////////////////////////////////////////
	//    CListCtrl
	int InsertItem(const LVITEM* pItem);
	int InsertItem(int nItem, LPCTSTR lpszItem);
	int InsertItem(int nItem, LPCTSTR lpszItem, int nImage);
	int InsertItem(UINT nMask, int nItem, LPCTSTR lpszItem, UINT nState,
		UINT nStateMask, int nImage, LPARAM lParam);
	//BOOL DeleteItem(int nItem);

	afx_msg void OnNMClick(NMHDR *pNMHDR, LRESULT *pResult);
};



//////////////////////////////////////////////////////////////////////////
//ButtonIco
#define APL_24_OK					0
#define APL_24_PLUS					1
#define APL_24_MINUS				2
#define APL_24_FIND					3
#define APL_24_CANCEL				4
#define APL_24_PKI					5
#define APL_24_COLUMNS				6
#define APL_24_PLANER				7
#define APL_24_PDF					8
#define APL_24_ADD_PDF				9
#define	APL_24_SELECT				10
#define	APL_24_DELETE				11
#define	APL_24_PERSON				12
#define	APL_24_ORG					13
#define	APL_24_EDIT					14
#define	APL_24_PROPERTIES			15
#define	APL_24_COMPOSITION			16
#define	APL_24_DESCRIPTION			17
#define	APL_24_PRINT				18
#define	APL_24_PRINT_PREVIEW		19
#define	APL_24_OPEN_FILE			20
#define	APL_24_MOVES				21
#define APL_24_SYSTEM				22
#define APL_24_ZONE					23
#define APL_24_VIEW					24
#define APL_24_ZOOMIN				25
#define APL_24_ZOOMOUT				26
#define APL_24_REPORT				27
#define APL_24_CSV					28
#define APL_24_CALC_RESOURCES		29
#define APL_24_SAVE					30
#define APL_24_FILTER_MOVES			31
#define APL_24_FILTER_REPAIR		32
#define APL_24_FILTER_REFUSALS		33
#define APL_24_FILTER_RC			34
#define APL_24_CLEAR				35
#define APL_24_RUN					36
#define APL_24_JOB					37
#define APL_24_PLANER_PDF			38
#define APL_24_NOTEBOOK				39
#define APL_24_DB2FILE				40
#define APL_24_FILE2DB				41
#define APL_24_FLASH				42
#define APL_24_PHOTO				43
#define APL_24_UNDO					44
#define APL_24_REFERENCE			45
#define APL_24_ERROR				46
#define APL_24_WARNING				47
#define APL_24_CREATE				48
#define APL_24_RESOLVED				49
#define APL_24_TAB_LEFT				50
#define APL_24_TAB_RIGHT			51
#define APL_24_FILTER_CONSERVES		49
#define APL_24_SHIFT_DOWN			50
#define APL_24_COPY					51
#define APL_24_UP					52
#define APL_24_DOWN					53
#define APL_24_LEFT					54
#define APL_24_RIGHT				55

#define APL_24_NEXT_INDEX			56

/*
#define APL_STD_OK				0
#define APL_STD_CANCEL			1
#define APL_STD_PROPERTIES		2
#define APL_STD_DELETE			3
#define APL_STD_NEW_SECTION		4
#define APL_STD_COPY_SECTION	5
#define APL_STD_TOP				6
#define APL_STD_BOTTOM			7
#define APL_STD_TABLE			8
#define APL_STD_SECTION_PROP	9
#define APL_STD_COLUMN			10
#define APL_STD_ADD_COLUMN		11
#define APL_STD_PICTURE			12
#define APL_STD_PLUS			13
#define APL_STD_LEFT			14
#define APL_STD_RIGHT			15
#define APL_STD_SETUP			16
#define APL_STD_CHARACTS		17
*/

APL_CLASS_EXPORT HICON aplGetButtonIco(int nIndex, bool bTruecolor = true);
APL_CLASS_EXPORT HICON aplGetButtonIcoGray(int nIndex, bool bTruecolor = true);

//APL_CLASS_EXPORT HICON aplGetStdIco16(int index); //    Gui

APL_CLASS_EXPORT bool aplIsDigit(const TCHAR* lpszStr);
APL_CLASS_EXPORT bool IsReal(const TCHAR* buf);
APL_CLASS_EXPORT bool IsRealOrEmpty(const TCHAR* buf);
APL_CLASS_EXPORT bool IsTime(const TCHAR* buf);
APL_CLASS_EXPORT bool IsInteger(const TCHAR* buf);
APL_CLASS_EXPORT bool IsPositive(const TCHAR* buf);
APL_CLASS_EXPORT bool TestCharactValue(CString tstVal, bool bTime, CString &message, bool MessageMode = true);
APL_CLASS_EXPORT DWORD GetDllVersion(LPCTSTR lpszDllName);
APL_CLASS_EXPORT bool GetExePath(HMODULE hModule, CString &buf);
APL_CLASS_EXPORT bool GetOSDisplayString( CString &verOS);
APL_CLASS_EXPORT bool aplGetFormatedStringDateAsOleDate(CString &buf, COleDateTime &time);
APL_CLASS_EXPORT CString StrE2Str(const TCHAR *buf, int iPrec = 3);
APL_CLASS_EXPORT CString Double2Str(double dVal, int iPrec = 3);
APL_CLASS_EXPORT double Str2Double(const TCHAR* str);
APL_CLASS_EXPORT void GetClientVer(CString &sVer);
APL_CLASS_EXPORT COLORREF aplFusionColors(COLORREF color1, COLORREF color2, double k1, double k2);
APL_CLASS_EXPORT bool aplGetGradientBitmap(CDC *pDC, CRect rect, COLORREF color1, COLORREF color2, CBitmap *bmp, bool bUseShadow = true);

APL_CLASS_EXPORT bool aplGetFormatedDateTime(CString buf, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedDateTime(COleDateTime &time, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedDate(CString buf, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedDate(COleDateTime &time, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedDate(SYSTEMTIME &time, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedTime(CString buf, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedTime(COleDateTime &time, CString &res);
APL_CLASS_EXPORT bool aplGetFormatedTime(SYSTEMTIME &time, CString &res);

/**     PSS    -
	    ,   
	    (  70   )*/
APL_CLASS_EXPORT bool aplGetAsDateTime(CString buf, CString &res);

/**	          "X. Y."
param dVal -    
param sVal -  */
APL_CLASS_EXPORT bool aplGetAsHM(double dVal, CString &sVal);
APL_CLASS_EXPORT bool aplGetAsHM(double dVal, double dMinVal, double dMaxVal, CString &sVal);
/**     "X. Y."   ,   ( )
param sVal -  
param dVal -    
param Hour -  .   
param Minutes -  ,   
return <b>false</b>    ( )*/
APL_CLASS_EXPORT bool aplGetAsDouble(LPCTSTR sVal, double &dVal, int *Hour=0, int *Minutes=0);
APL_CLASS_EXPORT bool aplGetAsDouble(LPCTSTR sVal, double &dVal, double &dMinVal, double &dMaxVal);

//        CToolBarEx
APL_CLASS_EXPORT void UpdatePopupMenu(CCmdTarget* pTarget, CMenu *pPopup);

//   sSourceFile   sDestPath
APL_CLASS_EXPORT bool aplCopyFile(const CString& sSourceFile, const CString& sDestPath, bool bDeleteSourceFile = false);

#endif // !defined(AFX_APLLISTCTRL_H__DAAAF0AC_4F92_413D_B921_4197AF4D681B__INCLUDED_)
