#pragma once

#ifndef APL_NO_LDAP_DEFINE
class LDAPMessage;
class LDAP;
#endif

#ifndef APL_LDAP_NOAUTOLIB
#ifdef _DEBUG
#ifdef _UNICODE
#pragma comment (lib,"aplLDAP_ud.lib")
#else // #ifdef _UNICODE
#pragma comment (lib,"aplLDAP_d.lib")
#endif // #ifdef _UNICODE
#else
#ifdef _UNICODE
#pragma comment (lib,"aplLDAP_u.lib")
#else // #ifdef _UNICODE
#pragma comment (lib,"aplLDAP.lib")
#endif // #ifdef _UNICODE
#endif
#endif


#ifdef APL_LDAP_NOAUTOLIB
#define CLASS_DECL_APL_LDAP  _declspec(dllexport)
#else
#define CLASS_DECL_APL_LDAP  _declspec(dllimport)
#endif

class CLASS_DECL_APL_LDAP CaplLDAP
{
public:
	CaplLDAP(void);
	~CaplLDAP(void); // Disconnect

	LPCTSTR GetLastError(); //   .

	static bool GetCurrentWindowsUser(CString &user);   //     windows
	static bool GetCurrentWindowsDomainName(CString &domain); //   ,     windows
	static bool GetCurrentWindowsDomainServer(CString &server); //   ,     windows


	//  LDAP,    .  (   .  ,    ) 
	//     Connect()  TestConnect()
	//   ==0,   389.        server:port
	bool Init(LPCTSTR domain, LPCTSTR server, ULONG port=0);

	//    .   .  (     Init())
	//  user_name==0,       windows
	//  true,  .
	// (!)   ,     ,      .
	//    m_s_last_error
	bool TestUserConnect(LPCTSTR user_name, LPCTSTR password);  
	
	//     (     Init())
	//  user_name==0,       windows
	//  true,  .
	bool Connect(LPCTSTR user_name, LPCTSTR password);
	
	//  ,  .  .
	void Disconnect(); 
	

	bool FindUser(LPCTSTR user_name);  //      0,   .     
	bool GetObjectAttr(LPCTSTR attr, CString &value); //     .    -   ';'
	
	
	bool GetUserInfo(LPCTSTR user_name,CString &info);  //     (  )

	bool Search(LPCTSTR BaseDN, LPCTSTR filter, CString &info); //  (  )

	static CString GetLDAPErrorDescr(ULONG errcode);

	void SetALDMode(bool bALDMode){m_bALDMode = bALDMode;}
	bool GetALDMode(){return m_bALDMode;}

protected:
	bool bIsConnect; //   
	bool m_bALDMode;        //    ALD (true  ALD  false  AD).     !!
	CString m_s_last_error;
	CString m_domain_dns;  //    DNS: "ad.ofc.gamma.ru"
	CString m_domain_ldap;  //    LDAP: "DC=ad,DC=ofc,DC=gamma,DC=ru"
	CString m_server;
	ULONG m_port;

	LDAP *m_pLdapConnection;
	LDAPMessage *m_answer, *m_entry;

	void SetLDAPError(LPCTSTR mess);
	void SetLDAPError(LPCTSTR mess, ULONG code);
};
